/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package jail.java.awt;

import java.io.IOException;
import java.util.ArrayList;

import blues.Log;
import impl.java.io.BluesFileSystem;
import jail.java.awt.image.ImageConsumer;
import jail.java.net.URL;

class BDImageProducerProxy implements jail.java.awt.image.ImageProducer {

    java.awt.image.ImageProducer producer;

    public BDImageProducerProxy(java.awt.image.ImageProducer producer) {
        this.producer = producer;
    }

    public void addConsumer(jail.java.awt.image.ImageConsumer ic) {
        if (ic instanceof BDImageConsumer) {
            producer.addConsumer((BDImageConsumer)ic);
        } else {
            Log.fatal("consumer not a BDImageConsumer");
        }
    }

    public boolean isConsumer(jail.java.awt.image.ImageConsumer ic) {
        if (ic instanceof BDImageConsumer) {
            return producer.isConsumer((BDImageConsumer)ic);
        } else {
            Log.fatal("consumer not a BDImageConsumer");
            return false;
        }
    }

    public void removeConsumer(jail.java.awt.image.ImageConsumer ic) {
        if (ic instanceof BDImageConsumer) {
            producer.removeConsumer((BDImageConsumer)ic);
        } else {
            Log.fatal("consumer not a BDImageConsumer");
        }
    }

    public void startProduction(jail.java.awt.image.ImageConsumer ic) {
        if (ic instanceof BDImageConsumer) {
            producer.startProduction((BDImageConsumer)ic);
        } else {
            Log.fatal("consumer not a BDImageConsumer");
        }
    }

    public void requestTopDownLeftRightResend(jail.java.awt.image.ImageConsumer ic) {
        Log.fatal("never called");
    }

    public static jail.java.awt.image.ImageProducer createImage(String filename) {
        jail.java.io.File f = new jail.java.io.File(filename);
        try {
            byte[] data = BluesFileSystem.readJailFile(f.getAbsolutePath(),512*1024*1024);
            return createImage(data,0,data.length);
        } catch(IOException e) {
            Log.log(Log.LOG_AWT, "Image ",filename," - read error: ",e.toString());
            return new ErrorImageProducer();
        }
    }

    public static jail.java.awt.image.ImageProducer createImage(URL url) {
        try {
            String localPath = BluesFileSystem.getLocalPath(url.openStream(),url.getPath());
            if (localPath==null) {
                throw new IOException();
            }
            byte[] data = BluesFileSystem.readLocalFile(localPath,512*1024*1024);
            return createImage(data,0,data.length);
        } catch(IOException e) {
            Log.log(Log.LOG_AWT, "Image ",url.toString()," - read error: ",e.toString());
            return new ErrorImageProducer();
        }
    }

    public static BDImageProducerProxy createImage(byte[] imagedata,int imageoffset,int imagelength) {

        java.awt.Toolkit toolkit = java.awt.Toolkit.getDefaultToolkit();
        java.awt.Image image =  toolkit.createImage(imagedata, imageoffset, imagelength);
        if (image==null) {
            return null;
        }
        return new BDImageProducerProxy(image.getSource());
    }

    private static class ErrorImageProducer implements jail.java.awt.image.ImageProducer {
        private ArrayList<ImageConsumer> consumers = new ArrayList<ImageConsumer>();

        @Override
        public synchronized void addConsumer(ImageConsumer ic) {
            if (isConsumer(ic)==false) {
                consumers.add(ic);
            }
        }

        @Override
        public synchronized boolean isConsumer(ImageConsumer ic) {
            return consumers.contains(ic);
        }
        @Override
        public synchronized void removeConsumer(ImageConsumer ic) {
            consumers.remove(ic);
        }

        @Override
        public void startProduction(ImageConsumer ic) {
            ic.imageComplete(ImageConsumer.IMAGEERROR);
        }

        @Override
        public void requestTopDownLeftRightResend(ImageConsumer ic) {
        }
    }

}
