/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import org.w3c.dom.Element;

public class StringSerializer
implements Serializer {
    private boolean decodeStrings;
    private boolean encodeStrings;

    public StringSerializer(boolean encodeStrings, boolean decodeStrings) {
        this.decodeStrings = decodeStrings;
        this.encodeStrings = encodeStrings;
    }

    @Override
    public Object deserialize(Element content) throws XMLRPCException {
        String text = XMLUtil.getOnlyTextContent(content.getChildNodes());
        if (this.decodeStrings) {
            text = text.replaceAll("&lt;", "<").replaceAll("&amp;", "&");
        }
        return text;
    }

    @Override
    public XmlElement serialize(Object object) {
        String content = object.toString();
        if (this.encodeStrings) {
            content = content.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("]]>", "]]&gt;");
        }
        return XMLUtil.makeXmlTag("string", content);
    }
}

