/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.SettingModel;

public final class Settings {

    public static class SetSettingValue
    extends AbstractCall<Boolean> {
        public static final String API_TYPE = "Settings.SetSettingValue";

        public SetSettingValue(String string, SettingModel.ValueExtended valueExtended) {
            this.addParameter("setting", string);
            this.addParameter("value", (AbstractModel)valueExtended);
        }

        @Override
        protected Boolean parseOne(JsonNode jsonNode) {
            return jsonNode.asBoolean();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class ResetSettingValue
    extends AbstractCall<String> {
        public static final String API_TYPE = "Settings.ResetSettingValue";

        public ResetSettingValue(String string) {
            this.addParameter("setting", string);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetSettingValue
    extends AbstractCall<SettingModel.ValueExtended> {
        public static final String API_TYPE = "Settings.GetSettingValue";
        public static final String RESULT = "value";

        public GetSettingValue(String string) {
            this.addParameter("setting", string);
        }

        @Override
        protected SettingModel.ValueExtended parseOne(JsonNode jsonNode) {
            return new SettingModel.ValueExtended((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetSections
    extends AbstractCall<SettingModel.SectionDetail> {
        public static final String API_TYPE = "Settings.GetSections";
        public static final String RESULT = "sections";

        public GetSections(String string, String ... stringArray) {
            this.addParameter("level", string);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<SettingModel.SectionDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<SettingModel.SectionDetail> arrayList = new ArrayList<SettingModel.SectionDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new SettingModel.SectionDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<SettingModel.SectionDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetCategories
    extends AbstractCall<SettingModel.CategoryDetail> {
        public static final String API_TYPE = "Settings.GetCategories";
        public static final String RESULT = "categories";

        public GetCategories(String string, String string2, String ... stringArray) {
            this.addParameter("level", string);
            this.addParameter("section", string2);
            this.addParameter("properties", stringArray);
        }

        public GetCategories(String string) {
            this.addParameter("properties", string);
        }

        public GetCategories(String string, String string2) {
            this.addParameter("level", string);
            this.addParameter("properties", string2);
        }

        @Override
        protected ArrayList<SettingModel.CategoryDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<SettingModel.CategoryDetail> arrayList = new ArrayList<SettingModel.CategoryDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new SettingModel.CategoryDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<SettingModel.CategoryDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }
}

