/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.ArdSettings;
import org.tinymediamanager.core.AspectRatio;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

public class ArdSettingsPanel
extends JPanel {
    private final Settings settings = Settings.getInstance();
    private JCheckBox chckbxARDEnabled;
    private JSlider sliderDetectionMode;
    private Map<String, JCheckBox> customARCheckBoxes = new LinkedHashMap<String, JCheckBox>();
    private ButtonGroup buttonGroupRound = new ButtonGroup();
    private JRadioButton rdbtnRoundNearest;
    private JRadioButton rdbtnRoundUpToNext;
    private ButtonGroup buttonGroupARUseMode = new ButtonGroup();
    private JRadioButton rdbtnMFMost;
    private JRadioButton rdbtnMFHigher;
    private JRadioButton rdbtnMFWider;
    private int previousMode = -1;
    private int previousMFMode = -1;

    public ArdSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.previousMode = this.settings.getArdMode().ordinal();
        this.sliderDetectionMode.setValue(this.settings.getArdMode().ordinal());
        this.sliderDetectionMode.addChangeListener(e -> {
            if (!this.sliderDetectionMode.getValueIsAdjusting()) {
                switch (this.sliderDetectionMode.getValue()) {
                    case 0: 
                    case 1: {
                        this.rdbtnMFMost.setEnabled(false);
                        this.rdbtnMFWider.setEnabled(false);
                        this.rdbtnMFHigher.setEnabled(false);
                        this.previousMFMode = this.previousMode == 2 ? this.settings.getArdMFMode() : this.previousMFMode;
                        this.buttonGroupARUseMode.clearSelection();
                        break;
                    }
                    case 2: {
                        this.rdbtnMFMost.setEnabled(true);
                        this.rdbtnMFWider.setEnabled(true);
                        this.rdbtnMFHigher.setEnabled(true);
                        this.rdbtnMFMost.setSelected(this.previousMFMode == 0);
                        this.rdbtnMFHigher.setSelected(this.previousMFMode == 1);
                        this.rdbtnMFWider.setSelected(this.previousMFMode == 2);
                    }
                }
                this.settings.setArdMode(ArdSettings.Mode.values()[this.sliderDetectionMode.getValue()]);
                this.previousMode = this.sliderDetectionMode.getValue();
            }
        });
        ItemListener checkBoxListener = e -> this.checkCustomARChanges();
        for (Map.Entry<String, JCheckBox> entry : this.customARCheckBoxes.entrySet()) {
            if (this.settings.getCustomAspectRatios().contains(entry.getKey())) {
                entry.getValue().setSelected(true);
            }
            entry.getValue().addItemListener(checkBoxListener);
        }
        if (this.settings.isArdRoundUp()) {
            this.rdbtnRoundUpToNext.setSelected(true);
        } else {
            this.rdbtnRoundNearest.setSelected(true);
        }
        boolean isAccurate = this.sliderDetectionMode.getValue() == 2;
        this.previousMFMode = this.settings.getArdMFMode();
        this.rdbtnMFMost.addChangeListener(e -> {
            if (this.rdbtnMFMost.isSelected()) {
                this.settings.setArdMFMode(0);
            }
        });
        this.rdbtnMFMost.setSelected(isAccurate && this.settings.getArdMFMode() == 0);
        this.rdbtnMFMost.setEnabled(isAccurate);
        this.rdbtnMFHigher.addChangeListener(e -> {
            if (this.rdbtnMFHigher.isSelected()) {
                this.settings.setArdMFMode(1);
            }
        });
        this.rdbtnMFHigher.setSelected(isAccurate && this.settings.getArdMFMode() == 1);
        this.rdbtnMFHigher.setEnabled(isAccurate);
        this.rdbtnMFWider.addChangeListener(e -> {
            if (this.rdbtnMFWider.isSelected()) {
                this.settings.setArdMFMode(2);
            }
        });
        this.rdbtnMFWider.setSelected(isAccurate && this.settings.getArdMFMode() == 2);
        this.rdbtnMFWider.setEnabled(isAccurate);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[]"));
        JPanel panelArdSettings = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][20lp!][500lp][grow]", "[][10lp!][][][][][10lp!][][][][]"));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("Settings.ard"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelArdSettings, lblLanguageT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#aspect-ratio-detector"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        int row = 0;
        JLabel lblDetectionMode = new JLabel(TmmResourceBundle.getString("Settings.ard.detectionMode.hint"));
        panelArdSettings.add((Component)lblDetectionMode, "cell 1 " + row + ", span, aligny top");
        this.sliderDetectionMode = new JSlider(0, 2, 1);
        this.sliderDetectionMode.setMajorTickSpacing(1);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel(TmmResourceBundle.getString("Settings.ard.detectionMode.fast")));
        labelTable.put(1, new JLabel(TmmResourceBundle.getString("Settings.ard.detectionMode.default")));
        labelTable.put(2, new JLabel(TmmResourceBundle.getString("Settings.ard.detectionMode.accurate")));
        this.sliderDetectionMode.setLabelTable(labelTable);
        this.sliderDetectionMode.setPaintLabels(true);
        this.sliderDetectionMode.setPaintTicks(true);
        lblDetectionMode.setLabelFor(this.sliderDetectionMode);
        panelArdSettings.add((Component)this.sliderDetectionMode, "cell 1 " + row + ", span");
        ++row;
        this.chckbxARDEnabled = new JCheckBox(TmmResourceBundle.getString("Settings.ard.automaticard"));
        panelArdSettings.add((Component)this.chckbxARDEnabled, "cell 1 " + ++row + ", span");
        JLabel lblAutomaticARDHint = new JLabel(IconManager.HINT);
        lblAutomaticARDHint.setToolTipText(TmmResourceBundle.getString("Settings.ard.automaticard.desc"));
        panelArdSettings.add((Component)lblAutomaticARDHint, "cell 1 " + row + ", span");
        ++row;
        JLabel lblAspectRatiosDesc = new JLabel(TmmResourceBundle.getString("Settings.ard.roundAspectRatios.hint"));
        panelArdSettings.add((Component)lblAspectRatiosDesc, "cell 1 " + ++row + ", span");
        ++row;
        JPanel panelCustomAspectRatios = new JPanel();
        panelCustomAspectRatios.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 30;
        panelArdSettings.add((Component)panelCustomAspectRatios, "cell 1 " + row + ", span");
        List<Float> customAspectRatios = AspectRatio.getDefaultValues();
        int yOne = 0;
        int yTwo = 0;
        for (Float customAR : customAspectRatios) {
            JCheckBox checkBox = new JCheckBox(AspectRatio.getDescription(customAR));
            this.customARCheckBoxes.put(customAR.toString(), checkBox);
            if (customAR.floatValue() < 1.9f) {
                gbc.gridx = 0;
                gbc.gridy = yOne++;
            } else {
                gbc.gridx = 1;
                gbc.gridy = yTwo++;
            }
            panelCustomAspectRatios.add((Component)checkBox, gbc);
            ++gbc.gridx;
        }
        this.rdbtnRoundNearest = new JRadioButton(TmmResourceBundle.getString("Settings.ard.roundNearest"));
        this.buttonGroupRound.add(this.rdbtnRoundNearest);
        panelArdSettings.add((Component)this.rdbtnRoundNearest, "cell 1 " + ++row + " 2 1,aligny bottom");
        this.rdbtnRoundUpToNext = new JRadioButton(TmmResourceBundle.getString("Settings.ard.roundUpToNext"));
        this.buttonGroupRound.add(this.rdbtnRoundUpToNext);
        panelArdSettings.add((Component)this.rdbtnRoundUpToNext, "cell 1 " + ++row + " 2 1");
        ++row;
        JLabel lblMultiFormat = new JLabel(TmmResourceBundle.getString("Settings.ard.multiformat.hint"));
        panelArdSettings.add((Component)lblMultiFormat, "cell 1 " + ++row + " 3 1");
        this.rdbtnMFMost = new JRadioButton(TmmResourceBundle.getString("Settings.ard.multiformat.useMost"));
        this.buttonGroupARUseMode.add(this.rdbtnMFMost);
        panelArdSettings.add((Component)this.rdbtnMFMost, "cell 1 " + ++row + ",growx");
        this.rdbtnMFHigher = new JRadioButton(TmmResourceBundle.getString("Settings.ard.multiformat.useHigher"));
        this.buttonGroupARUseMode.add(this.rdbtnMFHigher);
        panelArdSettings.add((Component)this.rdbtnMFHigher, "cell 1 " + ++row + ",growx");
        this.rdbtnMFWider = new JRadioButton(TmmResourceBundle.getString("Settings.ard.multiformat.useWider"));
        this.buttonGroupARUseMode.add(this.rdbtnMFWider);
        panelArdSettings.add((Component)this.rdbtnMFWider, "cell 1 " + ++row + ",growx");
    }

    private void checkCustomARChanges() {
        LinkedHashSet<String> customARs = new LinkedHashSet<String>();
        for (Map.Entry<String, JCheckBox> entry : this.customARCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            customARs.add(entry.getKey());
        }
        this.settings.setCustomAspectRatios(new ArrayList<String>(customARs));
    }

    protected void initDataBindings() {
        BeanProperty ardRoundUpBeanProperty = BeanProperty.create((String)"ardRoundUp");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_ard_roundUp = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)ardRoundUpBeanProperty, (Object)this.rdbtnRoundUpToNext, (Property)jCheckBoxBeanProperty);
        autoBinding_ard_roundUp.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"ardEnabled");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxARDEnabled, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
    }
}

