/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvshowChecksumsAction
extends TmmAction {
    private static final long serialVersionUID = 1L;

    public TvshowChecksumsAction() {
        this.putValue("Name", TmmResourceBundle.getString("checksum.crc32.calculate"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("checksum.crc32.calculate"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final TvShowSelectionModel.SelectedObjects sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(false, false);
        TmmTask task = new TmmTask(TmmResourceBundle.getString("checksum.crc32.calculate"), sel.getEpisodes().size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                Set<TvShowEpisode> selectedEpisodes = sel.getEpisodesRecursive();
                for (TvShowEpisode ep : selectedEpisodes) {
                    MediaFile main = ep.getMainVideoFile();
                    String crc = Utils.getCRC32(main.getFileAsPath());
                    if (crc.isEmpty()) continue;
                    main.setCRC32(crc);
                    ep.saveToDb();
                }
            }
        };
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

