/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.tools.JarDiff;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Differ {
    public void createDiff(File nvdir, File ovdir, boolean verbose) throws IOException {
        String nvers = nvdir.getName();
        String overs = ovdir.getName();
        try {
            if (Long.parseLong(nvers) <= Long.parseLong(overs)) {
                String err = "New version (" + nvers + ") must be greater than old version (" + overs + ").";
                throw new IOException(err);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Non-numeric versions? [nvers=" + nvers + ", overs=" + overs + "].");
        }
        Application oapp = new Application(new EnvConfig(ovdir));
        oapp.init(false);
        ArrayList<Resource> orsrcs = new ArrayList<Resource>();
        orsrcs.addAll(oapp.getCodeResources());
        orsrcs.addAll(oapp.getResources());
        Application napp = new Application(new EnvConfig(nvdir));
        napp.init(false);
        ArrayList<Resource> nrsrcs = new ArrayList<Resource>();
        nrsrcs.addAll(napp.getCodeResources());
        nrsrcs.addAll(napp.getResources());
        File patch = new File(nvdir, "patch" + overs + ".dat");
        this.createPatch(patch, orsrcs, nrsrcs, verbose);
        for (Application.AuxGroup ag : napp.getAuxGroups()) {
            orsrcs = new ArrayList();
            Application.AuxGroup oag = oapp.getAuxGroup(ag.name);
            if (oag != null) {
                orsrcs.addAll(oag.codes);
                orsrcs.addAll(oag.rsrcs);
            }
            nrsrcs = new ArrayList();
            nrsrcs.addAll(ag.codes);
            nrsrcs.addAll(ag.rsrcs);
            patch = new File(nvdir, "patch-" + ag.name + overs + ".dat");
            this.createPatch(patch, orsrcs, nrsrcs, verbose);
        }
    }

    protected void createPatch(File patch, List<Resource> orsrcs, List<Resource> nrsrcs, boolean verbose) throws IOException {
        int version = 2;
        MessageDigest md = Digest.getMessageDigest(version);
        try (FileOutputStream fos = new FileOutputStream(patch);
             BufferedOutputStream buffered = new BufferedOutputStream(fos);
             ZipOutputStream jout = new ZipOutputStream(buffered);){
            for (Resource rsrc : nrsrcs) {
                Resource orsrc;
                int oidx = orsrcs.indexOf(rsrc);
                Resource resource = orsrc = oidx == -1 ? null : orsrcs.remove(oidx);
                if (orsrc != null) {
                    String ndig;
                    String odig = orsrc.computeDigest(version, md, null);
                    if (odig.equals(ndig = rsrc.computeDigest(version, md, null))) {
                        if (!verbose) continue;
                        System.out.println("Unchanged: " + rsrc.getPath());
                        continue;
                    }
                    if (rsrc.getPath().endsWith(".jar")) {
                        if (verbose) {
                            System.out.println("JarDiff: " + rsrc.getPath());
                        }
                        File otemp = this.rebuildJar(orsrc.getLocal());
                        File temp = this.rebuildJar(rsrc.getLocal());
                        jout.putNextEntry(new ZipEntry(rsrc.getPath() + ".patch"));
                        this.jarDiff(otemp, temp, jout);
                        FileUtil.deleteHarder(otemp);
                        FileUtil.deleteHarder(temp);
                        continue;
                    }
                }
                if (verbose) {
                    System.out.println("Addition: " + rsrc.getPath());
                }
                jout.putNextEntry(new ZipEntry(rsrc.getPath() + ".create"));
                Differ.pipe(rsrc.getLocal(), jout);
            }
            for (Resource rsrc : orsrcs) {
                if (verbose) {
                    System.out.println("Removal: " + rsrc.getPath());
                }
                jout.putNextEntry(new ZipEntry(rsrc.getPath() + ".delete"));
            }
            System.out.println("Created patch file: " + patch);
        }
        catch (IOException ioe) {
            FileUtil.deleteHarder(patch);
            throw ioe;
        }
    }

    protected File rebuildJar(File target) throws IOException {
        File temp = File.createTempFile("differ", "jar");
        try (ZipFile jar = new ZipFile(target);
             FileOutputStream tempFos = new FileOutputStream(temp);
             BufferedOutputStream tempBos = new BufferedOutputStream(tempFos);
             ZipOutputStream jout = new ZipOutputStream(tempBos);){
            byte[] buffer = new byte[4096];
            Enumeration<? extends ZipEntry> iter = jar.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                entry.setCompressedSize(-1L);
                jout.putNextEntry(entry);
                InputStream in = jar.getInputStream(entry);
                try {
                    int size = in.read(buffer);
                    while (size != -1) {
                        jout.write(buffer, 0, size);
                        size = in.read(buffer);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return temp;
    }

    protected void jarDiff(File ofile, File nfile, ZipOutputStream jout) throws IOException {
        JarDiff.createPatch(ofile.getPath(), nfile.getPath(), jout, false);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: Differ [-verbose] new_vers_dir old_vers_dir");
            System.exit(255);
        }
        Differ differ = new Differ();
        boolean verbose = false;
        int aidx = 0;
        if ("-verbose".equals(args[0])) {
            verbose = true;
            ++aidx;
        }
        try {
            differ.createDiff(new File(args[aidx++]), new File(args[aidx++]), verbose);
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getMessage());
            System.exit(255);
        }
    }

    protected static void pipe(File file, OutputStream out) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            StreamUtil.copy(fin, out);
        }
    }
}

