/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.ClassPath;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.PathBuilder;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.net.Connector;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.Color;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.HostWhitelist;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.Rectangle;
import com.threerings.getdown.util.StreamUtil;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Application {
    public static final String CONFIG_FILE = "getdown.txt";
    public static final String VERSION_FILE = "version.txt";
    public static final String PROP_PASSTHROUGH_PREFIX = "app.";
    public static final String SIGNATURE_SUFFIX = ".sig";
    public static final String MANIFEST_CLASS = "manifest";
    public Connector conn = Connector.DEFAULT;
    protected final EnvConfig _envc;
    protected Digest _digest;
    protected long _version = -1L;
    protected long _targetVersion = -1L;
    protected String _appbase;
    protected URL _vappbase;
    protected URL _latest;
    protected String _class;
    protected String _dockName;
    protected String _dockIconPath;
    protected boolean _strictComments;
    protected boolean _allowOffline;
    protected int _maxConcDownloads;
    protected String _trackingURL;
    protected Set<Integer> _trackingPcts;
    protected String _trackingCookieName;
    protected String _trackingCookieProperty;
    protected String _trackingURLSuffix;
    protected String _trackingGAHash;
    protected long _trackingStart;
    protected int _trackingId;
    protected String _javaVersionProp = "java.version";
    protected String _javaVersionRegex = "(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(_\\d+)?)?)?";
    protected long _javaMinVersion;
    protected long _javaMaxVersion;
    protected boolean _javaExactVersionRequired;
    protected String _javaLocation;
    protected File _javaLocalDir;
    protected List<Resource> _codes = new ArrayList<Resource>();
    protected List<Resource> _resources = new ArrayList<Resource>();
    protected List<String> _cleanupPatterns = new ArrayList<String>();
    protected List<String> _cpdirs = new ArrayList<String>();
    protected int _verifyTimeout = 60;
    protected RevalidatePolicy _revalidatePolicy = RevalidatePolicy.AFTER_UPDATE;
    protected boolean _useCodeCache;
    protected int _codeCacheRetentionDays;
    protected Map<String, AuxGroup> _auxgroups = new HashMap<String, AuxGroup>();
    protected Map<String, Boolean> _auxactive = new HashMap<String, Boolean>();
    protected List<String> _jvmargs = new ArrayList<String>();
    protected List<String> _appargs = new ArrayList<String>();
    protected String[] _optimumJvmArgs;
    protected List<String> _txtJvmArgs = new ArrayList<String>();
    protected FileLock _lock;
    protected FileChannel _lockChannel;
    protected Random _rando = new Random();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String ENV_VAR_PREFIX = "%ENV.";
    protected static final Pattern ENV_VAR_PATTERN = Pattern.compile("%ENV\\.(.*?)%");

    public static Config readConfig(EnvConfig envc, boolean checkPlatform) throws IOException {
        Config config = null;
        File cfgfile = new File(envc.appDir, CONFIG_FILE);
        Config.ParseOpts opts = Config.createOpts(checkPlatform);
        try {
            if (cfgfile.exists()) {
                config = Config.parseConfig(cfgfile, opts);
            } else {
                cfgfile = new File(envc.appDir, "getdown.txt_old");
                if (cfgfile.exists()) {
                    config = Config.parseConfig(cfgfile, opts);
                } else {
                    Log.log.info("Found no getdown.txt file", "appdir", envc.appDir);
                }
            }
        }
        catch (Exception e) {
            Log.log.warning("Failure reading config file", "file", config, e);
        }
        if (config == null) {
            Log.log.info("Using 'appbase' from bootstrap config", "appbase", envc.appBase);
            HashMap<String, Object> cdata = new HashMap<String, Object>();
            cdata.put("appbase", envc.appBase);
            config = new Config(cdata);
        }
        return config;
    }

    public Application(EnvConfig envc) {
        this._envc = envc;
    }

    public File getAppDir() {
        return this._envc.appDir;
    }

    public boolean useCodeCache() {
        return this._useCodeCache;
    }

    public int getCodeCacheRetentionDays() {
        return this._codeCacheRetentionDays;
    }

    public int maxConcurrentDownloads() {
        return this._maxConcDownloads;
    }

    public Resource getConfigResource() {
        try {
            return this.createResource(CONFIG_FILE, Resource.NORMAL);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid appbase '" + this._vappbase + "'.", e);
        }
    }

    public List<Resource> getCodeResources() {
        return this._codes;
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public List<String> getClassPathDirectories() {
        return this._cpdirs;
    }

    public String getDigest(Resource resource) {
        return this._digest.getDigest(resource);
    }

    public List<String> cleanupPatterns() {
        return this._cleanupPatterns;
    }

    public List<Resource> getAllActiveResources() {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        allResources.addAll(this.getActiveCodeResources());
        allResources.addAll(this.getActiveResources());
        return allResources;
    }

    public AuxGroup getAuxGroup(String name) {
        return this._auxgroups.get(name);
    }

    public Iterable<AuxGroup> getAuxGroups() {
        return this._auxgroups.values();
    }

    public boolean isAuxGroupActive(String auxgroup) {
        Boolean active = this._auxactive.get(auxgroup);
        if (active == null) {
            active = this.getLocalPath(auxgroup + ".dat").exists();
            this._auxactive.put(auxgroup, active);
        }
        return active;
    }

    public List<Resource> getActiveCodeResources() {
        ArrayList<Resource> codes = new ArrayList<Resource>(this.getCodeResources());
        for (AuxGroup aux : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(aux.name)) continue;
            codes.addAll(aux.codes);
        }
        return codes;
    }

    public List<Resource> getNativeResources() {
        ArrayList<Resource> natives = new ArrayList<Resource>();
        for (Resource resource : this._resources) {
            if (!resource.isNative()) continue;
            natives.add(resource);
        }
        return natives;
    }

    public List<Resource> getActiveResources() {
        ArrayList<Resource> rsrcs = new ArrayList<Resource>(this.getResources());
        for (AuxGroup aux : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(aux.name)) continue;
            rsrcs.addAll(aux.rsrcs);
        }
        return rsrcs;
    }

    public Resource getPatchResource(String auxgroup) {
        if (this._targetVersion <= this._version) {
            Log.log.warning("Requested patch resource for up-to-date or non-versioned application", "cvers", this._version, "tvers", this._targetVersion);
            return null;
        }
        String infix = auxgroup == null ? "" : "-" + auxgroup;
        String pfile = "patch" + infix + this._version + ".dat";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(pfile));
            return new Resource(pfile, remote, this.getLocalPath(pfile), Resource.NORMAL);
        }
        catch (Exception e) {
            Log.log.warning("Failed to create patch resource path", "pfile", pfile, "appbase", this._appbase, "tvers", this._targetVersion, "error", e);
            return null;
        }
    }

    public File getJavaLocalDir() {
        return this._javaLocalDir;
    }

    public Resource getJavaVMResource() {
        if (StringUtil.isBlank(this._javaLocation)) {
            return null;
        }
        String vmfileExt = this._javaLocation.substring(this._javaLocation.lastIndexOf(46));
        String vmfile = this._javaLocalDir.getName() + vmfileExt;
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(this._javaLocation));
            return new Resource(vmfile, remote, this.getLocalPath(vmfile), EnumSet.of(Resource.Attr.UNPACK, Resource.Attr.CLEAN));
        }
        catch (Exception e) {
            Log.log.warning("Failed to create VM resource", "vmfile", vmfile, "appbase", this._appbase, "tvers", this._targetVersion, "javaloc", this._javaLocation, "error", e);
            return null;
        }
    }

    public Resource getFullResource() {
        String file = "full";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(file));
            return new Resource(file, remote, this.getLocalPath(file), Resource.NORMAL);
        }
        catch (Exception e) {
            Log.log.warning("Failed to create full resource path", "file", file, "appbase", this._appbase, "tvers", this._targetVersion, "error", e);
            return null;
        }
    }

    public URL getTrackingURL(String event) {
        try {
            String suffix = this._trackingURLSuffix == null ? "" : this._trackingURLSuffix;
            String ga = this.getGATrackingCode();
            return this._trackingURL == null ? null : HostWhitelist.verify(new URL(this._trackingURL + Application.encodePath(event + suffix + ga)));
        }
        catch (MalformedURLException mue) {
            Log.log.warning("Invalid tracking URL", "path", this._trackingURL, "event", event, "error", mue);
            return null;
        }
    }

    public URL getTrackingProgressURL(int percent) {
        if (this._trackingPcts == null || !this._trackingPcts.contains(percent)) {
            return null;
        }
        return this.getTrackingURL("pct" + percent);
    }

    public String getTrackingCookieName() {
        return this._trackingCookieName;
    }

    public String getTrackingCookieProperty() {
        return this._trackingCookieProperty;
    }

    public Config init(boolean checkPlatform) throws IOException {
        Config config = Application.readConfig(this._envc, checkPlatform);
        this.initBase(config);
        this.initJava(config);
        this.initTracking(config);
        this.initResources(config);
        this.initCleanupPatterns(config);
        this.initArgs(config);
        return config;
    }

    public void initBase(Config config) throws IOException {
        this._version = config.getLong("version", -1L);
        this._appbase = config.getString("appbase");
        if (this._appbase == null) {
            throw new RuntimeException("m.missing_appbase");
        }
        this._appbase = this.resolveEnvVars(SysProps.overrideAppbase(this._appbase));
        if (!this._appbase.endsWith("/")) {
            this._appbase = this._appbase + "/";
        }
        try {
            this._vappbase = this.createVAppBase(this._version);
        }
        catch (MalformedURLException mue) {
            String err = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw new IOException(err, mue);
        }
        String latest = config.getString("latest");
        if (latest != null) {
            latest = (latest = this.processArg(latest)).startsWith(this._appbase) ? this._appbase + latest.substring(this._appbase.length()) : SysProps.replaceDomain(latest);
            try {
                this._latest = HostWhitelist.verify(new URL(latest));
            }
            catch (MalformedURLException mue) {
                Log.log.warning("Invalid URL for latest attribute.", mue);
            }
        }
        this._strictComments = config.getBoolean("strict_comments");
        this._allowOffline = config.getBoolean("allow_offline");
        this._revalidatePolicy = config.getEnum("revalidate_policy", RevalidatePolicy.class, RevalidatePolicy.AFTER_UPDATE);
        int tpSize = SysProps.threadPoolSize();
        this._maxConcDownloads = Math.max(1, config.getInt("max_concurrent_downloads", tpSize));
        this._verifyTimeout = config.getInt("verify_timeout", 60);
        this._useCodeCache = config.getBoolean("use_code_cache");
        this._codeCacheRetentionDays = config.getInt("code_cache_retention_days", 7);
    }

    public void initJava(Config config) {
        this._javaVersionProp = config.getString("java_version_prop", this._javaVersionProp);
        this._javaVersionRegex = config.getString("java_version_regex", this._javaVersionRegex);
        this._javaMinVersion = config.getLong("java_version", this._javaMinVersion);
        this._javaMinVersion = config.getLong("java_min_version", this._javaMinVersion);
        this._javaMaxVersion = config.getLong("java_max_version", this._javaMaxVersion);
        this._javaExactVersionRequired = config.getBoolean("java_exact_version_required");
        this._javaLocation = config.getString("java_location");
        this._javaLocalDir = this.getLocalPath(config.getString("java_local_dir", "java_vm"));
    }

    public void initTracking(Config config) {
        this._trackingURL = config.getString("tracking_url");
        String trackPcts = config.getString("tracking_percents");
        if (!StringUtil.isBlank(trackPcts)) {
            this._trackingPcts = new HashSet<Integer>();
            for (int pct : StringUtil.parseIntArray(trackPcts)) {
                this._trackingPcts.add(pct);
            }
        } else if (!StringUtil.isBlank(this._trackingURL)) {
            this._trackingPcts = new HashSet<Integer>();
            this._trackingPcts.add(50);
        }
        this._trackingCookieName = config.getString("tracking_cookie_name");
        this._trackingCookieProperty = config.getString("tracking_cookie_property");
        this._trackingURLSuffix = config.getString("tracking_url_suffix");
        this._trackingGAHash = config.getString("tracking_ga_hash");
    }

    public void initResources(Config config) throws IOException {
        this._codes.clear();
        this._resources.clear();
        this._auxgroups.clear();
        if (config.getMultiValue("code") == null && config.getMultiValue("ucode") == null) {
            throw new IOException("m.missing_code");
        }
        this.parseResources(config, "code", Resource.NORMAL, this._codes);
        this.parseResources(config, "ucode", Resource.UNPACK, this._codes);
        this.parseResources(config, "resource", Resource.NORMAL, this._resources);
        this.parseResources(config, "uresource", Resource.UNPACK, this._resources);
        this.parseResources(config, "xresource", Resource.EXEC, this._resources);
        this.parseResources(config, "presource", Resource.PRELOAD, this._resources);
        this.parseResources(config, "nresource", Resource.NATIVE, this._resources);
        for (String auxgroup : config.getList("auxgroups")) {
            ArrayList<Resource> codes = new ArrayList<Resource>();
            this.parseResources(config, auxgroup + ".code", Resource.NORMAL, codes);
            this.parseResources(config, auxgroup + ".ucode", Resource.UNPACK, codes);
            ArrayList<Resource> rsrcs = new ArrayList<Resource>();
            this.parseResources(config, auxgroup + ".resource", Resource.NORMAL, rsrcs);
            this.parseResources(config, auxgroup + ".xresource", Resource.EXEC, rsrcs);
            this.parseResources(config, auxgroup + ".uresource", Resource.UNPACK, rsrcs);
            this.parseResources(config, auxgroup + ".presource", Resource.PRELOAD, rsrcs);
            this.parseResources(config, auxgroup + ".nresource", Resource.NATIVE, rsrcs);
            this._auxgroups.put(auxgroup, new AuxGroup(auxgroup, codes, rsrcs));
        }
    }

    public void initCleanupPatterns(Config config) {
        this._cleanupPatterns.clear();
        String[] patterns = config.getMultiValue("cleanup_pattern");
        if (patterns == null) {
            return;
        }
        this._cleanupPatterns.addAll(Arrays.asList(patterns));
    }

    public void initArgs(Config config) throws IOException {
        this._jvmargs.clear();
        this._appargs.clear();
        this._txtJvmArgs.clear();
        this._cpdirs.clear();
        String appPrefix = this._envc.appId == null ? "" : this._envc.appId + ".";
        this._class = config.getString("class");
        if (appPrefix.length() > 0) {
            this._class = config.getString(appPrefix + "class", this._class);
        }
        if (this._class == null) {
            throw new IOException("m.missing_class");
        }
        Application.addAll(config.getMultiValue("jvmarg"), this._jvmargs);
        if (appPrefix.length() > 0) {
            Application.addAll(config.getMultiValue(appPrefix + "jvmarg"), this._jvmargs);
        }
        this._optimumJvmArgs = config.getMultiValue("optimum_jvmarg");
        Application.addAll(config.getMultiValue(appPrefix + "apparg"), this._appargs);
        this._appargs.addAll(this._envc.appArgs);
        this.fillAssignmentListFromPairs("extra.txt", this._txtJvmArgs);
        Application.addAll(config.getMultiValue(appPrefix + "classpath"), this._cpdirs);
        this._dockName = config.getString("ui.name");
        this._dockIconPath = config.getString("ui.mac_dock_icon", "../desktop.icns");
    }

    protected void fillAssignmentListFromPairs(String pairLocation, List<String> collector) {
        File pairFile = this.getLocalPath(pairLocation);
        if (pairFile.exists()) {
            try {
                List<String[]> args = Config.parsePairs(pairFile, Config.createOpts(false));
                for (String[] pair : args) {
                    if (pair[1].length() == 0) {
                        collector.add(pair[0]);
                        continue;
                    }
                    collector.add(pair[0] + "=" + pair[1]);
                }
            }
            catch (Throwable t) {
                Log.log.warning("Failed to parse '" + pairFile + "': " + t, new Object[0]);
            }
        }
    }

    public URL getRemoteURL(String path) throws MalformedURLException {
        return new URL(this._vappbase, Application.encodePath(path));
    }

    public File getLocalPath(String path) {
        return new File(this.getAppDir(), path);
    }

    public boolean haveValidJavaVersion() {
        if (this._javaMinVersion == 0L && this._javaMaxVersion == 0L) {
            return true;
        }
        try {
            long version = SysProps.parseJavaVersion(this._javaVersionProp, this._javaVersionRegex);
            Log.log.info("Checking Java version", "current", version, "wantMin", this._javaMinVersion, "wantMax", this._javaMaxVersion);
            Resource vmjar = this.getJavaVMResource();
            if (vmjar != null && vmjar.isMarkedValid()) {
                File relfile = new File(this._javaLocalDir, "release");
                if (!relfile.exists()) {
                    Log.log.warning("Unpacked JVM missing 'release' file. Assuming valid version.", new Object[0]);
                    return true;
                }
                long vmvers = VersionUtil.readReleaseVersion(relfile, this._javaVersionRegex);
                if (vmvers == 0L) {
                    Log.log.warning("Unable to read version from 'release' file. Assuming valid.", new Object[0]);
                    return true;
                }
                version = vmvers;
                Log.log.info("Checking version of unpacked JVM [vers=" + version + "].", new Object[0]);
            }
            if (this._javaExactVersionRequired) {
                if (version == this._javaMinVersion) {
                    return true;
                }
                Log.log.warning("An exact Java VM version is required.", "current", version, "required", this._javaMinVersion);
                return false;
            }
            boolean minVersionOK = this._javaMinVersion == 0L || version >= this._javaMinVersion;
            boolean maxVersionOK = this._javaMaxVersion == 0L || version <= this._javaMaxVersion;
            return minVersionOK && maxVersionOK;
        }
        catch (RuntimeException re) {
            Log.log.warning("Unable to parse VM version, hoping for the best", "error", re, "needed", this._javaMinVersion);
            return true;
        }
    }

    public boolean hasOptimumJvmArgs() {
        return this._optimumJvmArgs != null;
    }

    public boolean allowOffline() {
        return this._allowOffline;
    }

    public void attemptRecovery(StatusDisplay status) throws IOException {
        status.updateStatus("m.updating_metadata");
        this.downloadConfigFile();
    }

    public void updateMetadata() throws IOException {
        try {
            this._vappbase = this.createVAppBase(this._targetVersion);
        }
        catch (MalformedURLException mue) {
            String err = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw new IOException(err, mue);
        }
        try {
            this.downloadDigestFiles();
            this.downloadConfigFile();
        }
        catch (IOException ex) {
            if (this._allowOffline) {
                Log.log.warning("Failed to update digest files.  Attempting offline operaton.", ex);
                if (!FileUtil.deleteHarder(this.getLocalPath(VERSION_FILE))) {
                    Log.log.warning("Deleting version.txt failed.  This probably isn't going to work.", new Object[0]);
                }
            }
            throw ex;
        }
    }

    public Process createProcess(boolean optimum) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(LaunchUtil.getJVMBinaryPath(this._javaLocalDir, SysProps.debug() || optimum));
        boolean dashJarMode = MANIFEST_CLASS.equals(this._class);
        ClassPath classPath = PathBuilder.buildClassPath(this);
        if (!dashJarMode) {
            args.add("-classpath");
            args.add(classPath.asArgumentString(this.getAppDir()));
        }
        if (LaunchUtil.isMacOS()) {
            args.add("-Xdock:icon=" + this.getLocalPath(this._dockIconPath).getAbsolutePath());
            args.add("-Xdock:name=" + this._dockName);
        }
        this.conn.addProxyArgs(args);
        args.add("-Dcom.threerings.getdown=true");
        ClassPath javaLibPath = PathBuilder.buildLibsPath(this, true);
        if (javaLibPath != null) {
            args.add("-Djava.library.path=" + javaLibPath.asArgumentString(this.getAppDir()));
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            key = key.substring(PROP_PASSTHROUGH_PREFIX.length());
            args.add("-D" + key + "=" + entry.getValue());
        }
        for (String string : this._jvmargs) {
            args.add(this.processArg(string));
        }
        if (optimum && this._optimumJvmArgs != null) {
            for (Iterator<Object> iterator : this._optimumJvmArgs) {
                args.add(this.processArg((String)((Object)iterator)));
            }
        }
        for (String string : this._txtJvmArgs) {
            args.add(this.processArg(string));
        }
        if (dashJarMode) {
            args.add("-jar");
            args.add(classPath.asArgumentString(this.getAppDir()));
        } else {
            args.add(this._class);
        }
        for (String string : this._appargs) {
            args.add(this.processArg(string));
        }
        String[] envp = this.createEnvironment();
        Object[] sargs = args.toArray(new String[args.size()]);
        Log.log.info("Running " + StringUtil.join(sargs, "\n  "), new Object[0]);
        return Runtime.getRuntime().exec((String[])sargs, envp, this.getAppDir());
    }

    protected String[] createEnvironment() {
        ArrayList<String> envvar = new ArrayList<String>();
        this.fillAssignmentListFromPairs("env.txt", envvar);
        if (envvar.isEmpty()) {
            Log.log.info("Didn't find any custom environment variables, not setting any.", new Object[0]);
            return null;
        }
        ArrayList<String> envAssignments = new ArrayList<String>();
        for (String string : envvar) {
            envAssignments.add(this.processArg(string));
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            envAssignments.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        Object[] envp = envAssignments.toArray(new String[envAssignments.size()]);
        Log.log.info("Environment " + StringUtil.join(envp, "\n "), new Object[0]);
        return envp;
    }

    /*
     * WARNING - void declaration
     */
    public void invokeDirect() throws IOException {
        void var6_14;
        void var6_9;
        ClassPath classPath = PathBuilder.buildClassPath(this);
        URL[] jarUrls = classPath.asUrls();
        URLClassLoader loader = new URLClassLoader(jarUrls, ClassLoader.getSystemClassLoader()){

            @Override
            protected PermissionCollection getPermissions(CodeSource code) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }
        };
        Thread.currentThread().setContextClassLoader(loader);
        Log.log.info("Configured URL class loader:", new Object[0]);
        URL[] uRLArray = jarUrls;
        int n = uRLArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            URL url = uRLArray[var6_9];
            Log.log.info("  " + url, new Object[0]);
            ++var6_9;
        }
        for (String jvmarg : this._jvmargs) {
            if (!jvmarg.startsWith("-D")) continue;
            int n2 = (jvmarg = this.processArg(jvmarg.substring(2))).indexOf(61);
            if (n2 == -1) {
                Log.log.warning("Bogus system property: '" + jvmarg + "'?", new Object[0]);
                continue;
            }
            System.setProperty(jvmarg.substring(0, n2), jvmarg.substring(n2 + 1));
        }
        HashMap<String, String> passProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            key = key.substring(PROP_PASSTHROUGH_PREFIX.length());
            passProps.put(key, (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : passProps.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Object[] args = new String[this._appargs.size()];
        boolean bl2 = false;
        while (var6_14 < args.length) {
            args[var6_14] = this.processArg(this._appargs.get((int)var6_14));
            ++var6_14;
        }
        try {
            Log.log.info("Loading " + this._class, new Object[0]);
            Class<?> clazz = loader.loadClass(this._class);
            Method main = clazz.getMethod("main", EMPTY_STRING_ARRAY.getClass());
            Log.log.info("Invoking main({" + StringUtil.join(args, ", ") + "})", new Object[0]);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception exception) {
            Log.log.warning("Failure invoking app main", exception);
        }
    }

    protected String processArg(String arg) {
        arg = arg.replace("%APPDIR%", this.getAppDir().getAbsolutePath());
        arg = arg.replace("%VERSION%", String.valueOf(this._version));
        arg = this.resolveEnvVars(arg);
        return arg;
    }

    protected String resolveEnvVars(String text) {
        if (text.contains(ENV_VAR_PREFIX)) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = ENV_VAR_PATTERN.matcher(text);
            while (matcher.find()) {
                String varName = matcher.group(1);
                String varValue = System.getenv(varName);
                String repValue = varValue == null ? "MISSING-" + varName : varValue;
                matcher.appendReplacement(sb, Matcher.quoteReplacement(repValue));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyMetadata(StatusDisplay status) throws IOException {
        Resource crsrc;
        Log.log.info("Verifying application: " + this._vappbase, new Object[0]);
        Log.log.info("Version: " + this._version, new Object[0]);
        Log.log.info("Class: " + this._class, new Object[0]);
        try {
            this._digest = new Digest(this.getAppDir(), this._strictComments);
        }
        catch (IOException ioe) {
            Log.log.info("Failed to load digest: " + ioe.getMessage() + ". Attempting recovery...", new Object[0]);
        }
        if (this._version == -1L) {
            String olddig = this._digest == null ? "" : this._digest.getMetaDigest();
            try {
                status.updateStatus("m.checking");
                this.downloadDigestFiles();
                this._digest = new Digest(this.getAppDir(), this._strictComments);
                if (!olddig.equals(this._digest.getMetaDigest())) {
                    Log.log.info("Unversioned digest changed. Revalidating...", new Object[0]);
                    status.updateStatus("m.validating");
                    this.clearValidationMarkers();
                }
            }
            catch (IOException ioe) {
                Log.log.warning("Failed to refresh non-versioned digest: " + ioe.getMessage() + ". Proceeding...", new Object[0]);
            }
        }
        if (this._digest == null) {
            status.updateStatus("m.updating_metadata");
            this.downloadDigestFiles();
            this._digest = new Digest(this.getAppDir(), this._strictComments);
        }
        if (!this._digest.validateResource(crsrc = this.getConfigResource(), null)) {
            status.updateStatus("m.updating_metadata");
            this.downloadConfigFile();
            this.downloadDigestFiles();
            this._digest = new Digest(this.getAppDir(), this._strictComments);
            this.clearValidationMarkers();
            if (this._digest.validateResource(crsrc, null)) {
                this.init(true);
            } else {
                Log.log.warning("getdown.txt failed to validate even after redownloading. Blindly forging onward.", new Object[0]);
            }
        }
        this._targetVersion = this._version;
        if (this._version != -1L) {
            File vfile = this.getLocalPath(VERSION_FILE);
            long fileVersion = VersionUtil.readVersion(vfile);
            if (fileVersion != -1L) {
                this._targetVersion = fileVersion;
            }
            if (this._latest != null) {
                try {
                    List<String[]> vdata = Config.parsePairs(new StringReader(this.conn.fetch(this._latest)), Config.createOpts(false));
                    for (String[] pair : vdata) {
                        if (!"version".equals(pair[0])) continue;
                        this._targetVersion = Math.max(Long.parseLong(pair[1]), this._targetVersion);
                        if (fileVersion == -1L || this._targetVersion <= fileVersion) break;
                        try (FileOutputStream fos = new FileOutputStream(vfile);
                             PrintStream out = new PrintStream(fos);){
                            out.println(this._targetVersion);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Log.log.warning("Unable to retrieve version from latest config file.", e);
                }
            }
        }
        if (this._version == this._targetVersion) return false;
        return true;
    }

    public void verifyResources(ProgressObserver obs, int[] alreadyValid, Set<Resource> unpacked, Set<Resource> toInstall, Set<Resource> toDownload) throws InterruptedException {
        ExecutorService exec = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        final LinkedBlockingQueue actions = new LinkedBlockingQueue();
        final int[] completed = new int[1];
        long start = System.currentTimeMillis();
        List<Resource> rsrcs = this.getAllActiveResources();
        long[] sizes = new long[rsrcs.size()];
        long totalSize = 0L;
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = rsrcs.get(ii).getLocal().length();
            totalSize += sizes[ii];
        }
        final ProgressObserver fobs = obs;
        final ProgressAggregator pagg = new ProgressAggregator(new ProgressObserver(){

            @Override
            public void progress(final int percent) {
                actions.add(new Runnable(){

                    @Override
                    public void run() {
                        fobs.progress(percent);
                    }
                });
            }
        }, sizes);
        final int[] fAlreadyValid = alreadyValid;
        final ConcurrentSkipListSet<Resource> toInstallAsync = new ConcurrentSkipListSet<Resource>(toInstall);
        final ConcurrentSkipListSet toDownloadAsync = new ConcurrentSkipListSet();
        final ConcurrentSkipListSet unpackedAsync = new ConcurrentSkipListSet();
        int ii = 0;
        while (ii < sizes.length) {
            final Resource rsrc = rsrcs.get(ii);
            final int index = ii++;
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    Application.this.verifyResource(rsrc, pagg.startElement(index), fAlreadyValid, unpackedAsync, toInstallAsync, toDownloadAsync);
                    actions.add(new Runnable(){

                        @Override
                        public void run() {
                            completed[0] = completed[0] + 1;
                        }
                    });
                }
            });
        }
        while (completed[0] < rsrcs.size()) {
            Runnable action = (Runnable)actions.poll(this._verifyTimeout, TimeUnit.SECONDS);
            if (action == null) {
                throw new IllegalStateException("m.verify_timeout");
            }
            action.run();
        }
        exec.shutdown();
        toInstall.addAll(toInstallAsync);
        toDownload.addAll(toDownloadAsync);
        unpacked.addAll(unpackedAsync);
        long complete = System.currentTimeMillis();
        Log.log.info("Verified resources", "count", rsrcs.size(), "alreadyValid", alreadyValid[0], "size", totalSize / 1024L + "k", "duration", complete - start + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyResource(Resource rsrc, ProgressObserver obs, int[] alreadyValid, Set<Resource> unpacked, Set<Resource> toInstall, Set<Resource> toDownload) {
        if (this._revalidatePolicy != RevalidatePolicy.ALWAYS && rsrc.isMarkedValid()) {
            if (alreadyValid != null) {
                alreadyValid[0] = alreadyValid[0] + 1;
            }
            obs.progress(100);
            return;
        }
        try {
            if (this._digest.validateResource(rsrc, obs)) {
                if (rsrc.getLocalNew().exists()) {
                    toInstall.add(rsrc);
                    return;
                }
                rsrc.applyAttrs();
                unpacked.add(rsrc);
                rsrc.markAsValid();
                return;
            }
        }
        catch (Exception e) {
            Log.log.info("Failure verifying resource. Requesting redownload...", "rsrc", rsrc, "error", e);
        }
        finally {
            obs.progress(100);
        }
        toDownload.add(rsrc);
    }

    public void unpackResources(ProgressObserver obs, Set<Resource> unpacked) throws InterruptedException {
        List<Resource> rsrcs = this.getActiveResources();
        Iterator<Resource> it = rsrcs.iterator();
        while (it.hasNext()) {
            Resource rsrc = it.next();
            if (rsrc.shouldUnpack() && !unpacked.contains(rsrc)) continue;
            it.remove();
        }
        long[] sizes = new long[rsrcs.size()];
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = rsrcs.get(ii).getLocal().length();
        }
        ProgressAggregator pagg = new ProgressAggregator(obs, sizes);
        for (int ii = 0; ii < sizes.length; ++ii) {
            Resource rsrc = rsrcs.get(ii);
            ProgressObserver pobs = pagg.startElement(ii);
            try {
                rsrc.unpack();
            }
            catch (IOException ioe) {
                Log.log.warning("Failure unpacking resource", "rsrc", rsrc, ioe);
            }
            pobs.progress(100);
        }
    }

    public void clearValidationMarkers() {
        this.clearValidationMarkers(this.getAllActiveResources().iterator());
    }

    public long getVersion() {
        return this._version;
    }

    protected URL createVAppBase(long version) throws MalformedURLException {
        String url = version < 0L ? this._appbase : this._appbase.replace("%VERSION%", String.valueOf(version));
        return HostWhitelist.verify(new URL(url));
    }

    protected void clearValidationMarkers(Iterator<Resource> iter) {
        while (iter.hasNext()) {
            iter.next().clearMarker();
        }
    }

    protected void downloadConfigFile() throws IOException {
        this.downloadControlFile(CONFIG_FILE, 0);
    }

    public synchronized boolean lockForUpdates() {
        if (this._lock != null && this._lock.isValid()) {
            return true;
        }
        try {
            this._lockChannel = new RandomAccessFile(this.getLocalPath("gettingdown.lock"), "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            Log.log.warning("Unable to create lock file", "message", e.getMessage(), e);
            return false;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException e) {
            Log.log.warning("Unable to create lock", "message", e.getMessage(), e);
            return false;
        }
        catch (OverlappingFileLockException e) {
            Log.log.warning("The lock is held elsewhere in this JVM", e);
            return false;
        }
        Log.log.info("Able to lock for updates: " + (this._lock != null), new Object[0]);
        return this._lock != null;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            Log.log.info("Releasing lock", new Object[0]);
            try {
                this._lock.release();
            }
            catch (IOException e) {
                Log.log.warning("Unable to release lock", "message", e.getMessage(), e);
            }
            try {
                this._lockChannel.close();
            }
            catch (IOException e) {
                Log.log.warning("Unable to close lock channel", "message", e.getMessage(), e);
            }
            this._lockChannel = null;
            this._lock = null;
        }
    }

    protected void downloadDigestFiles() throws IOException {
        for (int version = 1; version <= 2; ++version) {
            this.downloadControlFile(Digest.digestFile(version), version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadControlFile(String path, int sigVersion) throws IOException {
        File original;
        File target = this.downloadFile(path);
        if (sigVersion > 0) {
            if (this._envc.certs.isEmpty()) {
                Log.log.info("No signing certs, not verifying digest.txt", "path", path);
            } else {
                File signatureFile = this.downloadFile(path + SIGNATURE_SUFFIX);
                byte[] signature = null;
                try (FileInputStream signatureStream = new FileInputStream(signatureFile);){
                    signature = StreamUtil.toByteArray(signatureStream);
                }
                finally {
                    FileUtil.deleteHarder(signatureFile);
                }
                byte[] buffer = new byte[8192];
                int validated = 0;
                for (Certificate cert : this._envc.certs) {
                    try (FileInputStream dataInput = new FileInputStream(target);){
                        int length;
                        Signature sig = Signature.getInstance(Digest.sigAlgorithm(sigVersion));
                        sig.initVerify(cert);
                        while ((length = dataInput.read(buffer)) != -1) {
                            sig.update(buffer, 0, length);
                        }
                        if (!sig.verify(Base64.decode(signature, 0))) {
                            Log.log.info("Signature does not match", "cert", cert.getPublicKey());
                            continue;
                        }
                        Log.log.info("Signature matches", "cert", cert.getPublicKey());
                        ++validated;
                    }
                    catch (IOException ioe) {
                        Log.log.warning("Failure validating signature of " + target + ": " + ioe, new Object[0]);
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
                if (validated == 0) {
                    FileUtil.deleteHarder(target);
                    throw new IOException("m.corrupt_digest_signature_error");
                }
            }
        }
        if (!FileUtil.renameTo(target, original = this.getLocalPath(path))) {
            throw new IOException("Failed to rename(" + target + ", " + original + ")");
        }
    }

    protected File downloadFile(String path) throws IOException {
        File target = this.getLocalPath(path + "_new");
        URL targetURL = null;
        try {
            targetURL = this.getRemoteURL(path);
        }
        catch (Exception e) {
            Log.log.warning("Requested to download invalid control file", "appbase", this._vappbase, "path", path, "error", e);
            throw new IOException("Invalid path '" + path + "'.", e);
        }
        Log.log.info("Attempting to refetch '" + path + "' from '" + targetURL + "'.", new Object[0]);
        this.conn.download(targetURL, target);
        return target;
    }

    protected Resource createResource(String path, EnumSet<Resource.Attr> attrs) throws MalformedURLException {
        return new Resource(path, this.getRemoteURL(path), this.getLocalPath(path), attrs);
    }

    protected static void addAll(String[] values, List<String> target) {
        if (values != null) {
            Collections.addAll(target, values);
        }
    }

    public static List<Integer> intsToList(int[] values) {
        ArrayList<Integer> list = new ArrayList<Integer>(values.length);
        for (int val : values) {
            list.add(val);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> stringsToList(String[] values) {
        return values == null ? null : Collections.unmodifiableList(Arrays.asList(values));
    }

    protected void parseResources(Config config, String name, EnumSet<Resource.Attr> attrs, List<Resource> list) {
        String[] rsrcs = config.getMultiValue(name);
        if (rsrcs == null) {
            return;
        }
        for (String rsrc : rsrcs) {
            try {
                list.add(this.createResource(rsrc, attrs));
            }
            catch (Exception e) {
                Log.log.warning("Invalid resource '" + rsrc + "'. " + e, new Object[0]);
            }
        }
    }

    protected String getGATrackingCode() {
        if (this._trackingGAHash == null) {
            return "";
        }
        long time = System.currentTimeMillis() / 1000L;
        if (this._trackingStart == 0L) {
            this._trackingStart = time;
        }
        if (this._trackingId == 0) {
            int low = 100000000;
            int high = 1000000000;
            this._trackingId = low + this._rando.nextInt(high - low);
        }
        StringBuilder cookie = new StringBuilder("&utmcc=__utma%3D").append(this._trackingGAHash);
        cookie.append(".").append(this._trackingId);
        cookie.append(".").append(this._trackingStart).append(".").append(this._trackingStart);
        cookie.append(".").append(time).append(".1%3B%2B");
        cookie.append("__utmz%3D").append(this._trackingGAHash).append(".");
        cookie.append(this._trackingStart).append(".1.1.");
        cookie.append("utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B");
        int low = 1000000000;
        int high = 2000000000;
        cookie.append("&utmn=").append(this._rando.nextInt(high - low));
        return cookie.toString();
    }

    protected static String encodePath(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8").replace("%2F", "/").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ue) {
            Log.log.warning("Failed to URL encode " + path + ": " + ue, new Object[0]);
            return path;
        }
    }

    protected static enum RevalidatePolicy {
        ALWAYS,
        AFTER_UPDATE;

    }

    public static class AuxGroup {
        public final String name;
        public final List<Resource> codes;
        public final List<Resource> rsrcs;

        public AuxGroup(String name, List<Resource> codes, List<Resource> rsrcs) {
            this.name = name;
            this.codes = Collections.unmodifiableList(codes);
            this.rsrcs = Collections.unmodifiableList(rsrcs);
        }
    }

    public static interface StatusDisplay {
        public void updateStatus(String var1);
    }

    public static final class UpdateInterface {
        public final String name;
        public final int background;
        public final List<String> rotatingBackgrounds;
        public final String errorBackground;
        public final List<String> iconImages;
        public final String backgroundImage;
        public final String progressImage;
        public final Rectangle progress;
        public final int progressText;
        public final int progressBar;
        public final Rectangle status;
        public final int statusText;
        public final int textShadow;
        public final String installError;
        public final Rectangle patchNotes;
        public final String patchNotesUrl;
        public final boolean hideDecorations;
        public final boolean hideProgressText;
        public final int minShowSeconds;
        public final Map<Step, List<Integer>> stepPercentages;

        public String toString() {
            return "[name=" + this.name + ", bg=" + this.background + ", bg=" + this.backgroundImage + ", pi=" + this.progressImage + ", prect=" + this.progress + ", pt=" + this.progressText + ", pb=" + this.progressBar + ", srect=" + this.status + ", st=" + this.statusText + ", shadow=" + this.textShadow + ", err=" + this.installError + ", nrect=" + this.patchNotes + ", notes=" + this.patchNotesUrl + ", stepPercentages=" + this.stepPercentages + ", hideProgressText" + this.hideProgressText + ", minShow=" + this.minShowSeconds + "]";
        }

        public UpdateInterface(Config config) {
            this.name = config.getString("ui.name");
            this.progress = config.getRect("ui.progress", new Rectangle(5, 5, 300, 15));
            this.progressText = config.getColor("ui.progress_text", -16777216);
            this.hideProgressText = config.getBoolean("ui.hide_progress_text");
            this.minShowSeconds = config.getInt("ui.min_show_seconds", 5);
            this.progressBar = config.getColor("ui.progress_bar", 0x6699CC);
            this.status = config.getRect("ui.status", new Rectangle(5, 25, 500, 100));
            this.statusText = config.getColor("ui.status_text", -16777216);
            this.textShadow = config.getColor("ui.text_shadow", 0);
            this.hideDecorations = config.getBoolean("ui.hide_decorations");
            this.backgroundImage = config.getString("ui.background_image");
            int defaultBackground = 0.5f < Color.brightness(this.progressText) ? -16777216 : -1;
            this.background = config.getColor("ui.background", defaultBackground);
            this.progressImage = config.getString("ui.progress_image");
            this.rotatingBackgrounds = Application.stringsToList(config.getMultiValue("ui.rotating_background"));
            this.iconImages = Application.stringsToList(config.getMultiValue("ui.icon"));
            this.errorBackground = config.getString("ui.error_background");
            String installError = config.getUrl("ui.install_error", null);
            this.installError = installError == null ? "m.default_install_error" : MessageUtil.taint(installError);
            this.patchNotes = config.getRect("ui.patch_notes", new Rectangle(5, 50, 112, 26));
            this.patchNotesUrl = config.getUrl("ui.patch_notes_url", null);
            EnumMap<Step, List<Integer>> stepPercentages = new EnumMap<Step, List<Integer>>(Step.class);
            for (Step step : Step.values()) {
                stepPercentages.put(step, step.defaultPercents);
            }
            for (Step step : Step.values()) {
                String spec = config.getString("ui.percents." + step.name());
                if (spec == null) continue;
                try {
                    stepPercentages.put(step, Application.intsToList(StringUtil.parseIntArray(spec)));
                }
                catch (Exception e) {
                    Log.log.warning("Failed to parse percentages for " + (Object)((Object)step) + ": " + spec, new Object[0]);
                }
            }
            this.stepPercentages = Collections.unmodifiableMap(stepPercentages);
        }

        public static enum Step {
            UPDATE_JAVA(10),
            VERIFY_METADATA(15, 65, 95),
            DOWNLOAD(40),
            PATCH(60),
            VERIFY_RESOURCES(70, 97),
            REDOWNLOAD_RESOURCES(90),
            UNPACK(98),
            LAUNCH(99);

            public final List<Integer> defaultPercents;

            private Step(int ... percents) {
                this.defaultPercents = Application.intsToList(percents);
            }
        }
    }
}

