/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.webm;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitWriterBuffer;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;

public class VPCodecConfigurationBox
extends AbstractFullBox {
    public static final String TYPE = "vpcC";
    private int profile;
    private int level;
    private int bitDepth;
    private int chromaSubsampling;
    private int videoFullRangeFlag;
    private int colourPrimaries;
    private int transferCharacteristics;
    private int matrixCoefficients;
    private byte[] codecIntializationData;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;

    public VPCodecConfigurationBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return this.codecIntializationData.length + 12;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        BitWriterBuffer bwb = new BitWriterBuffer(byteBuffer);
        bwb.writeBits(this.profile, 8);
        bwb.writeBits(this.level, 8);
        bwb.writeBits(this.bitDepth, 4);
        bwb.writeBits(this.chromaSubsampling, 3);
        bwb.writeBits(this.videoFullRangeFlag, 1);
        bwb.writeBits(this.colourPrimaries, 8);
        bwb.writeBits(this.transferCharacteristics, 8);
        bwb.writeBits(this.matrixCoefficients, 8);
        bwb.writeBits(this.codecIntializationData.length, 16);
        byteBuffer.put(this.codecIntializationData);
    }

    @Override
    protected void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        BitReaderBuffer brb = new BitReaderBuffer(content);
        this.profile = brb.readBits(8);
        this.level = brb.readBits(8);
        this.bitDepth = brb.readBits(4);
        this.chromaSubsampling = brb.readBits(3);
        this.videoFullRangeFlag = brb.readBits(1);
        this.colourPrimaries = brb.readBits(8);
        this.transferCharacteristics = brb.readBits(8);
        this.matrixCoefficients = brb.readBits(8);
        int len = brb.readBits(16);
        this.codecIntializationData = new byte[len];
        content.get(this.codecIntializationData);
    }

    public int getProfile() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.profile;
    }

    public void setProfile(int profile) {
        int n = profile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.profile = profile;
    }

    public int getLevel() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.level;
    }

    public void setLevel(int level) {
        int n = level;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.level = level;
    }

    public int getBitDepth() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.bitDepth;
    }

    public void setBitDepth(int bitDepth) {
        int n = bitDepth;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.bitDepth = bitDepth;
    }

    public int getChromaSubsampling() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.chromaSubsampling;
    }

    public void setChromaSubsampling(int chromaSubsampling) {
        int n = chromaSubsampling;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.chromaSubsampling = chromaSubsampling;
    }

    public int getVideoFullRangeFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.videoFullRangeFlag;
    }

    public void setVideoFullRangeFlag(int videoFullRangeFlag) {
        int n = videoFullRangeFlag;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.videoFullRangeFlag = videoFullRangeFlag;
    }

    public int getColourPrimaries() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.colourPrimaries;
    }

    public void setColourPrimaries(int colourPrimaries) {
        int n = colourPrimaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.colourPrimaries = colourPrimaries;
    }

    public int getTransferCharacteristics() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.transferCharacteristics;
    }

    public void setTransferCharacteristics(int transferCharacteristics) {
        int n = transferCharacteristics;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.transferCharacteristics = transferCharacteristics;
    }

    public int getMatrixCoefficients() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.matrixCoefficients;
    }

    public void setMatrixCoefficients(int matrixCoefficients) {
        int n = matrixCoefficients;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.matrixCoefficients = matrixCoefficients;
    }

    public byte[] getCodecIntializationData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.codecIntializationData;
    }

    public void setCodecIntializationData(byte[] codecIntializationData) {
        byte[] byArray = codecIntializationData;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)byArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.codecIntializationData = codecIntializationData;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "VPCodecConfigurationBox{profile=" + this.profile + ", level=" + this.level + ", bitDepth=" + this.bitDepth + ", chromaSubsampling=" + this.chromaSubsampling + ", videoFullRangeFlag=" + this.videoFullRangeFlag + ", colourPrimaries=" + this.colourPrimaries + ", transferCharacteristics=" + this.transferCharacteristics + ", matrixCoefficients=" + this.matrixCoefficients + ", codecIntializationData=" + Arrays.toString(this.codecIntializationData) + '}';
    }

    static {
        VPCodecConfigurationBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VPCodecConfigurationBox.java", VPCodecConfigurationBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProfile", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProfile", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "profile", "", "void"), 85);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColourPrimaries", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 121);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setColourPrimaries", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "colourPrimaries", "", "void"), 125);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransferCharacteristics", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 129);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTransferCharacteristics", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "transferCharacteristics", "", "void"), 133);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMatrixCoefficients", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 137);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMatrixCoefficients", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "matrixCoefficients", "", "void"), 141);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCodecIntializationData", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "[B"), 145);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCodecIntializationData", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "[B", "codecIntializationData", "", "void"), 149);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "java.lang.String"), 154);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLevel", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLevel", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "level", "", "void"), 93);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBitDepth", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 97);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBitDepth", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "bitDepth", "", "void"), 101);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChromaSubsampling", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 105);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setChromaSubsampling", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "chromaSubsampling", "", "void"), 109);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVideoFullRangeFlag", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "", "", "", "int"), 113);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setVideoFullRangeFlag", "org.mp4parser.boxes.webm.VPCodecConfigurationBox", "int", "videoFullRangeFlag", "", "void"), 117);
    }
}

