/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentBox;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.boxes.iso23001.part7.AbstractSampleEncryptionBox;
import org.mp4parser.boxes.iso23001.part7.AbstractTrackEncryptionBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.muxer.Mp4TrackImpl;
import org.mp4parser.muxer.RandomAccessSource;
import org.mp4parser.muxer.tracks.encryption.CencEncryptedTrack;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.Path;

public class PiffMp4TrackImpl
extends Mp4TrackImpl
implements CencEncryptedTrack {
    private List<CencSampleAuxiliaryDataFormat> sampleEncryptionEntries;
    private UUID defaultKeyId;

    public PiffMp4TrackImpl(long trackId, Container isofile, RandomAccessSource randomAccess, String name) throws IOException {
        super(trackId, isofile, randomAccess, name);
        TrackBox trackBox = null;
        for (TrackBox box : Path.getPaths((Container)isofile, (String)"moov/trak")) {
            if (box.getTrackHeaderBox().getTrackId() != trackId) continue;
            trackBox = box;
            break;
        }
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath(trackBox, (String)"mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schm[0]");
        assert (schm != null && schm.getSchemeType().equals("piff")) : "Track must be PIFF encrypted";
        this.sampleEncryptionEntries = new ArrayList<CencSampleAuxiliaryDataFormat>();
        List movieExtendsBoxes = Path.getPaths((Container)isofile, (String)"moov/mvex");
        if (!movieExtendsBoxes.isEmpty()) {
            for (MovieFragmentBox movieFragmentBox : isofile.getBoxes(MovieFragmentBox.class)) {
                List trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                for (TrackFragmentBox traf : trafs) {
                    long baseOffset;
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                    AbstractTrackEncryptionBox tenc = (AbstractTrackEncryptionBox)Path.getPath((AbstractContainerBox)trackBox, (String)"mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/uuid[0]");
                    assert (tenc != null);
                    this.defaultKeyId = tenc.getDefault_KID();
                    if (traf.getTrackFragmentHeaderBox().hasBaseDataOffset()) {
                        baseOffset = traf.getTrackFragmentHeaderBox().getBaseDataOffset();
                    } else {
                        Iterator it = isofile.getBoxes().iterator();
                        baseOffset = 0L;
                        Box b = (Box)it.next();
                        while (b != movieFragmentBox) {
                            baseOffset += b.getSize();
                            b = (Box)it.next();
                        }
                    }
                    List truns = traf.getBoxes(TrackRunBox.class);
                    boolean sampleNo = false;
                    AbstractSampleEncryptionBox senc = (AbstractSampleEncryptionBox)traf.getBoxes(AbstractSampleEncryptionBox.class).get(0);
                    for (CencSampleAuxiliaryDataFormat cencSampleAuxiliaryDataFormat : senc.getEntries()) {
                        this.sampleEncryptionEntries.add(cencSampleAuxiliaryDataFormat);
                    }
                }
            }
        }
    }

    public UUID getDefaultKeyId() {
        return this.defaultKeyId;
    }

    @Override
    public boolean hasSubSampleEncryption() {
        return false;
    }

    @Override
    public List<CencSampleAuxiliaryDataFormat> getSampleEncryptionEntries() {
        return this.sampleEncryptionEntries;
    }

    public String toString() {
        return "PiffMp4TrackImpl{handler='" + this.getHandler() + '\'' + '}';
    }

    @Override
    public String getName() {
        return "enc(" + super.getName() + ")";
    }
}

