/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.AudioSpecificConfig;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.SLConfigDescriptor;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;

public class AACTrackImpl
extends AbstractTrack {
    public static final Map<Integer, Integer> SAMPLING_FREQUENCY_INDEX_MAP = new HashMap<Integer, Integer>();
    static Map<Integer, String> audioObjectTypes = new HashMap<Integer, String>();
    TrackMetaData trackMetaData = new TrackMetaData();
    private AudioSampleEntry audioSampleEntry;
    private long[] decTimes;
    private AdtsHeader firstHeader;
    private int bufferSizeDB;
    private long maxBitRate;
    private long avgBitRate;
    private DataSource dataSource;
    private List<Sample> samples;

    public AACTrackImpl(DataSource dataSource) throws IOException {
        this(dataSource, "eng");
    }

    public AACTrackImpl(DataSource dataSource, String lang) throws IOException {
        super(dataSource.toString());
        this.dataSource = dataSource;
        this.samples = new ArrayList<Sample>();
        this.firstHeader = this.readSamples(dataSource);
        double packetsPerSecond = (double)this.firstHeader.sampleRate / 1024.0;
        double duration = (double)this.samples.size() / packetsPerSecond;
        long dataSize = 0L;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (Sample sample : this.samples) {
            int size = (int)sample.getSize();
            dataSize += (long)size;
            queue.add(size);
            while ((double)queue.size() > packetsPerSecond) {
                queue.pop();
            }
            if (queue.size() != (int)packetsPerSecond) continue;
            int currSize = 0;
            for (Integer aQueue : queue) {
                currSize += aQueue.intValue();
            }
            double currBitrate = 8.0 * (double)currSize / (double)queue.size() * packetsPerSecond;
            if (!(currBitrate > (double)this.maxBitRate)) continue;
            this.maxBitRate = (int)currBitrate;
        }
        this.avgBitRate = (int)((double)(8L * dataSize) / duration);
        this.bufferSizeDB = 1536;
        this.audioSampleEntry = new AudioSampleEntry("mp4a");
        if (this.firstHeader.channelconfig == 7) {
            this.audioSampleEntry.setChannelCount(8);
        } else {
            this.audioSampleEntry.setChannelCount(this.firstHeader.channelconfig);
        }
        this.audioSampleEntry.setSampleRate((long)this.firstHeader.sampleRate);
        this.audioSampleEntry.setDataReferenceIndex(1);
        this.audioSampleEntry.setSampleSize(16);
        ESDescriptorBox esds = new ESDescriptorBox();
        ESDescriptor descriptor = new ESDescriptor();
        descriptor.setEsId(0);
        SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
        slConfigDescriptor.setPredefined(2);
        descriptor.setSlConfigDescriptor(slConfigDescriptor);
        DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
        decoderConfigDescriptor.setObjectTypeIndication(64);
        decoderConfigDescriptor.setStreamType(5);
        decoderConfigDescriptor.setBufferSizeDB(this.bufferSizeDB);
        decoderConfigDescriptor.setMaxBitRate(this.maxBitRate);
        decoderConfigDescriptor.setAvgBitRate(this.avgBitRate);
        AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
        audioSpecificConfig.setOriginalAudioObjectType(2);
        audioSpecificConfig.setSamplingFrequencyIndex(this.firstHeader.sampleFrequencyIndex);
        audioSpecificConfig.setChannelConfiguration(this.firstHeader.channelconfig);
        decoderConfigDescriptor.setAudioSpecificInfo(audioSpecificConfig);
        descriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
        esds.setEsDescriptor(descriptor);
        this.audioSampleEntry.addBox((Box)esds);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(lang);
        this.trackMetaData.setVolume(1.0f);
        this.trackMetaData.setTimescale(this.firstHeader.sampleRate);
        this.decTimes = new long[this.samples.size()];
        Arrays.fill(this.decTimes, 1024L);
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.audioSampleEntry);
    }

    @Override
    public long[] getSampleDurations() {
        return this.decTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private AdtsHeader readADTSHeader(DataSource channel) throws IOException {
        AdtsHeader hdr = new AdtsHeader();
        ByteBuffer bb = ByteBuffer.allocate(7);
        while (bb.position() < 7) {
            if (channel.read(bb) != -1) continue;
            return null;
        }
        BitReaderBuffer brb = new BitReaderBuffer((ByteBuffer)((Buffer)bb).rewind());
        int syncword = brb.readBits(12);
        if (syncword != 4095) {
            throw new IOException("Expected Start Word 0xfff");
        }
        hdr.mpegVersion = brb.readBits(1);
        hdr.layer = brb.readBits(2);
        hdr.protectionAbsent = brb.readBits(1);
        hdr.profile = brb.readBits(2) + 1;
        hdr.sampleFrequencyIndex = brb.readBits(4);
        hdr.sampleRate = SAMPLING_FREQUENCY_INDEX_MAP.get(hdr.sampleFrequencyIndex);
        brb.readBits(1);
        hdr.channelconfig = brb.readBits(3);
        hdr.original = brb.readBits(1);
        hdr.home = brb.readBits(1);
        hdr.copyrightedStream = brb.readBits(1);
        hdr.copyrightStart = brb.readBits(1);
        hdr.frameLength = brb.readBits(13);
        hdr.bufferFullness = brb.readBits(11);
        hdr.numAacFramesPerAdtsFrame = brb.readBits(2) + 1;
        if (hdr.numAacFramesPerAdtsFrame != 1) {
            throw new IOException("This muxer can only work with 1 AAC frame per ADTS frame");
        }
        if (hdr.protectionAbsent == 0) {
            channel.read(ByteBuffer.allocate(2));
        }
        return hdr;
    }

    private AdtsHeader readSamples(DataSource channel) throws IOException {
        AdtsHeader hdr;
        AdtsHeader first = null;
        while ((hdr = this.readADTSHeader(channel)) != null) {
            if (first == null) {
                first = hdr;
            }
            final long currentPosition = channel.position();
            final long frameSize = hdr.frameLength - hdr.getSize();
            this.samples.add(new Sample(){

                @Override
                public void writeTo(WritableByteChannel channel) throws IOException {
                    AACTrackImpl.this.dataSource.transferTo(currentPosition, frameSize, channel);
                }

                @Override
                public long getSize() {
                    return frameSize;
                }

                @Override
                public ByteBuffer asByteBuffer() {
                    try {
                        return AACTrackImpl.this.dataSource.map(currentPosition, frameSize);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public SampleEntry getSampleEntry() {
                    return AACTrackImpl.this.audioSampleEntry;
                }
            });
            channel.position(channel.position() + (long)hdr.frameLength - (long)hdr.getSize());
        }
        return first;
    }

    public String toString() {
        return "AACTrackImpl{sampleRate=" + this.firstHeader.sampleRate + ", channelconfig=" + this.firstHeader.channelconfig + '}';
    }

    static {
        audioObjectTypes.put(1, "AAC Main");
        audioObjectTypes.put(2, "AAC LC (Low Complexity)");
        audioObjectTypes.put(3, "AAC SSR (Scalable Sample Rate)");
        audioObjectTypes.put(4, "AAC LTP (Long Term Prediction)");
        audioObjectTypes.put(5, "SBR (Spectral Band Replication)");
        audioObjectTypes.put(6, "AAC Scalable");
        audioObjectTypes.put(7, "TwinVQ");
        audioObjectTypes.put(8, "CELP (Code Excited Linear Prediction)");
        audioObjectTypes.put(9, "HXVC (Harmonic Vector eXcitation Coding)");
        audioObjectTypes.put(10, "Reserved");
        audioObjectTypes.put(11, "Reserved");
        audioObjectTypes.put(12, "TTSI (Text-To-Speech Interface)");
        audioObjectTypes.put(13, "Main Synthesis");
        audioObjectTypes.put(14, "Wavetable Synthesis");
        audioObjectTypes.put(15, "General MIDI");
        audioObjectTypes.put(16, "Algorithmic Synthesis and Audio Effects");
        audioObjectTypes.put(17, "ER (Error Resilient) AAC LC");
        audioObjectTypes.put(18, "Reserved");
        audioObjectTypes.put(19, "ER AAC LTP");
        audioObjectTypes.put(20, "ER AAC Scalable");
        audioObjectTypes.put(21, "ER TwinVQ");
        audioObjectTypes.put(22, "ER BSAC (Bit-Sliced Arithmetic Coding)");
        audioObjectTypes.put(23, "ER AAC LD (Low Delay)");
        audioObjectTypes.put(24, "ER CELP");
        audioObjectTypes.put(25, "ER HVXC");
        audioObjectTypes.put(26, "ER HILN (Harmonic and Individual Lines plus Noise)");
        audioObjectTypes.put(27, "ER Parametric");
        audioObjectTypes.put(28, "SSC (SinuSoidal Coding)");
        audioObjectTypes.put(29, "PS (Parametric Stereo)");
        audioObjectTypes.put(30, "MPEG Surround");
        audioObjectTypes.put(31, "(Escape value)");
        audioObjectTypes.put(32, "Layer-1");
        audioObjectTypes.put(33, "Layer-2");
        audioObjectTypes.put(34, "Layer-3");
        audioObjectTypes.put(35, "DST (Direct Stream Transfer)");
        audioObjectTypes.put(36, "ALS (Audio Lossless)");
        audioObjectTypes.put(37, "SLS (Scalable LosslesS)");
        audioObjectTypes.put(38, "SLS non-core");
        audioObjectTypes.put(39, "ER AAC ELD (Enhanced Low Delay)");
        audioObjectTypes.put(40, "SMR (Symbolic Music Representation) Simple");
        audioObjectTypes.put(41, "SMR Main");
        audioObjectTypes.put(42, "USAC (Unified Speech and Audio Coding) (no SBR)");
        audioObjectTypes.put(43, "SAOC (Spatial Audio Object Coding)");
        audioObjectTypes.put(44, "LD MPEG Surround");
        audioObjectTypes.put(45, "USAC");
        SAMPLING_FREQUENCY_INDEX_MAP.put(96000, 0);
        SAMPLING_FREQUENCY_INDEX_MAP.put(88200, 1);
        SAMPLING_FREQUENCY_INDEX_MAP.put(64000, 2);
        SAMPLING_FREQUENCY_INDEX_MAP.put(48000, 3);
        SAMPLING_FREQUENCY_INDEX_MAP.put(44100, 4);
        SAMPLING_FREQUENCY_INDEX_MAP.put(32000, 5);
        SAMPLING_FREQUENCY_INDEX_MAP.put(24000, 6);
        SAMPLING_FREQUENCY_INDEX_MAP.put(22050, 7);
        SAMPLING_FREQUENCY_INDEX_MAP.put(16000, 8);
        SAMPLING_FREQUENCY_INDEX_MAP.put(12000, 9);
        SAMPLING_FREQUENCY_INDEX_MAP.put(11025, 10);
        SAMPLING_FREQUENCY_INDEX_MAP.put(8000, 11);
        SAMPLING_FREQUENCY_INDEX_MAP.put(0, 96000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(1, 88200);
        SAMPLING_FREQUENCY_INDEX_MAP.put(2, 64000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(3, 48000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(4, 44100);
        SAMPLING_FREQUENCY_INDEX_MAP.put(5, 32000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(6, 24000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(7, 22050);
        SAMPLING_FREQUENCY_INDEX_MAP.put(8, 16000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(9, 12000);
        SAMPLING_FREQUENCY_INDEX_MAP.put(10, 11025);
        SAMPLING_FREQUENCY_INDEX_MAP.put(11, 8000);
    }

    class AdtsHeader {
        int sampleFrequencyIndex;
        int mpegVersion;
        int layer;
        int protectionAbsent;
        int profile;
        int sampleRate;
        int channelconfig;
        int original;
        int home;
        int copyrightedStream;
        int copyrightStart;
        int frameLength;
        int bufferFullness;
        int numAacFramesPerAdtsFrame;

        AdtsHeader() {
        }

        int getSize() {
            return 7 + (this.protectionAbsent == 0 ? 2 : 0);
        }
    }
}

