/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.h264.parsing.write;

import java.io.IOException;
import java.io.OutputStream;
import org.mp4parser.muxer.tracks.h264.parsing.Debug;
import org.mp4parser.muxer.tracks.h264.parsing.write.BitstreamWriter;

public class CAVLCWriter
extends BitstreamWriter {
    public CAVLCWriter(OutputStream out) {
        super(out);
    }

    public void writeU(int value, int n, String string) throws IOException {
        Debug.print(string + "\t");
        this.writeNBit(value, n);
        Debug.println("\t" + value);
    }

    public void writeUE(int value) throws IOException {
        int bits = 0;
        int cumul = 0;
        for (int i = 0; i < 15; ++i) {
            if (value < cumul + (1 << i)) {
                bits = i;
                break;
            }
            cumul += 1 << i;
        }
        this.writeNBit(0L, bits);
        this.write1Bit(1);
        this.writeNBit(value - cumul, bits);
    }

    public void writeUE(int value, String string) throws IOException {
        Debug.print(string + "\t");
        this.writeUE(value);
        Debug.println("\t" + value);
    }

    public void writeSE(int value, String string) throws IOException {
        Debug.print(string + "\t");
        this.writeUE((value << 1) * (value < 0 ? -1 : 1) + (value > 0 ? 1 : 0));
        Debug.println("\t" + value);
    }

    public void writeBool(boolean value, String string) throws IOException {
        Debug.print(string + "\t");
        this.write1Bit(value ? 1 : 0);
        Debug.println("\t" + value);
    }

    public void writeU(int i, int n) throws IOException {
        this.writeNBit(i, n);
    }

    public void writeNBit(long value, int n, String string) throws IOException {
        Debug.print(string + "\t");
        for (int i = 0; i < n; ++i) {
            this.write1Bit((int)(value >> n - i - 1) & 1);
        }
        Debug.println("\t" + value);
    }

    public void writeTrailingBits() throws IOException {
        this.write1Bit(1);
        this.writeRemainingZero();
        this.flush();
    }

    public void writeSliceTrailingBits() {
        throw new IllegalStateException("todo");
    }
}

