/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class LogicalVolumeIntegrityDescriptor
extends UDFDescriptor {
    Timestamp recordingDateAndTime;
    Long integrityType;
    ExtentAD nextIntegrityExtent;
    byte[] logicalVolumeContentsUse;
    Long numberOfPartitions;
    Long lengthOfImplementationUse;
    byte[] freeSpaceTable;
    byte[] sizeTable;
    RegId implementationId;
    Long numberOfFiles;
    Long numberOfDirectories;
    Integer minReadVersion;
    Integer minWriteVersion;
    Integer maxWriteersion;
    byte[] implementationUse;
    public static final int MINUMUM_LENGTH = 80;

    public LogicalVolumeIntegrityDescriptor() {
    }

    public LogicalVolumeIntegrityDescriptor(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 9;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 80) {
            throw new InvalidDescriptor("LogicalVolumeIntegrityDescriptor descriptor too short");
        }
        this.deserializeTag(byArray);
        this.recordingDateAndTime = new Timestamp(this.getBytes(byArray, 12));
        this.integrityType = this.getUInt32(byArray);
        this.nextIntegrityExtent = new ExtentAD(this.getBytes(byArray, 8));
        this.logicalVolumeContentsUse = this.getBytes(byArray, 32);
        this.numberOfPartitions = this.getUInt32(byArray);
        this.lengthOfImplementationUse = this.getUInt32(byArray);
        this.freeSpaceTable = this.getBytes(byArray, this.numberOfPartitions.intValue() * 4);
        this.sizeTable = this.getBytes(byArray, this.numberOfPartitions.intValue() * 4);
        this.implementationId = new RegId(this.getBytes(byArray, 32));
        this.numberOfFiles = this.getUInt32(byArray);
        this.numberOfDirectories = this.getUInt32(byArray);
        this.minReadVersion = this.getUInt16(byArray);
        this.minWriteVersion = this.getUInt16(byArray);
        this.maxWriteersion = this.getUInt16(byArray);
        this.implementationUse = this.getBytes(byArray, this.lengthOfImplementationUse.intValue() - 46);
    }
}

