/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;

public class TmmDateFormat {
    public static final Logger LOGGER;
    private static final String NATIVE_DATE_MEDIUM;
    private static final String NATIVE_TIME_SHORT;
    private static final String NATIVE_TIME_MEDIUM;
    private static final Map<String, DateFormat> DATEFORMAT_CACHE;

    private static DateFormat[] getDateTimeFormats() {
        boolean jnaAvailable = false;
        try {
            int ptrSize = Native.POINTER_SIZE;
            jnaAvailable = true;
        }
        catch (Throwable e) {
            LOGGER.error("Could not load JNA - '{}'", (Object)e.getMessage());
        }
        DateFormat[] formats = null;
        try {
            if (SystemUtils.IS_OS_MAC && jnaAvailable) {
                formats = TmmDateFormat.getMacFormats();
            } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_UNIX) {
                formats = TmmDateFormat.getUnixFormats();
            } else if (SystemUtils.IS_OS_WINDOWS && jnaAvailable) {
                formats = TmmDateFormat.getWindowsFormats();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Could not load native date formats -'{}'", (Object)e.getMessage());
        }
        if (formats == null || formats.length < 11) {
            formats = new DateFormat[]{DateFormat.getDateInstance(3, Locale.getDefault()), new SimpleDateFormat(TmmDateFormat.getNativeDatePattern(Locale.getDefault())), DateFormat.getDateInstance(1, Locale.getDefault()), DateFormat.getTimeInstance(3, Locale.getDefault()), DateFormat.getTimeInstance(2, Locale.getDefault()), DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()), DateFormat.getDateTimeInstance(3, 2, Locale.getDefault()), new SimpleDateFormat(TmmDateFormat.getNativeDatePattern(Locale.getDefault()) + " " + ((SimpleDateFormat)DateFormat.getTimeInstance(3, Locale.getDefault())).toPattern()), new SimpleDateFormat(TmmDateFormat.getNativeDatePattern(Locale.getDefault()) + " " + ((SimpleDateFormat)DateFormat.getTimeInstance(2, Locale.getDefault())).toPattern()), DateFormat.getDateTimeInstance(1, 3, Locale.getDefault()), DateFormat.getDateTimeInstance(1, 2, Locale.getDefault())};
        }
        return formats;
    }

    private static String getNativeDatePattern(Locale locale) {
        String country;
        return switch (country = locale.getCountry().toUpperCase()) {
            case "DE", "AT", "CH", "PL", "CZ", "SK", "HU" -> "dd.MM.yyyy";
            case "FR", "BE", "IT", "ES", "PT", "GB", "IE" -> "dd/MM/yyyy";
            case "HR", "BA", "SI", "RS", "ME", "MK" -> "dd.MM.yyyy.";
            case "US" -> "MM/dd/yyyy";
            case "CN", "JP", "KR" -> "yyyy/MM/dd";
            default -> "yyyy-MM-dd";
        };
    }

    private static DateFormat[] getMacFormats() {
        CF cf = (CF)Native.load((String)"CoreFoundation", CF.class);
        return new DateFormat[]{TmmDateFormat.getMacFormat(cf, 1L, 0L), TmmDateFormat.getMacFormat(cf, 2L, 0L), TmmDateFormat.getMacFormat(cf, 3L, 0L), TmmDateFormat.getMacFormat(cf, 0L, 1L), TmmDateFormat.getMacFormat(cf, 0L, 3L), TmmDateFormat.getMacFormat(cf, 1L, 1L), TmmDateFormat.getMacFormat(cf, 1L, 2L), TmmDateFormat.getMacFormat(cf, 2L, 1L), TmmDateFormat.getMacFormat(cf, 2L, 2L), TmmDateFormat.getMacFormat(cf, 3L, 1L), TmmDateFormat.getMacFormat(cf, 3L, 2L)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getMacFormat(CF cf, long dateStyle, long timeStyle) {
        Pointer formatter = cf.CFDateFormatterCreate(null, null, dateStyle, timeStyle);
        if (formatter == null) {
            throw new IllegalStateException("CFDateFormatterCreate: null");
        }
        try {
            Pointer format = cf.CFDateFormatterGetFormat(formatter);
            int length = (int)cf.CFStringGetLength(format);
            char[] buffer = new char[length];
            cf.CFStringGetCharacters(format, new CF.CFRange(0L, length), buffer);
            DateFormat dateFormat = TmmDateFormat.formatFromString(new String(buffer));
            return dateFormat;
        }
        finally {
            cf.CFRelease(formatter);
        }
    }

    private static DateFormat[] getUnixFormats() {
        String localeStr = System.getenv("LC_TIME");
        if (localeStr == null) {
            return null;
        }
        int p = (localeStr = localeStr.strip()).indexOf(46);
        if (p > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p);
        }
        Locale locale = (p = localeStr.indexOf(95)) < 0 ? new Locale(localeStr) : new Locale(localeStr.substring(0, p), localeStr.substring(p + 1));
        return new DateFormat[]{DateFormat.getDateInstance(3, locale), DateFormat.getDateInstance(2, locale), DateFormat.getDateInstance(1, locale), DateFormat.getTimeInstance(3, locale), DateFormat.getTimeInstance(2, locale), DateFormat.getDateTimeInstance(3, 3, locale), DateFormat.getDateTimeInstance(3, 2, locale), DateFormat.getDateTimeInstance(2, 3, locale), DateFormat.getDateTimeInstance(2, 2, locale), DateFormat.getDateTimeInstance(1, 3, locale), DateFormat.getDateTimeInstance(1, 2, locale)};
    }

    private static DateFormat[] getWindowsFormats() {
        String shortDate;
        int bufferSize;
        char[] buffer;
        Kernel32 kernel32 = (Kernel32)Native.load((String)"Kernel32", Kernel32.class);
        int rv = kernel32.GetLocaleInfoEx(null, 31, buffer = new char[bufferSize = 128], bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumDate = shortDate = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 32, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String longDate = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 121, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortTime = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 4099, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumTime = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        return new DateFormat[]{TmmDateFormat.formatFromString(shortDate), TmmDateFormat.formatFromString(mediumDate), TmmDateFormat.formatFromString(longDate), TmmDateFormat.formatFromString(shortTime), TmmDateFormat.formatFromString(mediumTime), TmmDateFormat.formatFromString(shortDate + " " + shortTime), TmmDateFormat.formatFromString(shortDate + " " + mediumTime), TmmDateFormat.formatFromString(mediumDate + " " + shortTime), TmmDateFormat.formatFromString(mediumDate + " " + mediumTime), TmmDateFormat.formatFromString(longDate + " " + shortTime), TmmDateFormat.formatFromString(longDate + " " + mediumTime)};
    }

    private static String fixWindowsFormat(String format) {
        format = format.replaceAll("g+", "G");
        format = Strings.CS.replace(format, "tt", "a");
        return format;
    }

    private static DateFormat formatFromString(String format) {
        try {
            return new SimpleDateFormat(format.strip());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unrecognized format string '" + format + "'");
        }
    }

    private static String getDatePattern() {
        return switch (Settings.getInstance().getDateFormatStyle()) {
            case DateFormatStyle.NATIVE -> NATIVE_DATE_MEDIUM;
            case DateFormatStyle.US_LONG -> "MM/dd/yyyy";
            case DateFormatStyle.UK_LONG -> "dd/MM/yyyy";
            case DateFormatStyle.DE_LONG -> "dd.MM.yyyy";
            case DateFormatStyle.HR_LONG -> "dd.MM.yyyy.";
            case DateFormatStyle.CN_LONG -> "yyyy/MM/dd";
            case DateFormatStyle.US_SHORT -> "MM/dd/yy";
            case DateFormatStyle.UK_SHORT -> "dd/MM/yy";
            case DateFormatStyle.DE_SHORT -> "dd.MM.yy";
            case DateFormatStyle.HR_SHORT -> "dd.MM.yy.";
            case DateFormatStyle.CN_SHORT -> "yy/MM/dd";
            default -> "yyyy-MM-dd";
        };
    }

    private static String getTimeShortPattern() {
        return switch (Settings.getInstance().getTimeFormatStyle()) {
            case TimeFormatStyle.NATIVE -> NATIVE_TIME_SHORT;
            case TimeFormatStyle.AM_PM -> "hh:mm a";
            default -> "HH:mm";
        };
    }

    private static String getTimeMediumPattern() {
        return switch (Settings.getInstance().getTimeFormatStyle()) {
            case TimeFormatStyle.NATIVE -> NATIVE_TIME_MEDIUM;
            case TimeFormatStyle.AM_PM -> "hh:mm:ss a";
            default -> "HH:mm:ss";
        };
    }

    private static DateFormat getCachedDateFormat(String pattern) {
        DateFormat df = DATEFORMAT_CACHE.get(pattern);
        if (df == null) {
            df = TmmDateFormat.formatFromString(pattern);
            DATEFORMAT_CACHE.put(pattern, df);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        return TmmDateFormat.getCachedDateFormat(TmmDateFormat.getDatePattern());
    }

    public static DateFormat getDateShortTimeFormat() {
        return TmmDateFormat.getCachedDateFormat(TmmDateFormat.getDatePattern() + " " + TmmDateFormat.getTimeShortPattern());
    }

    public static DateFormat getDateMediumTimeFormat() {
        return TmmDateFormat.getCachedDateFormat(TmmDateFormat.getDatePattern() + " " + TmmDateFormat.getTimeMediumPattern());
    }

    static {
        SimpleDateFormat simpleDateFormat;
        LOGGER = LoggerFactory.getLogger(TmmDateFormat.class);
        DATEFORMAT_CACHE = new HashMap<String, DateFormat>();
        DateFormat[] formats = TmmDateFormat.getDateTimeFormats();
        DateFormat dateFormat = formats[1];
        if (dateFormat instanceof SimpleDateFormat) {
            simpleDateFormat = (SimpleDateFormat)dateFormat;
            NATIVE_DATE_MEDIUM = simpleDateFormat.toPattern();
        } else {
            NATIVE_DATE_MEDIUM = TmmDateFormat.getNativeDatePattern(Locale.getDefault());
        }
        dateFormat = formats[3];
        if (dateFormat instanceof SimpleDateFormat) {
            simpleDateFormat = (SimpleDateFormat)dateFormat;
            NATIVE_TIME_SHORT = simpleDateFormat.toPattern();
        } else {
            NATIVE_TIME_SHORT = ((SimpleDateFormat)DateFormat.getTimeInstance(3, Locale.getDefault())).toPattern();
        }
        dateFormat = formats[4];
        if (dateFormat instanceof SimpleDateFormat) {
            simpleDateFormat = (SimpleDateFormat)dateFormat;
            NATIVE_TIME_MEDIUM = simpleDateFormat.toPattern();
        } else {
            NATIVE_TIME_MEDIUM = ((SimpleDateFormat)DateFormat.getTimeInstance(2, Locale.getDefault())).toPattern();
        }
    }

    private static interface CF
    extends Library {
        public static final long kCFDateFormatterNoStyle = 0L;
        public static final long kCFDateFormatterShortStyle = 1L;
        public static final long kCFDateFormatterMediumStyle = 2L;
        public static final long kCFDateFormatterLongStyle = 3L;

        public Pointer CFDateFormatterCreate(Pointer var1, Pointer var2, long var3, long var5);

        public Pointer CFDateFormatterGetFormat(Pointer var1);

        public long CFStringGetLength(Pointer var1);

        public void CFStringGetCharacters(Pointer var1, CFRange var2, char[] var3);

        public void CFRelease(Pointer var1);

        public static class CFRange
        extends Structure
        implements Structure.ByValue {
            public long location;
            public long length;

            protected List<String> getFieldOrder() {
                return Arrays.asList("location", "length");
            }

            public CFRange(long location, long length) {
                this.location = location;
                this.length = length;
            }
        }
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SLONGDATE = 32;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, char[] var3, int var4);

        public int GetLastError();
    }

    public static enum DateFormatStyle {
        NATIVE("Settings.ui.date.system"),
        INTERNATIONAL("yyyy-MM-dd (2024-12-31)"),
        US_LONG("MM/dd/yyyy (12/31/2024)"),
        UK_LONG("dd/MM/yyyy (31/12/2024)"),
        DE_LONG("dd.MM.yyyy (31.12.2024)"),
        HR_LONG("dd.MM.yyyy. (31.12.2024.)"),
        CN_LONG("yyyy/MM/dd (2024/12/31)"),
        US_SHORT("MM/dd/yy (12/31/24)"),
        UK_SHORT("dd/MM/yy (31/12/24)"),
        DE_SHORT("dd.MM.yy (31.12.24)"),
        HR_SHORT("dd.MM.yy (31.12.24.)"),
        CN_SHORT("yy/MM/dd (24/12/31)");

        private final String displayName;

        private DateFormatStyle(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            String result = TmmResourceBundle.getString(this.displayName);
            if ("???".equalsIgnoreCase(result)) {
                return this.displayName;
            }
            return result;
        }
    }

    public static enum TimeFormatStyle {
        NATIVE("Settings.ui.time.system"),
        TWENTY_FOUR_HOURS("hh:mm (23:59)"),
        AM_PM("HH:mm a (11:59 PM)");

        private final String displayName;

        private TimeFormatStyle(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            String result = TmmResourceBundle.getString(this.displayName);
            if ("???".equalsIgnoreCase(result)) {
                return this.displayName;
            }
            return result;
        }
    }
}

