/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.CodeSource;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class Utils {
    private static final Logger LOGGER;
    private static final Pattern localePattern;
    private static final Pattern stackingPattern1;
    private static final Pattern stackingPattern1a;
    private static final Pattern stackingPattern2;
    private static final Pattern stackingPattern3;
    private static final Pattern stackingPattern4;
    private static final Pattern folderStackingPattern;
    private static final char[] ILLEGAL_FILENAME_CHARACTERS;
    public static final Pattern YOUTUBE_PATTERN;
    public static final Pattern SEASON_NFO_PATTERN;
    public static final String DISC_FOLDER_REGEX = "(?i)(VIDEO_TS|BDMV|HVDVD_TS)$";
    public static final List<String> SKIP_FILES;
    private static final List<Locale> AVAILABLE_LOCALES;
    private static String tempFolder;

    private Utils() {
    }

    public static String getExtension(Path path) {
        String ext = "";
        String fn = path.getFileName().toString();
        int i = fn.lastIndexOf(46);
        if (i > 0) {
            ext = fn.substring(i + 1);
        }
        return ext;
    }

    public static boolean isRegularFile(Path file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return Utils.isRegularFile(attr);
        }
        catch (IOException e) {
            try {
                BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                return Utils.isRegularFile(attr);
            }
            catch (IOException e1) {
                LOGGER.warn("Could not read BasicFileAttributes for '{}' - '{}' [{}]", new Object[]{file, e1.getMessage(), e1.getClass().getSimpleName()});
                return false;
            }
        }
    }

    public static boolean isRegularFile(BasicFileAttributes attr) {
        return !attr.isDirectory();
    }

    public static String relPath(String parent, String child) {
        return Utils.relPath(Paths.get(parent, new String[0]), Paths.get(child, new String[0]));
    }

    public static String relPath(Path parent, Path child) {
        return parent.relativize(child).toString();
    }

    public static List<String> getAllDatasources() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String m : MovieModuleManager.getInstance().getSettings().getMovieDataSource()) {
            ret.add(m);
        }
        for (String t : TvShowModuleManager.getInstance().getSettings().getTvShowDataSource()) {
            ret.add(t);
        }
        Comparator<String> c = Comparator.comparingInt(String::length);
        Collections.sort(ret, c);
        Collections.reverse(ret);
        return ret;
    }

    public static String getSortableName(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            return "";
        }
        if (title.startsWith("LA ")) {
            return title;
        }
        if (title.toLowerCase(Locale.ROOT).matches("^die hard$") || title.toLowerCase(Locale.ROOT).matches("^die hard[:\\s].*")) {
            return title;
        }
        if (title.toLowerCase(Locale.ROOT).matches("^die another day$") || title.toLowerCase(Locale.ROOT).matches("^die another day[:\\s].*")) {
            return title;
        }
        for (String prfx : Settings.getInstance().getTitlePrefix()) {
            String delim = "\\s+";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            if (!title.matches("(?i)^" + Pattern.quote(prfx) + delim + "(.*)")) continue;
            title = title.replaceAll("(?i)^" + Pattern.quote(prfx) + delim + "(.*)", "$1, " + prfx);
            break;
        }
        return title.strip();
    }

    public static String removeSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        for (String prfx : Settings.getInstance().getTitlePrefix()) {
            String delim = " ";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            title = title.replaceAll("(?i)(.*), " + Pattern.quote(prfx) + "$", prfx + delim + "$1");
        }
        return title.strip();
    }

    public static String cleanStackingMarkers(String filename) {
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            Matcher m = stackingPattern1.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern1a.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern2.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern3.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern4.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
        }
        return filename;
    }

    public static String cleanFolderStackingMarkers(String filename) {
        Matcher m;
        if (!StringUtils.isEmpty((CharSequence)filename) && (m = folderStackingPattern.matcher(filename)).matches()) {
            return m.group(1);
        }
        return filename;
    }

    public static String getFolderStackingMarker(String filename) {
        Matcher m;
        if (!StringUtils.isEmpty((CharSequence)filename) && (m = folderStackingPattern.matcher(filename)).matches()) {
            return m.group(2);
        }
        return "";
    }

    public static String getStackingMarker(String filename) {
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            Matcher m = stackingPattern1.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern1a.matcher(filename);
            if (m.matches()) {
                return m.group(1);
            }
            m = stackingPattern2.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern3.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern4.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
        }
        return "";
    }

    public static String substr(String str, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher m = regex.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String getStackingPrefix(String filename) {
        String stack = Utils.getStackingMarker(filename).replaceAll("[0-9]", "");
        if (stack.length() == 1 || stack.contains("of")) {
            stack = "";
        }
        return stack;
    }

    public static int getStackingNumber(String filename) {
        String stack;
        if (!StringUtils.isEmpty((CharSequence)filename) && !(stack = Utils.getStackingMarker(filename)).isEmpty()) {
            if (stack.equalsIgnoreCase("a")) {
                return 1;
            }
            if (stack.equalsIgnoreCase("b")) {
                return 2;
            }
            if (stack.equalsIgnoreCase("c")) {
                return 3;
            }
            if (stack.equalsIgnoreCase("d")) {
                return 4;
            }
            if (stack.contains("of")) {
                stack = stack.replaceAll("of.*", "");
            }
            try {
                return Integer.parseInt(stack.replaceAll("[^0-9]", ""));
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceFirst("^\\\"(.*)\\\"$", "$1");
    }

    private static String getEncProp(String prop) {
        String property = System.getProperty(prop);
        if (StringUtils.isBlank((CharSequence)property)) {
            return "";
        }
        return URLEncoder.encode(property, StandardCharsets.UTF_8);
    }

    public static void removeEmptyStringsFromList(List<String> list) {
        List<String> toFilter = list.stream().filter(StringUtils::isBlank).toList();
        list.removeAll(toFilter);
    }

    public static void removeDuplicateStringFromCollectionIgnoreCase(Collection<String> original) {
        LinkedHashSet<String> items = new LinkedHashSet<String>(original);
        HashSet check = new HashSet();
        ArrayList toRemove = new ArrayList();
        original.forEach(item -> {
            String upper = item.toUpperCase(Locale.ROOT);
            if (check.contains(upper)) {
                toRemove.add(item);
            } else {
                check.add(upper);
            }
        });
        toRemove.forEach(items::remove);
        original.clear();
        original.addAll(items);
    }

    public static String replacePlaceholders(String source, String[] replacements) {
        Matcher matcher;
        String result = source;
        int index = 0;
        Pattern pattern = Pattern.compile("\\{\\}");
        while ((matcher = pattern.matcher(result)).find()) {
            try {
                result = replacements.length > index ? result.replaceFirst(pattern.pattern(), new UnicodeUnescaper().translate((CharSequence)StringEscapeUtils.escapeJava((String)replacements[index]))) : result.replaceFirst(pattern.pattern(), "");
            }
            catch (Exception e) {
                result = result.replaceFirst(pattern.pattern(), "");
            }
            ++index;
        }
        return StrgUtils.removeDuplicateWhitespace(result);
    }

    public static boolean moveDirectorySafe(Path srcDir, Path destDir) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
            LOGGER.debug("try to move folder {} to {}", (Object)srcDir, (Object)destDir);
            if (!Files.isDirectory(srcDir, new LinkOption[0])) {
                throw new FileNotFoundException("Source '{}" + srcDir + "' does not exist, or is not a directory");
            }
            if (Files.exists(destDir, new LinkOption[0]) && !Files.isSameFile(destDir, srcDir)) {
                throw new FileExistsException("Destination '" + destDir + "' already exists");
            }
            if (destDir.getParent() != null && !Files.exists(destDir.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(destDir.getParent(), new FileAttribute[0]);
                }
                catch (AccessDeniedException e) {
                    LOGGER.error("ACCESS DENIED (create folder) for '{}' - '{}' [{}]", new Object[]{destDir, e.getMessage(), e.getClass().getSimpleName()});
                }
                catch (Exception e) {
                    LOGGER.error("Could not create directory structure '{}'", (Object)destDir.getParent());
                }
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.move(srcDir, destDir, StandardCopyOption.ATOMIC_MOVE);
                    rename = true;
                }
                catch (AccessDeniedException e) {
                    LOGGER.error("ACCESS DENIED (move folder) for '{}' to '{}' - '{}' [{}]", new Object[]{srcDir, destDir, e.getMessage(), e.getClass().getSimpleName()});
                }
                catch (AtomicMoveNotSupportedException a) {
                    try (Stream<Path> stream = Files.walk(srcDir, new FileVisitOption[0]);){
                        Iterator srcFiles = stream.iterator();
                        while (srcFiles.hasNext()) {
                            Path source = (Path)srcFiles.next();
                            Path destination = destDir.resolve(srcDir.relativize(source));
                            if (Files.isSymbolicLink(source)) {
                                Files.createSymbolicLink(destination, source.toRealPath(new LinkOption[0]), new FileAttribute[0]);
                                continue;
                            }
                            if (Files.isDirectory(source, new LinkOption[0])) {
                                if (Files.exists(destination, new LinkOption[0])) continue;
                                Files.createDirectory(destination, new FileAttribute[0]);
                                continue;
                            }
                            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                            Utils.fixDateAttributes(source, destination);
                        }
                        Utils.deleteDirectoryRecursive(srcDir);
                        rename = true;
                    }
                    catch (AccessDeniedException e) {
                        LOGGER.error("ACCESS DENIED (move folder) for '{}' - '{}' [{}]", new Object[]{srcDir, e.getMessage(), e.getClass().getSimpleName()});
                    }
                    catch (IOException e) {
                        LOGGER.warn("Rename problem (fallback) for '{}' - '{}' [{}]", new Object[]{srcDir, e.getMessage(), e.getClass().getSimpleName()});
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Rename problem for '{} - '{}' [{}]", new Object[]{srcDir, e.getMessage(), e.getClass().getSimpleName()});
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.debug("I'm so excited - could not sleep");
                    break;
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename directory {} to {}", (Object)srcDir, (Object)destDir);
                LOGGER.info("Renaming aborted");
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, srcDir, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.debug("Successfully moved folder {} to {}", (Object)srcDir, (Object)destDir);
            return true;
        }
        return true;
    }

    private static void fixDateAttributes(Path source, Path destination) {
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                BasicFileAttributes srcAttrs = Files.readAttributes(source, BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributeView tgtView = Files.getFileAttributeView(destination, BasicFileAttributeView.class, new LinkOption[0]);
                tgtView.setTimes(srcAttrs.lastModifiedTime(), srcAttrs.lastAccessTime(), srcAttrs.creationTime());
            }
            catch (Exception e) {
                LOGGER.trace("could not set date attributes for '{}' - '{}' [{}]", new Object[]{destination, e.getMessage(), e.getClass().getSimpleName()});
            }
        }
    }

    public static boolean moveFileSafe(Path srcFile, Path destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.toAbsolutePath().toString().equals(destFile.toAbsolutePath().toString())) {
            LOGGER.debug("try to move file '{}' to '{}'", (Object)srcFile, (Object)destFile);
            if (!Files.exists(srcFile, new LinkOption[0]) && !Files.isSymbolicLink(srcFile)) {
                throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                throw new IOException("Source '" + srcFile + "' is a directory");
            }
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isSameFile(destFile, srcFile)) {
                throw new FileExistsException("Destination '" + destFile + "' already exists");
            }
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                throw new IOException("Destination '" + destFile + "' is a directory");
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.move(srcFile, destFile, StandardCopyOption.ATOMIC_MOVE);
                    rename = true;
                }
                catch (AccessDeniedException e) {
                    LOGGER.error("ACCESS DENIED (move file) for '{}' to '{}' - '{}' [{}]", new Object[]{srcFile, destFile, e.getMessage(), e.getClass().getSimpleName()});
                }
                catch (AtomicMoveNotSupportedException a) {
                    try {
                        Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
                        Utils.fixDateAttributes(srcFile, destFile);
                        Files.delete(srcFile);
                        rename = true;
                    }
                    catch (AccessDeniedException e) {
                        LOGGER.error("ACCESS DENIED (move file) for '{}' - '{}' [{}]", new Object[]{srcFile, e.getMessage(), e.getClass().getSimpleName()});
                    }
                    catch (IOException e) {
                        LOGGER.warn("Rename problem (fallback) for '{}' - '{}' [{}]", new Object[]{srcFile, e.getMessage(), e.getClass().getSimpleName()});
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Rename problem for '{}' - '{}' [{}]", new Object[]{srcFile, e.getMessage(), e.getClass().getSimpleName()});
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.debug("I'm so excited - could not sleep");
                    break;
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename file '{}' to '{}'", (Object)srcFile, (Object)destFile);
                LOGGER.info("Renaming aborted");
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, srcFile, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.debug("Successfully moved file from '{}' to '{}'", (Object)srcFile, (Object)destFile);
            return true;
        }
        return true;
    }

    public static boolean copyFileSafe(Path srcFile, Path destFile) throws IOException {
        return Utils.copyFileSafe(srcFile, destFile, false);
    }

    public static boolean copyFileSafe(Path srcFile, Path destFile, boolean overwrite) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.toAbsolutePath().toString().equals(destFile.toAbsolutePath().toString())) {
            LOGGER.debug("try to copy file {} to {}", (Object)srcFile, (Object)destFile);
            if (!Files.exists(srcFile, new LinkOption[0])) {
                LOGGER.debug("file not found - '{}'", (Object)srcFile);
                throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                LOGGER.debug("source is a directory - '{}'", (Object)srcFile);
                throw new IOException("Source '" + srcFile + "' is a directory");
            }
            if (!overwrite && Files.exists(destFile, new LinkOption[0]) && !Files.isSameFile(destFile, srcFile)) {
                LOGGER.debug("destination exists - '{}'", (Object)destFile);
                throw new FileExistsException("Destination '" + destFile + "' already exists");
            }
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                LOGGER.debug("destination is a directory - '{}'", (Object)destFile);
                throw new IOException("Destination '" + destFile + "' is a directory");
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
                    Utils.fixDateAttributes(srcFile, destFile);
                    rename = true;
                }
                catch (AccessDeniedException e) {
                    LOGGER.error("ACCESS DENIED (copy file) for '{}' to '{}' - '{}' [{}]", new Object[]{srcFile, destFile, e.getMessage(), e.getClass().getSimpleName()});
                }
                catch (UnsupportedOperationException u) {
                    try {
                        Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
                        Utils.fixDateAttributes(srcFile, destFile);
                        rename = true;
                    }
                    catch (AccessDeniedException e) {
                        LOGGER.error("ACCESS DENIED (copy file) for '{}' to '{}' - '{}' [{}]", new Object[]{srcFile, destFile, e.getMessage(), e.getClass().getSimpleName()});
                    }
                    catch (IOException e) {
                        LOGGER.warn("Copy did not work (fallback) for '{}' - '{}' [{}]", new Object[]{srcFile, e.getMessage(), e.getClass().getSimpleName()});
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Copy did not work: {} [{}]", (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
                }
                if (rename) break;
                try {
                    LOGGER.debug("copy did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.debug("I'm so excited - could not sleep");
                    break;
                }
            }
            if (!rename) {
                LOGGER.error("Failed to copy file {} to {}", (Object)srcFile, (Object)destFile);
                LOGGER.info("Copying aborted");
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, srcFile, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.debug("Successfully copied file from {} to {}", (Object)srcFile, (Object)destFile);
            return true;
        }
        return true;
    }

    public static boolean deleteFileWithBackup(Path file, String datasource) {
        if (!Settings.getInstance().isEnableTrash()) {
            return Utils.deleteFileSafely(file);
        }
        Path ds = Paths.get(datasource, new String[0]);
        if (!file.startsWith(ds)) {
            LOGGER.warn("Could not delete file '{}': datasource '{}' does not match", (Object)file, (Object)datasource);
            return false;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            LOGGER.warn("Could not delete file '{}': file is a directory!", (Object)file);
            return false;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM");
        try {
            if (!Files.exists(backup, new LinkOption[0])) {
                Files.createDirectories(backup, new FileAttribute[0]);
            }
            if (!Files.exists(backup.resolve(".nomedia"), new LinkOption[0])) {
                Files.createFile(backup.resolve(".nomedia"), new FileAttribute[0]);
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (create folder) for '{}' - '{}' [{}]", new Object[]{backup, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM", ds.relativize(file).toString());
            if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                Files.createDirectories(backup.getParent(), new FileAttribute[0]);
            }
            Files.deleteIfExists(backup);
            return Utils.moveFileSafe(file, backup);
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (delete file) for '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete file '{}' - {} [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
    }

    public static boolean deleteFileSafely(Path file) {
        if (Files.isDirectory(file = file.toAbsolutePath(), new LinkOption[0])) {
            LOGGER.warn("Will not delete file '{}': file is a directory!", (Object)file);
            return false;
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (delete file) for '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete file '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
        return true;
    }

    public static boolean deleteDirectorySafely(Path folder) {
        try {
            Utils.deleteDirectoryRecursive(folder);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Could not delete folder '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
    }

    public static boolean deleteDirectorySafely(Path folder, String datasource) {
        if (!Settings.getInstance().isEnableTrash()) {
            try {
                Utils.deleteDirectoryRecursive(folder);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Could not delete folder '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
                return false;
            }
        }
        folder = folder.toAbsolutePath();
        Path ds = Paths.get(datasource, new String[0]);
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            LOGGER.warn("Will not delete folder '{}': folder is a file, NOT a directory!", (Object)folder);
            return false;
        }
        if (!folder.startsWith(ds)) {
            LOGGER.warn("Will not delete folder '{}': datasource '{}' does not match", (Object)folder, (Object)datasource);
            return false;
        }
        try {
            Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM");
            if (!Files.exists(backup, new LinkOption[0])) {
                Files.createDirectories(backup, new FileAttribute[0]);
            }
            if (!Files.exists(backup.resolve(".nomedia"), new LinkOption[0])) {
                Files.createFile(backup.resolve(".nomedia"), new FileAttribute[0]);
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (read file) - '{}'", (Object)e.getMessage());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Instant instant = Instant.now();
            long timeStampSeconds = instant.getEpochSecond();
            Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM", ds.relativize(folder).toString() + timeStampSeconds);
            if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                Files.createDirectories(backup.getParent(), new FileAttribute[0]);
            }
            return Utils.moveDirectorySafe(folder, backup);
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (move folder) for '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Could not delete directory '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
            return false;
        }
    }

    public static List<Locale> getLanguages() {
        block18: {
            if (!AVAILABLE_LOCALES.isEmpty()) {
                return new ArrayList<Locale>(AVAILABLE_LOCALES);
            }
            AVAILABLE_LOCALES.add(Utils.getLocaleFromLanguage(Locale.ENGLISH.getLanguage()));
            try {
                CodeSource src;
                InputStream is = Utils.class.getResourceAsStream("/");
                if (is != null) {
                    String resource;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((resource = br.readLine()) != null) {
                        Utils.parseLocaleFromFilename(resource);
                    }
                }
                if (AVAILABLE_LOCALES.size() != 1 || (src = Utils.class.getProtectionDomain().getCodeSource()) == null) break block18;
                URL jar = src.getLocation();
                try (InputStream jarInputStream = jar.openStream();
                     ZipInputStream zip = new ZipInputStream(jarInputStream);){
                    ZipEntry e;
                    while ((e = zip.getNextEntry()) != null) {
                        Utils.parseLocaleFromFilename(e.getName());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not read locales -'{}' [{}]", (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
            }
        }
        return new ArrayList<Locale>(AVAILABLE_LOCALES);
    }

    private static void parseLocaleFromFilename(String filename) {
        Matcher matcher = localePattern.matcher(filename);
        if (matcher.matches()) {
            String language = matcher.group(1);
            String country = matcher.group(2);
            Locale myloc = StringUtils.isNotBlank((CharSequence)country) ? Utils.getLocaleFromLanguage(language + "_" + country) : Utils.getLocaleFromLanguage(language);
            if (myloc != null && !AVAILABLE_LOCALES.contains(myloc)) {
                AVAILABLE_LOCALES.add(myloc);
            }
        }
    }

    public static Locale getLocaleFromLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return Locale.getDefault();
        }
        if ("en".equalsIgnoreCase(language)) {
            return Locale.US;
        }
        if ("zh_Hant".equalsIgnoreCase(language) || "zh__#Hant".equalsIgnoreCase(language) || "zh_HK".equalsIgnoreCase(language) || "zh_TW".equalsIgnoreCase(language)) {
            return new Locale.Builder().setLanguage("zh").setScript("Hant").build();
        }
        if ("zh".equalsIgnoreCase(language) || "zh__#Hans".equalsIgnoreCase(language) || "zh_Hans".equalsIgnoreCase(language) || "zh_CN".equalsIgnoreCase(language) || "zh_SG".equalsIgnoreCase(language)) {
            return new Locale.Builder().setLanguage("zh").setScript("Hans").build();
        }
        if (language.length() > 2) {
            try {
                return LocaleUtils.toLocale((String)language);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse language '{}' - '{}'", (Object)language, (Object)e.getMessage());
            }
        }
        return new Locale(language);
    }

    public static List<String> getAllTranslationsFor(String key) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Locale l : Utils.getLanguages()) {
            ResourceBundle b = ResourceBundle.getBundle("messages", l);
            try {
                String value = b.getString(key);
                if (ret.contains(value)) continue;
                ret.add(value);
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static void createBackupFile(Path file) {
        Utils.createBackupFile(file, true);
    }

    public static void createBackupFile(Path file, boolean overwrite) {
        Path backup = Paths.get(Globals.BACKUP_FOLDER, new String[0]);
        try {
            if (!Files.exists(backup, new LinkOption[0])) {
                Files.createDirectory(backup, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String date = formatter.format(new Date());
            if (!Files.exists(backup = backup.resolve(file.getFileName() + "." + date + ".zip"), new LinkOption[0]) || overwrite) {
                Utils.createZip(backup, file);
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (create backup file) for '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (IOException e) {
            LOGGER.error("Could not backup file '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
        }
    }

    public static void deleteOldBackupFile(Path file, int keep) {
        ArrayList<Path> al = new ArrayList<Path>();
        String fname = file.getFileName().toString();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(Globals.BACKUP_FOLDER, new String[0]));){
            for (Path path : directoryStream) {
                if (!path.getFileName().toString().matches(fname + "\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip") && !path.getFileName().toString().matches(fname + "\\.\\d{4}\\-\\d{2}\\-\\d{2}")) continue;
                al.add(path);
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (listing old backups) for '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (IOException e) {
            LOGGER.error("Could not list files from the backup folder '{}' - '{}' [{}]", new Object[]{Globals.BACKUP_FOLDER, e.getMessage(), e.getClass().getSimpleName()});
            return;
        }
        al.sort((o1, o2) -> (int)(o1.toFile().lastModified() - o2.toFile().lastModified()));
        for (int i = 0; i < al.size() - keep; ++i) {
            Path backupFile = (Path)al.get(i);
            LOGGER.debug("deleting old backup file {}", (Object)backupFile.getFileName());
            Utils.deleteFileSafely(backupFile);
        }
    }

    public static void sendWakeOnLanPacket(String macAddr) {
        String IP = "255.255.255.255";
        int port = 7;
        try {
            int i;
            byte[] MACBYTE = new byte[6];
            String[] hex = macAddr.split("(\\:|\\-)");
            for (int i2 = 0; i2 < 6; ++i2) {
                MACBYTE[i2] = (byte)Integer.parseInt(hex[i2], 16);
            }
            byte[] bytes = new byte[6 + 16 * MACBYTE.length];
            for (i = 0; i < 6; ++i) {
                bytes[i] = -1;
            }
            for (i = 6; i < bytes.length; i += MACBYTE.length) {
                System.arraycopy(MACBYTE, 0, bytes, i, MACBYTE.length);
            }
            InetAddress address = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, 7);
            try (DatagramSocket socket = new DatagramSocket();){
                socket.send(packet);
            }
            LOGGER.debug("Sent WOL packet to {}", (Object)macAddr);
        }
        catch (Exception e) {
            LOGGER.error("Error sending WOL packet to '{}' - '{}'", (Object)macAddr, (Object)e.getMessage());
        }
    }

    public static void deleteDirectoryRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        LOGGER.debug("Deleting complete directory: {}", (Object)dir);
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFileFailed(Path file, @NotNull IOException exc) {
                    LOGGER.warn("Could not delete '{}' - '{}'", (Object)file, (Object)exc.getMessage());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (delete complete directory) for '{}' - '{}' [{}]", new Object[]{dir, e.getMessage(), e.getClass().getSimpleName()});
            throw e;
        }
    }

    public static void deleteEmptyDirectoryRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        LOGGER.debug("Deleting empty directories in: {}", (Object)dir);
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (Utils.isFolderEmpty(dir)) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFileFailed(Path file, @NotNull IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (delete empty directories) for '{}' - '{}' [{}]", new Object[]{dir, e.getMessage(), e.getClass().getSimpleName()});
            throw e;
        }
    }

    public static boolean isFolderEmpty(Path folder) throws IOException {
        boolean bl;
        block8: {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(folder);
            try {
                boolean bl2 = bl = !dirStream.iterator().hasNext();
                if (dirStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessDeniedException e) {
                    LOGGER.error("ACCESS DENIED (checking for empty folders) for '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
                    throw e;
                }
            }
            dirStream.close();
        }
        return bl;
    }

    public static void createZip(Path zipFile, Path toBeAdded) {
        ArrayList<File> filesToArchive = new ArrayList<File>();
        if (Files.isDirectory(toBeAdded, new LinkOption[0])) {
            filesToArchive.addAll(FileUtils.listFiles((File)toBeAdded.toFile(), null, (boolean)true));
        } else {
            filesToArchive.add(toBeAdded.toFile());
        }
        try (ZipArchiveOutputStream archive = new ZipArchiveOutputStream(zipFile.toFile());){
            for (File file : filesToArchive) {
                String entryName = Utils.getEntryName(toBeAdded.toFile(), file);
                ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                archive.putArchiveEntry(entry);
                try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                     BufferedInputStream input = new BufferedInputStream(is);){
                    IOUtils.copy((InputStream)input, (OutputStream)archive);
                }
                archive.closeArchiveEntry();
            }
            archive.finish();
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (creating .zip) for '{}' - '{}' [{}]", new Object[]{zipFile, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file '{}' - '{}' [{}]", new Object[]{zipFile, e.getMessage(), e.getClass().getSimpleName()});
        }
    }

    private static String getEntryName(File source, File file) throws IOException {
        int index = source.getAbsoluteFile().getParentFile().getAbsolutePath().length() + 1;
        String path = file.getCanonicalPath();
        return path.substring(index);
    }

    public static void unzip(Path zipFile, final Path destDir) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (!Files.exists(zipFile, new LinkOption[0])) {
            return;
        }
        try {
            if (!Files.exists(destDir, new LinkOption[0])) {
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            env.put("create", "false");
            URI fileUri = zipFile.toUri();
            URI zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null);
            try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
                Path root = zipfs.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(destDir.toString(), file.toString());
                        LOGGER.debug("Extracting file {} to {}", (Object)file, (Object)destFile);
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                        Utils.fixDateAttributes(file, destFile);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                        if (!Files.exists(dirToCreate, new LinkOption[0])) {
                            LOGGER.debug("Creating directory {}", (Object)dirToCreate);
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (extracting .zip) - '{}'", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file: {} [{}]", (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
        }
    }

    public static void unzipFile(Path zipFile, final Path fileToExtract, final Path destFile) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (!Files.exists(zipFile, new LinkOption[0])) {
            return;
        }
        try {
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
            }
            URI fileUri = zipFile.toUri();
            URI zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null);
            env.put("create", "false");
            try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
                Path root = zipfs.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                        if (file.toString().equals(fileToExtract.toString())) {
                            LOGGER.debug("Extracting file {} to {}", (Object)file, (Object)destFile);
                            Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                            Utils.fixDateAttributes(file, destFile);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (extracting .zip) for '{}' - '{}'", (Object)zipFile, (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file '{}' - '{}' [{}]", new Object[]{zipFile, e.getMessage(), e.getClass().getSimpleName()});
        }
    }

    public static void writeStringToFile(Path file, String text) throws IOException {
        try {
            Files.writeString(file, (CharSequence)text, new OpenOption[0]);
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (delete/write file) for '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
            throw e;
        }
    }

    public static String readFileToString(Path file) throws IOException {
        try {
            return Files.readString(file);
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (read file) for '{}' - '{}' [{}]", new Object[]{file, e.getMessage(), e.getClass().getSimpleName()});
            throw e;
        }
    }

    public static void copyDirectoryRecursive(Path from, Path to) throws IOException {
        LOGGER.debug("Copying complete directory from {} to {}", (Object)from, (Object)to);
        try {
            Files.walkFileTree(from, new CopyFileVisitor(to));
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (copy directory) for '{}' to '{}' - '{}' [{}]", new Object[]{from, to, e.getMessage(), e.getClass().getSimpleName()});
            throw e;
        }
    }

    public static void cleanOldLogs() {
        Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -30);
        Date dateBefore30Days = cal.getTime();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(Globals.LOG_FOLDER, new String[0]));){
            for (Path path : directoryStream) {
                Matcher matcher = pattern.matcher(path.getFileName().toString());
                if (!matcher.find()) continue;
                try {
                    Date date = DateUtils.parseDate(matcher.group());
                    if (!dateBefore30Days.after(date)) continue;
                    Utils.deleteFileSafely(path);
                }
                catch (Exception e) {
                    LOGGER.debug("could not clean old logs: {}", (Object)e.getMessage());
                }
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (delete old logs) - '{}'", (Object)e.getMessage());
        }
        catch (IOException e) {
            LOGGER.debug("could not clean old logs: {}", (Object)e.getMessage());
        }
        List<Path> traces = Utils.listFiles(Paths.get(Globals.LOG_FOLDER, new String[0]));
        traces.removeIf(s -> !s.getFileName().toString().startsWith("trace"));
        Collections.sort(traces);
        for (int i = 0; i < traces.size() - 3; ++i) {
            Utils.deleteFileSafely(traces.get(i));
        }
    }

    public static String getArtworkExtensionFromUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "jpg";
        }
        String ext = UrlUtil.getExtension(url).toLowerCase(Locale.ROOT);
        if (StringUtils.isBlank((CharSequence)ext)) {
            try {
                Url url1 = new Url(url);
                InputStream is = url1.getInputStream(true);
                ext = Utils.getArtworkExtensionFromContentType(url1.getHeader("content-type"));
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)ext) || "tbn".equals(ext)) {
            ext = "jpg";
        }
        if (!MediaFileHelper.SUPPORTED_ARTWORK_FILETYPES.contains(ext)) {
            ext = "jpg";
        }
        return ext.toLowerCase(Locale.ROOT);
    }

    public static String getArtworkExtensionFromContentType(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return "";
        }
        if (contentType.startsWith("image/")) {
            switch (contentType.replace("image/", "")) {
                case "bmp": 
                case "x-bmp": 
                case "x-ms-bmp": {
                    return "bmp";
                }
                case "gif": {
                    return "gif";
                }
                case "jpeg": {
                    return "jpg";
                }
                case "png": {
                    return "png";
                }
                case "tiff": {
                    return "tif";
                }
                case "webp": {
                    return "webp";
                }
            }
            return "";
        }
        return "";
    }

    public static List<Path> listFiles(Path root) {
        ArrayList<Path> filesFound = new ArrayList<Path>();
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return filesFound;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(root);){
            for (Path path : directoryStream) {
                if (!Utils.isRegularFile(path)) continue;
                filesFound.add(path);
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (list files) for '{}' - '{}' [{}]", new Object[]{root, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (IOException e) {
            LOGGER.warn("Could not get a file listing for '{}' - {} [{}]", new Object[]{root, e.getMessage(), e.getClass().getSimpleName()});
        }
        return filesFound;
    }

    public static List<Path> listFilesRecursive(Path root) {
        final ArrayList<Path> filesFound = new ArrayList<Path>();
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return filesFound;
        }
        try {
            Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new AbstractFileVisitor(){

                @Override
                @NotNull
                public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) {
                    if (Utils.isRegularFile(file)) {
                        filesFound.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (list files) for '{}' - '{}' [{}]", new Object[]{root, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (Exception e) {
            LOGGER.warn("Could not get a file listing for '{}' - '{}'", (Object)root, (Object)e.getMessage());
        }
        return filesFound;
    }

    public static long getDirectorySizeOfDiscFiles(Path path) {
        long size = 0L;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            size = walk.filter(Utils::isRegularFile).mapToLong(p -> {
                try {
                    return Files.size(p);
                }
                catch (IOException e) {
                    return 0L;
                }
            }).sum();
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (get directory size) for '{}' - '{}' [{}]", new Object[]{path, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (IOException e) {
            LOGGER.warn("Could not get folder size for '{}' - '{}' [{}]", new Object[]{path, e.getMessage(), e.getClass().getSimpleName()});
        }
        return size;
    }

    public static void flushFileOutputStreamToDisk(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) {
            return;
        }
        try {
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
            Thread.sleep(150L);
        }
        catch (Exception e) {
            LOGGER.debug("Could not flush to disk: {}", (Object)e.getMessage());
        }
    }

    public static String getTempFolder() {
        return tempFolder;
    }

    public static Set<Path> getUnknownFilesByRegex(Path folder, List<String> regexList) {
        GetUnknownFilesVisitor visitor = new GetUnknownFilesVisitor(regexList);
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (list files) for '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
        }
        catch (IOException e) {
            LOGGER.error("Could not get unknown files from '{}' - '{}' [{}]", new Object[]{folder, e.getMessage(), e.getClass().getSimpleName()});
        }
        return visitor.fileList;
    }

    @Deprecated
    public static boolean containsSkipFile(Path dir, boolean readNomedia) {
        return Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || readNomedia && Files.exists(dir.resolve(".nomedia"), new LinkOption[0]);
    }

    public static void deleteUnwantedFilesAndFoldersFor(MediaEntity me) {
        List<String> regexPatterns = Settings.getInstance().getCleanupFileType();
        LOGGER.info("Start cleanup of unwanted file types/folders: {}", regexPatterns);
        HashSet<Path> fileList = new HashSet<Path>();
        for (Path file : Utils.getUnknownFilesByRegex(me.getPathNIO(), regexPatterns)) {
            if (me.getPathNIO().equals(file)) continue;
            fileList.add(file);
        }
        boolean dirty = false;
        for (Path file : fileList) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                try {
                    LOGGER.debug("Deleting folder - {}", (Object)file);
                    Utils.deleteDirectoryRecursive(file);
                    dirty = true;
                }
                catch (Exception e) {
                    LOGGER.debug("could not delete folder - {}", (Object)e.getMessage());
                }
                continue;
            }
            MediaFile mf = new MediaFile(file);
            if (mf.getType() == MediaFileType.VIDEO) continue;
            LOGGER.debug("Deleting file - {}", (Object)file);
            Utils.deleteFileWithBackup(file, me.getDataSource());
            if (!me.getMediaFiles().contains(mf)) continue;
            me.removeFromMediaFiles(mf);
            dirty = true;
        }
        if (dirty) {
            me.saveToDb();
        }
    }

    private static Set<PosixFilePermission> parsePerms(int mode) {
        HashSet<PosixFilePermission> ret = new HashSet<PosixFilePermission>();
        if ((mode & 1) > 0) {
            ret.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) > 0) {
            ret.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) > 0) {
            ret.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) > 0) {
            ret.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) > 0) {
            ret.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) > 0) {
            ret.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) > 0) {
            ret.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) > 0) {
            ret.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) > 0) {
            ret.add(PosixFilePermission.OWNER_READ);
        }
        return ret;
    }

    public static void clearTempFolder() {
        try {
            FileUtils.forceDeleteOnExit((File)Paths.get(tempFolder, new String[0]).toFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String cleanFilename(String filename) {
        for (char c : ILLEGAL_FILENAME_CHARACTERS) {
            filename = filename.replace(c, '_');
        }
        return filename;
    }

    public static int returnOneWhenFilled(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return 1;
        }
        return 0;
    }

    public static int returnOneWhenFilled(int value) {
        if (value > 0) {
            return 1;
        }
        return 0;
    }

    public static int returnOneWhenFilled(Date value) {
        if (value != null && value.getTime() > 0L) {
            return 1;
        }
        return 0;
    }

    public static int returnOneWhenFilled(Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            return 1;
        }
        return 0;
    }

    public static int returnOneWhenFilled(Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            return 1;
        }
        return 0;
    }

    public static String formatFileSizeForDisplay(long filesize) {
        double base = 1000.0;
        if (!Settings.getInstance().isFileSizeBase10()) {
            base = 1024.0;
        }
        if (!Settings.getInstance().isFileSizeDisplayHumanReadable()) {
            double sizeInMb = (double)filesize / (base * base);
            DecimalFormat df = sizeInMb < 1.0 ? new DecimalFormat("#0.00") : new DecimalFormat("#0");
            return df.format(sizeInMb) + " M";
        }
        long bytes = filesize;
        if (-base < (double)bytes && (double)bytes < base) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while ((double)bytes <= -base * 999.95 || (double)bytes >= base * 999.95) {
            bytes = (long)((double)bytes / base);
            ci.next();
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format((double)bytes / base) + " " + ci.current();
    }

    public static String getCRC32(Path file) {
        String crc = "";
        int BUFFER_SIZE = 0x100000;
        byte[] buffer = new byte[0x100000];
        CRC32 crc32 = new CRC32();
        LOGGER.trace("Calculating CRC32 for {}", (Object)file);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            int bytesRead = 0;
            while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) >= 0) {
                crc32.update(buffer, 0, bytesRead);
            }
            if (crc32.getValue() > 0L) {
                crc = HexFormat.of().withUpperCase().toHexDigits(crc32.getValue(), 8);
                LOGGER.trace("Got CRC32 [{}] for {}", (Object)crc, (Object)file);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not generate CRC32 from file '{}' - '{}'", (Object)file, (Object)e.getMessage());
        }
        return crc;
    }

    static {
        block5: {
            LOGGER = LoggerFactory.getLogger(Utils.class);
            localePattern = Pattern.compile("messages_(.{2})_?(.{2,4})?\\.properties", 2);
            stackingPattern1 = Pattern.compile("(.*)[ _.-]+((?:cd|dvd|p(?:ar)?t|dis[ck])[1-9][0-9]?)([ _.-].+)$", 2);
            stackingPattern1a = Pattern.compile("((?:cd|dvd|p(?:ar)?t|dis[ck])[1-9][0-9]?)([ _.-].+)$", 2);
            stackingPattern2 = Pattern.compile("(.*)[ _.-]+((?:cd|dvd|p(?:ar)?t|dis[ck])[a-d])([ _.-].+)$", 2);
            stackingPattern3 = Pattern.compile("(.*?)[_.-]+([a-d])(\\.[^.]+)$", 2);
            stackingPattern4 = Pattern.compile("(.*?)[ (_.-]+([1-9][0-9]?[ .]?(?:of|\u29f8|\u2215|\\/)[ .]?[1-9][0-9]?)[ )_-]?([ _.-].+)$", 2);
            folderStackingPattern = Pattern.compile("(.*?)[ _.-]*((?:cd|dvd|p(?:ar)?t|dis[ck])[1-9][0-9]?)$", 2);
            ILLEGAL_FILENAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
            YOUTUBE_PATTERN = Pattern.compile("^((?:https?:)?\\/\\/)?((?:www|m)\\.)?((?:youtube\\.com|youtu.be))(\\/(?:[\\w\\-]+\\?v=|embed\\/|v\\/)?)([\\w\\-]+)(\\S+)?$");
            SEASON_NFO_PATTERN = Pattern.compile("^season(\\d{2,}|\\-specials)?\\.nfo$", 2);
            SKIP_FILES = Arrays.asList(".tmmignore", "tmmignore", ".nomedia");
            AVAILABLE_LOCALES = new ArrayList<Locale>();
            try {
                String temp = System.getProperty("java.io.tmpdir");
                Path tempFolder = Paths.get(temp, new String[0]);
                if (Files.exists(tempFolder, new LinkOption[0]) && Files.isWritable(tempFolder)) {
                    tempFolder = Paths.get(temp, "tmm");
                    if (!Files.exists(tempFolder, new LinkOption[0])) {
                        Files.createDirectories(tempFolder, new FileAttribute[0]);
                    }
                    Utils.tempFolder = Files.exists(tempFolder, new LinkOption[0]) && Files.isWritable(tempFolder) ? tempFolder.toAbsolutePath().toString() : temp;
                } else {
                    Utils.tempFolder = "tmp";
                }
            }
            catch (Error | Exception ignored) {
                if (tempFolder == null) break block5;
                tempFolder = "tmp";
            }
        }
    }

    public static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
            Path target;
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            }
            if (!Files.exists(target = this.targetPath.resolve(this.sourcePath.relativize(dir)), new LinkOption[0])) {
                try {
                    Files.createDirectories(target, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IOException x) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
            Utils.fixDateAttributes(file, this.targetPath);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class GetUnknownFilesVisitor
    extends AbstractFileVisitor {
        private final Set<Path> fileList = new HashSet<Path>();
        private final List<String> regexList;

        GetUnknownFilesVisitor(List<String> regexList) {
            this.regexList = regexList;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attr) {
            for (String regex : this.regexList) {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(file.getFileName().toString());
                if (!m.find()) continue;
                this.fileList.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes var2) {
            if (dir.getFileName() != null && dir.getFileName().toString().matches(Utils.DISC_FOLDER_REGEX)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            for (String regex : this.regexList) {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(dir.getFileName().toString());
                if (!m.find()) continue;
                this.fileList.add(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

