/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.IPrintable;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmToStringStyle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntityFilenameHistory;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public abstract class MediaEntity
extends AbstractModelObject
implements IPrintable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntity.class);
    protected UUID dbId = UUID.randomUUID();
    @JsonProperty
    protected boolean locked = false;
    @JsonProperty
    protected String dataSource = "";
    @JsonProperty
    protected Map<String, Object> ids = new ConcurrentHashMap<String, Object>(0);
    @JsonProperty
    protected String title = "";
    @JsonProperty
    protected String originalTitle = "";
    @JsonProperty
    protected int year = 0;
    @JsonProperty
    protected String plot = "";
    @JsonProperty
    protected String path = "";
    @JsonProperty
    protected Date dateAdded = new Date();
    @JsonProperty
    protected String productionCompany = "";
    @JsonProperty
    protected String note = "";
    @JsonProperty
    protected Map<String, MediaRating> ratings = new ConcurrentHashMap<String, MediaRating>(0);
    @JsonProperty
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    @JsonProperty
    protected final List<String> tags = new CopyOnWriteArrayList<String>();
    @JsonProperty
    protected Map<MediaFileType, String> artworkUrlMap = new EnumMap<MediaFileType, String>(MediaFileType.class);
    @JsonProperty
    protected String originalFilename = "";
    @JsonProperty
    protected String lastScraperId = "";
    @JsonProperty
    protected String lastScrapeLanguage = "";
    @JsonProperty
    protected MediaEntityFilenameHistory renameHistory = null;
    protected boolean newlyAdded = false;
    protected boolean duplicate = false;
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public abstract MediaFile getMainFile();

    public abstract Date getReleaseDate();

    public void initializeAfterLoading() {
        this.mediaFiles.removeIf(Objects::isNull);
        this.tags.removeIf(Objects::isNull);
        this.sortMediaFiles();
        Utils.removeEmptyStringsFromList(this.tags);
        Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tags);
    }

    public void merge(MediaEntity other) {
        this.merge(other, false);
    }

    public void forceMerge(MediaEntity other) {
        this.merge(other, true);
    }

    protected void merge(MediaEntity other, boolean force) {
        if (this.locked || other == null) {
            return;
        }
        this.setTitle(StringUtils.isBlank((CharSequence)this.title) || force ? other.title : this.title);
        this.setOriginalTitle(StringUtils.isBlank((CharSequence)this.originalTitle) || force ? other.originalTitle : this.originalTitle);
        this.setYear(this.year == 0 || force ? other.year : this.year);
        this.setPlot(StringUtils.isBlank((CharSequence)this.plot) || force ? other.plot : this.plot);
        this.setProductionCompany(StringUtils.isBlank((CharSequence)this.productionCompany) || force ? other.productionCompany : this.productionCompany);
        this.setOriginalFilename(StringUtils.isBlank((CharSequence)this.originalFilename) || force ? other.originalFilename : this.originalFilename);
        this.setLastScraperId(StringUtils.isBlank((CharSequence)this.lastScraperId) || force ? other.lastScraperId : this.lastScraperId);
        this.setLastScrapeLanguage(StringUtils.isBlank((CharSequence)this.lastScrapeLanguage) || force ? other.lastScrapeLanguage : this.lastScrapeLanguage);
        if (force) {
            this.ids.clear();
            this.ratings.clear();
            this.tags.clear();
            this.artworkUrlMap.clear();
        }
        this.setRatings(other.ratings);
        this.setTags(other.tags);
        for (String string : other.getIds().keySet()) {
            if (this.ids.containsKey(string)) continue;
            this.ids.put(string, other.getId(string));
        }
        for (MediaFileType mediaFileType : other.getArtworkUrls().keySet()) {
            if (this.artworkUrlMap.containsKey((Object)mediaFileType)) continue;
            this.artworkUrlMap.put(mediaFileType, other.getArtworkUrl(mediaFileType));
        }
        this.setNote(StringUtils.isBlank((CharSequence)this.note) || force ? other.note : this.note);
    }

    protected void sortMediaFiles() {
        Comparator<MediaFile> mediaFileComparator = this.getMediaFileComparator();
        if (mediaFileComparator != null) {
            this.mediaFiles.sort(mediaFileComparator);
        } else {
            Collections.sort(this.mediaFiles);
        }
    }

    public UUID getDbId() {
        return this.dbId;
    }

    public void setDbId(UUID id) {
        this.dbId = id;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean newValue) {
        boolean oldValue = this.locked;
        this.locked = newValue;
        this.firePropertyChange("locked", oldValue, newValue);
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String newValue) {
        String oldValue = this.dataSource;
        this.dataSource = newValue;
        this.firePropertyChange("dataSource", oldValue, newValue);
    }

    public Map<String, Object> getIds() {
        return Collections.unmodifiableMap(this.ids);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getPlot() {
        return this.plot;
    }

    public String getPath() {
        return this.path;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getOriginalBasename() {
        return FilenameUtils.getBaseName((String)this.originalFilename);
    }

    public Path getPathNIO() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return null;
        }
        return Paths.get(this.path, new String[0]).toAbsolutePath();
    }

    public String getFoldername() {
        Path pathNIO = this.getPathNIO();
        if (pathNIO == null) {
            return "";
        }
        return pathNIO.getFileName().toString();
    }

    public String getParent() {
        Path pathNIO = this.getPathNIO();
        if (pathNIO == null) {
            return "";
        }
        Path parent = Paths.get(this.dataSource, new String[0]).toAbsolutePath().relativize(pathNIO.getParent());
        return parent.toString();
    }

    public Dimension getArtworkDimension(MediaFileType type) {
        return MediaFileHelper.getArtworkDimension(ListUtils.getFirst(this.getMediaFiles(type)));
    }

    public String getArtworkFilename(MediaFileType type) {
        List<MediaFile> artworks = this.getMediaFiles(type);
        if (!artworks.isEmpty()) {
            return artworks.get(0).getFile().toString();
        }
        return "";
    }

    public Map<String, MediaRating> getRatings() {
        return this.ratings;
    }

    public MediaRating getRating(String id) {
        return this.ratings.getOrDefault(id, MediaMetadata.EMPTY_RATING);
    }

    public abstract MediaRating getRating();

    public MediaRating getUserRating() {
        MediaRating mediaRating = this.ratings.get("user");
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public int getYear() {
        return this.year;
    }

    public String getDecadeShort() {
        Object decade = "";
        if (this.year > 0) {
            int len = String.valueOf(this.year).length();
            String pre = String.valueOf(this.year).substring(0, len - 1);
            decade = pre + "0s";
        }
        return decade;
    }

    public String getDecadeLong() {
        Object decade = "";
        if (this.year > 0) {
            int len = String.valueOf(this.year).length();
            String pre = String.valueOf(this.year).substring(0, len - 1);
            decade = pre + "0-" + pre + "9";
        }
        return decade;
    }

    public void setIds(Map<String, Object> ids) {
        for (Map.Entry<String, Object> entry : ids.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            this.setId(entry.getKey(), entry.getValue());
        }
    }

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue == null ? "" : newValue.strip();
        this.firePropertyChange("title", oldValue, newValue);
    }

    public void setOriginalTitle(String newValue) {
        String oldValue = this.originalTitle;
        this.originalTitle = newValue == null ? "" : newValue.strip();
        this.firePropertyChange("originalTitle", oldValue, newValue);
    }

    public void setPlot(String newValue) {
        String oldValue = this.plot;
        this.plot = newValue == null ? "" : newValue.strip();
        this.firePropertyChange("plot", oldValue, newValue);
    }

    public void setPath(String newValue) {
        String oldValue = this.path;
        this.path = newValue;
        this.firePropertyChange("path", oldValue, newValue);
    }

    public void setOriginalFilename(String newValue) {
        String oldValue = this.originalFilename;
        this.originalFilename = newValue;
        this.firePropertyChange("originalFilename", oldValue, newValue);
    }

    public void removeRating(String id) {
        MediaRating removedMediaRating = this.ratings.remove(id);
        if (removedMediaRating != null) {
            this.firePropertyChange("rating", null, this.ratings);
        }
    }

    public void clearRatings() {
        this.ratings.clear();
        this.firePropertyChange("rating", null, this.ratings);
    }

    public void setRatings(Map<String, MediaRating> newRatings) {
        MediaRating userMediaRating = this.ratings.get("user");
        this.ratings.clear();
        for (Map.Entry<String, MediaRating> entry : newRatings.entrySet()) {
            if (entry.getValue() == MediaMetadata.EMPTY_RATING || !(entry.getValue().getRating() >= 0.0f)) continue;
            this.setRating(entry.getValue());
        }
        if (userMediaRating != null && !newRatings.containsKey("user")) {
            this.setRating(userMediaRating);
        }
    }

    public void setRating(MediaRating mediaRating) {
        if (mediaRating != null && StringUtils.isNotBlank((CharSequence)mediaRating.getId()) && mediaRating.getRating() >= 0.0f) {
            this.ratings.put(mediaRating.getId(), mediaRating);
            this.firePropertyChange("rating", null, mediaRating);
        }
    }

    public void setYear(int newValue) {
        int oldValue = this.year;
        this.year = newValue;
        this.firePropertyChange("year", oldValue, newValue);
    }

    public void setArtworkUrl(String url, MediaFileType type) {
        String oldValue = this.getArtworkUrl(type);
        switch (type) {
            case POSTER: 
            case FANART: 
            case BANNER: 
            case THUMB: 
            case CLEARART: 
            case DISC: 
            case LOGO: 
            case CLEARLOGO: 
            case CHARACTERART: 
            case KEYART: 
            case SEASON_BANNER: 
            case SEASON_FANART: 
            case SEASON_POSTER: 
            case SEASON_THUMB: {
                if (StringUtils.isBlank((CharSequence)url)) {
                    this.artworkUrlMap.remove((Object)type);
                    break;
                }
                this.artworkUrlMap.put(type, url);
                break;
            }
            default: {
                return;
            }
        }
        this.firePropertyChange(type.name().toLowerCase(Locale.ROOT) + "Url", oldValue, url);
    }

    public String getArtworkUrl(MediaFileType type) {
        String url = this.artworkUrlMap.get((Object)type);
        return url == null ? "" : url;
    }

    public void removeArtworkUrl(MediaFileType type) {
        this.artworkUrlMap.remove((Object)type);
    }

    public Map<MediaFileType, String> getArtworkUrls() {
        return this.artworkUrlMap;
    }

    public void setArtwork(Path file, MediaFileType type) {
        List<MediaFile> images = this.getMediaFiles(type);
        if (!images.isEmpty()) {
            MediaFile mediaFile = images.get(0);
            mediaFile.setFile(file);
            mediaFile.gatherMediaInformation(true);
            this.fireAddedEventForMediaFile(mediaFile);
        } else {
            MediaFile mediaFile = new MediaFile(file, type);
            mediaFile.gatherMediaInformation();
            this.addToMediaFiles(mediaFile);
        }
        this.firePropertyChange("mediaInformation", false, true);
    }

    public Map<MediaFileType, MediaFile> getArtworkMap() {
        EnumMap<MediaFileType, MediaFile> artworkMap = new EnumMap<MediaFileType, MediaFile>(MediaFileType.class);
        List<MediaFile> mfs = this.getMediaFiles();
        for (MediaFile mf : mfs) {
            if (!mf.isGraphic() || artworkMap.containsKey((Object)mf.getType())) continue;
            artworkMap.put(mf.getType(), mf);
        }
        return artworkMap;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public Date getDateAddedForUi() {
        Date now;
        Date date = null;
        switch (Settings.getInstance().getDateField()) {
            case FILE_CREATION_DATE: {
                MediaFile mainMediaFile = this.getMainFile();
                if (mainMediaFile == null) break;
                date = mainMediaFile.getDateCreated();
                break;
            }
            case FILE_LAST_MODIFIED_DATE: {
                MediaFile mainMediaFile = this.getMainFile();
                if (mainMediaFile == null) break;
                date = mainMediaFile.getDateLastModified();
                break;
            }
            case RELEASE_DATE: {
                date = this.getReleaseDate();
                break;
            }
            default: {
                date = this.dateAdded;
            }
        }
        if (date == null) {
            date = this.dateAdded;
        }
        if ((now = new Date()).before(date)) {
            date = this.dateAdded;
        }
        return date;
    }

    public String getDateAddedAsString() {
        Date date = this.getDateAddedForUi();
        if (date == null) {
            return "";
        }
        return TmmDateFormat.getDateShortTimeFormat().format(this.dateAdded);
    }

    public void setDateAdded(Date newValue) {
        Date oldValue = this.dateAdded;
        this.dateAdded = newValue;
        this.firePropertyChange("dateAdded", oldValue, newValue);
        this.firePropertyChange("dateAddedAsString", oldValue, newValue);
    }

    public String getProductionCompany() {
        return this.productionCompany;
    }

    public List<String> getProductionCompanyAsArray() {
        return ParserUtils.split(this.productionCompany);
    }

    public void setProductionCompany(String newValue) {
        String oldValue = this.productionCompany;
        this.productionCompany = StrgUtils.strip(newValue);
        this.firePropertyChange("productionCompany", oldValue, newValue);
    }

    public boolean isScraped() {
        return this.calculateScrapeScore() > 5.0f;
    }

    protected float calculateScrapeScore() {
        float score = 0.0f;
        score += (float)this.ids.size();
        score += (float)Utils.returnOneWhenFilled(this.originalTitle);
        score += (float)Utils.returnOneWhenFilled(this.plot);
        score += (float)Utils.returnOneWhenFilled(this.productionCompany);
        score += (float)Utils.returnOneWhenFilled(this.ratings);
        score += (float)Utils.returnOneWhenFilled(this.artworkUrlMap);
        if (!this.getMediaFiles(MediaFileType.NFO).isEmpty()) {
            score += 1.0f;
        }
        return score += (float)Utils.returnOneWhenFilled(this.lastScraperId);
    }

    public void setNote(String newValue) {
        String oldValue = this.note;
        this.note = StrgUtils.strip(newValue);
        this.firePropertyChange("note", oldValue, newValue);
    }

    public String getNote() {
        return this.note;
    }

    public String getLastScraperId() {
        return this.lastScraperId;
    }

    public void setLastScraperId(String newValue) {
        String oldValue = this.lastScraperId;
        this.lastScraperId = StrgUtils.strip(newValue);
        this.firePropertyChange("lastScraperId", oldValue, newValue);
    }

    public String getLastScrapeLanguage() {
        return this.lastScrapeLanguage;
    }

    public void setLastScrapeLanguage(String newValue) {
        String oldValue = this.lastScrapeLanguage;
        this.lastScrapeLanguage = StrgUtils.strip(newValue);
        this.firePropertyChange("lastScrapeLanguage", oldValue, newValue);
    }

    public void setDuplicate() {
        this.duplicate = true;
    }

    public void clearDuplicate() {
        this.duplicate = false;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setId(String key, Object value) {
        String v = String.valueOf(value).strip();
        if ("".equals(v) || "0".equals(v) || "null".equals(v)) {
            this.ids.remove(key);
        } else {
            if ("imdb".equals(key) && !MediaIdUtil.isValidImdbId(v)) {
                return;
            }
            if (value instanceof String) {
                try {
                    Integer parsedInt = Integer.parseInt(v);
                    this.ids.put(key, parsedInt);
                }
                catch (NumberFormatException ex) {
                    this.ids.put(key, v);
                }
            } else {
                this.ids.put(key, value);
            }
        }
        this.firePropertyChange(key, null, value);
        this.firePropertyChange("id", null, value);
        if ("tmdb".equals(key) || "imdb".equals(key) || "tvdb".equals(key) || "trakt".equals(key)) {
            this.firePropertyChange(key + "Id", null, value);
        }
    }

    public void removeId(String key) {
        Object obj = this.ids.remove(key);
        if (obj != null) {
            this.firePropertyChange(key, obj, null);
        }
    }

    public void removeAllIds() {
        new ArrayList<String>(this.ids.keySet()).forEach(this::removeId);
    }

    public Object getId(String key) {
        return this.ids.get(key);
    }

    public String getIdAsString(String key) {
        return MediaIdUtil.getIdAsString(this.ids, key);
    }

    public int getIdAsInt(String key) {
        return MediaIdUtil.getIdAsInt(this.ids, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToMediaFiles(MediaFile mediaFile) {
        if (mediaFile == null) {
            return;
        }
        boolean changed = false;
        try {
            MediaFile oldMf;
            int i;
            this.readWriteLock.writeLock().lock();
            if (this.mediaFiles.contains(mediaFile) && (i = this.mediaFiles.indexOf(mediaFile)) >= 0 && (oldMf = this.mediaFiles.get(i)).getType() != mediaFile.getType()) {
                this.mediaFiles.remove(i);
            }
            if (!this.mediaFiles.contains(mediaFile)) {
                this.mediaFiles.add(mediaFile);
                this.sortMediaFiles();
                changed = true;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        if (changed) {
            this.firePropertyChange("mediaFiles", null, this.mediaFiles);
            this.fireAddedEventForMediaFile(mediaFile);
        }
    }

    public void addToMediaFiles(List<MediaFile> mediaFiles) {
        for (MediaFile mediaFile : ListUtils.nullSafe(mediaFiles)) {
            this.addToMediaFiles(mediaFile);
        }
    }

    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        if (mediaFile == null) {
            return;
        }
        switch (mediaFile.getType()) {
            case FANART: 
            case SEASON_FANART: {
                this.firePropertyChange("fanart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case POSTER: 
            case SEASON_POSTER: {
                this.firePropertyChange("poster", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case BANNER: 
            case SEASON_BANNER: {
                this.firePropertyChange("banner", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case THUMB: 
            case SEASON_THUMB: {
                this.firePropertyChange("thumb", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CLEARART: {
                this.firePropertyChange("clearart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case DISC: {
                this.firePropertyChange("disc", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case LOGO: {
                this.firePropertyChange("logo", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CLEARLOGO: {
                this.firePropertyChange("clearlogo", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CHARACTERART: {
                this.firePropertyChange("characterart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case KEYART: {
                this.firePropertyChange("keyart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
        }
    }

    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        if (mediaFile == null) {
            return;
        }
        switch (mediaFile.getType()) {
            case FANART: 
            case SEASON_FANART: {
                this.firePropertyChange("fanart", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case POSTER: 
            case SEASON_POSTER: {
                this.firePropertyChange("poster", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case BANNER: 
            case SEASON_BANNER: {
                this.firePropertyChange("banner", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case THUMB: 
            case SEASON_THUMB: {
                this.firePropertyChange("thumb", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case CLEARART: {
                this.firePropertyChange("clearart", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case DISC: {
                this.firePropertyChange("disc", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case LOGO: {
                this.firePropertyChange("logo", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CLEARLOGO: {
                this.firePropertyChange("clearlogo", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CHARACTERART: {
                this.firePropertyChange("characterart", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case KEYART: {
                this.firePropertyChange("keyart", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
        }
    }

    public List<MediaFile> getMediaFiles() {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.readLock().lock();
            mf.addAll(this.mediaFiles);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return mf;
    }

    public List<MediaFile> getMediaFilesRecursive() {
        return this.getMediaFiles();
    }

    public boolean hasMediaFiles() {
        return !this.mediaFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaFile> getMediaFiles(MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.readLock().lock();
            for (MediaFile mediaFile : this.mediaFiles) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (!match) continue;
                mf.add(mediaFile);
            }
            ArrayList<MediaFile> arrayList = mf;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaFile getBiggestMediaFile(MediaFileType ... types) {
        MediaFile mf = null;
        try {
            this.readWriteLock.readLock().lock();
            for (MediaFile mediaFile : this.mediaFiles) {
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type) || mf != null && mediaFile.getFilesize() < mf.getFilesize()) continue;
                    mf = mediaFile;
                }
            }
            Iterator<MediaFile> iterator = mf;
            return iterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalFilesize() {
        try {
            this.readWriteLock.readLock().lock();
            long result = 0L;
            for (MediaFile mediaFile : this.mediaFiles) {
                result += mediaFile.getFilesize();
            }
            long l = result;
            return l;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaFile getNewestMediaFilesOfType(MediaFileType ... types) {
        MediaFile mf = null;
        try {
            this.readWriteLock.readLock().lock();
            for (MediaFile mediaFile : this.mediaFiles) {
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type) || mf != null && mediaFile.getFiledate() < mf.getFiledate()) continue;
                    mf = new MediaFile(mediaFile);
                }
            }
            Iterator<MediaFile> iterator = mf;
            return iterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaFile> getMediaFilesExceptType(MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.readLock().lock();
            for (MediaFile mediaFile : this.mediaFiles) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (match) continue;
                mf.add(mediaFile);
            }
            ArrayList<MediaFile> arrayList = mf;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void removeAllMediaFiles() {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>(this.mediaFiles);
        try {
            this.readWriteLock.writeLock().lock();
            for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
                this.mediaFiles.remove(i);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    public void removeFromMediaFiles(MediaFile mediaFile) {
        boolean changed = false;
        try {
            this.readWriteLock.writeLock().lock();
            changed = this.mediaFiles.remove(mediaFile);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        if (changed) {
            this.firePropertyChange("mediaFiles", null, this.mediaFiles);
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMediaFilesExceptType(MediaFileType type) {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.writeLock().lock();
            for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
                MediaFile mediaFile = this.mediaFiles.get(i);
                if (mediaFile.getType().equals((Object)type)) continue;
                this.mediaFiles.remove(i);
                changedMediafiles.add(mediaFile);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        if (!changedMediafiles.isEmpty()) {
            for (MediaFile mediaFile : changedMediafiles) {
                this.fireRemoveEventForMediaFile(mediaFile);
            }
            this.firePropertyChange("mediaFiles", null, this.mediaFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMediaFiles(MediaFileType type) {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.writeLock().lock();
            for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
                MediaFile mediaFile = this.mediaFiles.get(i);
                if (!mediaFile.getType().equals((Object)type)) continue;
                this.mediaFiles.remove(i);
                changedMediafiles.add(mediaFile);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        if (!changedMediafiles.isEmpty()) {
            for (MediaFile mediaFile : changedMediafiles) {
                this.fireRemoveEventForMediaFile(mediaFile);
            }
            this.firePropertyChange("mediaFiles", null, this.mediaFiles);
        }
    }

    public void deleteMediaFiles(MediaFileType type) {
        this.getMediaFiles(type).forEach(mediaFile -> {
            mediaFile.deleteSafely(this.getDataSource());
            this.removeFromMediaFiles((MediaFile)mediaFile);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMediaFilePath(Path oldPath, Path newPath) {
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.readLock().lock();
            mfs.addAll(this.mediaFiles);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        for (MediaFile mf : mfs) {
            Path oldCache;
            mf.replacePathForRenamedFolder(oldPath, newPath);
            if (!mf.isGraphic() || !Files.exists(oldCache = ImageCache.getAbsolutePath(mf), new LinkOption[0])) continue;
            Path newCache = ImageCache.getAbsolutePath(mf);
            LOGGER.trace("updating imageCache {} -> {}", (Object)oldCache, (Object)newCache);
            try {
                Files.move(oldCache, newCache, new CopyOption[0]);
            }
            catch (IOException e) {
                LOGGER.warn("Error moving cached file '{}' - '{}'", (Object)oldCache, (Object)e.getMessage());
            }
        }
    }

    public void cacheImages() {
        List<MediaFile> imageFiles = this.getImagesToCache();
        imageFiles.forEach(ImageCache::cacheImageAsync);
    }

    public List<MediaFile> getImagesToCache() {
        if (!Settings.getInstance().isImageCache()) {
            return Collections.emptyList();
        }
        return this.getMediaFiles().stream().filter(MediaFile::isGraphic).toList();
    }

    public void gatherMediaFileInformation(boolean force) {
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        try {
            this.readWriteLock.readLock().lock();
            mfs.addAll(this.mediaFiles);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        for (MediaFile mediaFile : mfs) {
            mediaFile.gatherMediaInformation(force);
        }
        String video = FilenameUtils.getBaseName((String)this.getMainFile().getFilenameWithoutStacking());
        for (MediaFile mediaFile : mfs) {
            if (mediaFile.getType() != MediaFileType.SUBTITLE && mediaFile.getType() != MediaFileType.AUDIO) continue;
            MediaStreamInfo info = MediaFileHelper.gatherLanguageInformation(mediaFile.getBasename(), video);
            if (mediaFile.getType() == MediaFileType.SUBTITLE && !mediaFile.getSubtitles().isEmpty()) {
                MediaFileSubtitle sub = mediaFile.getSubtitles().get(0);
                if (sub.getLanguage().isEmpty() || info.getLanguage().matches("[a-zA-Z][a-zA-Z][_-].*")) {
                    sub.setLanguage(info.getLanguage());
                }
                sub.setTitle(info.getTitle());
                sub.set(info.getFlags());
                continue;
            }
            if (mediaFile.getType() != MediaFileType.AUDIO || !mediaFile.getAudioChannels().isEmpty()) continue;
            MediaFileAudioStream audio = mediaFile.getAudioStreams().get(0);
            if (StringUtils.isBlank((CharSequence)audio.getLanguage()) || info.getLanguage().matches("[a-zA-Z][a-zA-Z][_-].*")) {
                audio.setLanguage(info.getLanguage());
            }
            if (StringUtils.isBlank((CharSequence)audio.getTitle())) {
                audio.setTitle(info.getTitle());
            }
            audio.set(info.getFlags());
        }
        this.firePropertyChange("mediaInformation", false, true);
    }

    public void fireEventForChangedMediaInformation() {
        this.firePropertyChange("mediaInformation", false, true);
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newValue) {
        boolean oldValue = this.newlyAdded;
        this.newlyAdded = newValue;
        this.firePropertyChange("newlyAdded", oldValue, newValue);
    }

    public void addToTags(Collection<String> newTags) {
        LinkedHashSet<String> newItems = new LinkedHashSet<String>();
        for (String tag : ListUtils.nullSafe(newTags)) {
            if (StringUtils.isBlank((CharSequence)tag)) continue;
            if (this.tags.stream().anyMatch(tag::equalsIgnoreCase)) continue;
            newItems.add(StrgUtils.strip(tag));
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.tags.addAll(newItems);
        this.firePropertyChange("tags", null, this.tags);
        this.firePropertyChange("tagsAsString", null, this.tags);
    }

    public void removeFromTags(String removeTag) {
        if (this.tags.remove(removeTag)) {
            this.firePropertyChange("tags", null, removeTag);
            this.firePropertyChange("tagsAsString", null, removeTag);
        }
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        ListUtils.mergeLists(this.tags, newTags);
        Utils.removeEmptyStringsFromList(this.tags);
        Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tags);
        this.firePropertyChange("tags", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagsAsString() {
        return String.join((CharSequence)", ", this.tags);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void removeAllTags() {
        this.tags.clear();
        this.firePropertyChange("tags", null, this.tags);
        this.firePropertyChange("tagsAsString", null, this.tags);
    }

    public MediaEntityFilenameHistory getRenameHistory() {
        return this.renameHistory;
    }

    public void setRenameHistory(MediaEntityFilenameHistory newValue) {
        MediaEntityFilenameHistory oldValue = this.renameHistory;
        this.renameHistory = newValue;
        this.firePropertyChange("renameHistory", oldValue, newValue);
    }

    public abstract void saveToDb();

    public abstract void callbackForGatheredMediainformation(MediaFile var1);

    public abstract void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType var1);

    protected abstract Comparator<MediaFile> getMediaFileComparator();

    protected void mergePersons(List<Person> baseList, List<Person> newItems) {
        if (baseList == null || newItems == null) {
            return;
        }
        for (int i = 0; i < newItems.size(); ++i) {
            Person entry = newItems.get(i);
            if (!baseList.contains(entry)) {
                try {
                    baseList.add(i, entry);
                }
                catch (IndexOutOfBoundsException e) {
                    baseList.add(entry);
                }
                continue;
            }
            int indexOldList = baseList.indexOf(entry);
            Person oldPerson = baseList.get(indexOldList);
            oldPerson.merge(entry);
            if (i == indexOldList) continue;
            Person oldEntry = baseList.remove(indexOldList);
            try {
                baseList.add(i, oldEntry);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                baseList.add(oldEntry);
            }
        }
    }

    @Override
    public String toPrintable() {
        return this.getTitle();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TmmToStringStyle.TMM_STYLE, (boolean)false, MediaEntity.class);
    }
}

