/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.TmmToStringStyle;
import org.tinymediamanager.core.entities.MediaStreamInfo;

public class MediaFileAudioStream
extends MediaStreamInfo {
    @JsonProperty
    private int audioChannels = 0;
    @JsonProperty
    private int bitrate = 0;
    @JsonProperty
    private int bitDepth = 0;

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int audiochannels) {
        this.audioChannels = audiochannels;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public String getBitrateInKbps() {
        return this.bitrate > 0 ? this.bitrate + " kbps" : "";
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public String getBitDepthAsString() {
        return this.bitDepth > 0 ? this.bitDepth + " bit" : "";
    }

    public void setBitDepth(int bitDepth) {
        this.bitDepth = bitDepth;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TmmToStringStyle.TMM_STYLE, (boolean)false, MediaFileAudioStream.class);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MediaFileAudioStream that = (MediaFileAudioStream)o;
        return this.audioChannels == that.audioChannels && this.bitrate == that.bitrate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.audioChannels, this.bitrate);
    }

    @JsonAnySetter
    public void setUnknownFields(String property, Object value) {
        if (value == null) {
            return;
        }
        if (property.equals("audioTitle")) {
            this.setTitle(value.toString());
        } else if (property.equals("defaultStream")) {
            this.setDefaultStream(Boolean.parseBoolean(value.toString()));
        }
    }
}

