/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.filenaming;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MovieSetFanartNaming implements IMovieSetFileNaming
{
    MOVIE_FANART{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-fanart." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    MOVIESET_FANART{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-fanart." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    KODI_FANART{

        @Override
        public String getFilename(String basename, String extension) {
            return "fanart." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_FANART{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-fanart." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    };

}

