/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.http;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.http.AbstractCommandHandler;
import org.tinymediamanager.core.movie.MovieExporter;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieARDetectorTask;
import org.tinymediamanager.core.movie.tasks.MovieFetchRatingsTask;
import org.tinymediamanager.core.movie.tasks.MovieMissingArtworkDownloadTask;
import org.tinymediamanager.core.movie.tasks.MovieReloadMediaInformationTask;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.movie.tasks.MovieSubtitleSearchAndDownloadTask;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.tasks.ExportTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.ParserUtils;

class MovieCommandTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieCommandTask.class);
    private final List<AbstractCommandHandler.Command> commands;
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final MovieSettings movieSettings = MovieModuleManager.getInstance().getSettings();
    private final List<Movie> newMovies = new ArrayList<Movie>();
    private TmmTask activeTask;

    public MovieCommandTask(List<AbstractCommandHandler.Command> commands) {
        super("Movie - HTTP commands");
        this.commands = commands;
    }

    @Override
    protected void doInBackground() {
        this.updateDataSources();
        this.reloadMediaInfo();
        this.aspectRatioDetection();
        this.scrape();
        this.downloadTrailer();
        this.downloadSubtitles();
        this.downloadMissingArtwork();
        this.rename();
        this.export();
    }

    private void updateDataSources() {
        TreeSet<String> dataSources = new TreeSet<String>();
        ArrayList<Movie> existingMovies = new ArrayList<Movie>(this.movieList.getMovies());
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"update".equals(command.action)) continue;
            dataSources.addAll(this.getDataSourcesForScope(command.scope));
        }
        if (!dataSources.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("update.datasource"));
            this.publishState(TmmResourceBundle.getString("update.datasource"), this.getProgressDone());
            this.activeTask = new MovieUpdateDatasourceTask(dataSources);
            this.activeTask.run();
            this.activeTask = null;
        }
        for (Movie movie : this.movieList.getMovies()) {
            if (existingMovies.contains(movie)) continue;
            this.newMovies.add(movie);
        }
    }

    private List<String> getDataSourcesForScope(AbstractCommandHandler.CommandScope scope) {
        ArrayList<String> dataSources = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)scope.name)) {
            scope.name = "all";
        }
        switch (scope.name) {
            case "all": {
                dataSources.addAll(this.movieSettings.getMovieDataSource());
                break;
            }
            case "single": {
                for (String index : ListUtils.nullSafe(Arrays.asList(scope.args))) {
                    try {
                        int i = Integer.parseInt(index);
                        if (this.movieSettings.getMovieDataSource().size() < i - 1) continue;
                        dataSources.add(this.movieSettings.getMovieDataSource().get(i - 1));
                    }
                    catch (Exception e) {
                        LOGGER.debug("Could not parse data source index from command - '{}'", (Object)e.getMessage());
                    }
                }
                break;
            }
        }
        return dataSources;
    }

    private void reloadMediaInfo() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"reloadMediaInfo".equals(command.action)) continue;
            LOGGER.debug("HTTP API: Reload media info - '{}'", (Object)command);
            List<Movie> movies = this.getMoviesForScope(command.scope);
            if (movies.isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("movie.reloadMediaInfo"));
            this.publishState(TmmResourceBundle.getString("movie.reloadMediaInfo"), this.getProgressDone());
            this.activeTask = new MovieReloadMediaInformationTask(movies);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private void aspectRatioDetection() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"detectAspectRatio".equals(command.action)) continue;
            LOGGER.debug("HTTP API: Detecting aspect ratio - '{}'", (Object)command);
            List<Movie> movies = this.getMoviesForScope(command.scope);
            if (movies.isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("movie.ard"));
            this.publishState(TmmResourceBundle.getString("movie.ard"), this.getProgressDone());
            this.activeTask = new MovieARDetectorTask(movies);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private void scrape() {
        for (AbstractCommandHandler.Command command : this.commands) {
            List<Movie> moviesToScrape;
            if ("scrape".equals(command.action)) {
                String scraperId;
                MediaScraper scraper;
                moviesToScrape = this.getMoviesForScope(command.scope);
                if (moviesToScrape.isEmpty()) continue;
                this.setTaskName(TmmResourceBundle.getString("movie.scraping"));
                this.publishState(TmmResourceBundle.getString("movie.scraping"), this.getProgressDone());
                MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
                List<MovieScraperMetadataConfig> config = this.movieSettings.getScraperMetadataConfig();
                if (StringUtils.isNotBlank((CharSequence)command.args.get("scraper")) && (scraper = MediaScraper.getMediaScraperById(scraperId = command.args.get("scraper"), ScraperType.MOVIE)) != null && scraper.isEnabled()) {
                    options.setMetadataScraper(scraper);
                }
                MovieScrapeTask.MovieScrapeParams movieScrapeParams = new MovieScrapeTask.MovieScrapeParams(new ArrayList<Movie>(moviesToScrape), options, config);
                movieScrapeParams.setOverwriteExistingItems(!this.movieSettings.isDoNotOverwriteExistingData());
                MovieScrapeTask task = new MovieScrapeTask(movieScrapeParams);
                task.setRunInBackground(true);
                this.activeTask = task;
                this.activeTask.run();
                while (TmmTaskManager.getInstance().isPoolRunning()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.activeTask = null;
                continue;
            }
            if (!"fetchRatings".equals(command.action) || (moviesToScrape = this.getMoviesForScope(command.scope)).isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("movie.fetchratings"));
            this.publishState(TmmResourceBundle.getString("movie.fetchratings"), this.getProgressDone());
            MovieFetchRatingsTask task = new MovieFetchRatingsTask(moviesToScrape, RatingProvider.RatingSource.getRatingSourcesForMovies());
            this.activeTask = task;
            this.activeTask.run();
            while (TmmTaskManager.getInstance().isPoolRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.activeTask = null;
        }
    }

    private void downloadTrailer() {
        LinkedHashSet<Movie> moviesToProcess = new LinkedHashSet<Movie>();
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"downloadTrailer".equals(command.action)) continue;
            LOGGER.debug("HTTP API: Downloading trailers - '{}'", (Object)command);
            boolean onlyMissingTrailer = true;
            if (StringUtils.isNotBlank((CharSequence)command.args.get("onlyMissing"))) {
                onlyMissingTrailer = Boolean.parseBoolean(command.args.get("onlyMissing"));
            }
            for (Movie movie : this.getMoviesForScope(command.scope)) {
                if (onlyMissingTrailer) {
                    if (!movie.getMediaFiles(MediaFileType.TRAILER).isEmpty()) continue;
                    moviesToProcess.add(movie);
                    continue;
                }
                moviesToProcess.add(movie);
            }
        }
        if (!moviesToProcess.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("trailer.download"));
            this.publishState(TmmResourceBundle.getString("trailer.download"), this.getProgressDone());
            for (Movie movie : moviesToProcess) {
                this.activeTask = new MovieTrailerDownloadTask(movie);
                this.activeTask.run();
                this.activeTask = null;
            }
        }
    }

    private void downloadSubtitles() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"downloadSubtitle".equals(command.action)) continue;
            String language = command.args.get("language");
            MediaLanguages mediaLanguages = null;
            if (StringUtils.isNotBlank((CharSequence)language)) {
                mediaLanguages = MediaLanguages.get(language);
            }
            if (mediaLanguages == null) {
                mediaLanguages = this.movieSettings.getScraperLanguage();
            }
            ArrayList<Movie> moviesToProcess = new ArrayList<Movie>();
            LOGGER.debug("HTTP API: Downloading missing subtitles - '{}'", (Object)command);
            boolean onlyMissingSubs = true;
            if (StringUtils.isNotBlank((CharSequence)command.args.get("onlyMissing"))) {
                onlyMissingSubs = Boolean.parseBoolean(command.args.get("onlyMissing"));
            }
            for (Movie movie : this.getMoviesForScope(command.scope)) {
                if (onlyMissingSubs) {
                    boolean subtitleFound = false;
                    for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
                        for (MediaFileSubtitle subtitle : mf.getSubtitles()) {
                            MediaLanguages subtitleLanguage;
                            if (!StringUtils.isNotBlank((CharSequence)subtitle.getLanguage()) || (subtitleLanguage = MediaLanguages.get(subtitle.getLanguage())) != mediaLanguages) continue;
                            subtitleFound = true;
                            break;
                        }
                        if (!subtitleFound) continue;
                        break;
                    }
                    if (subtitleFound) continue;
                    moviesToProcess.add(movie);
                    continue;
                }
                moviesToProcess.add(movie);
            }
            if (moviesToProcess.isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("movie.download.subtitles"));
            this.publishState(TmmResourceBundle.getString("movie.download.subtitles"), this.getProgressDone());
            this.activeTask = new MovieSubtitleSearchAndDownloadTask(moviesToProcess, mediaLanguages);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private void downloadMissingArtwork() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"downloadMissingArtwork".equals(command.action)) continue;
            this.setTaskName(TmmResourceBundle.getString("movie.downloadmissingartwork"));
            this.publishState(TmmResourceBundle.getString("movie.downloadmissingartwork"), this.getProgressDone());
            MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
            movieSearchAndScrapeConfig.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
            movieSearchAndScrapeConfig.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
            ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
            for (MediaScraper artworkScraper : MovieModuleManager.getInstance().getMovieList().getAvailableArtworkScrapers()) {
                if (!MovieModuleManager.getInstance().getSettings().getArtworkScrapers().contains(artworkScraper.getId())) continue;
                selectedArtworkScrapers.add(artworkScraper);
            }
            if (StringUtils.isNotBlank((CharSequence)command.args.get("scraper"))) {
                selectedArtworkScrapers.clear();
                List<String> scraperIds = ParserUtils.split(command.args.get("scraper"));
                for (String id : scraperIds) {
                    MediaScraper scraper = MediaScraper.getMediaScraperById(id, ScraperType.MOVIE_ARTWORK);
                    if (scraper == null || !scraper.isEnabled()) continue;
                    selectedArtworkScrapers.add(scraper);
                }
            }
            movieSearchAndScrapeConfig.setArtworkScraper(selectedArtworkScrapers);
            this.activeTask = new MovieMissingArtworkDownloadTask(this.getMoviesForScope(command.scope), movieSearchAndScrapeConfig, MovieModuleManager.getInstance().getSettings().getScraperMetadataConfig());
            this.activeTask.run();
            this.activeTask = null;
            while (TmmTaskManager.getInstance().isPoolRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void rename() {
        LinkedHashSet<Movie> moviesToRename = new LinkedHashSet<Movie>();
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"rename".equals(command.action)) continue;
            moviesToRename.addAll(this.getMoviesForScope(command.scope));
        }
        if (!moviesToRename.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("movie.rename"));
            this.publishState(TmmResourceBundle.getString("movie.rename"), this.getProgressDone());
            this.activeTask = new MovieRenameTask(new ArrayList<Movie>(moviesToRename));
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private void export() {
        for (AbstractCommandHandler.Command command : this.commands) {
            String exportPath;
            List<Movie> toExport;
            if (!"export".equals(command.action) || (toExport = this.getMoviesForScope(command.scope)).isEmpty()) continue;
            String templateName = command.args.get("template");
            ExportTemplate template = MediaEntityExporter.findTemplates(MediaEntityExporter.TemplateType.MOVIE).stream().filter(t -> t.getPath().endsWith(templateName)).findFirst().orElse(null);
            if (template == null || StringUtils.isBlank((CharSequence)(exportPath = command.args.get("exportPath")))) continue;
            try {
                LOGGER.debug("HTTP API: Exporting movies - '{}'", (Object)command);
                this.setTaskName(TmmResourceBundle.getString("movie.export"));
                this.publishState(TmmResourceBundle.getString("movie.export"), this.getProgressDone());
                this.activeTask = new ExportTask(TmmResourceBundle.getString("movie.export"), new MovieExporter(Paths.get(template.getPath(), new String[0])), toExport, Paths.get(exportPath, new String[0]));
                this.activeTask.run();
            }
            catch (Exception e) {
                LOGGER.debug("Could not export movies - '{}'", (Object)e.getMessage());
            }
            this.activeTask = null;
        }
    }

    private List<Movie> getMoviesForScope(AbstractCommandHandler.CommandScope scope) {
        ArrayList<Movie> moviesToProcess = new ArrayList<Movie>();
        if (StringUtils.isBlank((CharSequence)scope.name)) {
            scope.name = "new";
        }
        switch (scope.name) {
            case "path": {
                if (scope.args == null || scope.args.length <= 0) break;
                ArrayList<Path> paths = new ArrayList<Path>();
                for (String path : scope.args) {
                    paths.add(Path.of(path, new String[0]).toAbsolutePath());
                }
                moviesToProcess.addAll(this.movieList.getMovies().stream().filter(movie -> paths.contains(movie.getPathNIO().toAbsolutePath())).collect(Collectors.toList()));
                break;
            }
            case "dataSource": {
                if (scope.args == null || scope.args.length <= 0) break;
                ArrayList<String> dataSources = new ArrayList<String>();
                for (String arg : scope.args) {
                    try {
                        dataSources.add(this.movieSettings.getMovieDataSource().get(Integer.parseInt(arg)));
                    }
                    catch (Exception e) {
                        dataSources.add(arg);
                    }
                }
                moviesToProcess.addAll(this.movieList.getMovies().stream().filter(movie -> dataSources.contains(movie.getDataSource())).collect(Collectors.toList()));
                break;
            }
            case "new": {
                moviesToProcess.addAll(this.newMovies);
                break;
            }
            case "unscraped": {
                moviesToProcess.addAll(this.movieList.getUnscrapedMovies());
                break;
            }
            default: {
                moviesToProcess.addAll(this.movieList.getMovies());
            }
        }
        return moviesToProcess;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.activeTask != null) {
            this.activeTask.cancel();
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }
}

