/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class MovieChangeDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieChangeDatasourceTask.class);
    private final String datasource;
    private final List<Movie> moviesToChange = new ArrayList<Movie>();

    public MovieChangeDatasourceTask(List<Movie> moviesToChange, String datasource) {
        super(TmmResourceBundle.getString("movie.changedatasource"));
        this.moviesToChange.addAll(moviesToChange);
        this.datasource = datasource;
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Changing data source for {} movies", (Object)this.moviesToChange.size());
        this.initThreadPool(1, "changeDataSource");
        for (Movie movie : this.moviesToChange) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Finished changing data sources - took {} ms", (Object)this.getRuntime());
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class Worker
    implements Runnable {
        private final Movie movie;

        private Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            if (this.movie.getDataSource().equals(MovieChangeDatasourceTask.this.datasource)) {
                LOGGER.debug("old and new data source is the same");
                return;
            }
            LOGGER.info("Changing data source of movie '{}' to '{}'", (Object)this.movie.getTitle(), (Object)MovieChangeDatasourceTask.this.datasource);
            Path destDir = Paths.get(MovieChangeDatasourceTask.this.datasource, Paths.get(this.movie.getDataSource(), new String[0]).relativize(this.movie.getPathNIO()).toString());
            if (this.movie.isMultiMovieDir()) {
                this.moveMovieFromMMD();
            } else if (Files.exists(destDir, new LinkOption[0]) || destDir.equals(Paths.get(MovieChangeDatasourceTask.this.datasource, new String[0]))) {
                this.movie.setMultiMovieDir(true);
                this.moveMovieFromMMD();
            } else {
                this.moveMovie();
            }
        }

        private void moveMovie() {
            Path srcDir = this.movie.getPathNIO();
            Path destDir = Paths.get(MovieChangeDatasourceTask.this.datasource, Paths.get(this.movie.getDataSource(), new String[0]).relativize(this.movie.getPathNIO()).toString());
            LOGGER.debug("moving movie dir '{}' to '{}", (Object)srcDir, (Object)destDir);
            try {
                boolean ok = Utils.moveDirectorySafe(srcDir, destDir);
                if (ok) {
                    this.movie.setDataSource(MovieChangeDatasourceTask.this.datasource);
                    this.movie.setPath(destDir.toAbsolutePath().toString());
                    this.movie.updateMediaFilePath(srcDir, destDir);
                    this.movie.saveToDb();
                    this.movie.cacheImages();
                    Utils.deleteEmptyDirectoryRecursive(srcDir);
                } else {
                    LOGGER.error("Could not move movie '{}' to destination '{}' - NOT changing datasource", (Object)this.movie.getTitle(), (Object)destDir);
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, srcDir, "message.changedatasource.failedmove"));
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not move movie '{}' to destination '{}' ('{}') - NOT changing datasource", new Object[]{this.movie.getTitle(), destDir, e.getMessage()});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.changedatasource.failedmove", new String[]{":", e.getLocalizedMessage()}));
            }
        }

        private void moveMovieFromMMD() {
            Path srcDir = this.movie.getPathNIO();
            Path destDir = Paths.get(MovieChangeDatasourceTask.this.datasource, Paths.get(this.movie.getDataSource(), new String[0]).relativize(this.movie.getPathNIO()).toString());
            LOGGER.debug("moving multi movie dir '{}' to '{}'", (Object)srcDir, (Object)destDir);
            try {
                if (!Files.exists(destDir, new LinkOption[0])) {
                    Files.createDirectories(destDir, new FileAttribute[0]);
                } else {
                    MediaFile mf = this.movie.getMainFile();
                    Path srcFile = mf.getFileAsPath();
                    Path destFile = destDir.resolve(srcDir.relativize(srcFile));
                    if (Files.exists(destFile, new LinkOption[0])) {
                        LOGGER.error("Video file already exists! '{}' - NOT moving movie", (Object)destDir);
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, srcDir, "message.changedatasource.failedmove"));
                        return;
                    }
                }
                for (MediaFile mf : this.movie.getMediaFiles()) {
                    Path srcFile = mf.getFileAsPath();
                    Path destFile = destDir.resolve(srcDir.relativize(srcFile));
                    Utils.moveFileSafe(srcFile, destFile);
                }
                this.movie.setDataSource(MovieChangeDatasourceTask.this.datasource);
                this.movie.setPath(destDir.toAbsolutePath().toString());
                this.movie.updateMediaFilePath(srcDir, destDir);
                this.movie.saveToDb();
                this.movie.cacheImages();
                Utils.deleteEmptyDirectoryRecursive(srcDir);
            }
            catch (Exception e) {
                LOGGER.error("error moving movie files: ", (Throwable)e);
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.changedatasource.failedmove", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

