/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class MovieReloadMediaInformationTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieReloadMediaInformationTask.class);
    private final List<Movie> moviesToReload;

    public MovieReloadMediaInformationTask(List<Movie> movies) {
        super(TmmResourceBundle.getString("movie.updatemediainfo"));
        this.moviesToReload = new ArrayList<Movie>(movies);
        this.initThreadPool(1, "reloadMI");
    }

    @Override
    protected void doInBackground() {
        try {
            LOGGER.info("Getting MediaInfo for '{}' movies", (Object)this.moviesToReload.size());
            this.start();
            for (final Movie m : this.moviesToReload) {
                if (this.cancel) break;
                for (MediaFile mf : m.getMediaFiles()) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, m, true){

                        @Override
                        public void callbackForGatheredMediainformation() {
                            super.callbackForGatheredMediainformation();
                            m.writeNFO();
                        }
                    });
                }
            }
            this.waitForCompletionOrCancel();
            LOGGER.info("Finished getting MediaInfo - took {} ms", (Object)this.getRuntime());
        }
        catch (Exception e) {
            LOGGER.error("Could not get MediaInfo - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "MediaInfo", "message.mediainfo.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }
}

