/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.tinymediamanager.core.threading.NullTask;
import org.tinymediamanager.core.threading.NullThreadPool;
import org.tinymediamanager.core.threading.ThreadUtils;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;

public class NullTasksMenu {
    public static JMenu createTaskManagerTestMenu() {
        JMenu menu = new JMenu("Tasks Debug");
        menu.setIcon(IconManager.FEEDBACK);
        JMenuItem i = new JMenuItem("ThreadPool with 1T 100WU");
        i.addActionListener(new AddTask(i.getText(), 1, 100, 500, "pool"));
        menu.add(i);
        i = new JMenuItem("ThreadPool with 5T 100WU");
        i.addActionListener(new AddTask(i.getText(), 5, 100, 500, "pool"));
        menu.add(i);
        menu.addSeparator();
        i = new JMenuItem("1 Main Task \u00e1 10WU");
        i.addActionListener(new AddTask(i.getText(), 1, 10, 1000, "main"));
        menu.add(i);
        i = new JMenuItem("1 Download Task \u00e1 10WU");
        i.addActionListener(new AddTask(i.getText(), 1, 10, 1000, "dl"));
        menu.add(i);
        i = new JMenuItem("1 ImageCache Task \u00e1 10WU");
        i.addActionListener(new AddTask(i.getText(), 1, 10, 1000, "img"));
        menu.add(i);
        i = new JMenuItem("1 Unknown Task \u00e1 10WU");
        i.addActionListener(new AddTask(i.getText(), 1, 10, 1000, "anon"));
        menu.add(i);
        menu.addSeparator();
        i = new JMenuItem("10 Main Tasks \u00e1 1WU");
        i.addActionListener(new AddTask(i.getText(), 10, 1, 2000, "main"));
        menu.add(i);
        i = new JMenuItem("10 Download Tasks \u00e1 1WU");
        i.addActionListener(new AddTask(i.getText(), 10, 1, 10000, "dl"));
        menu.add(i);
        i = new JMenuItem("10 ImageCache Tasks \u00e1 1WU");
        i.addActionListener(new AddTask(i.getText(), 10, 1, 2000, "img"));
        menu.add(i);
        i = new JMenuItem("10 Unknown Tasks \u00e1 1WU");
        i.addActionListener(new AddTask(i.getText(), 10, 1, 5000, "anon"));
        menu.add(i);
        return menu;
    }

    private static class AddTask
    implements ActionListener {
        private final int sleep;
        private final int amount;
        private final int workunits;
        private final String type;
        private final String name;

        public AddTask(String name, int amount, int workunits, int sleepForEachWU, String type) {
            this.name = name;
            this.amount = amount;
            this.workunits = workunits;
            this.type = type;
            this.sleep = sleepForEachWU;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.type.equals("pool")) {
                long rnd = Math.round(Math.random() * 100.0 + 1.0);
                TmmTaskManager.getInstance().addMainTask(new NullThreadPool(this.name + "-" + rnd, this.amount, this.workunits, this.sleep));
            } else {
                for (int i = 0; i < this.amount; ++i) {
                    switch (this.type) {
                        case "main": {
                            TmmTaskManager.getInstance().addUnnamedTask(new NullTask(this.name + "-" + i, this.workunits, this.sleep, TmmTaskHandle.TaskType.MAIN_TASK));
                            break;
                        }
                        case "dl": {
                            TmmTaskManager.getInstance().addDownloadTask(new NullTask(this.name + "-" + i, this.workunits, this.sleep, TmmTaskHandle.TaskType.BACKGROUND_TASK));
                            break;
                        }
                        case "img": {
                            TmmTaskManager.getInstance().addImageCacheTask(new NullTask(this.name + "-" + i, this.workunits, this.sleep, TmmTaskHandle.TaskType.BACKGROUND_TASK));
                            break;
                        }
                        case "anon": {
                            TmmTaskManager.getInstance().addUnnamedTask(new NullTask(this.name + "-" + i, this.workunits, this.sleep, TmmTaskHandle.TaskType.BACKGROUND_TASK));
                            break;
                        }
                    }
                    ThreadUtils.sleep(100L);
                }
            }
        }
    }
}

