/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.extended.ChainedNamedRenderer;
import com.floreysoft.jmte.message.DefaultErrorHandler;
import com.floreysoft.jmte.message.ErrorMessage;
import com.floreysoft.jmte.message.ParseException;
import com.floreysoft.jmte.message.ResourceBundleMessage;
import com.floreysoft.jmte.template.OutputAppender;
import com.floreysoft.jmte.token.Token;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaEntityFilenameHistory;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedArrayUniqueRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedFramerateRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedSplitRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.PathRenderer;
import org.tinymediamanager.core.jmte.RegexpProcessor;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.TmmOutputAppender;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.threading.ThreadUtils;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamer.class);
    private static final Map<String, String> TOKEN_MAP = TvShowRenamer.createTokenMap();
    private static final String[] seasonNumbers = new String[]{"seasonNr", "seasonNr2", "seasonNrDvd", "seasonNrDvd2", "episode.season", "episode.dvdSeason"};
    private static final String[] episodeNumbers = new String[]{"episodeNr", "episodeNr2", "episodeNrDvd", "episodeNrDvd2", "episode.episode", "episode.dvdEpisode", "absoluteNr", "absoluteNr2", "episode.absoluteNumber"};
    private static final String[] episodeTitles = new String[]{"title", "originalTitle", "englishTitle", "titleSortable", "episode.title", "episode.originalTitle", "episode.titleSortable", "episode.englishTitle"};
    private static final String[] episodeAired = new String[]{"airedDate", "episode.firstAired"};
    private static final Pattern epDelimiter = Pattern.compile("(\\s?(folge|episode|[epx]+)\\s?)\\$\\{.*?\\}", 2);
    private static final Pattern seDelimiter = Pattern.compile("((staffel|season|s)\\s?)\\$\\{.*?\\}", 2);
    private static final List<String> DISC_FOLDERS = Arrays.asList("bdmv", "video_ts", "hvdvd_ts");
    private static final Pattern MF_STACKING_PATTERN = Pattern.compile(".*?([\\s._-]\\d)$");

    private TvShowRenamer() {
        throw new IllegalAccessError();
    }

    private static Map<String, String> createTokenMap() {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("showTitle", "tvShow.title");
        tokenMap.put("showOriginalTitle", "tvShow.originalTitle");
        tokenMap.put("showEnglishTitle", "tvShow.englishTitle");
        tokenMap.put("showTitleSortable", "tvShow.titleSortable");
        tokenMap.put("showYear", "tvShow.year");
        tokenMap.put("parent", "tvShow.parent");
        tokenMap.put("showNote", "tvShow.note");
        tokenMap.put("showStatus", "tvShow.status");
        tokenMap.put("showRating", "tvShow.rating.rating");
        tokenMap.put("showImdb", "tvShow.imdbId");
        tokenMap.put("showTmdb", "tvShow.tmdbId");
        tokenMap.put("showTvdb", "tvShow.tvdbId");
        tokenMap.put("showCertification", "tvShow.certification");
        tokenMap.put("showTags", "tvShow.tags");
        tokenMap.put("showGenres", "tvShow.genres");
        tokenMap.put("showGenresAsString", "tvShow.genresAsString");
        tokenMap.put("showProductionCompany", "tvShow.productionCompany");
        tokenMap.put("showProductionCompanyAsArray", "tvShow.productionCompanyAsArray");
        tokenMap.put("seasonName", "season.title");
        tokenMap.put("episodeNr", "episode.episode");
        tokenMap.put("episodeNr2", "episode.episode;number(%02d)");
        tokenMap.put("episodeNrAired", "episode.airedEpisode");
        tokenMap.put("episodeNrAired2", "episode.airedEpisode;number(%02d)");
        tokenMap.put("episodeNrDvd", "episode.dvdEpisode");
        tokenMap.put("episodeNrDvd2", "episode.dvdEpisode;number(%02d)");
        tokenMap.put("seasonNr", "episode.season;number(%d)");
        tokenMap.put("seasonNr2", "episode.season;number(%02d)");
        tokenMap.put("seasonNrAired", "episode.airedSeason;number(%d)");
        tokenMap.put("seasonNrAired2", "episode.airedSeason;number(%02d)");
        tokenMap.put("seasonNrDvd", "episode.dvdSeason;number(%d)");
        tokenMap.put("seasonNrDvd2", "episode.dvdSeason;number(%02d)");
        tokenMap.put("absoluteNr", "episode.absoluteNumber;number(%d)");
        tokenMap.put("absoluteNr2", "episode.absoluteNumber;number(%02d)");
        tokenMap.put("title", "episode.title");
        tokenMap.put("originalTitle", "episode.originalTitle");
        tokenMap.put("englishTitle", "episode.englishTitle");
        tokenMap.put("originalFilename", "episode.originalFilename");
        tokenMap.put("originalBasename", "episode.originalBasename");
        tokenMap.put("titleSortable", "episode.titleSortable");
        tokenMap.put("year", "episode.year");
        tokenMap.put("airedDate", "episode.firstAired;date(yyyy-MM-dd)");
        tokenMap.put("episodeRating", "episode.rating.rating");
        tokenMap.put("episodeImdb", "episode.imdbId");
        tokenMap.put("episodeTmdb", "episode.tmdbId");
        tokenMap.put("episodeTvdb", "episode.tvdbId");
        tokenMap.put("episodeTags", "episode.tags");
        tokenMap.put("videoCodec", "episode.mediaInfoVideoCodec");
        tokenMap.put("videoFormat", "episode.mediaInfoVideoFormat");
        tokenMap.put("videoResolution", "episode.mediaInfoVideoResolution");
        tokenMap.put("aspectRatio", "episode.mediaInfoAspectRatioAsString");
        tokenMap.put("aspectRatio2", "episode.mediaInfoAspectRatio2AsString");
        tokenMap.put("videoBitDepth", "episode.mediaInfoVideoBitDepth");
        tokenMap.put("videoBitRate", "episode.mediaInfoVideoBitrate;bitrate");
        tokenMap.put("framerate", "episode.mediaInfoFrameRate;framerate");
        tokenMap.put("audioCodec", "episode.mediaInfoAudioCodec");
        tokenMap.put("audioCodecList", "episode.mediaInfoAudioCodecList");
        tokenMap.put("audioCodecsAsString", "episode.mediaInfoAudioCodecList;array");
        tokenMap.put("audioChannels", "episode.mediaInfoAudioChannels");
        tokenMap.put("audioChannelList", "episode.mediaInfoAudioChannelList");
        tokenMap.put("audioChannelsAsString", "episode.mediaInfoAudioChannelList;array");
        tokenMap.put("audioChannelsDot", "episode.mediaInfoAudioChannelsDot");
        tokenMap.put("audioChannelDotList", "episode.mediaInfoAudioChannelDotList");
        tokenMap.put("audioChannelsDotAsString", "episode.mediaInfoAudioChannelDotList;array");
        tokenMap.put("audioLanguage", "episode.mediaInfoAudioLanguage");
        tokenMap.put("audioLanguageList", "episode.mediaInfoAudioLanguageList");
        tokenMap.put("audioLanguagesAsString", "episode.mediaInfoAudioLanguageList;array");
        tokenMap.put("subtitleLanguageList", "episode.mediaInfoSubtitleLanguageList");
        tokenMap.put("subtitleLanguagesAsString", "episode.mediaInfoSubtitleLanguageList;array");
        tokenMap.put("3Dformat", "episode.video3DFormat");
        tokenMap.put("hdr", "episode.videoHDR");
        tokenMap.put("hdrformat", "episode.videoHDRFormat");
        tokenMap.put("filesize", "episode.videoFilesize;filesize");
        tokenMap.put("mediaSource", "episode.mediaSource");
        tokenMap.put("note", "episode.note");
        tokenMap.put("crc32", "episode.CRC32");
        return tokenMap;
    }

    public static Map<String, String> getTokenMap() {
        return Collections.unmodifiableMap(TOKEN_MAP);
    }

    public static Map<String, String> getTokenMapReversed() {
        return Collections.unmodifiableMap(TOKEN_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
    }

    private static String lz(int num) {
        return String.format("%02d", num);
    }

    public static void renameTvShow(TvShow tvShow) {
        MediaEntityFilenameHistory filenameHistory = new MediaEntityFilenameHistory();
        TvShowRenamer.renameTvShowRoot(tvShow, filenameHistory);
        TvShowRenamer.renameTvShowMediaFiles(tvShow, filenameHistory);
        tvShow.setRenameHistory(filenameHistory);
        TvShowRenamer.renameSeasonMediaFiles(tvShow);
        TvShowRenamer.cleanupUnwantedFiles(tvShow);
        tvShow.saveToDb();
    }

    private static void renameTvShowRoot(TvShow show, MediaEntityFilenameHistory filenameHistory) {
        if (TvShowModuleManager.getInstance().getSettings().getRenamerFilename().isEmpty() && TvShowModuleManager.getInstance().getSettings().getRenamerSeasonFoldername().isEmpty() && TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername().isEmpty()) {
            LOGGER.warn("NOT renaming TV show '{}' - renaming patterns are empty!", (Object)show.getTitle());
            return;
        }
        LOGGER.info("Renaming TV show '{}'", (Object)show.getTitle());
        LOGGER.debug("TV show year: {}", (Object)show.getYear());
        LOGGER.debug("TV show path: {}", (Object)show.getPathNIO());
        String newPathname = TvShowRenamer.getTvShowFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername(), show);
        String oldPathname = show.getPathNIO().toString();
        filenameHistory.setOldPath(oldPathname);
        if (!newPathname.isEmpty()) {
            Path srcDir = Paths.get(oldPathname, new String[0]);
            Path destDir = Paths.get(newPathname, new String[0]);
            if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
                try {
                    boolean ok;
                    if (!Files.exists(destDir.getParent(), new LinkOption[0])) {
                        Files.createDirectory(destDir.getParent(), new FileAttribute[0]);
                    }
                    if (ok = Utils.moveDirectorySafe(srcDir, destDir)) {
                        show.updateMediaFilePath(srcDir, destDir);
                        show.setPath(newPathname);
                        filenameHistory.setNewPath(newPathname);
                        for (TvShowSeason tvShowSeason : show.getSeasons()) {
                            tvShowSeason.updateMediaFilePath(srcDir, destDir);
                        }
                        for (TvShowEpisode episode : show.getEpisodes()) {
                            episode.replacePathForRenamedTvShowRoot(srcDir, destDir);
                            episode.updateMediaFilePath(srcDir, destDir);
                            episode.saveToDb();
                        }
                        if (Settings.getInstance().isImageCache()) {
                            for (MediaFile gfx : show.getMediaFiles()) {
                                ImageCache.cacheImageSilently(gfx, false);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error moving folder '{}' to '{}' - '{}'", new Object[]{srcDir, destDir, e.getMessage()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)filenameHistory.getNewPath())) {
            filenameHistory.setNewPath(filenameHistory.getOldPath());
        }
    }

    private static void renameTvShowMediaFiles(TvShow tvShow, MediaEntityFilenameHistory filenameHistory) {
        Object newMFs;
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>(tvShow.getMediaFiles());
        cleanup.removeAll(Collections.singleton(null));
        MediaFile nfo = MediaFile.EMPTY_MEDIAFILE;
        for (MediaFile mf : tvShow.getMediaFiles(MediaFileType.NFO)) {
            if (mf.getFiledate() < nfo.getFiledate()) continue;
            nfo = new MediaFile(mf);
        }
        Path newTvShowPath = tvShow.getPathNIO();
        if (nfo != MediaFile.EMPTY_MEDIAFILE) {
            newMFs = TvShowRenamer.generateFilename(tvShow, nfo);
            Iterator<MediaFile> iterator = newMFs.iterator();
            while (iterator.hasNext()) {
                MediaFile newMF = iterator.next();
                boolean ok = TvShowRenamer.copyFile(nfo.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(newTvShowPath, nfo.getFileAsPath(), newMF.getFileAsPath()));
                    needed.add(newMF);
                    continue;
                }
                filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(newTvShowPath, nfo.getFileAsPath(), nfo.getFileAsPath()));
                needed.add(nfo);
            }
        } else {
            LOGGER.trace("No valid NFO found for this TV show");
        }
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (mf == null) continue;
            LOGGER.trace("Rename 1:N {} {}", (Object)mf.getType(), (Object)mf.getFileAsPath());
            List<MediaFile> newMFs2 = TvShowRenamer.generateFilename(tvShow, mf);
            for (MediaFile newMF : newMFs2) {
                boolean ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(newTvShowPath, mf.getFileAsPath(), newMF.getFileAsPath()));
                    needed.add(newMF);
                    continue;
                }
                filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(newTvShowPath, mf.getFileAsPath(), mf.getFileAsPath()));
                needed.add(mf);
            }
        }
        for (MediaFile gfx : tvShow.getMediaFiles()) {
            ImageCache.invalidateCachedImage(gfx);
        }
        newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll((Collection<MediaFile>)newMFs);
        LOGGER.debug("Cleanup...");
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            if (needed.contains(cleanup.get(i))) continue;
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (Files.exists(cl.getFileAsPath(), new LinkOption[0])) {
                LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                Utils.deleteFileWithBackup(cl.getFileAsPath(), tvShow.getDataSource());
                if (cl.isGraphic()) {
                    ImageCache.invalidateCachedImage(cl);
                }
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Error in cleanup of '{}' - '{}'", (Object)cl.getFileAsPath(), (Object)e.getMessage());
            }
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(tvShow.getPathNIO());
        }
        catch (Exception e) {
            LOGGER.warn("cCould not delete empty subfolders of '{}' - '{}'", (Object)tvShow.getPathNIO(), (Object)e.getMessage());
        }
        tvShow.removeAllMediaFiles();
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : needed) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        ThreadUtils.sleep(250L);
        tvShow.addToMediaFiles(needed);
    }

    private static MediaEntityFilenameHistory.FilenameHistory createFilenameHistory(Path tvShowRoot, Path oldFilePath, Path newFilePath) {
        String oldFilename = tvShowRoot.relativize(oldFilePath).toString();
        String newFilename = tvShowRoot.relativize(newFilePath).toString();
        return new MediaEntityFilenameHistory.FilenameHistory(oldFilename, newFilename);
    }

    private static MediaEntityFilenameHistory.FilenameHistory findFilenameHistoryForMediaFile(MediaEntity entity, MediaFile mediaFile) {
        Path tvShowRoot;
        if (entity.getRenameHistory() == null) {
            return null;
        }
        if (entity instanceof TvShow) {
            TvShow tvShow = (TvShow)entity;
            tvShowRoot = tvShow.getPathNIO();
        } else if (entity instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)entity;
            tvShowRoot = season.getTvShow().getPathNIO();
        } else if (entity instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)entity;
            tvShowRoot = episode.getTvShow().getPathNIO();
        } else {
            return null;
        }
        for (MediaEntityFilenameHistory.FilenameHistory filenameHistory : entity.getRenameHistory().getFilenameHistory()) {
            if (!filenameHistory.newFilename().equals(tvShowRoot.relativize(mediaFile.getFileAsPath()).toString())) continue;
            return filenameHistory;
        }
        return null;
    }

    public static List<MediaFile> generateFilename(TvShow tvShow, MediaFile original) {
        ArrayList<MediaFile> neededMediaFiles = new ArrayList<MediaFile>();
        List<Enum> filenamings = null;
        switch (original.getType()) {
            case POSTER: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getPosterFilenames();
                break;
            }
            case FANART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getFanartFilenames();
                break;
            }
            case BANNER: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getBannerFilenames();
                break;
            }
            case CLEARLOGO: 
            case LOGO: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames();
                break;
            }
            case CLEARART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getClearartFilenames();
                break;
            }
            case THUMB: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getThumbFilenames();
                break;
            }
            case DISC: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getDiscartFilenames();
                break;
            }
            case CHARACTERART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames();
                break;
            }
            case KEYART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getKeyartFilenames();
                break;
            }
            case TRAILER: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getTrailerFilenames();
                break;
            }
            case NFO: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getNfoFilenames();
                break;
            }
            case EXTRAFANART: {
                neededMediaFiles.addAll(TvShowRenamer.generateExtrafanartFilename(tvShow, original));
                break;
            }
            default: {
                neededMediaFiles.add(original);
            }
        }
        if (filenamings != null) {
            for (IFileNaming iFileNaming : filenamings) {
                String stackingMarker;
                String extension = TvShowRenamer.getMediaFileExtension(original);
                Object newFilename = iFileNaming.getFilename(tvShow.getFoldername(), extension);
                if (!StringUtils.isNotBlank((CharSequence)newFilename)) continue;
                Matcher matcher = MF_STACKING_PATTERN.matcher(original.getBasename());
                if (matcher.matches() && StringUtils.isNotBlank((CharSequence)(stackingMarker = matcher.group(1)))) {
                    newFilename = FilenameUtils.getBaseName((String)newFilename) + stackingMarker + "." + extension;
                }
                MediaFile newMediaFile = new MediaFile(original);
                newMediaFile.setFile(tvShow.getPathNIO().resolve((String)newFilename));
                neededMediaFiles.add(newMediaFile);
            }
        }
        return neededMediaFiles;
    }

    private static List<MediaFile> generateExtrafanartFilename(TvShow tvShow, MediaFile original) {
        TvShowExtraFanartNaming name;
        Object newFilename;
        if (TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
            return Collections.emptyList();
        }
        int index = TvShowArtworkHelper.getIndexOfArtwork(original.getFilename());
        if (index > 0 && StringUtils.isNotBlank((CharSequence)(newFilename = (name = TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().get(0)).getFilename("", TvShowRenamer.getMediaFileExtension(original))))) {
            String basename = FilenameUtils.getBaseName((String)newFilename);
            newFilename = basename + index + "." + TvShowRenamer.getMediaFileExtension(original);
            Path folder = name == TvShowExtraFanartNaming.FOLDER_EXTRAFANART ? tvShow.getPathNIO().resolve("extrafanart") : tvShow.getPathNIO();
            MediaFile newMediaFile = new MediaFile(original);
            newMediaFile.setFile(folder.resolve((String)newFilename));
            return Collections.singletonList(newMediaFile);
        }
        return Collections.emptyList();
    }

    private static void renameSeasonMediaFiles(TvShow tvShow) {
        HashMap<TvShowSeason, MediaEntityFilenameHistory> filenameHistoryMap = new HashMap<TvShowSeason, MediaEntityFilenameHistory>();
        LinkedHashSet needed = new LinkedHashSet();
        ArrayList cleanup = new ArrayList();
        Path tvShowRoot = tvShow.getPathNIO();
        for (TvShowSeason tvShowSeason : tvShow.getSeasons()) {
            MediaEntityFilenameHistory filenameHistory = new MediaEntityFilenameHistory();
            filenameHistoryMap.put(tvShowSeason, filenameHistory);
            LinkedHashSet neededSeason = new LinkedHashSet();
            ArrayList<MediaFile> arrayList = new ArrayList<MediaFile>();
            MediaFile nfo = MediaFile.EMPTY_MEDIAFILE;
            for (MediaFile mf : tvShowSeason.getMediaFiles(MediaFileType.NFO)) {
                arrayList.add(mf);
                if (mf.getFiledate() < nfo.getFiledate()) continue;
                nfo = new MediaFile(mf);
            }
            if (nfo != MediaFile.EMPTY_MEDIAFILE && (!tvShowSeason.getEpisodes().isEmpty() || TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems())) {
                for (TvShowSeasonNfoNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonNfoFilenames()) {
                    String filename = naming.getFilename(tvShowSeason, "nfo");
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMf = new MediaFile(nfo);
                    newMf.setFile(Paths.get(tvShow.getPath(), filename));
                    boolean ok = TvShowRenamer.copyFile(nfo.getFileAsPath(), newMf.getFileAsPath());
                    if (!ok) continue;
                    filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, nfo.getFileAsPath(), newMf.getFileAsPath()));
                    neededSeason.add(newMf);
                }
            }
            arrayList.forEach(tvShowSeason::removeFromMediaFiles);
            neededSeason.forEach(tvShowSeason::addToMediaFiles);
            needed.addAll(neededSeason);
            cleanup.addAll(arrayList);
        }
        List<MediaFileType> types = Arrays.asList(MediaFileType.SEASON_POSTER, MediaFileType.SEASON_FANART, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB);
        for (MediaFileType type : types) {
            for (TvShowSeason tvShowSeason : tvShow.getSeasons()) {
                MediaEntityFilenameHistory filenameHistory = (MediaEntityFilenameHistory)filenameHistoryMap.get(tvShowSeason);
                LinkedHashSet neededSeason = new LinkedHashSet();
                ArrayList<MediaFile> cleanupSeason = new ArrayList<MediaFile>();
                MediaFile artworkFile = null;
                for (MediaFile mf : tvShowSeason.getMediaFiles(type)) {
                    cleanupSeason.add(mf);
                    if (artworkFile != null) continue;
                    artworkFile = mf;
                }
                if (artworkFile != null && (!tvShowSeason.getEpisodes().isEmpty() || TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems())) {
                    switch (type) {
                        case SEASON_POSTER: {
                            boolean ok;
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonPosterNaming tvShowSeasonPosterNaming : TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames()) {
                                filename = tvShowSeasonPosterNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(tvShow.getPath(), filename));
                                ok = TvShowRenamer.copyFile(artworkFile.getFileAsPath(), newMf.getFileAsPath());
                                if (!ok) continue;
                                filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, artworkFile.getFileAsPath(), newMf.getFileAsPath()));
                                neededSeason.add(newMf);
                            }
                            break;
                        }
                        case SEASON_FANART: {
                            boolean ok;
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonFanartNaming tvShowSeasonFanartNaming : TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames()) {
                                filename = tvShowSeasonFanartNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(tvShow.getPath(), filename));
                                ok = TvShowRenamer.copyFile(artworkFile.getFileAsPath(), newMf.getFileAsPath());
                                if (!ok) continue;
                                filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, artworkFile.getFileAsPath(), newMf.getFileAsPath()));
                                neededSeason.add(newMf);
                            }
                            break;
                        }
                        case SEASON_BANNER: {
                            boolean ok;
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonBannerNaming tvShowSeasonBannerNaming : TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames()) {
                                filename = tvShowSeasonBannerNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(tvShow.getPath(), filename));
                                ok = TvShowRenamer.copyFile(artworkFile.getFileAsPath(), newMf.getFileAsPath());
                                if (!ok) continue;
                                filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, artworkFile.getFileAsPath(), newMf.getFileAsPath()));
                                neededSeason.add(newMf);
                            }
                            break;
                        }
                        case SEASON_THUMB: {
                            boolean ok;
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonThumbNaming tvShowSeasonThumbNaming : TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames()) {
                                filename = tvShowSeasonThumbNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(tvShow.getPath(), filename));
                                ok = TvShowRenamer.copyFile(artworkFile.getFileAsPath(), newMf.getFileAsPath());
                                if (!ok) continue;
                                filenameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, artworkFile.getFileAsPath(), newMf.getFileAsPath()));
                                neededSeason.add(newMf);
                            }
                            break;
                        }
                    }
                }
                cleanupSeason.forEach(tvShowSeason::removeFromMediaFiles);
                neededSeason.forEach(tvShowSeason::addToMediaFiles);
                cleanup.addAll(cleanupSeason);
                needed.addAll(neededSeason);
            }
        }
        for (MediaFile gfx : tvShow.getMediaFiles()) {
            ImageCache.invalidateCachedImage(gfx);
        }
        LOGGER.debug("Cleanup...");
        List<Path> list = Utils.listFilesRecursive(tvShow.getPathNIO());
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            if (needed.contains(cleanup.get(i))) continue;
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (list.contains(cl.getFileAsPath())) {
                LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                tvShow.removeFromMediaFiles(cl);
                for (TvShowSeason season : tvShow.getSeasons()) {
                    season.removeFromMediaFiles(cl);
                }
                Utils.deleteFileWithBackup(cl.getFileAsPath(), tvShow.getDataSource());
                if (cl.isGraphic()) {
                    ImageCache.invalidateCachedImage(cl);
                }
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException iOException) {
                LOGGER.error("Error in cleanup of '{}' - '{}'", (Object)cl.getFileAsPath(), (Object)iOException.getMessage());
            }
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(tvShow.getPathNIO());
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete empty subfolders of '{}' - '{}'", (Object)tvShow.getPathNIO(), (Object)e.getMessage());
        }
        for (MediaFile mf : needed) {
            String string = tvShow.getPathNIO().relativize(mf.getFileAsPath().getParent()).toString();
            int season = TvShowHelpers.detectSeasonFromFileAndFolder(mf.getFilename(), string);
            tvShow.removeFromMediaFiles(mf);
            for (TvShowSeason tvShowSeason : tvShow.getSeasons()) {
                tvShowSeason.removeFromMediaFiles(mf);
            }
            if (season == Integer.MIN_VALUE) continue;
            TvShowSeason tvShowSeason = tvShow.getSeason(season);
            tvShowSeason.addToMediaFiles(mf);
        }
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : tvShow.getMediaFiles()) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        for (TvShowSeason tvShowSeason : tvShow.getSeasons()) {
            MediaEntityFilenameHistory mediaEntityFilenameHistory = (MediaEntityFilenameHistory)filenameHistoryMap.get(tvShowSeason);
            if (ListUtils.isNotEmpty(mediaEntityFilenameHistory.getFilenameHistory())) {
                tvShowSeason.setRenameHistory(mediaEntityFilenameHistory);
                continue;
            }
            tvShowSeason.setRenameHistory(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void renameEpisode(TvShowEpisode episode) {
        boolean bl;
        void var13_32;
        void var11_15;
        if (TvShowModuleManager.getInstance().getSettings().getRenamerFilename().isEmpty() && TvShowModuleManager.getInstance().getSettings().getRenamerSeasonFoldername().isEmpty() && TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername().isEmpty()) {
            LOGGER.warn("NOT renaming TV show '{}', episode S{} E{} - renaming patterns are empty!", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode()});
            return;
        }
        MediaFile originalVideoMediaFile = new MediaFile(episode.getMainVideoFile());
        if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
            LOGGER.warn("Can not rename episode '{}' (TV show '{}') - invalid season/episode number (S{} E{})", new Object[]{episode.getTitle(), episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode()});
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode.getTvShow().getTitle(), "tvshow.renamer.failedrename", new String[]{episode.getTitle()}));
            return;
        }
        LOGGER.info("Renaming TvShow '{}', episode S{} E{}", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode()});
        if (episode.isDisc()) {
            TvShowRenamer.renameEpisodeAsDisc(episode);
            return;
        }
        List<TvShowEpisode> episodes = TvShowList.getTvEpisodesByFile(episode.getTvShow(), originalVideoMediaFile.getFile());
        episode.reEvaluateStacking();
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>(episode.getMediaFiles());
        cleanup.removeAll(Collections.singleton(null));
        Path tvShowRoot = episode.getTvShow().getPathNIO();
        MediaEntityFilenameHistory fileNameHistory = new MediaEntityFilenameHistory();
        String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
        Path seasonFolder = episode.getTvShow().getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonFoldername) && !Files.exists(seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername), new LinkOption[0])) {
            try {
                Files.createDirectory(seasonFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String oldVideoBasename = episode.getVideoBasenameWithoutStacking();
        for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO)) {
            LOGGER.trace("Rename 1:1 {} {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            List<MediaFile> newFilenames = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile, "");
            if (ListUtils.isEmpty(newFilenames)) {
                LOGGER.warn("Could not rename '{}' - no new filename generated!", (Object)mediaFile.getFileAsPath());
                return;
            }
            MediaFile mediaFile2 = newFilenames.get(0);
            boolean ok = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), mediaFile2.getFileAsPath());
            if (!ok) {
                return;
            }
            fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, mediaFile.getFileAsPath(), mediaFile2.getFileAsPath()));
            mediaFile.setFile(mediaFile2.getFileAsPath());
            episode.setPath(mediaFile2.getPath());
            needed.add(mediaFile);
        }
        ArrayList<Object> mfs = new ArrayList<MediaFile>();
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.FANART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.POSTER));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.BANNER));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CLEARART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.THUMB));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.LOGO));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CLEARLOGO));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.DISC));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CHARACTERART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.KEYART));
        mfs.removeAll(Collections.singleton(null));
        for (Object mf : mfs) {
            LOGGER.trace("Rename 1:N {} {}", (Object)((MediaFile)mf).getType(), (Object)((MediaFile)mf).getFileAsPath());
            List<MediaFile> list = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), (MediaFile)mf, oldVideoBasename);
            for (MediaFile newMF : list) {
                boolean ok = TvShowRenamer.copyFile(((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath());
                if (!ok) continue;
                fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, ((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath()));
                needed.add(newMF);
                if (!ImageCache.isImageCached(((MediaFile)mf).getFileAsPath())) continue;
                Path oldCache = ImageCache.getAbsolutePath((MediaFile)mf);
                Path newCache = ImageCache.getAbsolutePath(newMF);
                LOGGER.trace("updating imageCache {} -> {}", (Object)oldCache, (Object)newCache);
                try {
                    Files.copy(oldCache, newCache, new CopyOption[0]);
                }
                catch (IOException e) {
                    LOGGER.warn("Error moving cached file '{}' - '{}'", (Object)oldCache, (Object)e.getMessage());
                }
            }
        }
        MediaFile mediaFile = MediaFile.EMPTY_MEDIAFILE;
        for (MediaFile mediaFile3 : episode.getMediaFiles(MediaFileType.NFO)) {
            if (mediaFile3.getFiledate() < var11_15.getFiledate()) continue;
            MediaFile mediaFile4 = new MediaFile(mediaFile3);
        }
        if (var11_15 != MediaFile.EMPTY_MEDIAFILE) {
            List<MediaFile> newNFOs = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), (MediaFile)var11_15, oldVideoBasename);
            if (!newNFOs.isEmpty()) {
                Iterator<MediaFile> iterator = newNFOs.iterator();
                while (iterator.hasNext()) {
                    MediaFile newNFO = iterator.next();
                    boolean ok = TvShowRenamer.copyFile(var11_15.getFileAsPath(), newNFO.getFileAsPath());
                    if (!ok) continue;
                    fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, var11_15.getFileAsPath(), newNFO.getFileAsPath()));
                    needed.add(newNFO);
                }
            } else {
                cleanup.add((MediaFile)var11_15);
            }
        } else {
            LOGGER.trace("No valid NFO found for this episode");
        }
        for (MediaFile mediaFile5 : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
            LOGGER.trace("Rename 1:1 {} {}", (Object)mediaFile5.getType(), (Object)mediaFile5.getFileAsPath());
            MediaFile newMF = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile5, oldVideoBasename).get(0);
            boolean ok = TvShowRenamer.moveFile(mediaFile5.getFileAsPath(), newMF.getFileAsPath());
            if (ok) {
                if (newMF.getFilename().endsWith(".sub")) {
                    try {
                        Path oldidx = mediaFile5.getFileAsPath().resolveSibling(mediaFile5.getFilename().replaceFirst("sub$", "idx"));
                        Path newidx = newMF.getFileAsPath().resolveSibling(newMF.getFilename().replaceFirst("sub$", "idx"));
                        Utils.moveFileSafe(oldidx, newidx);
                        MediaFile idx = new MediaFile(newidx);
                        needed.add(idx);
                        fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, oldidx, newidx));
                    }
                    catch (Exception oldidx) {
                        // empty catch block
                    }
                }
                needed.add(newMF);
                fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, mediaFile5.getFileAsPath(), newMF.getFileAsPath()));
                continue;
            }
            LOGGER.error("Could not rename subtitle file '{}'", (Object)mediaFile5.getFileAsPath());
            needed.add(mediaFile5);
        }
        mfs = new ArrayList<MediaFile>(episode.getMediaFilesExceptType(MediaFileType.VIDEO, MediaFileType.NFO, MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.DISC, MediaFileType.CHARACTERART, MediaFileType.KEYART, MediaFileType.SUBTITLE));
        mfs.removeAll(Collections.singleton(null));
        for (MediaFile mediaFile6 : mfs) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile6.getType(), (Object)mediaFile6.getFileAsPath());
            if ("idx".equalsIgnoreCase(mediaFile6.getExtension())) continue;
            List<MediaFile> newMFs = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile6, oldVideoBasename);
            newMFs.removeAll(Collections.singleton(null));
            for (MediaFile newMF : newMFs) {
                boolean ok = TvShowRenamer.copyFile(mediaFile6.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, mediaFile6.getFileAsPath(), newMF.getFileAsPath()));
                    needed.add(newMF);
                    continue;
                }
                fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(tvShowRoot, mediaFile6.getFileAsPath(), mediaFile6.getFileAsPath()));
                needed.add(mediaFile6);
            }
        }
        for (MediaFile mediaFile7 : episode.getMediaFiles()) {
            ImageCache.invalidateCachedImage(mediaFile7);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        LOGGER.debug("Cleanup...");
        int n = cleanup.size() - 1;
        while (var13_32 >= 0) {
            if (!needed.contains(cleanup.get((int)var13_32))) {
                MediaFile cl = (MediaFile)cleanup.get((int)var13_32);
                if (Files.exists(cl.getFileAsPath(), new LinkOption[0])) {
                    LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                    Utils.deleteFileWithBackup(cl.getFileAsPath(), episode.getTvShow().getDataSource());
                }
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                    if (!directoryStream.iterator().hasNext()) {
                        LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                        Files.delete(cl.getFileAsPath().getParent());
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error in cleanup of '{}' - '{}'", (Object)cl.getFileAsPath(), (Object)e.getMessage());
                }
            }
            --var13_32;
        }
        boolean bl2 = false;
        for (MediaEntityFilenameHistory.FilenameHistory history : fileNameHistory.getFilenameHistory()) {
            if (history.oldFilename().equals(history.newFilename())) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (TvShowEpisode e : episodes) {
                e.removeAllMediaFiles();
                e.addToMediaFiles(needed);
                e.setPath(episode.getPath());
                e.gatherMediaFileInformation(false);
                e.setRenameHistory(fileNameHistory);
                e.saveToDb();
                if (!Settings.getInstance().isImageCache()) continue;
                for (MediaFile gfx : e.getMediaFiles()) {
                    ImageCache.cacheImageSilently(gfx, false);
                }
            }
        }
    }

    private static void renameEpisodeAsDisc(TvShowEpisode episode) {
        block16: {
            String newFoldername;
            Path epFolder;
            Path disc;
            MediaEntityFilenameHistory fileNameHistory = new MediaEntityFilenameHistory();
            MediaFile mf = episode.getMainVideoFile();
            List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(episode.getTvShow(), mf.getFile());
            if (!episode.isDisc() || !mf.isDiscFile()) {
                return;
            }
            if (DISC_FOLDERS.contains(mf.getFileAsPath().getFileName().toString().toLowerCase(Locale.ROOT))) {
                disc = mf.getFileAsPath();
                epFolder = disc.getParent();
            } else if (DISC_FOLDERS.contains(mf.getFileAsPath().getParent().getFileName().toString().toLowerCase(Locale.ROOT))) {
                disc = mf.getFileAsPath().getParent();
                epFolder = disc.getParent();
            } else {
                LOGGER.warn("TV show '{}', Episode S{} E{} is labeled as 'on BD/DVD', but structure seems not to match. Try our best to get this right... o_O", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode()});
                epFolder = disc = mf.getFileAsPath().getParent();
            }
            String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
            Path seasonFolder = episode.getTvShow().getPathNIO();
            if (StringUtils.isNotBlank((CharSequence)seasonFoldername) && !Files.exists(seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername), new LinkOption[0])) {
                try {
                    Files.createDirectory(seasonFolder, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank((CharSequence)(newFoldername = FilenameUtils.getBaseName((String)TvShowRenamer.generateFoldername(episode.getTvShow(), mf))))) {
                LOGGER.warn("Empty disc folder name for TV show '{}', Episode S{} E{} - exiting", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode()});
                return;
            }
            Path newEpFolder = seasonFolder.resolve(newFoldername);
            try {
                if (epFolder.toAbsolutePath().toString().equals(newEpFolder.toAbsolutePath().toString())) break block16;
                boolean ok = false;
                try {
                    if (!Files.exists(newEpFolder.getParent(), new LinkOption[0])) {
                        Files.createDirectory(newEpFolder.getParent(), new FileAttribute[0]);
                    }
                    ok = Utils.moveDirectorySafe(epFolder, newEpFolder);
                }
                catch (Exception e) {
                    LOGGER.error("Could not rename episode S{} E{} of '{} - '{}'", new Object[]{episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle(), e.getMessage()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)epFolder, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
                if (ok) {
                    LOGGER.debug("updating *all* MFs for new path -> {}", (Object)newEpFolder);
                    for (TvShowEpisode e : eps) {
                        e.updateMediaFilePath(epFolder, newEpFolder);
                        e.setPath(newEpFolder.toAbsolutePath().toString());
                        fileNameHistory.addFilenameHistory(TvShowRenamer.createFilenameHistory(episode.getTvShow().getPathNIO(), epFolder, newEpFolder));
                        e.setRenameHistory(fileNameHistory);
                        e.saveToDb();
                    }
                }
                TvShowRenamer.cleanEmptyDir(epFolder);
            }
            catch (Exception e) {
                LOGGER.error("Error moving video file '{}' to '{}' - '{}'", new Object[]{disc, newFoldername, e.getMessage()});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    public static void undoRename(TvShow tvShow) {
        if (tvShow.getRenameHistory() != null) {
            TvShowRenamer.undoRenameTvShow(tvShow);
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            TvShowRenamer.undoRenameSeason(season);
        }
        tvShow.saveToDb();
    }

    private static void undoRenameTvShow(TvShow tvShow) {
        if (StringUtils.isNotBlank((CharSequence)tvShow.getRenameHistory().getOldPath())) {
            Path srcDir = Paths.get(tvShow.getRenameHistory().getNewPath(), new String[0]);
            Path destDir = Paths.get(tvShow.getRenameHistory().getOldPath(), new String[0]);
            if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
                try {
                    boolean ok;
                    if (!Files.exists(destDir.getParent(), new LinkOption[0])) {
                        Files.createDirectory(destDir.getParent(), new FileAttribute[0]);
                    }
                    if (ok = Utils.moveDirectorySafe(srcDir, destDir)) {
                        tvShow.updateMediaFilePath(srcDir, destDir);
                        tvShow.setPath(tvShow.getRenameHistory().getOldPath());
                        for (TvShowSeason tvShowSeason : tvShow.getSeasons()) {
                            tvShowSeason.updateMediaFilePath(srcDir, destDir);
                        }
                        for (TvShowEpisode episode : tvShow.getEpisodes()) {
                            episode.replacePathForRenamedTvShowRoot(srcDir, destDir);
                            episode.updateMediaFilePath(srcDir, destDir);
                        }
                        if (Settings.getInstance().isImageCache()) {
                            for (MediaFile gfx : tvShow.getMediaFiles()) {
                                ImageCache.cacheImageSilently(gfx, false);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error moving folder '{}' to '{}' - '{}'", new Object[]{srcDir, destDir, e.getMessage()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
        Path tvShowRoot = tvShow.getPathNIO();
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        for (MediaFile mediaFile : tvShow.getMediaFiles()) {
            MediaEntityFilenameHistory.FilenameHistory filenameHistory = TvShowRenamer.findFilenameHistoryForMediaFile(tvShow, mediaFile);
            if (filenameHistory == null) {
                LOGGER.debug("could not undo rename for '{}' - history not found", (Object)mediaFile.getFilename());
                continue;
            }
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            MediaFile oldMF = new MediaFile(mediaFile);
            oldMF.setFile(tvShowRoot.resolve(filenameHistory.oldFilename()));
            boolean ok = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), oldMF.getFileAsPath());
            if (!ok) continue;
            mediaFile.setFile(oldMF.getFileAsPath());
            needed.add(mediaFile);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        tvShow.removeAllMediaFiles();
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : needed) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        ThreadUtils.sleep(250L);
        tvShow.addToMediaFiles(needed);
        tvShow.gatherMediaFileInformation(false);
        tvShow.setRenameHistory(null);
    }

    private static void undoRenameSeason(TvShowSeason season) {
        Path tvShowRoot = season.getTvShow().getPathNIO();
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        for (MediaFile mediaFile : season.getMediaFiles()) {
            MediaEntityFilenameHistory.FilenameHistory filenameHistory = TvShowRenamer.findFilenameHistoryForMediaFile(season.getTvShow(), mediaFile);
            if (filenameHistory == null) {
                LOGGER.debug("could not undo rename for '{}' - history not found", (Object)mediaFile.getFilename());
                continue;
            }
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            MediaFile oldMF = new MediaFile(mediaFile);
            oldMF.setFile(tvShowRoot.resolve(filenameHistory.oldFilename()));
            boolean ok = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), oldMF.getFileAsPath());
            if (!ok) continue;
            mediaFile.setFile(oldMF.getFileAsPath());
            needed.add(mediaFile);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        season.removeAllMediaFiles();
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : needed) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        ThreadUtils.sleep(250L);
        season.addToMediaFiles(needed);
        season.gatherMediaFileInformation(false);
        season.setRenameHistory(null);
    }

    private static void cleanEmptyDir(Path dir) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            if (!directoryStream.iterator().hasNext()) {
                LOGGER.debug("Deleting empty Directory - {}", (Object)dir);
                Files.delete(dir);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void undoRename(TvShowEpisode episode) {
        boolean ok;
        MediaFile oldMF;
        MediaEntityFilenameHistory.FilenameHistory filenameHistory;
        if (episode.getRenameHistory() == null) {
            LOGGER.debug("could not undo rename - no history available");
            return;
        }
        if (episode.isDisc()) {
            TvShowRenamer.undoRenameEpisodeAsDisc(episode);
            return;
        }
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        Path tvShowRoot = episode.getTvShow().getPathNIO();
        for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO)) {
            filenameHistory = TvShowRenamer.findFilenameHistoryForMediaFile(episode, mediaFile);
            if (filenameHistory == null) {
                LOGGER.debug("could not undo rename - VIDEO file history not found");
                return;
            }
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            oldMF = new MediaFile(mediaFile);
            oldMF.setFile(tvShowRoot.resolve(filenameHistory.oldFilename()));
            ok = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), oldMF.getFileAsPath());
            if (!ok) {
                LOGGER.error("Could not move video file ({}) of episode S{} E{} of '{}' - abort renaming", new Object[]{mediaFile, episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle()});
                return;
            }
            mediaFile.setFile(oldMF.getFileAsPath());
            episode.setPath(oldMF.getPath());
            needed.add(mediaFile);
        }
        for (MediaFile mediaFile : episode.getMediaFilesExceptType(MediaFileType.VIDEO)) {
            filenameHistory = TvShowRenamer.findFilenameHistoryForMediaFile(episode, mediaFile);
            if (filenameHistory == null) {
                LOGGER.debug("could not undo rename for '{}' - history not found", (Object)mediaFile.getFilename());
                continue;
            }
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            oldMF = new MediaFile(mediaFile);
            oldMF.setFile(tvShowRoot.resolve(filenameHistory.oldFilename()));
            ok = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), oldMF.getFileAsPath());
            if (!ok) continue;
            mediaFile.setFile(oldMF.getFileAsPath());
            needed.add(mediaFile);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        episode.removeAllMediaFiles();
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : needed) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        ThreadUtils.sleep(250L);
        episode.addToMediaFiles(needed);
        episode.gatherMediaFileInformation(false);
        episode.setRenameHistory(null);
        episode.saveToDb();
        try {
            Utils.deleteEmptyDirectoryRecursive(tvShowRoot);
        }
        catch (IOException iOException) {
            LOGGER.warn("Eould not delete empty subfolders of '{}' - '{}'", (Object)tvShowRoot, (Object)iOException.getMessage());
        }
    }

    private static void undoRenameEpisodeAsDisc(TvShowEpisode episode) {
        MediaFile mf = episode.getMainVideoFile();
        List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(episode.getTvShow(), mf.getFile());
        if (!episode.isDisc() || !mf.isDiscFile() || ListUtils.isEmpty(episode.getRenameHistory().getFilenameHistory())) {
            return;
        }
        MediaEntityFilenameHistory.FilenameHistory filenameHistory = episode.getRenameHistory().getFilenameHistory().get(0);
        Path newEpFolder = episode.getTvShow().getPathNIO().resolve(filenameHistory.newFilename());
        Path oldEpFolder = episode.getTvShow().getPathNIO().resolve(filenameHistory.oldFilename());
        try {
            boolean ok = false;
            try {
                if (!Files.exists(oldEpFolder.getParent(), new LinkOption[0])) {
                    Files.createDirectory(oldEpFolder.getParent(), new FileAttribute[0]);
                }
                ok = Utils.moveDirectorySafe(newEpFolder, oldEpFolder);
            }
            catch (Exception e) {
                LOGGER.error("Could not move episode files ({}) of episode S{} E{} of '{}'", new Object[]{oldEpFolder, episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle()});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)newEpFolder, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
            if (ok) {
                LOGGER.debug("updating *all* MFs for new path -> {}", (Object)newEpFolder);
                for (TvShowEpisode e : eps) {
                    e.updateMediaFilePath(newEpFolder, oldEpFolder);
                    e.setPath(oldEpFolder.toAbsolutePath().toString());
                    e.setRenameHistory(null);
                    e.saveToDb();
                }
            }
            TvShowRenamer.cleanEmptyDir(newEpFolder);
        }
        catch (Exception e) {
            LOGGER.error("Could not move episode files ({}) of episode S{} E{} of '{}' - abort renaming", new Object[]{oldEpFolder, episode.getSeason(), episode.getEpisode(), episode.getTvShow().getTitle()});
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public static String generateFoldername(TvShow tvShow, MediaFile mf) {
        List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile());
        if (ListUtils.isEmpty(eps)) {
            return "";
        }
        return TvShowRenamer.createDestination(TvShowModuleManager.getInstance().getSettings().getRenamerFilename(), eps);
    }

    public static List<MediaFile> generateEpisodeFilenames(TvShow tvShow, MediaFile mf, String videoBasename) {
        return TvShowRenamer.generateEpisodeFilenames("", tvShow, mf, videoBasename);
    }

    public static List<MediaFile> generateEpisodeFilenames(String template, TvShow tvShow, MediaFile mf, String oldVideoBasename) {
        ArrayList<MediaFile> newFiles = new ArrayList<MediaFile>();
        if (mf.getType() == MediaFileType.NFO && TvShowModuleManager.getInstance().getSettings().getEpisodeNfoFilenames().isEmpty()) {
            return newFiles;
        }
        List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile());
        if (ListUtils.isEmpty(eps)) {
            return newFiles;
        }
        eps.sort((ep1, ep2) -> {
            if (ep1.getSeason() != ep2.getSeason()) {
                return Integer.compare(ep1.getSeason(), ep2.getSeason());
            }
            return Integer.compare(ep1.getEpisode(), ep2.getEpisode());
        });
        TvShowEpisode firstEp = eps.get(0);
        boolean singleSE = true;
        for (int i = 1; i < eps.size(); ++i) {
            if (eps.get(i).getSeason() == firstEp.getSeason() && eps.get(i).getEpisode() == firstEp.getEpisode()) continue;
            singleSE = false;
            break;
        }
        if (singleSE) {
            eps.clear();
            eps.add(firstEp);
        }
        Object newFilename = "";
        newFilename = StringUtils.isBlank((CharSequence)template) ? TvShowRenamer.createDestination(TvShowModuleManager.getInstance().getSettings().getRenamerFilename(), eps) : TvShowRenamer.createDestination(template, eps);
        if (mf.getStacking() > 0) {
            newFilename = Utils.cleanFolderStackingMarkers((String)newFilename);
        }
        String seasonFoldername = TvShowRenamer.getSeasonFoldername(tvShow, eps.get(0));
        Path seasonFolder = tvShow.getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonFoldername)) {
            seasonFolder = tvShow.getPathNIO().resolve(seasonFoldername);
        }
        if (StringUtils.isBlank((CharSequence)newFilename)) {
            MediaFile mediaFile = new MediaFile(mf);
            mediaFile.setFile(seasonFolder.resolve(mf.getFilename()));
            newFiles.add(mediaFile);
            return newFiles;
        }
        switch (mf.getType()) {
            case VIDEO: {
                MediaFile video = new MediaFile(mf);
                newFilename = (String)newFilename + TvShowRenamer.getStackingString(mf);
                newFilename = (String)newFilename + "." + mf.getExtension();
                video.setFile(seasonFolder.resolve((String)newFilename));
                newFiles.add(video);
                break;
            }
            case NFO: {
                MediaFile nfo = new MediaFile(mf);
                newFilename = (String)newFilename + "." + mf.getExtension();
                nfo.setFile(seasonFolder.resolve((String)newFilename));
                newFiles.add(nfo);
                break;
            }
            case THUMB: {
                for (TvShowEpisodeThumbNaming thumbNaming : TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames()) {
                    String thumbFilename = thumbNaming.getFilename((String)newFilename, TvShowRenamer.getMediaFileExtension(mf));
                    MediaFile thumb = new MediaFile(mf);
                    thumb.setFile(seasonFolder.resolve(thumbFilename));
                    newFiles.add(thumb);
                }
                break;
            }
            case SUBTITLE: {
                MediaFileSubtitle sub;
                List<MediaFileSubtitle> subtitles = mf.getSubtitles();
                Object subtitleFilename = newFilename = (String)newFilename + TvShowRenamer.getStackingString(mf);
                if (subtitles != null && !subtitles.isEmpty() && (sub = mf.getSubtitles().get(0)) != null) {
                    if (!sub.getLanguage().isEmpty()) {
                        String lang = LanguageStyle.getLanguageCodeForStyle(sub.getLanguage(), TvShowModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = sub.getLanguage();
                        }
                        subtitleFilename = (String)subtitleFilename + "." + lang;
                    }
                    if (sub.isForced()) {
                        subtitleFilename = (String)subtitleFilename + ".forced";
                    }
                    if (sub.isSdh()) {
                        subtitleFilename = (String)subtitleFilename + ".sdh";
                    }
                    if (StringUtils.isNotBlank((CharSequence)sub.getTitle())) {
                        subtitleFilename = (String)subtitleFilename + "." + sub.getTitle().strip();
                    }
                }
                if (StringUtils.isBlank((CharSequence)subtitleFilename)) {
                    subtitleFilename = newFilename;
                }
                if (!StringUtils.isNotBlank((CharSequence)subtitleFilename)) break;
                MediaFile subtitle = new MediaFile(mf);
                subtitle.setFile(seasonFolder.resolve((String)subtitleFilename + "." + mf.getExtension()));
                newFiles.add(subtitle);
                break;
            }
            case FANART: {
                MediaFile fanart = new MediaFile(mf);
                fanart.setFile(seasonFolder.resolve((String)newFilename + "-fanart." + TvShowRenamer.getMediaFileExtension(mf)));
                newFiles.add(fanart);
                break;
            }
            case TRAILER: {
                MediaFile trailer = new MediaFile(mf);
                trailer.setFile(seasonFolder.resolve((String)newFilename + "-trailer." + mf.getExtension()));
                newFiles.add(trailer);
                break;
            }
            case MEDIAINFO: {
                MediaFile mediainfo = new MediaFile(mf);
                newFilename = (String)newFilename + TvShowRenamer.getStackingString(mf);
                mediainfo.setFile(seasonFolder.resolve((String)newFilename + "-mediainfo." + mf.getExtension()));
                newFiles.add(mediainfo);
                break;
            }
            case VSMETA: {
                MediaFile vsmeta = new MediaFile(mf);
                String videoExt = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                newFilename = (String)newFilename + "." + videoExt + ".vsmeta";
                vsmeta.setFile(seasonFolder.resolve((String)newFilename));
                newFiles.add(vsmeta);
                break;
            }
            case EXTRA: 
            case VIDEO_EXTRA: {
                MediaFile extra = new MediaFile(mf);
                if (MediaFileHelper.isExtraInDedicatedFolder(mf, tvShow)) {
                    newFiles.add(extra);
                    break;
                }
                String extraTitle = mf.getBasename().replace(oldVideoBasename, "");
                extra.setFile(seasonFolder.resolve((String)newFilename + extraTitle + "." + mf.getExtension()));
                newFiles.add(extra);
                break;
            }
            case SAMPLE: {
                MediaFile sample = new MediaFile(mf);
                sample.setFile(seasonFolder.resolve((String)newFilename + "-sample." + mf.getExtension()));
                newFiles.add(sample);
                break;
            }
            case AUDIO: 
            case TEXT: 
            case UNKNOWN: {
                MediaFile other = new MediaFile(mf);
                boolean spaceSubstitution = TvShowModuleManager.getInstance().getSettings().isRenamerFilenameSpaceSubstitution();
                String spaceReplacement = TvShowModuleManager.getInstance().getSettings().getRenamerFilenameSpaceReplacement();
                String destination = TvShowRenamer.cleanupDestination((String)newFilename + StringUtils.difference((String)oldVideoBasename, (String)FilenameUtils.getBaseName((String)mf.getFilename())), spaceSubstitution, spaceReplacement);
                other.setFile(seasonFolder.resolve(destination + "." + mf.getExtension()));
                newFiles.add(other);
                break;
            }
        }
        return newFiles;
    }

    public static List<MediaFile> generateSeasonFilenames(TvShow show, TvShowSeason season, MediaFile mf) {
        ArrayList<MediaFile> newFiles = new ArrayList<MediaFile>();
        switch (mf.getType()) {
            case NFO: {
                if (season.getEpisodes().isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) break;
                for (TvShowSeasonNfoNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonNfoFilenames()) {
                    String filename = naming.getFilename(season, mf.getExtension());
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMf = new MediaFile(mf);
                    newMf.setFile(show.getPathNIO().resolve(filename));
                    newFiles.add(newMf);
                }
                break;
            }
            case SEASON_POSTER: {
                if (season.getEpisodes().isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) break;
                for (TvShowSeasonPosterNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames()) {
                    String filename = naming.getFilename(season, mf.getExtension());
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMF = new MediaFile(mf);
                    newMF.setFile(show.getPathNIO().resolve(filename));
                    newFiles.add(newMF);
                }
                break;
            }
            case SEASON_FANART: {
                if (season.getEpisodes().isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) break;
                for (TvShowSeasonFanartNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames()) {
                    String filename = naming.getFilename(season, mf.getExtension());
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMF = new MediaFile(mf);
                    newMF.setFile(show.getPathNIO().resolve(filename));
                    newFiles.add(newMF);
                }
                break;
            }
            case SEASON_BANNER: {
                if (season.getEpisodes().isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) break;
                for (TvShowSeasonBannerNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames()) {
                    String filename = naming.getFilename(season, mf.getExtension());
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMF = new MediaFile(mf);
                    newMF.setFile(show.getPathNIO().resolve(filename));
                    newFiles.add(newMF);
                }
                break;
            }
            case SEASON_THUMB: {
                if (season.getEpisodes().isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) break;
                for (TvShowSeasonThumbNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames()) {
                    String filename = naming.getFilename(season, mf.getExtension());
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMF = new MediaFile(mf);
                    newMF.setFile(show.getPathNIO().resolve(filename));
                    newFiles.add(newMF);
                }
                break;
            }
        }
        return newFiles;
    }

    public static String getSeasonFoldername(TvShow show, TvShowSeason season) {
        TvShowEpisode firstEpisode = ListUtils.getFirst(season.getEpisodes());
        if (firstEpisode == null) {
            return "";
        }
        return TvShowRenamer.getSeasonFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerSeasonFoldername(), show, firstEpisode);
    }

    public static String getSeasonFoldername(TvShow show, TvShowEpisode episode) {
        return TvShowRenamer.getSeasonFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerSeasonFoldername(), show, episode);
    }

    public static String getSeasonFoldername(String template, TvShow show, TvShowEpisode episode) {
        Object seasonFolderName = template;
        TvShowSeason tvShowSeason = show.getSeason(episode.getSeason());
        if (tvShowSeason == null) {
            return "";
        }
        seasonFolderName = tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() && !StringUtils.isBlank((CharSequence)TvShowModuleManager.getInstance().getSettings().getRenamerSeasonFoldername()) ? "Specials" : TvShowRenamer.createDestination((String)seasonFolderName, tvShowSeason, episode);
        if (StringUtils.isBlank((CharSequence)seasonFolderName) && !TvShowRenamer.isRecommended(template, TvShowModuleManager.getInstance().getSettings().getRenamerFilename())) {
            seasonFolderName = "Season " + tvShowSeason.getSeason();
        }
        return seasonFolderName;
    }

    public static String getTvShowFoldername(TvShow tvShow) {
        return TvShowRenamer.getTvShowFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername(), tvShow);
    }

    public static String getTvShowFoldername(String template, TvShow tvShow) {
        String newPathname;
        try {
            newPathname = StringUtils.isNotBlank((CharSequence)template) ? Paths.get(tvShow.getDataSource(), TvShowRenamer.createDestination(template, tvShow)).toString() : tvShow.getPathNIO().toString();
        }
        catch (Exception e) {
            newPathname = tvShow.getPathNIO().toString();
        }
        return newPathname;
    }

    public static String getTokenValue(TvShow show, TvShowEpisode episode, String token) {
        try {
            Engine engine = TvShowRenamer.createEngine();
            engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
            engine.setOutputAppender((OutputAppender)new TmmOutputAppender(){

                @Override
                protected String replaceInvalidCharacters(String text) {
                    if (this.isUnicodeReplacementEnabled()) {
                        text = StrgUtils.replaceForbiddenFilesystemCharacters(text);
                    }
                    return TvShowRenamer.replaceInvalidCharacters(text);
                }

                @Override
                protected boolean isUnicodeReplacementEnabled() {
                    return TvShowModuleManager.getInstance().getSettings().isUnicodeReplacement();
                }
            });
            HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
            if (episode != null) {
                root.put("episode", episode);
                root.put("season", episode.getTvShowSeason());
            }
            root.put("tvShow", show);
            return engine.transform(JmteUtils.morphTemplate(token, TOKEN_MAP), root);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to process token: '{}' - '{}'", (Object)token, (Object)e.getMessage());
            return token;
        }
    }

    public static Engine createEngine() {
        Engine engine = Engine.createEngine();
        engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
        engine.registerRenderer(Path.class, (Renderer)new PathRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayUniqueRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFramerateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedSplitRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new TvShowNamedFirstCharacterRenderer());
        engine.registerNamedRenderer((NamedRenderer)new ChainedNamedRenderer(engine.getAllNamedRenderers()));
        engine.registerAnnotationProcessor((AnnotationProcessor)new RegexpProcessor());
        engine.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(ErrorMessage errorMessage, Token token, Map<String, Object> parameters) throws ParseException {
                throw new ParseException((com.floreysoft.jmte.message.Message)new ResourceBundleMessage(errorMessage.key).withModel(parameters).onToken(token));
            }
        });
        return engine;
    }

    public static String createDestination(String template, TvShow show) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        boolean spaceSubstitution = TvShowModuleManager.getInstance().getSettings().isRenamerShowPathnameSpaceSubstitution();
        String spaceReplacement = TvShowModuleManager.getInstance().getSettings().getRenamerShowPathnameSpaceReplacement();
        return TvShowRenamer.cleanupDestination(TvShowRenamer.getTokenValue(show, null, template), spaceSubstitution, spaceReplacement);
    }

    public static String createDestination(String template, TvShowSeason season, TvShowEpisode episode) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        String newDestination = TvShowRenamer.getTokenValue(season.getTvShow(), episode, template);
        boolean spaceSubstitution = TvShowModuleManager.getInstance().getSettings().isRenamerSeasonPathnameSpaceSubstitution();
        String spaceReplacement = TvShowModuleManager.getInstance().getSettings().getRenamerSeasonPathnameSpaceReplacement();
        newDestination = TvShowRenamer.cleanupDestination(newDestination, spaceSubstitution, spaceReplacement);
        return newDestination;
    }

    public static String createDestination(String template, List<TvShowEpisode> episodes) {
        if (StringUtils.isBlank((CharSequence)template) || episodes.isEmpty()) {
            return "";
        }
        TvShowEpisode firstEp = episodes.get(0);
        String newDestination = template;
        if (episodes.size() == 1) {
            newDestination = TvShowRenamer.getTokenValue(firstEp.getTvShow(), firstEp, template);
        } else {
            Pattern pattern;
            Matcher matcher;
            Pattern pattern2;
            Object matcher2;
            String episodeToken;
            Object loopNumbers = "";
            String seasonToken = TvShowRenamer.getTokenFromTemplate(newDestination, seasonNumbers);
            if (StringUtils.isNotBlank((CharSequence)seasonToken)) {
                String seasonPart = "";
                Matcher matcher3 = seDelimiter.matcher(newDestination);
                if (matcher3.find()) {
                    seasonPart = matcher3.group(0);
                } else {
                    Pattern pattern3 = Pattern.compile("\\$\\{" + Pattern.quote(seasonToken) + ".*?\\}");
                    matcher3 = pattern3.matcher(newDestination);
                    if (matcher3.find()) {
                        seasonPart = matcher3.group(0);
                    }
                }
                loopNumbers = (String)loopNumbers + seasonPart;
            }
            if (StringUtils.isNotBlank((CharSequence)(episodeToken = TvShowRenamer.getTokenFromTemplate(newDestination, episodeNumbers)))) {
                Object episodePart = "";
                Object matcher4 = epDelimiter.matcher(newDestination);
                if (((Matcher)matcher4).find()) {
                    episodePart = (String)episodePart + ((Matcher)matcher4).group(0);
                } else {
                    Pattern pattern4 = Pattern.compile("\\$\\{" + Pattern.quote(episodeToken) + ".*?\\}");
                    matcher4 = pattern4.matcher(newDestination);
                    if (((Matcher)matcher4).find()) {
                        episodePart = ((Matcher)matcher4).group(0);
                    }
                }
                loopNumbers = (String)loopNumbers + (String)episodePart;
            }
            loopNumbers = ((String)loopNumbers).strip();
            StringBuilder episodeParts = new StringBuilder();
            for (TvShowEpisode episode : episodes) {
                String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, (String)loopNumbers);
                episodeParts.append(" ").append(episodePart);
            }
            if (StringUtils.isNotBlank((CharSequence)loopNumbers)) {
                newDestination = newDestination.replace((CharSequence)loopNumbers, episodeParts.toString().strip());
            }
            Object loopTitles = "";
            String titleToken = TvShowRenamer.getTokenFromTemplate(template, episodeTitles);
            if (StringUtils.isNotBlank((CharSequence)titleToken) && ((Matcher)(matcher2 = (pattern2 = Pattern.compile("\\$\\{" + Pattern.quote(titleToken) + ".*?\\}", 2)).matcher(template))).find()) {
                loopTitles = (String)loopTitles + ((Matcher)matcher2).group(0);
            }
            if (StringUtils.isNotBlank((CharSequence)(loopTitles = ((String)loopTitles).strip()))) {
                episodeParts = new StringBuilder();
                String previous = "";
                for (TvShowEpisode episode : episodes) {
                    String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, (String)loopTitles);
                    if (!episodePart.equals(previous)) {
                        if (StringUtils.isNotBlank((CharSequence)episodeParts.toString())) {
                            episodeParts.append(" -");
                        }
                        episodeParts.append(" ").append(episodePart);
                    }
                    previous = episodePart;
                }
                newDestination = newDestination.replace((CharSequence)loopTitles, episodeParts.toString().strip());
            }
            Object loopAired = "";
            String airedToken = TvShowRenamer.getTokenFromTemplate(template, episodeAired);
            if (StringUtils.isNotBlank((CharSequence)airedToken) && (matcher = (pattern = Pattern.compile("\\$\\{" + Pattern.quote(airedToken) + ".*?\\}", 2)).matcher(template)).find()) {
                loopAired = (String)loopAired + matcher.group(0);
            }
            if (StringUtils.isNotBlank((CharSequence)(loopAired = ((String)loopAired).strip()))) {
                episodeParts = new StringBuilder();
                for (TvShowEpisode episode : episodes) {
                    String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, (String)loopAired);
                    if (StringUtils.isNotBlank((CharSequence)episodeParts.toString())) {
                        episodeParts.append(" -");
                    }
                    episodeParts.append(" ").append(episodePart);
                }
                newDestination = newDestination.replace((CharSequence)loopAired, episodeParts.toString().strip());
            }
            newDestination = TvShowRenamer.getTokenValue(firstEp.getTvShow(), firstEp, newDestination);
        }
        if (newDestination.endsWith("." + firstEp.getMainVideoFile().getExtension())) {
            newDestination = FilenameUtils.getBaseName((String)newDestination);
        }
        boolean spaceSubstitution = TvShowModuleManager.getInstance().getSettings().isRenamerFilenameSpaceSubstitution();
        String spaceReplacement = TvShowModuleManager.getInstance().getSettings().getRenamerFilenameSpaceReplacement();
        newDestination = TvShowRenamer.cleanupDestination(newDestination, spaceSubstitution, spaceReplacement);
        return newDestination;
    }

    private static String cleanupDestination(String destination, Boolean spaceSubstitution, String spaceReplacement) {
        destination = destination.replaceAll("\\([ ]?\\)", "");
        destination = destination.replaceAll("\\[[ ]?\\]", "");
        destination = destination.replaceAll("\\{[ ]?\\}", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            destination = destination.replaceAll("\\\\{2,}", "\\\\");
            destination = destination.replaceAll("^\\\\", "");
            destination = destination.replaceAll("\\s+\\\\", "\\\\");
            destination = destination.replaceAll("\\\\\\s+", "\\\\");
            destination = destination.replaceAll("[ \\.\\-_]+\\\\", "\\\\");
        } else {
            destination = destination.replaceAll(File.separator + "{2,}", File.separator);
            destination = destination.replaceAll("^" + File.separator, "");
            destination = destination.replaceAll("\\s+/", "/");
            destination = destination.replaceAll("/\\s+", "/");
            destination = destination.replaceAll("[ \\.\\-_]+/", "/");
        }
        if (spaceSubstitution.booleanValue()) {
            destination = destination.replace(" ", spaceReplacement);
            destination = destination.replaceAll(Pattern.quote(spaceReplacement) + "+", spaceReplacement);
        }
        if (TvShowModuleManager.getInstance().getSettings().isAsciiReplacement()) {
            destination = StrgUtils.convertToAscii(destination, false);
        }
        if (TvShowModuleManager.getInstance().getSettings().isUnicodeReplacement()) {
            destination = destination.replace("...", "\u2026");
        }
        destination = destination.replaceAll("^[ \\.\\-_]+", "");
        destination = destination.replaceAll("[ \\.\\-_]+$", "");
        destination = TvShowRenamer.replaceInvalidCharacters(destination);
        destination = destination.replaceAll("\r?\n", " ");
        destination = destination.replaceAll(" +", " ");
        return destination.strip();
    }

    public static boolean isRecommended(String seasonPattern, String filePattern) {
        int epCnt = TvShowRenamer.count(filePattern, episodeNumbers);
        int titleCnt = TvShowRenamer.count(filePattern, episodeTitles);
        int seCnt = TvShowRenamer.count(filePattern, seasonNumbers);
        int seFolderCnt = TvShowRenamer.count(seasonPattern, seasonNumbers);
        if (TvShowRenamer.count(filePattern, new String[]{"originalFilename", "originalBasename"}) > 0) {
            return true;
        }
        if (epCnt != 1 || titleCnt > 1 || seCnt > 1 || seFolderCnt > 1 || seCnt + seFolderCnt == 0) {
            LOGGER.debug("Too many/less episode/season/title replacer patterns");
            return false;
        }
        int epPos = TvShowRenamer.getPatternPos(filePattern, episodeNumbers);
        int sePos = TvShowRenamer.getPatternPos(filePattern, seasonNumbers);
        int titlePos = TvShowRenamer.getPatternPos(filePattern, episodeTitles);
        if (sePos > epPos) {
            LOGGER.debug("Season pattern should be before episode pattern!");
            return false;
        }
        if (titleCnt == 1 && seCnt == 1 && titlePos < epPos && titlePos > sePos) {
            LOGGER.debug("Title should not be between season/episode pattern");
            return false;
        }
        return true;
    }

    private static int count(String pattern, String[] possibleValues) {
        int count = 0;
        for (String r : possibleValues) {
            if (!TvShowRenamer.containsToken(pattern, r)) continue;
            ++count;
        }
        return count;
    }

    private static int getPatternPos(String pattern, String[] possibleValues) {
        int pos = -1;
        for (String r : possibleValues) {
            if (!TvShowRenamer.containsToken(pattern, r)) continue;
            pos = pattern.indexOf(r);
        }
        return pos;
    }

    private static String getTokenFromTemplate(String template, String[] possibleTokens) {
        for (String token : possibleTokens) {
            if (!TvShowRenamer.containsToken(template, token)) continue;
            return token;
        }
        return "";
    }

    private static boolean containsToken(String template, String token) {
        Pattern pattern = Pattern.compile("\\$\\{" + token + "[\\[\\};]");
        Matcher matcher = pattern.matcher(template);
        return matcher.find();
    }

    private static String getMediaFileExtension(MediaFile mf) {
        String ext = mf.getExtension().replace("jpeg", "jpg");
        if (ext.equalsIgnoreCase("tbn")) {
            String cont = mf.getContainerFormat();
            if (cont.equalsIgnoreCase("PNG")) {
                ext = "png";
            } else if (cont.equalsIgnoreCase("JPEG")) {
                ext = "jpg";
            }
        }
        return ext;
    }

    private static void cleanupUnwantedFiles(TvShow show) {
        if (TvShowModuleManager.getInstance().getSettings().renamerCleanupUnwanted) {
            Utils.deleteUnwantedFilesAndFoldersFor(show);
        }
    }

    private static boolean moveFile(Path oldFilename, Path newFilename) {
        try {
            boolean ok;
            if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveFileSafe(oldFilename, newFilename)) {
                return true;
            }
            LOGGER.error("Could not move file '{}' to '{}'", (Object)oldFilename, (Object)newFilename);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Could not move file '{}' to '{}' - '{}'", new Object[]{oldFilename, newFilename, e.getMessage()});
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldFilename, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    private static boolean copyFile(Path oldFilename, Path newFilename) {
        if (!oldFilename.toAbsolutePath().toString().equals(newFilename.toAbsolutePath().toString())) {
            LOGGER.debug("copy file '{}' to '{}'", (Object)oldFilename, (Object)newFilename);
            if (oldFilename.equals(newFilename)) {
                return TvShowRenamer.moveFile(oldFilename, newFilename);
            }
            try {
                if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                    Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
                }
                Utils.copyFileSafe(oldFilename, newFilename, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static String getStackingString(MediaFile mf) {
        String delimiter = ".";
        if (TvShowModuleManager.getInstance().getSettings().isRenamerFilenameSpaceSubstitution()) {
            delimiter = TvShowModuleManager.getInstance().getSettings().getRenamerFilenameSpaceReplacement();
        }
        if (!mf.getStackingMarker().isEmpty()) {
            return delimiter + mf.getStackingMarker();
        }
        if (mf.getStacking() != 0) {
            return delimiter + "CD" + mf.getStacking();
        }
        return "";
    }

    public static String replaceInvalidCharacters(String source) {
        String result = source;
        if ("-".equals(TvShowModuleManager.getInstance().getSettings().getRenamerColonReplacement())) {
            result = result.replace(": ", " - ");
            result = result.replace(":", "-");
        } else {
            result = result.replace(":", TvShowModuleManager.getInstance().getSettings().getRenamerColonReplacement());
        }
        return result.replaceAll("([\":<>|?*])", "");
    }

    public static String isPatternValid(String pattern) {
        Object err = "";
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = p.matcher(pattern);
        while (matcher.find()) {
            String tok;
            String fulltoken = matcher.group(1);
            String token = "";
            if (fulltoken.contains(",")) {
                String[] split = fulltoken.split(",");
                token = split[1];
            } else if (fulltoken.contains("[")) {
                token = fulltoken.substring(0, fulltoken.indexOf(91));
            } else if (fulltoken.contains(";")) {
                token = fulltoken.substring(0, fulltoken.indexOf(59));
                String first = fulltoken.substring(fulltoken.indexOf(59) + 1);
                if (!first.equals("first")) {
                    err = (String)err + "  " + matcher.group();
                }
            } else {
                token = fulltoken;
            }
            if ((tok = TOKEN_MAP.get(token.strip())) != null) continue;
            err = (String)err + "  " + matcher.group();
        }
        return err;
    }

    public static class TvShowNamedFirstCharacterRenderer
    implements NamedRenderer {
        private static final Pattern FIRST_ALPHANUM_PATTERN = Pattern.compile("[\\p{L}\\d]");

        public String render(Object o, String s, Locale locale, Map<String, Object> map) {
            String source;
            Matcher matcher;
            if (o instanceof String && StringUtils.isNotBlank((CharSequence)((String)o)) && (matcher = FIRST_ALPHANUM_PATTERN.matcher(source = StrgUtils.convertToAscii((String)o, false))).find()) {
                String first = matcher.group();
                if (first.matches("\\p{L}")) {
                    return first.toUpperCase(Locale.ROOT);
                }
                return TvShowModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
            }
            if (o instanceof Number) {
                return TvShowModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
            }
            if (o instanceof Date) {
                return TvShowModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
            }
            return "";
        }

        public String getName() {
            return "first";
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Date.class, String.class, Integer.class, Long.class};
        }
    }
}

