/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.bus.Event;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToEmbyConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToJellyfinConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToKodiConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToXbmcConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowActorImageFetcherTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.TvUtils;

public class TvShow
extends MediaEntity
implements IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    public static final Pattern SEASON_ONLY_PATTERN = Pattern.compile("^(s|staffel|season|series)[\\s_.-]*(\\d{1,4})$", 2);
    @JsonProperty
    private String englishTitle = "";
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private MediaAiredStatus status = MediaAiredStatus.UNKNOWN;
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private MediaCertification certification = MediaCertification.UNKNOWN;
    @JsonProperty
    private String country = "";
    @JsonProperty
    private MediaEpisodeGroup episodeGroup = MediaEpisodeGroup.DEFAULT_AIRED;
    @JsonProperty
    private final List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private int top250 = 0;
    @JsonProperty
    private final List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> crew = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<TvShowEpisode> dummyEpisodes = new CopyOnWriteArrayList<TvShowEpisode>();
    @JsonProperty
    private final List<String> extraFanartUrls = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private final List<MediaTrailer> trailer = new CopyOnWriteArrayList<MediaTrailer>();
    @JsonProperty
    private final List<MediaEpisodeGroup> episodeGroups = new CopyOnWriteArrayList<MediaEpisodeGroup>();
    @JsonProperty
    private final Map<String, Map<Integer, String>> seasonNames = new HashMap<String, Map<Integer, String>>();
    @JsonProperty
    private final Map<String, Map<Integer, String>> seasonOverviews = new HashMap<String, Map<Integer, String>>();
    private final List<TvShowSeason> seasons = new CopyOnWriteArrayList<TvShowSeason>();
    private final List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private String titleSortable = "";
    private Date lastWatched = null;
    private volatile List<TvShowEpisode> cachedEpisodesForDisplay;
    private static final Comparator<MediaTrailer> TRAILER_QUALITY_COMPARATOR = new MediaTrailer.QualityComparator();

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        this.genres.removeIf(Objects::isNull);
        this.actors.removeIf(Objects::isNull);
        this.extraFanartUrls.removeIf(StringUtils::isBlank);
        this.episodeGroups.removeIf(Objects::isNull);
        this.trailer.removeIf(Objects::isNull);
        this.seasons.removeIf(Objects::isNull);
        this.episodes.removeIf(Objects::isNull);
        this.dummyEpisodes.removeIf(Objects::isNull);
        for (TvShowEpisode episode : this.dummyEpisodes) {
            episode.setTvShow(this);
            this.addToSeason(episode);
        }
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    public void merge(TvShow other) {
        this.merge(other, false);
    }

    public void forceMerge(TvShow other) {
        this.merge(other, true);
    }

    void merge(TvShow other, boolean force) {
        if (this.locked || other == null) {
            return;
        }
        super.merge(other, force);
        this.setEnglishTitle(StringUtils.isEmpty((CharSequence)this.englishTitle) || force ? other.englishTitle : this.englishTitle);
        this.setEpisodeGroup(this.episodeGroup == MediaEpisodeGroup.DEFAULT_AIRED || force ? other.episodeGroup : this.episodeGroup);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setFirstAired(this.firstAired == null || force ? other.firstAired : this.firstAired);
        this.setStatus(this.status == MediaAiredStatus.UNKNOWN || force ? other.status : this.status);
        this.setCertification(this.certification == MediaCertification.UNKNOWN || force ? other.certification : this.certification);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        this.setTop250(this.top250 == 0 || force ? other.top250 : this.top250);
        if (force) {
            this.genres.clear();
            this.actors.clear();
            this.crew.clear();
            this.extraFanartUrls.clear();
            this.episodeGroups.clear();
            this.seasonNames.clear();
            this.seasonOverviews.clear();
            this.trailer.clear();
        }
        this.setGenres(other.genres);
        this.setActors(other.actors);
        this.setCrew(other.crew);
        this.setExtraFanartUrls(other.extraFanartUrls);
        this.setEpisodeGroups(other.episodeGroups);
        this.setTrailers(other.trailer);
        for (Map.Entry<String, Map<Integer, String>> entry : other.seasonNames.entrySet()) {
            this.seasonNames.putIfAbsent(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Map<Integer, String>> entry : other.seasonOverviews.entrySet()) {
            this.seasonOverviews.putIfAbsent(entry.getKey(), entry.getValue());
        }
        for (TvShowSeason otherSeason : other.getSeasons()) {
            TvShowSeason ourSeason = this.getSeason(otherSeason.getSeason());
            if (ourSeason == null) {
                this.addSeason(new TvShowSeason(otherSeason));
                continue;
            }
            ourSeason.merge(otherSeason);
        }
        for (TvShowEpisode ep : this.episodes) {
            MediaFile our = ep.getMainVideoFile();
            TvShowEpisode otherEP = other.getEpisodes().stream().filter(otherep -> otherep.getMainVideoFile().equals(our) && ep.getSeason() == otherep.getSeason() && ep.getEpisode() == otherep.getEpisode()).findFirst().orElse(null);
            if (otherEP == null) continue;
            ep.merge(otherEP, force);
        }
        for (TvShowEpisode otherEp : other.getEpisodes()) {
            MediaFile theirs = otherEp.getMainVideoFile();
            TvShowEpisode ourEP = this.getEpisodes().stream().filter(ourEp -> ourEp.getMainVideoFile().equals(theirs) && ourEp.getSeason() == otherEp.getSeason() && ourEp.getEpisode() == otherEp.getEpisode()).findFirst().orElse(null);
            if (ourEP != null) continue;
            TvShowEpisode clone = new TvShowEpisode(otherEp);
            clone.setTvShow(this);
            this.addEpisode(clone);
        }
    }

    @Override
    public void addToMediaFiles(MediaFile mediaFile) {
        super.addToMediaFiles(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    @Override
    public void setTitle(String newValue) {
        super.setTitle(newValue);
        String oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public String getEnglishTitle() {
        return this.englishTitle;
    }

    public void setEnglishTitle(String newValue) {
        String oldValue = this.englishTitle;
        this.englishTitle = newValue;
        this.firePropertyChange("englishTitle", oldValue, newValue);
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = StrgUtils.strip(newValue);
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    @Override
    public MediaRating getRating() {
        MediaRating mediaRating = null;
        for (String ratingSource : TvShowModuleManager.getInstance().getSettings().getRatingSources()) {
            if (!StringUtils.isBlank((CharSequence)ratingSource) && (mediaRating = (MediaRating)this.ratings.get(ratingSource)) != null) break;
        }
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public MediaEpisodeGroup getEpisodeGroup() {
        return this.episodeGroup;
    }

    public void setEpisodeGroup(MediaEpisodeGroup newValue) {
        MediaEpisodeGroup oldValue = this.episodeGroup;
        this.episodeGroup = newValue;
        this.firePropertyChange("episodeGroup", oldValue, newValue);
        if (!oldValue.equals(newValue)) {
            LOGGER.debug("Switched episodeGroup '{}' -> '{}' for show {}", new Object[]{oldValue, newValue, this.getTitle()});
            this.seasons.forEach(TvShowSeason::removeAllEpisodes);
            this.invalidateEpisodeForDisplayCache();
            for (TvShowEpisode episode : this.getEpisodesForDisplay()) {
                TvShowSeason season = this.getOrCreateSeason(episode.getSeason());
                this.firePropertyChange("addedSeason", null, season);
                season.addEpisode(episode);
                episode.firePropertyChange("episodeGroup", oldValue, newValue);
            }
            for (TvShowSeason season : new ArrayList<TvShowSeason>(this.seasons)) {
                if (!season.isEmpty()) continue;
                this.removeSeason(season);
            }
            for (TvShowSeason season : this.getSeasons()) {
                season.setTitle(this.getSeasonName(season.getSeason()));
                season.setPlot(this.getSeasonOverview(season.getSeason()));
            }
        }
    }

    public List<MediaEpisodeGroup> getEpisodeGroups() {
        return Collections.unmodifiableList(this.episodeGroups);
    }

    public void setEpisodeGroups(Collection<MediaEpisodeGroup> newValues) {
        this.episodeGroups.clear();
        for (MediaEpisodeGroup.EpisodeGroupType eg : MediaEpisodeGroup.EpisodeGroupType.values()) {
            if (this.episodeGroup != null && this.episodeGroup.getEpisodeGroupType() == eg && newValues.contains(this.episodeGroup)) {
                this.episodeGroups.add(this.episodeGroup);
            }
            newValues.forEach(group -> {
                if (group.getEpisodeGroupType() == eg && !this.episodeGroups.contains(group)) {
                    this.episodeGroups.add((MediaEpisodeGroup)group);
                }
            });
        }
        this.firePropertyChange("episodeGroups", null, this.episodeGroups);
    }

    public void addEpisodeGroup(MediaEpisodeGroup episodeGroup) {
        this.episodeGroups.add(episodeGroup);
    }

    public void setSeasonNames(Map<MediaEpisodeGroup, Map<Integer, String>> newValue) {
        this.seasonNames.clear();
        for (Map.Entry<MediaEpisodeGroup, Map<Integer, String>> entry : newValue.entrySet()) {
            this.seasonNames.putIfAbsent(entry.getKey().toString(), entry.getValue());
        }
        this.firePropertyChange("seasonNames", null, this.seasonNames);
    }

    public Map<String, Map<Integer, String>> getSeasonNames() {
        return Collections.unmodifiableMap(this.seasonNames);
    }

    String getSeasonName(int season) {
        String seasonName;
        Map<Integer, String> seasonNamesForEpisodeGroup = this.seasonNames.get(this.episodeGroup.toString());
        if (seasonNamesForEpisodeGroup != null && StringUtils.isNotBlank((CharSequence)(seasonName = seasonNamesForEpisodeGroup.get(season)))) {
            return seasonName;
        }
        return "";
    }

    public void setSeasonOverviews(Map<MediaEpisodeGroup, Map<Integer, String>> newValue) {
        this.seasonOverviews.clear();
        for (Map.Entry<MediaEpisodeGroup, Map<Integer, String>> entry : newValue.entrySet()) {
            this.seasonOverviews.putIfAbsent(entry.getKey().toString(), entry.getValue());
        }
        this.firePropertyChange("seasonOverviews", null, this.seasonOverviews);
    }

    public Map<String, Map<Integer, String>> getSeasonOverviews() {
        return Collections.unmodifiableMap(this.seasonOverviews);
    }

    String getSeasonOverview(int season) {
        String seasonName;
        Map<Integer, String> seasonOverviewForEpisodeGroup = this.seasonOverviews.get(this.episodeGroup.toString());
        if (seasonOverviewForEpisodeGroup != null && StringUtils.isNotBlank((CharSequence)(seasonName = seasonOverviewForEpisodeGroup.get(season)))) {
            return seasonName;
        }
        return "";
    }

    public List<TvShowEpisode> getEpisodes() {
        return Collections.unmodifiableList(this.episodes);
    }

    public synchronized void addEpisode(TvShowEpisode episode) {
        int oldValue = this.episodes.size();
        this.episodes.add(episode);
        this.addToSeason(episode);
        this.episodes.sort(TvShowEpisode::compareTo);
        this.invalidateEpisodeForDisplayCache();
        this.firePropertyChange("addedEpisode", null, episode);
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        for (MediaEpisodeNumber episodeNumber : episode.getEpisodeNumbers()) {
            if (this.episodeGroups.contains(episodeNumber.episodeGroup())) continue;
            this.episodeGroups.add(episodeNumber.episodeGroup());
        }
    }

    public List<TvShowEpisode> getDummyEpisodes() {
        return Collections.unmodifiableList(this.dummyEpisodes);
    }

    public void setDummyEpisodes(List<TvShowEpisode> dummyEpisodes) {
        this.dummyEpisodes.clear();
        this.dummyEpisodes.addAll(dummyEpisodes);
        for (TvShowEpisode dummy : this.dummyEpisodes) {
            dummy.setTvShow(this);
        }
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            this.seasons.forEach(TvShowSeason::removeDummyEpisodes);
            for (TvShowEpisode episode : dummyEpisodes) {
                TvShowSeason season = this.getSeasonForEpisode(episode);
                season.addEpisode(episode);
                if (!season.getEpisodesForDisplay().contains(episode)) continue;
                this.firePropertyChange("addedEpisode", null, episode);
            }
        }
        this.dummyEpisodes.sort(TvShowEpisode::compareTo);
        this.invalidateEpisodeForDisplayCache();
        this.firePropertyChange("dummyEpisodes", null, dummyEpisodes);
        this.firePropertyChange("episodeCount", 0, this.episodes.size());
    }

    public void removeDummyEpisode(@NotNull TvShowEpisode episode) {
        if (!episode.isDummy()) {
            return;
        }
        this.removeEpisode(episode);
        this.dummyEpisodes.remove(episode);
        this.saveToDb();
        this.invalidateEpisodeForDisplayCache();
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        if (this.cachedEpisodesForDisplay == null) {
            this.cachedEpisodesForDisplay = Collections.unmodifiableList(TvShowHelpers.getEpisodesForDisplay(this.episodes, this.dummyEpisodes));
        }
        return this.cachedEpisodesForDisplay;
    }

    void invalidateEpisodeForDisplayCache() {
        this.cachedEpisodesForDisplay = null;
    }

    public List<TvShowEpisode> getEpisodesForSeason(int season) {
        ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getSeason() != season) continue;
            eps.add(episode);
        }
        return eps;
    }

    public int getEpisodeCount() {
        return this.episodes.size();
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        if (!TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            return count;
        }
        for (TvShowSeason season : this.seasons) {
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                if (!episode.isDummy() || !TvShowHelpers.shouldAddDummyEpisode(episode)) continue;
                ++count;
            }
        }
        return count;
    }

    private void addToSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.addEpisode(episode);
    }

    private void removeFromSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.removeEpisode(episode);
    }

    public synchronized TvShowSeason getSeasonForEpisode(TvShowEpisode episode) {
        TvShowSeason season = null;
        for (TvShowSeason s : this.seasons) {
            if (s.getSeason() != episode.getSeason()) continue;
            season = s;
            break;
        }
        if (season == null) {
            season = new TvShowSeason(episode.getSeason(), this);
            season.setTitle(this.getSeasonName(episode.getSeason()));
            season.setPlot(this.getSeasonOverview(episode.getSeason()));
            this.addSeason(season);
        }
        return season;
    }

    public int getSeasonCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            if (season.isDummy()) continue;
            ++count;
        }
        return count;
    }

    public TvShowSeason getSeason(int seasonNumber) {
        return this.seasons.parallelStream().filter(season -> season.getSeason() == seasonNumber).findFirst().orElse(null);
    }

    public TvShowSeason getOrCreateSeason(int seasonNumber) {
        TvShowSeason season = this.getSeason(seasonNumber);
        if (season == null) {
            season = new TvShowSeason(seasonNumber, this);
            season.setTitle(this.getSeasonName(seasonNumber));
            season.setPlot(this.getSeasonOverview(seasonNumber));
            this.addSeason(season);
        }
        return season;
    }

    public void removeEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            this.removeFromSeason(episode);
            this.episodes.remove(episode);
            this.invalidateEpisodeForDisplayCache();
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
            if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes() && ListUtils.isEmpty(this.getEpisode(episode.getSeason(), episode.getEpisode()))) {
                for (TvShowEpisode dummy : this.dummyEpisodes) {
                    if (!TvShowHelpers.shouldAddDummyEpisode(dummy) || dummy.getSeason() != episode.getSeason() || dummy.getEpisode() != episode.getEpisode()) continue;
                    this.addToSeason(dummy);
                    this.firePropertyChange("addedEpisode", null, dummy);
                    break;
                }
            }
        } else if (this.dummyEpisodes.contains(episode)) {
            TvShowSeason season = this.getSeasonForEpisode(episode);
            season.removeEpisode(episode);
            this.invalidateEpisodeForDisplayCache();
            EventBus.publishEvent(EventBus.TOPIC_TV_SHOWS, Event.createSaveEvent(season));
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", 0, this.episodes.size());
        }
    }

    public void deleteEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.deleteFilesSafely();
            this.removeFromSeason(episode);
            this.episodes.remove(episode);
            this.invalidateEpisodeForDisplayCache();
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        }
    }

    public void addSeason(TvShowSeason season) {
        if (!this.seasons.contains(season)) {
            int seasonCount = this.seasons.size();
            this.seasons.add(season);
            this.seasons.sort(TvShowSeason::compareTo);
            this.firePropertyChange("addedSeason", null, season);
            this.firePropertyChange("seasonCount", seasonCount, this.seasons.size());
        }
    }

    void removeSeason(TvShowSeason season) {
        int seasonCount = this.seasons.size();
        if (this.seasons.remove(season)) {
            this.firePropertyChange("removedSeason", null, season);
            this.firePropertyChange("seasonCount", seasonCount, this.seasons.size());
        }
    }

    public List<TvShowSeason> getSeasons() {
        return Collections.unmodifiableList(this.seasons);
    }

    public int getTop250() {
        return this.top250;
    }

    public void setTop250(int newValue) {
        int oldValue = this.top250;
        this.top250 = newValue;
        this.firePropertyChange("top250", oldValue, newValue);
    }

    public List<MediaGenres> getGenres() {
        return Collections.unmodifiableList(this.genres);
    }

    public void addToGenres(Collection<MediaGenres> newGenres) {
        LinkedHashSet<MediaGenres> newItems = new LinkedHashSet<MediaGenres>();
        for (MediaGenres genre : ListUtils.nullSafe(newGenres)) {
            if (genre == null || this.genres.contains(genre)) continue;
            newItems.add(genre);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.genres.addAll(newItems);
        this.firePropertyChange("genre", null, newGenres);
        this.firePropertyChange("genresAsString", null, newGenres);
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public void removeAllGenres() {
        this.genres.clear();
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public void setMetadata(MediaMetadata metadata, List<TvShowScraperMetadataConfig> config, boolean overwriteExistingItems) {
        if (this.locked) {
            LOGGER.debug("TV show locked, but setMetadata has been called!");
            return;
        }
        if (metadata == null || metadata.getIds().isEmpty()) {
            LOGGER.warn("Wanted to save empty metadata for TV show '{}'", (Object)this.getTitle());
            return;
        }
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        if (!matchFound && this.isScraped()) {
            String ot = this.getTitle().replaceAll("\\W", "").toLowerCase(Locale.ROOT);
            String nt = metadata.getTitle().replaceAll("\\W", "").toLowerCase(Locale.ROOT);
            if (this.getYear() == metadata.getYear() && ot.equals(nt)) {
                matchFound = true;
            }
        }
        boolean newEntity = false;
        if (this.ids.isEmpty()) {
            matchFound = true;
            newEntity = true;
        }
        if (!matchFound && overwriteExistingItems) {
            this.ids.clear();
        }
        if (overwriteExistingItems) {
            this.setIds(metadata.getIds());
        } else {
            for (Map.Entry entry : metadata.getIds().entrySet()) {
                if (this.ids.containsKey(entry.getKey())) continue;
                this.setId((String)entry.getKey(), entry.getValue());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getTitle()) && (overwriteExistingItems || newEntity || StringUtils.isBlank((CharSequence)this.getTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setTitle(StrgUtils.capitalize(metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.ORIGINAL_TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getOriginalTitle()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getOriginalTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setOriginalTitle(StrgUtils.capitalize(metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.ENGLISH_TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getEnglishTitle()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getEnglishTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setEnglishTitle(StrgUtils.capitalize(metadata.getEnglishTitle()));
            } else {
                this.setEnglishTitle(metadata.getEnglishTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.PLOT) && StringUtils.isNotBlank((CharSequence)metadata.getPlot()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getPlot()))) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(TvShowScraperMetadataConfig.YEAR) && metadata.getYear() > 0 && (overwriteExistingItems || this.getYear() <= 0)) {
            this.setYear(metadata.getYear());
        }
        if (config.contains(TvShowScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            if (matchFound || !overwriteExistingItems) {
                newRatings.putAll(this.getRatings());
            }
            for (MediaRating mediaRating : metadata.getRatings()) {
                if (overwriteExistingItems) {
                    newRatings.put(mediaRating.getId(), mediaRating);
                    continue;
                }
                newRatings.putIfAbsent(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(TvShowScraperMetadataConfig.AIRED) && metadata.getReleaseDate() != null && (overwriteExistingItems || this.getFirstAired() == null)) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.contains(TvShowScraperMetadataConfig.TOP250) && metadata.getTop250() > 0 && (overwriteExistingItems || this.getTop250() <= 0)) {
            this.setTop250(metadata.getTop250());
        }
        if (config.contains(TvShowScraperMetadataConfig.STATUS) && metadata.getStatus() != MediaAiredStatus.UNKNOWN && (overwriteExistingItems || this.getStatus() == null || this.getStatus() == MediaAiredStatus.UNKNOWN)) {
            this.setStatus(metadata.getStatus());
        }
        if (config.contains(TvShowScraperMetadataConfig.RUNTIME) && metadata.getRuntime() > 0 && (overwriteExistingItems || this.getRuntime() <= 0)) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.contains(TvShowScraperMetadataConfig.COUNTRY) && !metadata.getCountries().isEmpty() && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getCountry()))) {
            this.setCountry(StringUtils.join(metadata.getCountries(), (String)", "));
        }
        if (config.contains(TvShowScraperMetadataConfig.STUDIO) && !metadata.getProductionCompanies().isEmpty() && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getProductionCompany()))) {
            this.setProductionCompany(StringUtils.join(metadata.getProductionCompanies(), (String)", "));
        }
        if (config.contains(TvShowScraperMetadataConfig.CERTIFICATION) && (overwriteExistingItems || this.getCertification() == null || this.getCertification() == MediaCertification.UNKNOWN) && !metadata.getCertifications().isEmpty()) {
            if (metadata.getCertifications().size() > 1) {
                if (!metadata.getCertifications().get(0).name().startsWith("US_TV")) {
                    this.setCertification(metadata.getCertifications().get(1));
                } else {
                    this.setCertification(metadata.getCertifications().get(0));
                }
            } else {
                this.setCertification(metadata.getCertifications().get(0));
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.ACTORS)) {
            if (!matchFound || overwriteExistingItems) {
                this.actors.clear();
            }
            this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
        }
        if (config.contains(TvShowScraperMetadataConfig.CREW)) {
            if (!matchFound || overwriteExistingItems) {
                this.crew.clear();
            }
            this.setCrew(metadata.getCastMembers(Person.Type.DIRECTOR));
            this.setCrew(metadata.getCastMembers(Person.Type.WRITER));
            this.setCrew(metadata.getCastMembers(Person.Type.PRODUCER));
            this.setCrew(metadata.getCastMembers(Person.Type.OTHER));
        }
        if (config.contains(TvShowScraperMetadataConfig.GENRES)) {
            if (!matchFound || overwriteExistingItems) {
                this.genres.clear();
            }
            this.setGenres(metadata.getGenres());
        }
        if (config.contains(TvShowScraperMetadataConfig.TAGS)) {
            if (!matchFound || overwriteExistingItems) {
                this.removeAllTags();
            }
            this.addToTags(metadata.getTags());
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_NAMES)) {
            if (!matchFound || overwriteExistingItems) {
                this.seasonNames.clear();
                this.seasons.forEach(season -> season.setTitle(""));
            }
            for (Map.Entry<MediaEpisodeGroup, Map<Integer, String>> entry : metadata.getSeasonNames().entrySet()) {
                if (!this.episodeGroups.contains(entry.getKey())) continue;
                Map seasonNamesForEpisodeGroup = this.seasonNames.computeIfAbsent(entry.getKey().toString(), k -> new HashMap());
                for (Map.Entry<Integer, String> entry2 : entry.getValue().entrySet()) {
                    TvShowSeason season2;
                    Matcher matcher = SEASON_ONLY_PATTERN.matcher(entry2.getValue());
                    if (!matcher.find()) {
                        if (overwriteExistingItems) {
                            seasonNamesForEpisodeGroup.put(entry2.getKey(), entry2.getValue());
                        } else {
                            seasonNamesForEpisodeGroup.putIfAbsent(entry2.getKey(), entry2.getValue());
                        }
                    }
                    if (!entry.getKey().equals(this.episodeGroup) || (season2 = this.getSeason(entry2.getKey())) == null) continue;
                    String seasonName = (String)seasonNamesForEpisodeGroup.get(entry2.getKey());
                    if (StringUtils.isNotBlank((CharSequence)seasonName)) {
                        season2.setTitle(seasonName);
                        continue;
                    }
                    season2.setTitle("");
                }
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_OVERVIEW)) {
            if (!matchFound || overwriteExistingItems) {
                this.seasonOverviews.clear();
                this.seasons.forEach(season -> season.setPlot(""));
            }
            for (Map.Entry<MediaEpisodeGroup, Map<Integer, String>> entry : metadata.getSeasonOverview().entrySet()) {
                if (!this.episodeGroups.contains(entry.getKey())) continue;
                Map seasonOverViewsForEpisodeGroup = this.seasonOverviews.computeIfAbsent(entry.getKey().toString(), k -> new HashMap());
                for (Map.Entry<Integer, String> entry2 : entry.getValue().entrySet()) {
                    TvShowSeason season3;
                    if (overwriteExistingItems) {
                        seasonOverViewsForEpisodeGroup.put(entry2.getKey(), entry2.getValue());
                    } else {
                        seasonOverViewsForEpisodeGroup.putIfAbsent(entry2.getKey(), entry2.getValue());
                    }
                    if (!entry.getKey().equals(this.episodeGroup) || (season3 = this.getSeason(entry2.getKey())) == null) continue;
                    String seasonPlot = (String)seasonOverViewsForEpisodeGroup.get(entry2.getKey());
                    if (StringUtils.isNotBlank((CharSequence)seasonPlot)) {
                        season3.setPlot(seasonPlot);
                        continue;
                    }
                    season3.setPlot("");
                }
            }
        }
        this.writeNFO();
        this.seasons.forEach(TvShowSeason::writeNfo);
        this.saveToDb();
    }

    public void setArtwork(List<MediaArtwork> artwork, List<TvShowScraperMetadataConfig> config, boolean overwrite) {
        TvShowArtworkHelper.setArtwork(this, artwork, config, overwrite);
    }

    public void downloadArtwork(MediaFileType type) {
        TvShowArtworkHelper.downloadArtwork(this, type);
    }

    public void writeNFO() {
        List<TvShowNfoNaming> nfoNamings = TvShowModuleManager.getInstance().getSettings().getNfoFilenames();
        if (!nfoNamings.isEmpty()) {
            TvShowGenericXmlConnector connector = switch (TvShowModuleManager.getInstance().getSettings().getTvShowConnector()) {
                case TvShowConnectors.XBMC, TvShowConnectors.MEDIAPORTAL -> new TvShowToXbmcConnector(this);
                case TvShowConnectors.EMBY -> new TvShowToEmbyConnector(this);
                case TvShowConnectors.JELLYFIN -> new TvShowToJellyfinConnector(this);
                default -> new TvShowToKodiConnector(this);
            };
            connector.write(nfoNamings);
            this.firePropertyChange("hasNfoFile", false, true);
        }
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        return nfos != null && !nfos.isEmpty();
    }

    public Boolean getHasTrailer() {
        if (ListUtils.isNotEmpty(this.trailer)) {
            return true;
        }
        if (!this.getMediaFiles(MediaFileType.TRAILER).isEmpty()) {
            return true;
        }
        return false;
    }

    public Boolean getHasMusicTheme() {
        return !this.getMediaFiles(MediaFileType.THEME).isEmpty();
    }

    public Boolean getHasNote() {
        return StringUtils.isNotBlank((CharSequence)this.note);
    }

    public Boolean getHasSeasonAndEpisodeImages() {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        for (TvShowSeason season : this.seasons) {
            if (season.isDummy() || tvShowList.detectMissingArtwork(season).isEmpty() && season.getHasEpisodeImages().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeMetadata() {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        for (TvShowEpisode episode : this.episodes) {
            if (tvShowList.detectMissingMetadata(episode).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public String getTvdbId() {
        return this.getIdAsString("tvdb");
    }

    public void setTvdbId(String newValue) {
        this.setId("tvdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
    }

    @Override
    public Date getReleaseDate() {
        return this.firstAired;
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return TmmDateFormat.getDateFormat().format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(DateUtils.parseDate(aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public MediaAiredStatus getStatus() {
        return this.status;
    }

    public void setStatus(MediaAiredStatus newValue) {
        MediaAiredStatus oldValue = this.status;
        this.status = newValue;
        this.firePropertyChange("status", (Object)oldValue, (Object)newValue);
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getRuntimeOfEpisodes() {
        int runtime = 0;
        for (TvShowEpisode episode : this.episodes) {
            runtime += episode.getRuntime();
        }
        return runtime;
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void addToActors(Collection<Person> newActors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newActors)) {
            if (person == null || this.actors.contains(person)) continue;
            if (person.getType() != Person.Type.ACTOR && person.getType() != Person.Type.GUEST) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.actors.addAll(newItems);
        this.firePropertyChange("actors", null, this.actors);
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public String getActorsAsString() {
        ArrayList<String> actorNames = new ArrayList<String>();
        for (Person actor : this.actors) {
            actorNames.add(actor.getName());
        }
        return StringUtils.join(actorNames, (String)", ");
    }

    public void removeActors() {
        this.actors.clear();
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        this.mergePersons(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public void addToCrew(Collection<Person> newCrew) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newCrew)) {
            if (person == null || this.crew.contains(person)) continue;
            if (person.getType() == Person.Type.ACTOR) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.crew.addAll(newItems);
        this.firePropertyChange("crew", null, this.getCrew());
    }

    public void removeCrew() {
        this.crew.clear();
        this.firePropertyChange("crew", null, this.getCrew());
    }

    @JsonSetter
    public void setCrew(List<Person> newCrew) {
        this.mergePersons(this.crew, newCrew);
        this.firePropertyChange("crew", null, this.getActors());
    }

    public List<Person> getCrew() {
        return this.crew;
    }

    @Override
    public MediaCertification getCertification() {
        return this.certification;
    }

    public void setCertification(MediaCertification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, (Object)newValue);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = StrgUtils.strip(newValue);
        this.firePropertyChange("country", oldValue, newValue);
    }

    public List<TvShowEpisode> getEpisodesToScrape() {
        ArrayList<TvShowEpisode> episodesToScrape = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getFirstAired() == null && episode.getEpisodeNumbers().isEmpty()) continue;
            episodesToScrape.add(episode);
        }
        return episodesToScrape;
    }

    public boolean isWatched() {
        boolean episodeFound = false;
        boolean watched = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy()) continue;
            episodeFound = true;
            watched = watched && episode.isWatched();
        }
        if (episodeFound) {
            return watched;
        }
        return false;
    }

    public boolean hasEpisodeSubtitles() {
        boolean subtitles = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getHasSubtitles()) continue;
            subtitles = false;
            break;
        }
        return subtitles;
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public List<MediaTrailer> getTrailer() {
        return Collections.unmodifiableList(this.trailer);
    }

    public void addToTrailer(Collection<MediaTrailer> newTrailers) {
        LinkedHashSet<MediaTrailer> newItems = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : ListUtils.nullSafe(newTrailers)) {
            if (trailer == null || this.trailer.contains(trailer)) continue;
            newItems.add(trailer);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.trailer.addAll(newItems);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void setTrailers(List<MediaTrailer> trailers) {
        MediaTrailer preferredTrailer = null;
        this.removeAllTrailers();
        ArrayList<MediaTrailer> newItems = new ArrayList<MediaTrailer>();
        if (TvShowModuleManager.getInstance().getSettings().isUseTrailerPreference()) {
            TrailerQuality desiredQuality = TvShowModuleManager.getInstance().getSettings().getTrailerQuality();
            TrailerSources desiredSource = TrailerSources.YOUTUBE;
            for (MediaTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MediaTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
                sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
                for (MediaTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < TrailerQuality.getTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
            sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MediaTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            newItems.add(preferredTrailer);
        }
        for (MediaTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.isEmpty() && trailer.getUrl().startsWith("http")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            newItems.add(trailer);
        }
        this.addToTrailer(newItems);
        this.mixinLocalTrailers();
    }

    public String getTrailerFilename(@NotNull TvShowTrailerNaming trailer) {
        return FilenameUtils.removeExtension((String)TvShowRenamer.replaceInvalidCharacters(trailer.getFilename(this.getTitle(), "ext")));
    }

    public List<String> getExtraFanartUrls() {
        return this.extraFanartUrls;
    }

    @JsonSetter
    public void setExtraFanartUrls(List<String> extraFanartUrls) {
        this.extraFanartUrls.clear();
        this.extraFanartUrls.addAll(extraFanartUrls);
        this.firePropertyChange("extraFanartUrls", null, this.extraFanartUrls);
    }

    @Override
    public List<MediaFile> getMediaFilesRecursive() {
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(this.getMediaFiles());
        unique.addAll(this.getSeasonMediaFiles());
        unique.addAll(this.getEpisodesMediaFiles());
        return new ArrayList<MediaFile>(unique);
    }

    public List<MediaFile> getEpisodesMediaFiles() {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (TvShowEpisode episode : this.episodes) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (mediaFiles.contains(mf)) continue;
                mediaFiles.add(mf);
            }
        }
        return mediaFiles;
    }

    public List<MediaFile> getSeasonMediaFiles() {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (TvShowSeason season : this.seasons) {
            for (MediaFile mf : season.getMediaFiles()) {
                if (mediaFiles.contains(mf)) continue;
                mediaFiles.add(mf);
            }
        }
        return mediaFiles;
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        if (TvShowModuleManager.getInstance().getSettings().isWriteActorImages()) {
            filesToCache.addAll(this.listActorFiles());
        }
        for (TvShowSeason season : new ArrayList<TvShowSeason>(this.getSeasons())) {
            filesToCache.addAll(season.getImagesToCache());
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            filesToCache.addAll(episode.getImagesToCache());
        }
        return filesToCache;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowModuleManager.getInstance().getTvShowList().persistTvShow(this);
        this.seasons.forEach(TvShowSeason::saveToDb);
    }

    void updateSeasonForEpisode(TvShowEpisode episode) {
        for (TvShowSeason season : this.seasons) {
            if (!season.getEpisodes().contains(episode) || season.getSeason() == episode.getSeason()) continue;
            season.removeEpisode(episode);
        }
        this.addToSeason(episode);
    }

    public List<int[]> getDuplicateEpisodes() {
        ArrayList<Integer> see = new ArrayList<Integer>();
        ArrayList<int[]> dupes = new ArrayList<int[]>();
        for (TvShowEpisode ep : this.episodes) {
            if (ep.getSeason() == -1 || ep.getEpisode() == -1) continue;
            int num = ep.getSeason() * 10000 + ep.getEpisode();
            if (!see.contains(num)) {
                see.add(num);
                continue;
            }
            int[] dupe = new int[]{ep.getSeason(), ep.getEpisode()};
            if (dupes.stream().anyMatch(c -> Arrays.equals(c, dupe))) continue;
            dupes.add(dupe);
        }
        return dupes;
    }

    public List<TvShowEpisode> getEpisode(int season, int episode) {
        if (season == -1 || episode == -1) {
            return Collections.emptyList();
        }
        ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode ep : this.episodes) {
            if (ep.getSeason() != season || ep.getEpisode() != episode) continue;
            eps.add(ep);
        }
        return eps;
    }

    public boolean hasNewlyAddedEpisodes() {
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected float calculateScrapeScore() {
        float score = super.calculateScrapeScore();
        score += (float)Utils.returnOneWhenFilled(this.runtime);
        score += (float)Utils.returnOneWhenFilled(this.firstAired);
        if (this.status != MediaAiredStatus.UNKNOWN) {
            score += 1.0f;
        }
        if (this.certification != MediaCertification.UNKNOWN) {
            score += 1.0f;
        }
        score += (float)Utils.returnOneWhenFilled(this.country);
        for (TvShowSeason season : this.getSeasons()) {
            score += (float)Utils.returnOneWhenFilled(season.getTitle());
            score += (float)Utils.returnOneWhenFilled(season.getArtworkUrls());
        }
        score += (float)Utils.returnOneWhenFilled(this.extraFanartUrls);
        score += (float)Utils.returnOneWhenFilled(this.actors);
        score += (float)Utils.returnOneWhenFilled(this.crew);
        return score += (float)Utils.returnOneWhenFilled(this.trailer);
    }

    public void writeActorImages(boolean overwriteExistingItems) {
        TvShowActorImageFetcherTask task = new TvShowActorImageFetcherTask(this);
        task.setOverwriteExistingItems(overwriteExistingItems);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    private List<MediaFile> listActorFiles() {
        if (!Files.exists(this.getPathNIO().resolve(".actors"), new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public boolean deleteFilesSafely() {
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public MediaFile getMainVideoFile() {
        return MediaFile.EMPTY_MEDIAFILE;
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return "";
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return "";
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return 0.0f;
    }

    @Override
    public Float getMediaInfoAspectRatio2() {
        return null;
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return "";
    }

    @Override
    public double getMediaInfoFrameRate() {
        return 0.0;
    }

    @Override
    public String getVideoHDRFormat() {
        return "";
    }

    @Override
    public boolean isVideoIn3D() {
        return false;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioChannelsDot() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioChannelDotList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getMediaInfoSubtitleCodecList() {
        return Collections.emptyList();
    }

    @Override
    public List<MediaStreamInfo.Flags> getMediaInfoSubtitleTypeList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return "";
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return 0;
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return MediaSource.UNKNOWN;
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            filesize += episode.getVideoFilesize();
        }
        return filesize;
    }

    @Override
    public long getTotalFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            filesize += episode.getTotalFilesize();
        }
        return filesize;
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.firePropertyChange("trailer", false, true);
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.firePropertyChange("trailer", true, false);
        }
    }

    private void mixinLocalTrailers() {
        for (int i = this.trailer.size() - 1; i >= 0; --i) {
            MediaTrailer mediaTrailer = this.trailer.get(i);
            if (!"downloaded".equalsIgnoreCase(mediaTrailer.getProvider())) continue;
            this.trailer.remove(i);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.TRAILER)) {
            LOGGER.debug("adding local trailer {}", (Object)mf.getFilename());
            MediaTrailer mt = new MediaTrailer();
            mt.setName(mf.getFilename());
            mt.setProvider("downloaded");
            mt.setQuality(mf.getVideoFormat());
            mt.setInNfo(false);
            mt.setUrl(mf.getFile().toUri().toString());
            this.trailer.add(0, mt);
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    public Object getValueForMetadata(TvShowScraperMetadataConfig metadataConfig) {
        switch (metadataConfig) {
            case ID: {
                return this.getIds();
            }
            case TITLE: {
                return this.getTitle();
            }
            case ORIGINAL_TITLE: {
                return this.getOriginalTitle();
            }
            case ENGLISH_TITLE: {
                return this.getEnglishTitle();
            }
            case PLOT: {
                return this.getPlot();
            }
            case YEAR: {
                return this.getYear();
            }
            case AIRED: {
                return this.getFirstAired();
            }
            case RATING: {
                return this.getRatings();
            }
            case RUNTIME: {
                return this.getRuntime();
            }
            case CERTIFICATION: {
                return this.getCertification();
            }
            case GENRES: {
                return this.getGenres();
            }
            case COUNTRY: {
                return this.getCountry();
            }
            case STUDIO: {
                return this.getProductionCompany();
            }
            case STATUS: {
                return this.getStatus();
            }
            case TAGS: {
                return this.getTags();
            }
            case TRAILER: {
                return this.getTrailer();
            }
            case ACTORS: {
                return this.getActors();
            }
            case POSTER: {
                return this.getMediaFiles(MediaFileType.POSTER);
            }
            case FANART: {
                return this.getMediaFiles(MediaFileType.FANART);
            }
            case BANNER: {
                return this.getMediaFiles(MediaFileType.BANNER);
            }
            case CLEARART: {
                return this.getMediaFiles(MediaFileType.CLEARART);
            }
            case THUMB: {
                return this.getMediaFiles(MediaFileType.THUMB);
            }
            case CLEARLOGO: {
                return this.getMediaFiles(MediaFileType.CLEARLOGO);
            }
            case DISCART: {
                return this.getMediaFiles(MediaFileType.DISC);
            }
            case KEYART: {
                return this.getMediaFiles(MediaFileType.KEYART);
            }
            case EXTRAFANART: {
                return this.getMediaFiles(MediaFileType.EXTRAFANART);
            }
            case CHARACTERART: {
                return this.getMediaFiles(MediaFileType.CHARACTERART);
            }
            case SEASON_NAMES: {
                for (TvShowSeason season : this.seasons) {
                    if (season.getSeason() < 0 || season.isDummy() || season.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || !StringUtils.isBlank((CharSequence)season.getTitle())) continue;
                    return null;
                }
                return "all seasonnames found";
            }
            case SEASON_OVERVIEW: {
                for (TvShowSeason season : this.seasons) {
                    if (season.getSeason() < 0 || season.isDummy() || season.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || !StringUtils.isBlank((CharSequence)season.getPlot())) continue;
                    return null;
                }
                return "all seasonoverviews found";
            }
            case SEASON_POSTER: {
                return this.getMediaFiles(MediaFileType.SEASON_POSTER);
            }
            case SEASON_FANART: {
                return this.getMediaFiles(MediaFileType.SEASON_FANART);
            }
            case SEASON_BANNER: {
                return this.getMediaFiles(MediaFileType.SEASON_BANNER);
            }
            case SEASON_THUMB: {
                return this.getMediaFiles(MediaFileType.SEASON_THUMB);
            }
            case THEME: {
                return this.getMediaFiles(MediaFileType.THEME);
            }
        }
        return null;
    }

    @JsonAnySetter
    public void setUnknownFields(String property, Object value) {
        if (StringUtils.isBlank((CharSequence)property) || value == null) {
            return;
        }
        switch (property) {
            case "seasonTitleMap": {
                if (!(value instanceof Map)) break;
                Map seasonTitleMap = (Map)value;
                for (Map.Entry entry : seasonTitleMap.entrySet()) {
                    Object v;
                    int seasonNumber = TvUtils.parseInt(entry.getKey());
                    if (seasonNumber <= -1 || !((v = entry.getValue()) instanceof String)) continue;
                    String seasonTitle = (String)v;
                    TvShowSeason season = this.getOrCreateSeason(seasonNumber);
                    season.setTitle(seasonTitle);
                }
                break;
            }
            case "seasonPosterUrlMap": {
                if (!(value instanceof Map)) break;
                Map seasonPosterUrlMap = (Map)value;
                for (Map.Entry entry : seasonPosterUrlMap.entrySet()) {
                    Object season;
                    int seasonNumber = TvUtils.parseInt(entry.getKey());
                    if (seasonNumber <= -1 || !((season = entry.getValue()) instanceof String)) continue;
                    String seasonPosterUrl = (String)season;
                    season = this.getOrCreateSeason(seasonNumber);
                    ((MediaEntity)season).setArtworkUrl(seasonPosterUrl, MediaFileType.SEASON_POSTER);
                }
                break;
            }
            case "seasonBannerUrlMap": {
                if (!(value instanceof Map)) break;
                Map seasonBannerUrlMap = (Map)value;
                for (Map.Entry entry : seasonBannerUrlMap.entrySet()) {
                    Object season;
                    int seasonNumber = TvUtils.parseInt(entry.getKey());
                    if (seasonNumber <= -1 || !((season = entry.getValue()) instanceof String)) continue;
                    String seasonBannerUrl = (String)season;
                    season = this.getOrCreateSeason(seasonNumber);
                    ((MediaEntity)season).setArtworkUrl(seasonBannerUrl, MediaFileType.SEASON_BANNER);
                }
                break;
            }
            case "seasonThumbUrlMap": {
                if (!(value instanceof Map)) break;
                Map seasonThumbUrlMap = (Map)value;
                for (Map.Entry entry : seasonThumbUrlMap.entrySet()) {
                    Object season;
                    int seasonNumber = TvUtils.parseInt(entry.getKey());
                    if (seasonNumber <= -1 || !((season = entry.getValue()) instanceof String)) continue;
                    String seasonThumbUrl = (String)season;
                    season = this.getOrCreateSeason(seasonNumber);
                    ((MediaEntity)season).setArtworkUrl(seasonThumbUrl, MediaFileType.SEASON_THUMB);
                }
                break;
            }
            case "seasonFanartUrlMap": {
                if (!(value instanceof Map)) break;
                Map seasonFanartUrlMap = (Map)value;
                for (Map.Entry entry : seasonFanartUrlMap.entrySet()) {
                    Object season;
                    int seasonNumber = TvUtils.parseInt(entry.getKey());
                    if (seasonNumber <= -1 || !((season = entry.getValue()) instanceof String)) continue;
                    String seasonFanartUrl = (String)season;
                    season = this.getOrCreateSeason(seasonNumber);
                    ((MediaEntity)season).setArtworkUrl(seasonFanartUrl, MediaFileType.SEASON_FANART);
                }
                break;
            }
            case "producers": 
            case "writers": 
            case "directors": {
                if (!(value instanceof List)) break;
                List crewList = (List)value;
                for (Person person : UpgradeTasks.upgradeCrew(crewList)) {
                    if (this.crew.contains(person)) continue;
                    this.crew.add(person);
                }
                this.crew.sort(Comparator.comparingInt(o -> o.getType().ordinal()));
            }
        }
    }
}

