/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tasks.MediaEntityActorImageFetcherTask;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowActorImageFetcherTask
extends MediaEntityActorImageFetcherTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowActorImageFetcherTask.class);

    public TvShowActorImageFetcherTask(TvShow tvShow) {
        this.mediaEntity = tvShow;
        this.persons = new HashSet<Person>(tvShow.getActors());
        for (TvShowEpisode episode : tvShow.getEpisodes()) {
            this.persons.addAll(episode.getActors());
        }
    }

    public TvShowActorImageFetcherTask(TvShowEpisode episode) {
        this.mediaEntity = episode.getTvShow();
        this.cleanup = false;
        this.persons = new HashSet<Person>(episode.getActors());
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

