/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiCallback;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.ConnectionListener;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;

public class JavaConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaConnectionManager.class);
    private final List<ConnectionListener> connectionListener = new ArrayList<ConnectionListener>();
    private final Map<String, CallRequest<?>> mCallRequests = new ConcurrentHashMap();
    private final Map<String, AbstractCall<?>> mCalls = new ConcurrentHashMap();
    private boolean isConnected = false;
    private Socket socket;
    private BufferedWriter bufferedWriter;
    private HostConfig hostConfig;
    private static final ObjectMapper OM = new ObjectMapper();

    public <T> JavaConnectionManager call(AbstractCall<T> abstractCall, ApiCallback<T> apiCallback) {
        if (this.isConnected) {
            this.mCallRequests.put(abstractCall.getId(), new CallRequest<T>(abstractCall, apiCallback));
            this.mCalls.put(abstractCall.getId(), abstractCall);
            this.writeSocket(abstractCall);
        } else {
            LOGGER.error("Cannot send call - NOT connected!");
        }
        return this;
    }

    public void registerConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener != null) {
            this.connectionListener.add(connectionListener);
        }
    }

    public void unregisterConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener != null) {
            this.connectionListener.remove(connectionListener);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(HostConfig hostConfig) throws ApiException {
        if (this.isConnected) {
            this.disconnect();
        }
        this.hostConfig = hostConfig;
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(hostConfig.mAddress, hostConfig.mTcpPort);
            this.socket = new Socket();
            this.socket.setSoTimeout(0);
            this.socket.connect(inetSocketAddress);
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.startParsingIncomingMessages();
            this.isConnected = true;
            this.notifyConnected();
        }
        catch (UnknownHostException unknownHostException) {
            this.disconnect();
            throw new ApiException(7, unknownHostException.getMessage(), unknownHostException);
        }
        catch (ConnectException connectException) {
            this.disconnect();
            throw new ApiException(5, connectException.getMessage(), connectException);
        }
        catch (IOException iOException) {
            this.disconnect();
            throw new ApiException(2, iOException.getMessage(), iOException);
        }
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public void reconnect() throws ApiException {
        this.connect(this.hostConfig);
    }

    private void startParsingIncomingMessages() {
        new Thread(){

            @Override
            public void run() {
                JsonFactory jsonFactory = OM.getJsonFactory();
                try {
                    JsonNode jsonNode;
                    JsonParser jsonParser = jsonFactory.createJsonParser(JavaConnectionManager.this.socket.getInputStream());
                    while ((jsonNode = (JsonNode)OM.readTree(jsonParser)) != null) {
                        JavaConnectionManager.this.notifyClients(jsonNode);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Error parsing incoming message: {}", (Object)exception.getMessage());
                    JavaConnectionManager.this.disconnect();
                }
            }
        }.start();
    }

    public void disconnect() {
        if (this.isConnected) {
            try {
                if (this.bufferedWriter != null) {
                    this.bufferedWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.notifyDisconnect();
            this.isConnected = false;
        }
    }

    private void notifyClients(JsonNode jsonNode) {
        if (jsonNode.has("error")) {
            String string = jsonNode.get("id").asText();
            if (this.mCallRequests.containsKey(string)) {
                CallRequest<?> callRequest = this.mCallRequests.remove(string);
                this.mCalls.remove(string);
                ApiCallback apiCallback = callRequest.mCallback;
                AbstractCall abstractCall = callRequest.mCall;
                JsonNode jsonNode2 = jsonNode.get("error");
                int n = -1;
                if (jsonNode2.has("code")) {
                    n = jsonNode2.get("code").asInt();
                }
                String string2 = "";
                if (jsonNode2.has("message")) {
                    string2 = jsonNode2.get("message").asText();
                }
                String string3 = "";
                if (jsonNode2.has("data")) {
                    string3 = jsonNode2.get("data").toString();
                }
                apiCallback.onError(n, string2, string3);
            } else {
                LOGGER.error("No such request for id {}: ERROR={}", (Object)string, (Object)jsonNode.toString());
            }
        } else if (jsonNode.has("id")) {
            String string = jsonNode.get("id").asText();
            if (this.mCallRequests.containsKey(string)) {
                CallRequest<?> callRequest = this.mCallRequests.remove(string);
                this.mCalls.remove(string);
                ApiCallback apiCallback = callRequest.mCallback;
                AbstractCall abstractCall = callRequest.mCall;
                abstractCall.setResponse(jsonNode);
                apiCallback.onResponse(abstractCall);
            } else {
                LOGGER.error("No such request for id {}: DATA={}", (Object)string, (Object)jsonNode.toString());
            }
        } else {
            AbstractEvent abstractEvent = AbstractEvent.parse((ObjectNode)jsonNode);
            if (abstractEvent != null) {
                for (ConnectionListener connectionListener : this.connectionListener) {
                    connectionListener.notificationReceived(abstractEvent);
                }
            }
        }
    }

    private void writeSocket(AbstractCall<?> abstractCall) {
        String string = abstractCall.getRequest().toString();
        LOGGER.debug("CALL: {}", (Object)string);
        try {
            this.bufferedWriter.write(string + "\n");
            this.bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void notifyDisconnect() {
        for (ConnectionListener connectionListener : this.connectionListener) {
            connectionListener.disconnected();
        }
    }

    private void notifyConnected() {
        for (ConnectionListener connectionListener : this.connectionListener) {
            connectionListener.connected();
        }
    }

    private static class CallRequest<T> {
        private final AbstractCall<T> mCall;
        private final ApiCallback<T> mCallback;

        public CallRequest(AbstractCall<T> abstractCall, ApiCallback<T> apiCallback) {
            this.mCall = abstractCall;
            this.mCallback = apiCallback;
        }

        public void update(AbstractCall<?> abstractCall) {
            this.mCall.copyResponse(abstractCall);
        }

        public void respond() {
            this.mCallback.onResponse(this.mCall);
        }

        public void error(int n, String string, String string2) {
            this.mCallback.onError(n, string, string2);
        }
    }
}

