/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.id;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.tinymediamanager.library.bluray.id.Id;

public class IdReader {
    private static String iso646String(byte[] byArray) {
        try {
            return new String(byArray, "ISO646-US");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static String readISO646String(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        return IdReader.iso646String(byArray);
    }

    public Id readId(DataInputStream dataInputStream) throws IOException {
        Id id = new Id();
        String string = IdReader.readISO646String(dataInputStream, 4);
        if (!"BDID".equals(string)) {
            throw new RuntimeException("ID mismatch: " + string);
        }
        String string2 = IdReader.readISO646String(dataInputStream, 4);
        id.setVersion(string2);
        dataInputStream.skipBytes(32);
        int n = dataInputStream.readInt();
        id.setOrgId(n);
        byte[] byArray = new byte[16];
        dataInputStream.read(byArray, 0, 16);
        id.setDiscId(byArray);
        return id;
    }

    public Id readXml(InputStream inputStream) throws JAXBException {
        String string = Id.class.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        JAXBContext jAXBContext = JAXBContext.newInstance((String)string2);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        return (Id)unmarshaller.unmarshal(inputStream);
    }
}

