/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@XmlType(propOrder={"refToPlayItemID", "refToSecondaryVideoStreamID", "pipTimelineType", "isLumaKey", "isTrickPlaying", "upperLimitLumaKey"})
public class MetadataBlockHeader {
    private int refToPlayItemID;
    private int refToSecondaryVideoStreamID;
    private PIPTimelineType pipTimelineType;
    private boolean isLumaKey;
    private boolean isTrickPlaying;
    private Integer upperLimitLumaKey;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.setRefToPlayItemID(dataInputStream.readUnsignedShort());
        this.setRefToSecondaryVideoStreamID(dataInputStream.readUnsignedByte());
        dataInputStream.skipBytes(1);
        int n = dataInputStream.readUnsignedShort();
        int n2 = (n & 0xF000) >> 12;
        PIPTimelineType[] pIPTimelineTypeArray = PIPTimelineType.values();
        for (int i = 0; i < pIPTimelineTypeArray.length; ++i) {
            if (pIPTimelineTypeArray[i].ordinal() != n2) continue;
            this.setPipTimelineType(pIPTimelineTypeArray[i]);
            break;
        }
        this.setIsLumaKey((n & 0x800) != 0);
        this.setIsTrickPlaying((n & 0x400) != 0);
        n = dataInputStream.readUnsignedShort();
        if (this.getIsLumaKey()) {
            this.setUpperLimitLumaKey(n & 0xFF);
        }
        dataInputStream.skipBytes(2);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getRefToPlayItemID());
        dataOutputStream.writeByte(this.getRefToSecondaryVideoStreamID());
        dataOutputStream.writeByte(0);
        int n = this.getPipTimelineType().ordinal() << 12;
        if (this.getIsLumaKey()) {
            n |= 0x800;
        }
        if (this.getIsTrickPlaying()) {
            n |= 0x400;
        }
        dataOutputStream.writeShort(n);
        n = 0;
        if (this.getIsLumaKey()) {
            n = this.getUpperLimitLumaKey();
        }
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(0);
    }

    public int getRefToPlayItemID() {
        return this.refToPlayItemID;
    }

    public void setRefToPlayItemID(int n) {
        this.refToPlayItemID = n;
    }

    public int getRefToSecondaryVideoStreamID() {
        return this.refToSecondaryVideoStreamID;
    }

    public void setRefToSecondaryVideoStreamID(int n) {
        this.refToSecondaryVideoStreamID = n;
    }

    public PIPTimelineType getPipTimelineType() {
        return this.pipTimelineType;
    }

    public void setPipTimelineType(PIPTimelineType pIPTimelineType) {
        this.pipTimelineType = pIPTimelineType;
    }

    public boolean getIsLumaKey() {
        return this.isLumaKey;
    }

    public void setIsLumaKey(boolean bl) {
        this.isLumaKey = bl;
    }

    public boolean getIsTrickPlaying() {
        return this.isTrickPlaying;
    }

    public void setIsTrickPlaying(boolean bl) {
        this.isTrickPlaying = bl;
    }

    public Integer getUpperLimitLumaKey() {
        return this.upperLimitLumaKey;
    }

    public void setUpperLimitLumaKey(Integer n) {
        this.upperLimitLumaKey = n;
    }

    static enum PIPTimelineType {
        reserved,
        SYNCHRONOUS,
        ASYNC_SUBPATH,
        ASYNC_PLAYITEM;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

