/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.license.TmmFeature;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.RingBuffer;

public abstract class AniDbMetadataProvider
implements TmmFeature {
    public static final String ID = "anidb";
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDbMetadataProvider.class);
    private static final RingBuffer<Long> connectionCounter = new RingBuffer(1);
    protected final HashMap<Integer, List<AniDBShow>> showsForLookup = new HashMap();
    protected final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    protected abstract MediaProviderInfo createMediaProviderInfo();

    protected void buildTitleHashMap() throws ScrapeException {
        block14: {
            OnDiskCachedUrl animeList;
            Pattern pattern = Pattern.compile("^(?!#)(\\d+)[|](\\d)[|]([\\w-]+)[|](.+)$");
            try {
                animeList = new OnDiskCachedUrl("http://anidb.net/api/anime-titles.dat.gz", 2, TimeUnit.DAYS);
            }
            catch (Exception e) {
                LOGGER.debug("Error getting AniDB index: {}", (Object)e.getMessage());
                throw new ScrapeException("Error getting AniDB index: " + e.getMessage());
            }
            try {
                Scanner scanner = new Scanner((InputStream)new GZIPInputStream(animeList.getInputStream()), StandardCharsets.UTF_8);
                block12: while (true) {
                    while (scanner.hasNextLine()) {
                        Matcher matcher = pattern.matcher(scanner.nextLine());
                        if (!matcher.matches()) continue;
                        try {
                            AniDBShow show = new AniDBShow();
                            show.aniDbId = Integer.parseInt(matcher.group(1));
                            show.language = matcher.group(3);
                            show.title = matcher.group(4);
                            List shows = this.showsForLookup.computeIfAbsent(show.aniDbId, k -> new ArrayList());
                            shows.add(show);
                            continue block12;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("could not parse anidb id - '{}'", (Object)e.getMessage());
                        }
                    }
                    break block14;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    scanner.close();
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOGGER.debug("Error getting AniDB index: {}", (Object)e.getMessage());
                throw new ScrapeException("Error getting AniDB index: " + e.getMessage());
            }
        }
    }

    @Nullable
    protected Document requestAnimeDocument(MediaSearchAndScrapeOptions options) throws ScrapeException {
        Document doc;
        String id = options.getIdAsString(this.providerInfo.getId());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{ID});
        }
        try {
            AniDbMetadataProvider.trackConnections();
            OnDiskCachedUrl url = new OnDiskCachedUrl("http://api.anidb.net:9001/httpapi?request=anime&" + this.getApiKey() + "aid=" + id, 1, TimeUnit.DAYS);
            try (InputStream is = url.getInputStream();){
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser().settings(ParseSettings.htmlDefault));
            }
            Element error = doc.getElementsByTag("error").first();
            if (error != null) {
                int httpCode = MetadataUtil.parseInt(error.attr("code"), 500);
                String message = error.ownText();
                throw new HttpException(httpCode, message);
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
        return doc;
    }

    protected static synchronized void trackConnections() throws InterruptedException {
        long oldestConnection;
        long currentTime = System.currentTimeMillis();
        if (connectionCounter.count() == connectionCounter.maxSize() && (oldestConnection = connectionCounter.getTailItem().longValue()) > currentTime - 2000L) {
            LOGGER.debug("connection limit reached, throttling...");
            do {
                AniDbMetadataProvider.class.wait(2000L - (currentTime - oldestConnection));
            } while (oldestConnection > (currentTime = System.currentTimeMillis()) - 2000L);
        }
        currentTime = System.currentTimeMillis();
        connectionCounter.add(currentTime);
    }

    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    static class AniDBShow {
        public int aniDbId;
        public String language;
        public String title;

        AniDBShow() {
        }
    }
}

