/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.LocaleUtils;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.util.LanguageUtils;

public enum MediaLanguages {
    af,
    ar,
    az,
    be,
    bg,
    bm,
    bn,
    bs,
    ca,
    ch,
    cs,
    cy,
    da,
    de,
    ee,
    el,
    en,
    es,
    es_MX,
    et,
    eu,
    fa,
    fi,
    fr,
    fr_CA,
    ff,
    ga,
    gl,
    ha,
    he,
    hi,
    hr,
    hu,
    hy,
    id,
    is,
    it,
    ja,
    ka,
    kk,
    ko,
    la,
    lv,
    lt,
    mk,
    ms,
    mt,
    nb,
    nl,
    no,
    pa,
    pl,
    ps,
    pt,
    pt_BR,
    rn,
    ro,
    ru,
    rw,
    si,
    sk,
    sl,
    so,
    sq,
    sr,
    sv,
    sw,
    ta,
    te,
    th,
    tr,
    uk,
    ur,
    uz,
    vi,
    wo,
    yo,
    yue,
    zh,
    zh_CN,
    zh_HK,
    zh_SG,
    zh_TW,
    zu,
    none("-");

    private final String title;
    private final String displayTitle;
    private static final Map<String, MediaLanguages> lookup;

    private MediaLanguages() {
        Locale locale = Utils.getLocaleFromLanguage(this.name());
        this.title = locale.getDisplayLanguage();
        this.displayTitle = locale.getDisplayName();
    }

    private MediaLanguages(String title) {
        this.title = title;
        this.displayTitle = title;
    }

    private static Map<String, MediaLanguages> prepareLookup() {
        HashMap<String, MediaLanguages> mlMap = new HashMap<String, MediaLanguages>();
        for (MediaLanguages lang : MediaLanguages.values()) {
            if (!lang.getTitle().isBlank()) {
                mlMap.put(lang.getTitle(), lang);
                mlMap.put(lang.toString(), lang);
            }
            mlMap.put(lang.name(), lang);
        }
        return mlMap;
    }

    public static MediaLanguages get(String title) {
        MediaLanguages entry = lookup.get(title);
        if (entry == null) {
            entry = lookup.get(LanguageUtils.getIso2LanguageFromLocalizedString(title));
        }
        if (entry == null) {
            entry = en;
        }
        return entry;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLanguage() {
        if (this == none) {
            return "";
        }
        int delim = this.name().indexOf("_");
        if (delim == -1) {
            return this.name();
        }
        return this.name().substring(0, delim);
    }

    public String toString() {
        return this.displayTitle + " (" + this.name() + ")";
    }

    public Locale toLocale() {
        if (this == none) {
            return null;
        }
        return LocaleUtils.toLocale((String)this.name());
    }

    public static MediaLanguages[] valuesSorted() {
        TreeMap<String, MediaLanguages> map = new TreeMap<String, MediaLanguages>(String.CASE_INSENSITIVE_ORDER);
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (ml == none) continue;
            map.put(ml.toString(), ml);
        }
        return map.values().toArray(new MediaLanguages[0]);
    }

    public static MediaLanguages[] allValuesSorted() {
        TreeMap<String, MediaLanguages> map = new TreeMap<String, MediaLanguages>(String.CASE_INSENSITIVE_ORDER);
        for (MediaLanguages ml : MediaLanguages.values()) {
            map.put(ml.toString(), ml);
        }
        return map.values().toArray(new MediaLanguages[0]);
    }

    static {
        lookup = MediaLanguages.prepareLookup();
    }
}

