/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.brotli.BrotliInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.scraper.http.ProxySettings;
import org.tinymediamanager.scraper.http.TmmHttp429RetryInterceptor;
import org.tinymediamanager.scraper.http.TmmHttpHeaderLoggerInterceptor;
import org.tinymediamanager.scraper.http.TmmHttpLoggingInterceptor;

public class TmmHttpClient {
    private static final Cache CACHE = new Cache(Paths.get(Globals.CACHE_FOLDER, "http").toFile(), 0x1900000L);
    private static OkHttpClient client = TmmHttpClient.createHttpClient();

    private TmmHttpClient() {
        throw new IllegalAccessError();
    }

    private static OkHttpClient createHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new TmmHttp429RetryInterceptor());
        builder.addInterceptor((Interceptor)new TmmHttpLoggingInterceptor());
        builder.addInterceptor((Interceptor)BrotliInterceptor.INSTANCE);
        builder.addInterceptor((Interceptor)new TmmHttpHeaderLoggerInterceptor());
        builder.connectionPool(new ConnectionPool(5, 5000L, TimeUnit.MILLISECONDS));
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(60L, TimeUnit.SECONDS);
        if (ProxySettings.INSTANCE.useProxy()) {
            TmmHttpClient.setProxy(builder);
        }
        if (Boolean.parseBoolean(System.getProperty("tmm.trustallcerts", "false"))) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public static OkHttpClient.Builder newBuilder() {
        return TmmHttpClient.newBuilder(false);
    }

    public static OkHttpClient.Builder newBuilder(Cache ownCache) {
        OkHttpClient.Builder builder = client.newBuilder();
        builder = builder.cache(ownCache);
        return builder;
    }

    public static OkHttpClient.Builder newBuilder(boolean withCache) {
        OkHttpClient.Builder builder = client.newBuilder();
        if (withCache) {
            builder = builder.cache(CACHE);
        }
        return builder;
    }

    public static OkHttpClient.Builder newBuilderWithForcedCache(int timeToLive, TimeUnit timeUnit) {
        return TmmHttpClient.newBuilder(true).addNetworkInterceptor(TmmHttpClient.provideCacheInterceptor(timeToLive, timeUnit));
    }

    public static OkHttpClient.Builder newBuilderWithForcedCache(Cache ownCache, int timeToLive, TimeUnit timeUnit) {
        return TmmHttpClient.newBuilder(ownCache).addNetworkInterceptor(TmmHttpClient.provideCacheInterceptor(timeToLive, timeUnit));
    }

    private static Interceptor provideCacheInterceptor(int timeToLive, TimeUnit timeUnit) {
        return chain -> {
            Response response = chain.proceed(chain.request());
            String head = response.header("cache-control");
            if (head == null || head.contains("no-store") || head.contains("no-cache") || head.contains("must-revalidate") || head.contains("max-age=0")) {
                CacheControl cacheControl = new CacheControl.Builder().maxAge(timeToLive, timeUnit).build();
                return response.newBuilder().removeHeader("x-amz-cf-id").removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", cacheControl.toString()).build();
            }
            return response;
        };
    }

    public static OkHttpClient getHttpClient() {
        return client;
    }

    public static void recreateHttpClient() {
        client = TmmHttpClient.createHttpClient();
    }

    private static void setProxy(OkHttpClient.Builder builder) {
        Proxy proxyHost;
        if (ProxySettings.INSTANCE.getPort() > 0) {
            proxyHost = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(ProxySettings.INSTANCE.getHost(), ProxySettings.INSTANCE.getPort()));
        } else if (StringUtils.isNotBlank((CharSequence)ProxySettings.INSTANCE.getHost())) {
            proxyHost = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(ProxySettings.INSTANCE.getHost(), 80));
        } else {
            return;
        }
        builder.proxy(proxyHost);
        if (StringUtils.isNotBlank((CharSequence)ProxySettings.INSTANCE.getUsername()) && StringUtils.isNotBlank((CharSequence)ProxySettings.INSTANCE.getPassword())) {
            builder.proxyAuthenticator((route, response) -> {
                String credential = Credentials.basic((String)ProxySettings.INSTANCE.getUsername(), (String)ProxySettings.INSTANCE.getPassword());
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            });
        }
    }

    public static void clearCache() throws IOException {
        CACHE.evictAll();
    }
}

