/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles_com;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.opensubtitles_com.model.LoginRequest;
import org.tinymediamanager.scraper.opensubtitles_com.model.LoginResponse;
import org.tinymediamanager.scraper.opensubtitles_com.service.Opensubtitles2Service;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class OpenSubtitlesComController {
    private static final String DEFAULT_API_URL = "https://api.opensubtitles.com";
    private static final String PARAM_API_KEY = "Api-Key";
    private static final String PARAM_AUTHORIZATION = "Authorization";
    private Retrofit restAdapter;
    private String apiKey = "";
    private String apiUrl = "https://api.opensubtitles.com";
    private String username;
    private String password;
    private String token;

    OpenSubtitlesComController() {
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setUsername(String username) {
        if (StringUtils.compare((String)username, (String)this.username) != 0) {
            this.token = "";
        }
        this.username = username;
    }

    public void setPassword(String password) {
        if (StringUtils.compare((String)password, (String)this.password) != 0) {
            this.token = "";
        }
        this.password = password;
    }

    public void authenticate() throws ScrapeException {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.username, this.password}) && StringUtils.isBlank((CharSequence)this.token)) {
            LoginRequest loginRequest = new LoginRequest();
            loginRequest.username = this.username;
            loginRequest.password = this.password;
            try {
                Response response = this.getService().login(loginRequest).execute();
                if (!response.isSuccessful() || response.body() == null || ((LoginResponse)response.body()).status != 200) {
                    int code = response.body() != null ? ((LoginResponse)response.body()).status : response.code();
                    throw new HttpException(code, "Could not logon to Opensubtitles.com");
                }
                LoginResponse resp = (LoginResponse)response.body();
                this.token = resp.token;
                this.apiUrl = resp.baseUrl;
                if (!this.apiUrl.startsWith("http")) {
                    this.apiUrl = "https://" + this.apiUrl;
                }
                this.restAdapter = null;
            }
            catch (IOException e) {
                throw new ScrapeException(e);
            }
        }
    }

    protected Retrofit getRestAdapter() {
        if (this.restAdapter == null) {
            Retrofit.Builder builder = new Retrofit.Builder();
            builder.baseUrl(this.apiUrl);
            builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create()));
            builder.client(TmmHttpClient.newBuilder().addInterceptor(chain -> {
                Request original = chain.request();
                Request.Builder request = original.newBuilder().method(original.method(), original.body());
                request.addHeader(PARAM_API_KEY, this.apiKey);
                if (StringUtils.isNotBlank((CharSequence)this.token)) {
                    request.addHeader(PARAM_AUTHORIZATION, "Bearer " + this.token);
                }
                request.header("User-Agent", "tinyMediaManager v5");
                return chain.proceed(request.build());
            }).build());
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    Opensubtitles2Service getService() {
        return (Opensubtitles2Service)this.getRestAdapter().create(Opensubtitles2Service.class);
    }
}

