/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.subdl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowSubtitleProvider;
import org.tinymediamanager.scraper.subdl.SubdlSubtitleProvider;
import org.tinymediamanager.scraper.subdl.model.SubdlModel;
import org.tinymediamanager.scraper.subdl.model.Subtitles;
import org.tinymediamanager.scraper.subdl.model.Type;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class SubdlTvShowSubtitleProvider
extends SubdlSubtitleProvider
implements ITvShowSubtitleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubdlTvShowSubtitleProvider.class);

    @Override
    public List<SubtitleSearchResult> search(SubtitleSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        LOGGER.debug("search() {}", (Object)options);
        ArrayList<SubtitleSearchResult> results = new ArrayList<SubtitleSearchResult>();
        SubdlModel searchResult = null;
        if (!(options.getIds().get("tvShowIds") instanceof Map)) {
            throw new NothingFoundException();
        }
        Map tvShowIds = (Map)options.getIds().get("tvShowIds");
        String tvShowImdbId = String.valueOf(tvShowIds.get("imdb"));
        if (MediaIdUtil.isValidImdbId(tvShowImdbId)) {
            searchResult = this.getSubdlFromImdbID(tvShowImdbId, options.getLanguage().name(), options.getSeason(), options.getEpisode());
        }
        int tvShowTmdbId = MetadataUtil.parseInt(String.valueOf(tvShowIds.get("tmdb")), 0);
        if (!(searchResult != null && searchResult.status || tvShowTmdbId <= 0)) {
            searchResult = this.getSubdlFromTmdbID(tvShowTmdbId, options.getLanguage().name(), options.getSeason(), options.getEpisode());
        }
        if (searchResult == null || !searchResult.status) {
            searchResult = this.getSubdlFromQuery(options.getSearchQuery(), options.getLanguage().name());
        }
        if (searchResult == null || !searchResult.status) {
            return results;
        }
        for (Subtitles sub : searchResult.subtitles) {
            if (options.getSeason() != sub.season || options.getEpisode() != sub.episode) continue;
            SubtitleSearchResult subtitle = new SubtitleSearchResult(options.getImdbId());
            subtitle.setReleaseName(sub.releaseName);
            subtitle.setTitle(sub.name.replace("SUBDL.com::", ""));
            subtitle.setHearingImpaired(sub.hi);
            subtitle.setUrl(() -> "https://dl.subdl.com" + sub.url);
            results.add(subtitle);
        }
        return results;
    }

    @Nullable
    private SubdlModel getSubdlFromQuery(String query, String language) {
        try {
            return this.processResponse(this.controller.getResultsForQuery(query, language.toUpperCase(Locale.ROOT), Type.TV));
        }
        catch (Exception e) {
            LOGGER.warn("could not get response from subdl - '{}'", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private SubdlModel getSubdlFromImdbID(String imdbID, String language, int season, int episode) {
        try {
            return this.processResponse(this.controller.getResultsFromImdbId(imdbID, language.toUpperCase(Locale.ROOT), Type.TV, season, episode));
        }
        catch (Exception e) {
            LOGGER.warn("could not get response from subdl - '{}'", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private SubdlModel getSubdlFromTmdbID(int tmdbId, String language, int season, int episode) {
        try {
            return this.processResponse(this.controller.getResultsFromTmdbId(tmdbId, language.toUpperCase(Locale.ROOT), Type.TV, season, episode));
        }
        catch (Exception e) {
            LOGGER.warn("could not get response from subdl - '{}'", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected String getSubId() {
        return "tvshow_subtitle";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && StringUtils.isNotBlank((CharSequence)this.providerInfo.getConfig().getValue("apiKey"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }
}

