/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.jupnp.http.Headers;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.transport.impl.DatagramProcessorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.upnp.Upnp;

public class TmmDatagramProcessor
extends DatagramProcessorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramProcessorImpl.class);

    public IncomingDatagramMessage read(InetAddress receivedOnAddress, DatagramPacket datagram) throws UnsupportedDataException {
        if (Upnp.getInstance().getBlockedIps().contains(datagram.getAddress().getHostAddress())) {
            throw new UnsupportedDataException("IP on blocklist - skipping");
        }
        try {
            LOGGER.debug("Reading message data from: {}:{}\n{}\n{}\n{}", new Object[]{datagram.getAddress(), datagram.getPort(), "===================================== DATAGRAM BEGIN ============================================", new String(datagram.getData()).trim(), "-===================================== DATAGRAM END ============================================="});
            ByteArrayInputStream is = new ByteArrayInputStream(datagram.getData());
            String[] startLine = Headers.readLine((ByteArrayInputStream)is).split(" ");
            if (startLine[0].startsWith("HTTP/1.")) {
                return this.readResponseMessage(receivedOnAddress, datagram, is, Integer.parseInt(startLine[1]), startLine[2], startLine[0]);
            }
            return this.readRequestMessage(receivedOnAddress, datagram, is, startLine[0], startLine[2]);
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Could not parse headers: " + ex, (Throwable)ex, (Object)datagram.getData());
        }
    }

    public DatagramPacket write(OutgoingDatagramMessage message) throws UnsupportedDataException {
        StringBuilder statusLine = new StringBuilder();
        UpnpOperation operation = message.getOperation();
        if (operation instanceof UpnpRequest) {
            UpnpRequest requestOperation = (UpnpRequest)operation;
            statusLine.append(requestOperation.getHttpMethodName()).append(" * ");
            statusLine.append("HTTP/1.").append(operation.getHttpMinorVersion()).append("\r\n");
        } else if (operation instanceof UpnpResponse) {
            UpnpResponse responseOperation = (UpnpResponse)operation;
            statusLine.append("HTTP/1.").append(operation.getHttpMinorVersion()).append(" ");
            statusLine.append(responseOperation.getStatusCode()).append(" ").append(responseOperation.getStatusMessage());
            statusLine.append("\r\n");
        } else {
            throw new UnsupportedDataException("Message operation is not request or response, don't know how to process: " + message);
        }
        StringBuilder messageData = new StringBuilder();
        messageData.append((CharSequence)statusLine);
        messageData.append(message.getHeaders().toString()).append("\r\n");
        LOGGER.debug("Writing message data for {} to: {}:{}\n{}\n{}\n{}", new Object[]{message, message.getDestinationAddress(), message.getDestinationPort(), "===================================== DATAGRAM BEGIN ============================================", messageData.toString().substring(0, messageData.length() - 2), "-===================================== DATAGRAM END ============================================="});
        byte[] data = messageData.toString().getBytes(StandardCharsets.US_ASCII);
        LOGGER.trace("Writing new datagram packet with " + data.length + " bytes for: " + message);
        return new DatagramPacket(data, data.length, message.getDestinationAddress(), message.getDestinationPort());
    }
}

