/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.upnp.Upnp;

public class TmmStreamClientImpl
implements StreamClient<StreamClientConfigurationImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmStreamClientImpl.class);
    protected final StreamClientConfigurationImpl configuration;
    protected final OkHttpClient client;

    public TmmStreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            X509TrustManager trustManager = (X509TrustManager)trustAllCerts[0];
            this.client = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(configuration.getTimeoutSeconds())).readTimeout(Duration.ofSeconds(configuration.getTimeoutSeconds())).sslSocketFactory(sslSocketFactory, trustManager).hostnameVerifier((hostname, session) -> true).build();
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create SSL context for OkHttp client", (Throwable)e);
        }
    }

    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) {
        if (Upnp.getInstance().getBlockedIps().contains(requestMessage.getUri().getHost())) {
            LOGGER.trace("IP on blocklist - skipping");
            return null;
        }
        UpnpRequest requestOperation = (UpnpRequest)requestMessage.getOperation();
        LOGGER.trace("Preparing HTTP request message with method '{}': {}", (Object)requestOperation.getHttpMethodName(), (Object)requestMessage);
        try {
            RequestBody body = null;
            if (requestMessage.getBody() != null) {
                if (requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
                    body = RequestBody.create((String)requestMessage.getBodyString(), (MediaType)MediaType.parse((String)"text/plain"));
                } else if (requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES)) {
                    body = RequestBody.create((byte[])requestMessage.getBodyBytes(), null);
                }
            }
            Request.Builder request = new Request.Builder().url(requestOperation.getURI().toURL()).method(requestOperation.getHttpMethodName(), body).addHeader(UpnpHeader.Type.USER_AGENT.getHttpName(), this.configuration.getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
            requestMessage.getHeaders().forEach((name, values) -> {
                for (String value : values) {
                    request.addHeader(name, value);
                }
            });
            LOGGER.debug("Sending HTTP request: {}", (Object)requestMessage);
            Response response = this.client.newCall(request.build()).execute();
            if (response.isSuccessful()) {
                LOGGER.debug("HTTP response successful: {}", (Object)response);
                UpnpResponse responseOperation = new UpnpResponse(response.code(), response.message());
                LOGGER.debug("Received response: {}", (Object)responseOperation);
                StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
                responseMessage.setHeaders(new UpnpHeaders(response.headers().toMultimap()));
                ResponseBody responseBody = response.body();
                if (responseBody != null && responseBody.contentLength() != 0L && responseMessage.isContentTypeMissingOrText()) {
                    LOGGER.debug("Response contains textual entity body, converting then setting string on message");
                    responseMessage.setBodyCharacters(responseBody.bytes());
                } else if (responseBody != null && responseBody.contentLength() > 0L) {
                    LOGGER.debug("Response contains binary entity body, setting bytes on message");
                    responseMessage.setBody(UpnpMessage.BodyType.BYTES, (Object)responseBody.bytes());
                } else {
                    LOGGER.debug("Response did not contain entity body");
                }
                LOGGER.debug("Response message complete: {}", (Object)responseMessage);
                return responseMessage;
            }
            LOGGER.debug("HTTP response failed: {}", (Object)response);
            if (response.code() == 401) {
                LOGGER.info("We've got a 401 - let's ignore that host from now on! ({})", (Object)requestMessage.getUri().getHost());
                Upnp.getInstance().addBlockedIp(requestMessage.getUri().getHost());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("HTTP request failed: {} - {}", (Object)requestMessage, (Object)ex.getMessage());
        }
        return null;
    }

    public void stop() {
    }
}

