/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;

public abstract class AbstractTmmUIModule
implements ITmmUIModule {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    protected final Map<Class<?>, Action> actionMap = new HashMap();
    protected Action searchAction = null;
    protected Action editAction = null;
    protected Action updateAction = null;
    protected Action renameAction = null;
    protected JPopupMenu popupMenu;
    protected JPopupMenu updatePopupMenu;
    protected JPopupMenu searchPopupMenu;
    protected JPopupMenu editPopupMenu;
    protected JPopupMenu renamePopupMenu;

    protected AbstractTmmUIModule() {
    }

    protected Action createAndRegisterAction(Class<? extends Action> actionClass) {
        Action action = this.actionMap.get(actionClass);
        if (action == null) {
            try {
                action = actionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.actionMap.put(actionClass, action);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return action;
    }

    protected void registerAccelerators() {
        for (Map.Entry<Class<?>, Action> entry : this.actionMap.entrySet()) {
            try {
                KeyStroke keyStroke = (KeyStroke)entry.getValue().getValue("AcceleratorKey");
                if (keyStroke == null) continue;
                String actionMapKey = "action" + entry.getKey().getName();
                this.getTabPanel().getInputMap(2).put(keyStroke, actionMapKey);
                this.getTabPanel().getActionMap().put(actionMapKey, entry.getValue());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Action getSearchAction() {
        return this.searchAction;
    }

    @Override
    public JPopupMenu getSearchMenu() {
        return this.searchPopupMenu;
    }

    @Override
    public Action getEditAction() {
        return this.editAction;
    }

    @Override
    public JPopupMenu getEditMenu() {
        return this.editPopupMenu;
    }

    @Override
    public Action getUpdateAction() {
        return this.updateAction;
    }

    @Override
    public JPopupMenu getUpdateMenu() {
        return this.updatePopupMenu;
    }

    @Override
    public Action getRenameAction() {
        return this.renameAction;
    }

    @Override
    public JPopupMenu getRenameMenu() {
        return this.renamePopupMenu;
    }

    @Override
    public Icon getSearchButtonIcon() {
        return IconManager.TOOLBAR_REFRESH;
    }

    @Override
    public Icon getSearchButtonHoverIcon() {
        return IconManager.TOOLBAR_REFRESH_HOVER;
    }
}

