/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.components.label.ImageLabel;

public class ArtworkDragAndDropListener
implements DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtworkDragAndDropListener.class);
    private final ImageLabel imageLabel;

    public ArtworkDragAndDropListener(ImageLabel imageLabel) {
        this.imageLabel = imageLabel;
    }

    private File[] getImageFiles(DropTargetDragEvent dtde) {
        try {
            return this.getImageFilesFromTransferData(dtde.getTransferable());
        }
        catch (Throwable t) {
            LOGGER.error("Failed to retrieve image files from drag-and-drop event: ", t);
            return new File[0];
        }
    }

    private File[] getImageFiles(DropTargetDropEvent dtde) {
        try {
            return this.getImageFilesFromTransferData(dtde.getTransferable());
        }
        catch (Throwable t) {
            LOGGER.error("Failed to retrieve image files from drag-and-drop event: ", t);
            return new File[0];
        }
    }

    private File[] getImageFilesFromTransferData(Transferable transferable) {
        try {
            Object transferData = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (!(transferData instanceof List)) {
                return new File[0];
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Image files", "jpg", "jpeg", "png", "bmp", "gif", "tbn", "webp");
            File[] imageFiles = (File[])((List)transferData).stream().filter(file -> filter.accept((File)file) && Utils.isRegularFile(file.getAbsoluteFile().toPath())).toArray(File[]::new);
            return imageFiles;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to retrieve image files from drag-and-drop event: ", t);
            return new File[0];
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
        File[] imageFiles = this.getImageFiles(dtde);
        if (imageFiles.length > 0) {
            // empty if block
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
        File[] imageFiles = this.getImageFiles(dtde);
        if (imageFiles.length > 0) {
            // empty if block
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            dtde.acceptDrop(1);
            File[] imageFiles = this.getImageFiles(dtde);
            if (imageFiles.length == 0) {
                return;
            }
            File file = imageFiles[0];
            String fileName = file.getAbsolutePath();
            this.imageLabel.clearImage();
            this.imageLabel.setImageUrl("file:/" + fileName);
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while processing the dropped file: ", t);
        }
    }
}

