/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.PersonEditorPanel;

public class PersonTable
extends TmmEditorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonTable.class);
    private final EventList<Person> personEventList;
    private String addTitle = "";
    private String editTitle = "";
    private Person.Type[] allowedEditorTypes = Person.Type.values();

    public PersonTable(EventList<Person> personEventList) {
        this.personEventList = personEventList;
        this.setModel((TableModel)((Object)new TmmTableModel<Person>((EventList<Person>)GlazedListsSwing.swingThreadProxyList(personEventList), new PersonTableFormat())));
        this.adjustColumnPreferredWidths(3);
    }

    private Person getPerson(int row) {
        int index = this.convertRowIndexToModel(row);
        return (Person)this.personEventList.get(index);
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        Person person = this.getPerson(row);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(this.getEditTitle());
        popupPanel.setOnCloseHandler(() -> this.onPersonChanged(person));
        PersonEditorPanel personEditorPanel = new PersonEditorPanel(person, this.allowedEditorTypes);
        popupPanel.setContent(personEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private String getEditTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.editTitle)) {
            return this.editTitle;
        }
        return TmmResourceBundle.getString("cast.edit");
    }

    public void onPersonChanged(Person person) {
    }

    @Override
    protected boolean isLinkCell(int row, int column) {
        return this.isEditorColumn(column) || this.isProfileColumn(column) && this.isProfileAvailable(row) || this.isImageColumn(column) && this.isImageAvailable(row);
    }

    private boolean isProfileColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "profileUrl".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private boolean isProfileAvailable(int row) {
        return PersonTable.hasProfileUrl(this.getPerson(row));
    }

    private boolean isImageColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "imageUrl".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private boolean isImageAvailable(int row) {
        return StringUtils.isNotBlank((CharSequence)this.getPerson(row).getThumbUrl());
    }

    @Override
    protected void linkClicked(int row, int column, MouseEvent mou) {
        Person person = this.getPerson(row);
        if (person != null) {
            JPopupMenu popupMenu = new JPopupMenu();
            if (this.isProfileColumn(column)) {
                int tvmazeId;
                int tvdbId;
                int tmdbId;
                String imdbId;
                JMenuItem item;
                int linksAdded = 0;
                String profileUrl = person.getProfileUrl();
                if (StringUtils.isNotBlank((CharSequence)profileUrl)) {
                    String title = profileUrl.contains("imdb.com") ? "IMDb" : (profileUrl.contains("themoviedb.org") ? "TMDB" : (profileUrl.contains("wikipedia.org") ? "Wikipedia" : (profileUrl.contains("tvmaze.com") ? "TVmaze" : (profileUrl.contains("thetvdb.com") ? "TVDB" : TmmResourceBundle.getString("profile.url")))));
                    item = new JMenuItem(title, IconManager.LINK);
                    item.addActionListener(e -> this.browseUrl(profileUrl));
                    popupMenu.add(item);
                    ++linksAdded;
                }
                if (StringUtils.isNotBlank((CharSequence)(imdbId = person.getIdAsString("imdb"))) && !profileUrl.contains("imdb.com")) {
                    item = new JMenuItem("IMDb", IconManager.LINK);
                    item.addActionListener(e -> this.browseUrl("https://www.imdb.com/de/name/" + imdbId));
                    popupMenu.add(item);
                    ++linksAdded;
                }
                if ((tmdbId = person.getIdAsInt("tmdb")) > 0 && !profileUrl.contains("themoviedb.org")) {
                    JMenuItem item2 = new JMenuItem("TMDB", IconManager.LINK);
                    item2.addActionListener(e -> this.browseUrl("https://www.themoviedb.org/person/" + tmdbId));
                    popupMenu.add(item2);
                    ++linksAdded;
                }
                if ((tvdbId = person.getIdAsInt("tvdb")) > 0 && !profileUrl.contains("thetvdb.com")) {
                    JMenuItem item3 = new JMenuItem("TVDB", IconManager.LINK);
                    item3.addActionListener(e -> this.browseUrl("https://thetvdb.com/people/" + tvdbId));
                    popupMenu.add(item3);
                    ++linksAdded;
                }
                if ((tvmazeId = person.getIdAsInt("tvmaze")) > 0 && !profileUrl.contains("tvmaze.com")) {
                    JMenuItem item4 = new JMenuItem("TVmaze", IconManager.LINK);
                    item4.addActionListener(e -> this.browseUrl("https://www.tvmaze.com/people/" + tvmazeId));
                    popupMenu.add(item4);
                    ++linksAdded;
                }
                if (linksAdded == 1) {
                    JMenuItem firstItem = (JMenuItem)popupMenu.getComponent(0);
                    firstItem.doClick();
                } else if (linksAdded > 1) {
                    popupMenu.show(mou.getComponent(), mou.getX(), mou.getY());
                }
            } else if (this.isImageColumn(column) && StringUtils.isNotBlank((CharSequence)person.getThumbUrl())) {
                ImagePreviewDialog dialog = new ImagePreviewDialog(person.getThumbUrl());
                dialog.setVisible(true);
            }
        }
    }

    private void browseUrl(String url) {
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception ex) {
            LOGGER.error("Could not open url in browser - '{}'", (Object)ex.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
        }
    }

    public void setAddTitle(String addTitle) {
        this.addTitle = addTitle;
    }

    private String getAddTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.addTitle)) {
            return this.addTitle;
        }
        return TmmResourceBundle.getString("cast.add");
    }

    public void setEditTitle(String editTitle) {
        this.editTitle = editTitle;
    }

    public void setAllowedEditorTypes(Person.Type[] newValues) {
        this.allowedEditorTypes = newValues;
    }

    public List<Person> getSelectedPersons() {
        ArrayList<Person> selectedPersons = new ArrayList<Person>();
        for (int i : this.getSelectedRows()) {
            Person person = this.getPerson(i);
            if (person == null) continue;
            selectedPersons.add(person);
        }
        return selectedPersons;
    }

    public void addPerson() {
        String defaultRole;
        String defaultName;
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        if (this.allowedEditorTypes != null && this.allowedEditorTypes.length == 1) {
            Person.Type personType = this.allowedEditorTypes[0];
            switch (personType) {
                case ACTOR: 
                case GUEST: {
                    defaultName = TmmResourceBundle.getString("cast.actor.unknown");
                    defaultRole = TmmResourceBundle.getString("cast.role.unknown");
                    break;
                }
                case DIRECTOR: {
                    defaultName = TmmResourceBundle.getString("director.name.unknown");
                    defaultRole = "Director";
                    break;
                }
                case WRITER: {
                    defaultName = TmmResourceBundle.getString("writer.name.unknown");
                    defaultRole = "Writer";
                    break;
                }
                case PRODUCER: {
                    defaultName = TmmResourceBundle.getString("producer.name.unknown");
                    defaultRole = TmmResourceBundle.getString("producer.role.unknown");
                    break;
                }
                default: {
                    defaultName = "";
                    defaultRole = "";
                    break;
                }
            }
        } else {
            defaultName = "";
            defaultRole = "";
        }
        Person person = new Person(Person.Type.OTHER, defaultName, defaultRole);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(this.getAddTitle());
        popupPanel.setOnCloseHandler(() -> {
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(defaultName)) {
                if (person.getRole().equals(defaultRole)) {
                    person.setRole("");
                }
                this.personEventList.add(0, (Object)person);
            }
        });
        PersonEditorPanel personEditorPanel = new PersonEditorPanel(person, this.allowedEditorTypes);
        popupPanel.setContent(personEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private static boolean hasProfileUrl(Person person) {
        if (person != null) {
            if (StringUtils.isNotBlank((CharSequence)person.getThumbUrl())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)person.getIdAsString("imdb"))) {
                return true;
            }
            if (person.getIdAsInt("tmdb") > 0) {
                return true;
            }
            if (person.getIdAsInt("tvdb") > 0) {
                return true;
            }
            if (person.getIdAsInt("tvmaze") > 0) {
                return true;
            }
        }
        return false;
    }

    private static class PersonTableFormat
    extends TmmTableFormat<Person> {
        private PersonTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.name"), "name", Person::getName, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.role"), "role", Person::getRole, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("image.url"), "imageUrl", person -> {
                if (StringUtils.isNotBlank((CharSequence)person.getThumbUrl())) {
                    return IconManager.TABLE_OK;
                }
                return IconManager.TABLE_NOT_OK;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.IMAGES);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("profile.url"), "profileUrl", person -> {
                if (PersonTable.hasProfileUrl(person)) {
                    return IconManager.TABLE_OK;
                }
                return IconManager.TABLE_NOT_OK;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.IDCARD);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }
}

