/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.JViewport;

class TmmViewport
extends JViewport {
    private final JTable fTable;

    TmmViewport(JTable table, int[] cols) {
        this.fTable = table;
        ArrayList<Integer> colsWoRightGrid = new ArrayList<Integer>(cols.length);
        for (int i : cols) {
            colsWoRightGrid.add(i);
        }
        this.fTable.putClientProperty("borderNotToDraw", colsWoRightGrid);
        this.setOpaque(false);
        this.initListeners();
    }

    private void initListeners() {
        PropertyChangeListener listener = this.createTableColumnWidthListener();
        for (int i = 0; i < this.fTable.getColumnModel().getColumnCount(); ++i) {
            this.fTable.getColumnModel().getColumn(i).addPropertyChangeListener(listener);
        }
    }

    private PropertyChangeListener createTableColumnWidthListener() {
        return evt -> this.repaint();
    }

    @Override
    public void setViewPosition(Point p) {
        super.setViewPosition(p);
        this.repaint();
    }
}

