/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public abstract class PostProcessDialog
extends TmmDialog {
    protected PostProcess process = null;
    protected final JTextField tfProcessName;
    protected final JTextField tfPath;
    protected final JTextArea tfCommand;

    public PostProcessDialog() {
        super(TmmResourceBundle.getString("Settings.addpostprocess"), "addPostProcess");
        this.setName("PostProcessDialog");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][grow][]", "[][][100lp:n]"));
        JLabel lblProcessName = new JLabel(TmmResourceBundle.getString("Settings.processname"));
        panelContent.add((Component)lblProcessName, "cell 0 0,alignx right");
        this.tfProcessName = new JTextField();
        this.tfProcessName.setColumns(20);
        panelContent.add((Component)this.tfProcessName, "cell 1 0,growx");
        JLabel lblPath = new JLabel(TmmResourceBundle.getString("metatag.path"));
        panelContent.add((Component)lblPath, "cell 0 1, alignx right");
        this.tfPath = new JTextField();
        this.tfPath.setColumns(30);
        panelContent.add((Component)this.tfPath, "cell 1 1,growx");
        JButton btnChoosePostProcessPath = new JButton(TmmResourceBundle.getString("Button.choosefile"));
        panelContent.add((Component)btnChoosePostProcessPath, "cell 2 1");
        btnChoosePostProcessPath.addActionListener(e -> {
            String path = TmmProperties.getInstance().getProperty("postprocess.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("Button.choosefile"), path, null);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfPath.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("postprocess.path", file.getParent().toString());
            }
        });
        JLabel lblCommand = new JLabel(TmmResourceBundle.getString("Settings.commandname"));
        panelContent.add((Component)lblCommand, "cell 0 2,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        panelContent.add((Component)scrollPane, "cell 1 2,grow");
        this.tfCommand = new JTextArea();
        scrollPane.setViewportView(this.tfCommand);
        this.tfCommand.setColumns(30);
        this.tfCommand.setLineWrap(true);
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setAction(new CancelAction());
        this.addButton(btnCancel);
        JButton btnSave = new JButton(TmmResourceBundle.getString("Button.save"));
        btnSave.setAction(new SaveAction());
        this.addDefaultButton(btnSave);
    }

    public void setProcess(PostProcess process) {
        this.process = process;
        if (this.process != null) {
            this.tfProcessName.setText(process.getName());
            this.tfPath.setText(process.getPath());
            this.tfCommand.setText(process.getCommand());
        }
    }

    protected abstract void save();

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PostProcessDialog.this.setVisible(false);
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PostProcessDialog.this.save();
        }
    }
}

