/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.images;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;

public class LoadingSpinner
implements Icon {
    private int width;
    private int height;
    private Area[] ticker;
    private Area[] shadow;
    private Timer timer;
    private JComponent parent;
    private int barsCount = 14;
    private Color baseColorLow = new Color(80, 80, 80);
    private Color baseColorHigh = new Color(120, 120, 120);
    private Color customColorLow = null;
    private Color customColorHigh = null;
    private boolean active = false;

    public LoadingSpinner(int size, JComponent parent) {
        this.width = this.height = size;
        this.parent = parent;
        this.ticker = this.buildTicker();
        this.shadow = this.buildShadow();
        int fps = 10;
        this.timer = new Timer(1000 / fps, new TimerTickActionListener());
    }

    public void setCustomColors(Color low, Color high) {
        this.customColorLow = low;
        this.customColorHigh = high;
        this.parent.repaint();
    }

    public void resetCustomColor() {
        this.customColorLow = null;
        this.customColorHigh = null;
        this.parent.repaint();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(x, y);
        g2.setColor(new Color(255, 255, 255, 0));
        g2.fillRect(0, 0, this.width - 1, this.height - 1);
        if (this.active) {
            int i;
            for (i = 0; i < this.shadow.length; ++i) {
                int alpha = (int)(150.0f * (1.0f - (float)i / ((float)this.shadow.length * 2.0f / 3.0f)));
                if (alpha < 0) {
                    alpha = 0;
                }
                Color shadowColor = new Color(0, 0, 0, alpha);
                g2.setColor(shadowColor);
                g2.fill(this.shadow[i]);
            }
            for (i = 0; i < this.ticker.length; ++i) {
                float factor = 1.0f - 0.5f * (float)i / (float)(this.ticker.length - 1);
                int alpha = (int)(255.0f * (1.0f - (float)i / ((float)this.ticker.length * 2.0f / 3.0f)));
                if (alpha < 0) {
                    alpha = 0;
                }
                Color[] colors = this.calculateColors(factor, alpha);
                g2.setPaint(new GradientPaint((float)this.width / 2.0f, 0.0f, colors[1], (float)this.width / 2.0f, this.height, colors[0]));
                g2.fill(this.ticker[i]);
            }
        } else {
            Color shadowColor = new Color(0, 0, 0, 150);
            g2.setColor(shadowColor);
            for (Area aShadow : this.shadow) {
                g2.fill(aShadow);
            }
            for (Area aTicker : this.ticker) {
                Color[] colors = this.calculateColors(1.0f, 255);
                g2.setPaint(new GradientPaint((float)this.width / 2.0f, 0.0f, colors[1], (float)this.width / 2.0f, this.height, colors[0]));
                g2.fill(aTicker);
            }
        }
    }

    private Color[] calculateColors(float factor, int alpha) {
        Color high;
        Color low;
        Color[] colors = new Color[2];
        if (factor == 1.0f && alpha == 255) {
            if (this.customColorLow != null && this.customColorHigh != null) {
                low = this.customColorLow;
                high = this.customColorHigh;
            } else {
                low = this.baseColorLow;
                high = this.baseColorHigh;
            }
        } else if (this.customColorLow != null && this.customColorHigh != null) {
            low = new Color((int)((float)this.customColorLow.getRed() * factor), (int)((float)this.customColorLow.getGreen() * factor), (int)((float)this.customColorLow.getBlue() * factor), alpha);
            high = new Color((int)((float)this.customColorHigh.getRed() * factor), (int)((float)this.customColorHigh.getGreen() * factor), (int)((float)this.customColorHigh.getBlue() * factor), alpha);
        } else {
            low = new Color((int)((float)this.baseColorLow.getRed() * factor), (int)((float)this.baseColorLow.getGreen() * factor), (int)((float)this.baseColorLow.getBlue() * factor), alpha);
            high = new Color((int)((float)this.baseColorHigh.getRed() * factor), (int)((float)this.baseColorHigh.getGreen() * factor), (int)((float)this.baseColorHigh.getBlue() * factor), alpha);
        }
        colors[0] = low;
        colors[1] = high;
        return colors;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void start() {
        if (!this.active) {
            this.active = true;
            this.timer.start();
        }
    }

    public void stop() {
        if (this.active) {
            this.active = false;
            this.timer.stop();
        }
        this.parent.repaint();
    }

    private Area[] buildTicker() {
        Area[] ticker = new Area[this.barsCount];
        Point2D.Double center = new Point2D.Double((double)this.width / 2.0, (float)this.height / 2.0f);
        double fixedAngle = Math.PI * 2 / (double)this.barsCount;
        for (double i = 0.0; i < (double)this.barsCount; i += 1.0) {
            Area primitive = new Area(new RoundRectangle2D.Double(0.0, 0.0, (float)this.width / 4.0f, (float)this.height / 15.0f, (float)this.height / 15.0f, (float)this.height / 15.0f));
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance((float)this.width / 10.0f, (float)(-this.height) / 15.0f);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            ticker[(int)i] = primitive;
        }
        return ticker;
    }

    private Area[] buildShadow() {
        Area[] shadow = new Area[this.barsCount];
        Point2D.Double center = new Point2D.Double((double)this.width / 2.0, (float)this.height / 2.0f);
        double fixedAngle = Math.PI * 2 / (double)this.barsCount;
        for (double i = 0.0; i < (double)this.barsCount; i += 1.0) {
            Area primitive = new Area(new RoundRectangle2D.Double(0.0, 0.0, (float)this.width / 4.0f, (float)this.height / 15.0f, (float)this.height / 15.0f, (float)this.height / 15.0f));
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY() + 1.0);
            AffineTransform toBorder = AffineTransform.getTranslateInstance((float)this.width / 10.0f, (float)(-this.height) / 15.0f);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY() + 1.0);
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            shadow[(int)i] = primitive;
        }
        return shadow;
    }

    private class TimerTickActionListener
    implements ActionListener {
        private TimerTickActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point2D.Double center = new Point2D.Double((double)LoadingSpinner.this.width / 2.0, (double)LoadingSpinner.this.height / 2.0);
            double fixedIncrement = Math.PI * 2 / (double)LoadingSpinner.this.barsCount;
            AffineTransform toCircle = AffineTransform.getRotateInstance(fixedIncrement, center.getX(), center.getY());
            for (Area aTicker : LoadingSpinner.this.ticker) {
                aTicker.transform(toCircle);
            }
            toCircle = AffineTransform.getRotateInstance(fixedIncrement, center.getX(), center.getY() + 1.0);
            for (Area aShadow : LoadingSpinner.this.shadow) {
                aShadow.transform(toCircle);
            }
            LoadingSpinner.this.parent.repaint();
        }
    }
}

