/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieUndoRenameAction
extends TmmAction {
    public MovieUndoRenameAction() {
        this.putValue("SmallIcon", IconManager.UNDO);
        this.putValue("Name", TmmResourceBundle.getString("movie.rename.undo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rename.undo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        for (Movie movie : selectedMovies) {
            MovieRenamer.undoRename(movie);
        }
    }
}

