/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractTextMovieUIFilter;

public class MovieVideoFilenameFilter
extends AbstractTextMovieUIFilter {
    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.videofilename"));
    }

    @Override
    public String getId() {
        return "movieVideoFilename";
    }

    @Override
    public boolean accept(Movie movie) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            Matcher matcher;
            for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                Matcher matcher2 = this.filterPattern.matcher(StrgUtils.normalizeString(mediaFile.getFilename()));
                if (!matcher2.find()) continue;
                return true;
            }
            if (StringUtils.isNotEmpty((CharSequence)movie.getOriginalFilename()) && (matcher = this.filterPattern.matcher(StrgUtils.normalizeString(movie.getOriginalFilename()))).find()) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

