/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.textfield.LinkTextArea;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPaneHTML;
import org.tinymediamanager.ui.moviesets.MovieInMovieSetTableFormat;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;

public class MovieSetInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetInformationPanel.class);
    private final MovieSetSelectionModel selectionModel;
    private final EventList<Movie> movieEventList;
    private JLabel lblMovieSetName;
    private ImageLabel lblFanart;
    private JLabel lblFanartSize;
    private ImageLabel lblPoster;
    private JLabel lblPosterSize;
    private JTextPane taOverview;
    private JLabel lblYear;
    private LinkLabel lblTmdbid;
    private LinkTextArea taArtworkPath1;
    private LinkTextArea taArtworkPath2;
    private JTextPane tpNote;

    public MovieSetInformationPanel(MovieSetSelectionModel setSelectionModel) {
        this.selectionModel = setSelectionModel;
        this.movieEventList = new ObservableElementList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)new BasicEventList()), GlazedLists.beanConnector(Movie.class));
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSetSelectionModel.class) {
                return;
            }
            MovieSet movieSet = this.selectionModel.getSelectedMovieSet();
            if ("selectedMovieSet".equals(property) || "addedMovie".equals(property) || "removedMovie".equals(property)) {
                this.movieEventList.clear();
                this.movieEventList.addAll(movieSet.getMovies());
                this.lblYear.setText(movieSet.getYears());
            }
            if ("selectedMovieSet".equals(property) || "mediaFiles".equals(property)) {
                this.setArtworkPath(movieSet);
            }
            if ("selectedMovieSet".equals(property) || "poster".equals(property)) {
                this.setPoster(movieSet);
            }
            if ("selectedMovieSet".equals(property) || "fanart".equals(property)) {
                this.setFanart(movieSet);
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.lblTmdbid.addActionListener(arg0 -> {
            String url = "https://www.themoviedb.org/collection/" + this.lblTmdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("Could not open '{}' in browser - '{}'", (Object)url, (Object)e.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.taArtworkPath1.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.taArtworkPath1.getText())) {
                Path path = Paths.get(this.taArtworkPath1.getText(), new String[0]);
                TmmUIHelper.openFolder(path);
            }
        });
        this.taArtworkPath2.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.taArtworkPath2.getText())) {
                Path path = Paths.get(this.taArtworkPath2.getText(), new String[0]);
                TmmUIHelper.openFolder(path);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[n:100lp:20%, grow][300lp:300lp,grow 350]", "[grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0,grow");
        this.lblPoster = new ImageLabel(false, false, true);
        this.lblPoster.setDesiredAspectRatio(0.6666667f);
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblPoster);
        this.lblPoster.enableLightbox();
        this.lblPosterSize = new JLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        panelLeft.add(this.lblPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblFanart = new ImageLabel(false, false, true);
        this.lblFanart.setDesiredAspectRatio(1.7777778f);
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblFanart);
        this.lblFanart.enableLightbox();
        this.lblFanartSize = new JLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        panelLeft.add(this.lblFanartSize);
        panelLeft.add(Box.createVerticalStrut(20));
        JPanel panelRight = new JPanel();
        this.add((Component)panelRight, "cell 1 0,grow");
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[450lp,grow]", "[][shrink 0][][shrink 0][][10%:25%,grow][shrink 0][][shrink 0][20lp!][][20%:35%,grow]"));
        this.lblMovieSetName = new JLabel("");
        panelRight.add((Component)this.lblMovieSetName, "cell 0 0, wmin 0");
        TmmFontHelper.changeFont(this.lblMovieSetName, 1.33, 1);
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow]", "[][]"));
        panelRight.add((Component)panel, "cell 0 2,grow");
        TmmLabel lblYearT = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        panel.add((Component)lblYearT, "cell 0 0");
        this.lblYear = new JLabel("");
        panel.add((Component)this.lblYear, "cell 1 0");
        TmmLabel lblTmdbidT = new TmmLabel(TmmResourceBundle.getString("metatag.tmdb"));
        panel.add((Component)lblTmdbidT, "cell 0 1");
        this.lblTmdbid = new LinkLabel();
        panel.add((Component)this.lblTmdbid, "cell 1 1");
        JSeparator separator = new JSeparator();
        panelRight.add((Component)separator, "cell 0 3,growx");
        JLabel lblPlot = new JLabel(TmmResourceBundle.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 4");
        TmmFontHelper.changeFont((JComponent)lblPlot, 1);
        NoBorderScrollPane scrollPaneOverview = new NoBorderScrollPane();
        panelRight.add((Component)scrollPaneOverview, "cell 0 5,grow");
        this.taOverview = new ReadOnlyTextPaneHTML();
        scrollPaneOverview.setViewportView(this.taOverview);
        separator = new JSeparator();
        panelRight.add((Component)separator, "cell 0 6,growx");
        JPanel panelBottom = new JPanel();
        panelRight.add((Component)panelBottom, "cell 0 7,grow");
        panelBottom.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3", "[][grow]", "[][grow]"));
        TmmLabel lblArtworkT = new TmmLabel(TmmResourceBundle.getString("metatag.artwork"));
        panelBottom.add((Component)lblArtworkT, "cell 0 0,aligny top");
        this.taArtworkPath1 = new LinkTextArea();
        panelBottom.add((Component)this.taArtworkPath1, "flowy,cell 1 0,growx,wmin 0");
        this.taArtworkPath2 = new LinkTextArea();
        panelBottom.add((Component)this.taArtworkPath2, "cell 1 0,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelBottom.add((Component)lblNoteT, "cell 0 1");
        this.tpNote = new ReadOnlyTextPaneHTML();
        panelBottom.add((Component)this.tpNote, "cell 1 1,growx,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 8,growx");
        TmmTable tableAssignedMovies = new TmmTable((TableModel)((Object)new TmmTableModel<Movie>(this.movieEventList, new MovieInMovieSetTableFormat())));
        tableAssignedMovies.setName("movieSets.movieTable");
        TmmUILayoutStore.getInstance().install(tableAssignedMovies);
        tableAssignedMovies.adjustColumnPreferredWidths(3);
        TmmLabel lblMoviesT = new TmmLabel(TmmResourceBundle.getString("tmm.movies"));
        panelRight.add((Component)lblMoviesT, "cell 0 10");
        JScrollPane scrollPane = new JScrollPane();
        tableAssignedMovies.configureScrollPane(scrollPane);
        panelRight.add((Component)scrollPane, "cell 0 11,grow");
    }

    private void setPoster(MovieSet movieSet) {
        MediaFile poster = ListUtils.getFirst(movieSet.getMediaFiles(MediaFileType.POSTER));
        if (poster != null) {
            this.lblPoster.setImageMediaFile(poster);
            Dimension posterSize = MediaFileHelper.getArtworkDimension(poster);
            this.lblPosterSize.setText(TmmResourceBundle.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPoster.setImageMediaFile(null);
            this.lblPoster.setImagePath(movieSet.getArtworkFilename(MediaFileType.POSTER));
            if (StringUtils.isNotBlank((CharSequence)this.lblPoster.getImagePath())) {
                ImageSizeLoader loader = new ImageSizeLoader(this.lblPoster.getImagePath(), "poster", this.lblPosterSize);
                loader.execute();
            } else {
                this.lblPosterSize.setText(TmmResourceBundle.getString("mediafiletype.poster"));
            }
        }
    }

    private void setFanart(MovieSet movieSet) {
        MediaFile fanart = ListUtils.getFirst(movieSet.getMediaFiles(MediaFileType.FANART));
        if (fanart != null) {
            this.lblFanart.setImageMediaFile(fanart);
            Dimension posterSize = MediaFileHelper.getArtworkDimension(fanart);
            this.lblFanartSize.setText(TmmResourceBundle.getString("mediafiletype.fanart") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblFanart.setImageMediaFile(null);
            this.lblFanart.setImagePath(movieSet.getArtworkFilename(MediaFileType.FANART));
            if (StringUtils.isNotBlank((CharSequence)this.lblFanart.getImagePath())) {
                ImageSizeLoader loader = new ImageSizeLoader(this.lblFanart.getImagePath(), "fanart", this.lblFanartSize);
                loader.execute();
            } else {
                this.lblFanartSize.setText(TmmResourceBundle.getString("mediafiletype.fanart"));
            }
        }
    }

    private void setArtworkPath(MovieSet movieSet) {
        String artworkPath = MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder();
        if (StringUtils.isBlank((CharSequence)artworkPath)) {
            this.taArtworkPath1.setVisible(false);
            this.taArtworkPath2.setVisible(false);
            return;
        }
        String artworkPath1 = "";
        String artworkPath2 = "";
        for (MediaFile mediaFile : movieSet.getMediaFiles()) {
            String mfPath;
            if (!mediaFile.isGraphic() || !(mfPath = mediaFile.getFileAsPath().getParent().toAbsolutePath().toString()).startsWith(artworkPath)) continue;
            if (StringUtils.isBlank((CharSequence)artworkPath1)) {
                artworkPath1 = mfPath;
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)artworkPath2) || mfPath.equals(artworkPath1)) continue;
            artworkPath2 = mfPath;
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)artworkPath1)) {
            this.taArtworkPath1.setVisible(true);
            this.taArtworkPath1.setText(artworkPath1);
        } else {
            this.taArtworkPath1.setVisible(false);
        }
        if (StringUtils.isNotBlank((CharSequence)artworkPath2)) {
            this.taArtworkPath2.setVisible(true);
            this.taArtworkPath2.setText(artworkPath2);
        } else {
            this.taArtworkPath2.setVisible(false);
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovieSet.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblMovieSetName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovieSet.plot");
        BeanProperty JTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.taOverview, (Property)JTextPaneBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSetSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovieSet.tmdbId");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSetSelectionModelBeanProperty, (Object)this.lblTmdbid, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSetSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovieSet.note");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSetSelectionModelBeanProperty_1, (Object)this.tpNote, (Property)jTextAreaBeanProperty);
        autoBinding_3.bind();
    }

    private static class ImageSizeLoader
    extends SwingWorker<Void, Void> {
        private final String path;
        private final String type;
        private final JLabel label;
        private int width;
        private int height;

        public ImageSizeLoader(String path, String type, JLabel label) {
            this.path = path;
            this.type = type;
            this.label = label;
        }

        @Override
        protected Void doInBackground() {
            if (!Files.exists(Paths.get(this.path, new String[0]), new LinkOption[0])) {
                return null;
            }
            try {
                BufferedImage img = ImageIO.read(new File(this.path));
                this.width = img.getWidth();
                this.height = img.getHeight();
            }
            catch (Exception e) {
                LOGGER.debug("Could not read {} dimensions: {}", (Object)("mediafiletype." + this.type), (Object)e.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.width > 0 && this.height > 0) {
                this.label.setText(TmmResourceBundle.getString("mediafiletype." + this.type) + " - " + this.width + "x" + this.height);
            } else {
                this.label.setText(TmmResourceBundle.getString("mediafiletype." + this.type));
            }
        }
    }
}

