/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.actions.ClearFilterPresetAction;
import org.tinymediamanager.ui.actions.FilterPresetAction;
import org.tinymediamanager.ui.actions.RequestFocusAction;
import org.tinymediamanager.ui.components.button.SplitButton;
import org.tinymediamanager.ui.components.panel.TmmListPanel;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeModel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeTextFilter;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableComparatorChooser;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.moviesets.MovieSetTableFormat;
import org.tinymediamanager.ui.moviesets.MovieSetTreeCellRenderer;
import org.tinymediamanager.ui.moviesets.MovieSetTreeDataProvider;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.moviesets.actions.MovieSetEditAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class MovieSetTreePanel
extends TmmListPanel {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final MovieSetSelectionModel selectionModel;
    private TmmTreeTable tree;
    private JLabel lblMovieCountFiltered;
    private JLabel lblMovieCountTotal;
    private JLabel lblMovieSetCountFiltered;
    private JLabel lblMovieSetCountTotal;
    private SplitButton btnFilter;
    private JLabel lblSelectedMovieCount;
    private JPopupMenu popupMenu;

    public MovieSetTreePanel(MovieSetSelectionModel movieSetSelectionModel) {
        this.initComponents();
        this.selectionModel = movieSetSelectionModel;
        this.selectionModel.setTreeTable(this.tree);
        this.updateTotals();
        MovieModuleManager.getInstance().getSettings().addPropertyChangeListener(e -> {
            switch (e.getPropertyName()) {
                case "movieSetCheckMetadata": 
                case "movieSetCheckArtwork": {
                    this.tree.invalidate();
                    break;
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[200lp:n,grow][100lp:n,fill]", "[][400lp,grow]0[][][]"));
        TmmTreeTextFilter<TmmTreeNode> searchField = new TmmTreeTextFilter<TmmTreeNode>();
        this.add(searchField, "cell 0 0,growx");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "search");
        this.getActionMap().put("search", new RequestFocusAction(searchField));
        this.btnFilter = new SplitButton(TmmResourceBundle.getString("movieextendedsearch.filter"));
        this.btnFilter.setToolTipText(TmmResourceBundle.getString("movieextendedsearch.options"));
        this.btnFilter.getActionButton().addActionListener(e -> MovieSetUIModule.getInstance().setFilterDialogVisible(true));
        this.btnFilter.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JPopupMenu popupMenu = MovieSetTreePanel.this.btnFilter.getPopupMenu();
                popupMenu.removeAll();
                MovieModuleManager.getInstance().getSettings().getMovieSetUiFilterPresets().keySet().stream().sorted().forEach(uiFilter -> {
                    FilterPresetAction action = new FilterPresetAction((String)uiFilter){

                        @Override
                        protected void processAction(ActionEvent e) {
                            MovieSetTreePanel.this.tree.setFilterValues(MovieModuleManager.getInstance().getSettings().getMovieSetUiFilterPresets().get(this.presetName));
                            MovieSetTreePanel.this.tree.storeFilters();
                        }
                    };
                    popupMenu.add(action);
                });
                if (popupMenu.getSubElements().length != 0) {
                    popupMenu.addSeparator();
                }
                popupMenu.add(new ClearFilterPresetAction(){

                    @Override
                    protected void processAction(ActionEvent e) {
                        MovieSetTreePanel.this.tree.setFilterValues(Collections.emptyList());
                        MovieSetTreePanel.this.tree.storeFilters();
                    }
                });
                popupMenu.pack();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.add((Component)this.btnFilter, "cell 1 0");
        MovieSetTableFormat tableFormat = new MovieSetTableFormat();
        this.tree = new TmmTreeTable(new MovieSetTreeDataProvider(tableFormat), tableFormat){

            @Override
            public void storeFilters() {
                if (MovieModuleManager.getInstance().getSettings().isStoreMovieSetUiFilters()) {
                    ArrayList<AbstractSettings.UIFilters> filterValues = new ArrayList<AbstractSettings.UIFilters>();
                    if (this.isFiltersActive()) {
                        for (ITmmTreeFilter filter : this.treeFilters) {
                            ITmmUIFilter uiFilter;
                            if (!(filter instanceof ITmmUIFilter) || (uiFilter = (ITmmUIFilter)((Object)filter)).getFilterState() == ITmmUIFilter.FilterState.INACTIVE) continue;
                            AbstractSettings.UIFilters uiFilters = new AbstractSettings.UIFilters();
                            uiFilters.id = uiFilter.getId();
                            uiFilters.state = uiFilter.getFilterState();
                            uiFilters.filterValue = uiFilter.getFilterValueAsString();
                            filterValues.add(uiFilters);
                        }
                    }
                    MovieModuleManager.getInstance().getSettings().setMovieSetUiFilters(filterValues);
                    MovieModuleManager.getInstance().getSettings().saveSettings();
                }
            }
        };
        this.tree.getColumnModel().getColumn(0).setCellRenderer(new MovieSetTreeCellRenderer());
        this.tree.addPropertyChangeListener("filterChanged", evt -> this.updateFilterIndicator());
        this.tree.setName("movieSets.movieSetTree");
        TmmTreeTableComparatorChooser.install(this.tree);
        TmmUILayoutStore.getInstance().install(this.tree);
        this.tree.addFilter(searchField);
        JScrollPane scrollPane = new JScrollPane();
        this.tree.configureScrollPane(scrollPane);
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.tree.adjustColumnPreferredWidths(3);
        this.tree.setRootVisible(false);
        this.tree.getModel().addTableModelListener(arg0 -> {
            if (this.tree.getTreeTableModel().getTreeModel() instanceof TmmTreeModel && ((TmmTreeModel)this.tree.getTreeTableModel().getTreeModel()).isAdjusting()) {
                return;
            }
            ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
            if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                selectionModel1.setSelectionInterval(0, 0);
            }
        });
        this.tree.getTreeTableModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                MovieSetTreePanel.this.updateTotals();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                MovieSetTreePanel.this.updateTotals();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                MovieSetTreePanel.this.updateTotals();
            }
        });
        this.tree.getSelectionModel().addListSelectionListener(arg0 -> {
            if (arg0.getValueIsAdjusting() || !(arg0.getSource() instanceof DefaultListSelectionModel)) {
                return;
            }
            if (this.tree.getModel().getRowCount() == 0) {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
                return;
            }
            if (this.tree.isAdjusting()) {
                return;
            }
            int index = ((DefaultListSelectionModel)arg0.getSource()).getMinSelectionIndex();
            DefaultMutableTreeNode node = this.tree.getTreeNode(index);
            if (node != null) {
                if (node.getUserObject() instanceof MovieSet) {
                    MovieSet movieSet = (MovieSet)node.getUserObject();
                    MovieSetUIModule.getInstance().setSelectedMovieSet(movieSet);
                }
                if (node.getUserObject() instanceof Movie) {
                    Movie movie = (Movie)node.getUserObject();
                    MovieSetUIModule.getInstance().setSelectedMovie(movie);
                }
            } else {
                MovieSetUIModule.getInstance().setSelectedMovieSet(null);
            }
            this.updateSelectionSums();
        });
        if (this.movieList.getMovieSetList() != null && !this.movieList.getMovieSetList().isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
                if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                    selectionModel1.setSelectionInterval(0, 0);
                }
            });
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && e.getButton() == 1) {
                    new MovieSetEditAction().actionPerformed(new ActionEvent(e, 0, ""));
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
        InputMap inputMap = this.tree.getInputMap(0);
        ActionMap actionMap = this.tree.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "popup");
        actionMap.put("popup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MovieSetTreePanel.this.popupMenu != null) {
                    Rectangle rect = MovieSetTreePanel.this.tree.getCellRect(MovieSetTreePanel.this.tree.getSelectedRow(), 0, false);
                    MovieSetTreePanel.this.popupMenu.show(MovieSetTreePanel.this.tree, rect.x + rect.width / 2, rect.y + rect.height / 2);
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){
            private long lastKeypress = 0L;
            private String searchTerm = "";

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && keyEvent.getKeyChar() == '\n') {
                    new MovieSetEditAction().actionPerformed(new ActionEvent(keyEvent, 0, ""));
                    keyEvent.consume();
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - this.lastKeypress > 500L) {
                    this.searchTerm = "";
                }
                this.lastKeypress = now;
                if (keyEvent.getKeyChar() != '\uffff') {
                    this.searchTerm = this.searchTerm + keyEvent.getKeyChar();
                    this.searchTerm = this.searchTerm.toLowerCase();
                }
                if (StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
                    TableModel model = MovieSetTreePanel.this.tree.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        MovieSetTreeDataProvider.MovieSetTreeNode node;
                        String title;
                        if (!(model.getValueAt(i, 0) instanceof MovieSetTreeDataProvider.MovieSetTreeNode) || !(title = (node = (MovieSetTreeDataProvider.MovieSetTreeNode)model.getValueAt(i, 0)).toString().toLowerCase(Locale.ROOT)).startsWith(this.searchTerm)) continue;
                        MovieSetTreePanel.this.tree.getSelectionModel().setSelectionInterval(i, i);
                        MovieSetTreePanel.this.tree.scrollRectToVisible(new Rectangle(MovieSetTreePanel.this.tree.getCellRect(i, 0, true)));
                        break;
                    }
                }
            }
        };
        this.tree.addKeyListener(keyListener);
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 2 2 1,growx");
        JPanel panelTotals = new JPanel();
        this.add((Component)panelTotals, "cell 0 3 2 1,grow");
        panelTotals.setLayout((LayoutManager)new MigLayout("insets 0", "[100lp:n,grow][100lp:n,grow,right]", "[]"));
        JLabel lblMovieSetCount = new JLabel(TmmResourceBundle.getString("tmm.moviesets") + ":");
        panelTotals.add((Component)lblMovieSetCount, "flowx,cell 0 0");
        this.lblMovieSetCountFiltered = new JLabel("");
        panelTotals.add((Component)this.lblMovieSetCountFiltered, "cell 0 0");
        JLabel lblMovieSetCountOf = new JLabel(TmmResourceBundle.getString("tmm.of"));
        panelTotals.add((Component)lblMovieSetCountOf, "cell 0 0");
        this.lblMovieSetCountTotal = new JLabel("");
        panelTotals.add((Component)this.lblMovieSetCountTotal, "cell 0 0");
        JLabel lblMovieCount = new JLabel(TmmResourceBundle.getString("tmm.movies") + ":");
        panelTotals.add((Component)lblMovieCount, "flowx,cell 0 1");
        this.lblMovieCountFiltered = new JLabel("");
        panelTotals.add((Component)this.lblMovieCountFiltered, "cell 0 1");
        JLabel lblMovieCountOf = new JLabel(TmmResourceBundle.getString("tmm.of"));
        panelTotals.add((Component)lblMovieCountOf, "cell 0 1");
        this.lblMovieCountTotal = new JLabel("");
        panelTotals.add((Component)this.lblMovieCountTotal, "cell 0 1");
        this.lblSelectedMovieCount = new JLabel("");
        panelTotals.add((Component)this.lblSelectedMovieCount, "cell 1 1");
    }

    private void updateFilterIndicator() {
        boolean active = false;
        if (this.tree.isFiltersActive()) {
            for (ITmmTreeFilter<TmmTreeNode> filter : this.tree.getFilters()) {
                if (!(filter instanceof ITmmUIFilter)) continue;
                ITmmUIFilter uiFilter = (ITmmUIFilter)((Object)filter);
                switch (uiFilter.getFilterState()) {
                    case ACTIVE: 
                    case ACTIVE_NEGATIVE: {
                        active = true;
                        break;
                    }
                }
                if (!active) continue;
                break;
            }
        }
        if (active) {
            this.btnFilter.getActionButton().setIcon(IconManager.FILTER_ACTIVE);
        } else {
            this.btnFilter.getActionButton().setIcon(null);
        }
    }

    private void updateTotals() {
        this.lblMovieSetCountTotal.setText(String.valueOf(this.movieList.getMovieSetCount()));
        this.lblMovieCountTotal.setText(String.valueOf(this.movieList.getMovieInMovieSetCount()));
        int movieSetCount = 0;
        int movieCount = 0;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getTreeTableModel().getRoot();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = node.getUserObject();
            if (userObject instanceof MovieSet) {
                ++movieSetCount;
                continue;
            }
            if (!(userObject instanceof Movie) || userObject instanceof MovieSet.MovieSetMovie) continue;
            ++movieCount;
        }
        this.lblMovieSetCountFiltered.setText(String.valueOf(movieSetCount));
        this.lblMovieCountFiltered.setText(String.valueOf(movieCount));
    }

    private void updateSelectionSums() {
        List<Movie> movies = this.selectionModel.getSelectedMoviesRecursive();
        String selectedMovies = TmmResourceBundle.getString("movie.selected").replace("{}", String.valueOf(movies.size()));
        double videoFileSize = (double)movies.stream().mapToLong(Movie::getVideoFilesize).sum() / 1.0E9;
        double totalFileSize = (double)movies.stream().mapToLong(MediaEntity::getTotalFilesize).sum() / 1.0E9;
        String text = String.format("%s (%.2f G)", selectedMovies, totalFileSize);
        this.lblSelectedMovieCount.setText(text);
        String selectedEpisodesHint = selectedMovies + " (" + TmmResourceBundle.getString("tmm.selected.hint1").replace("{}", String.format("%.2f G", videoFileSize)) + " / " + TmmResourceBundle.getString("tmm.selected.hint2").replace("{}", String.format("%.2f G", totalFileSize)) + ")";
        this.lblSelectedMovieCount.setToolTipText(selectedEpisodesHint);
    }

    public TmmTreeTable getTreeTable() {
        return this.tree;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        if (popupMenu != null) {
            this.setComponentPopupMenu(popupMenu);
            popupMenu.addSeparator();
            popupMenu.add(new ExpandAllAction());
            popupMenu.add(new CollapseAllAction());
        }
        this.tree.addMouseListener(new TablePopupListener(popupMenu, this.tree));
    }

    public class ExpandAllAction
    extends AbstractAction {
        public ExpandAllAction() {
            this.putValue("Name", TmmResourceBundle.getString("tree.expandall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            do {
                MovieSetTreePanel.this.tree.expandRow(i++);
            } while (i < MovieSetTreePanel.this.tree.getRowCount());
        }
    }

    public class CollapseAllAction
    extends AbstractAction {
        public CollapseAllAction() {
            this.putValue("Name", TmmResourceBundle.getString("tree.collapseall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = MovieSetTreePanel.this.tree.getRowCount() - 1; i >= 0; --i) {
                MovieSetTreePanel.this.tree.collapseRow(i);
            }
        }
    }
}

