/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AspectRatio;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.mediainfo.MediaInfo3D;
import org.tinymediamanager.core.tasks.MediaFileARDetectorTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.FFmpeg;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.IntegerInputVerifier;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.MediaFileAudioStreamEditTable;
import org.tinymediamanager.ui.components.table.MediaFileSubtitleEditTable;
import org.tinymediamanager.ui.components.table.TmmTable;

public class MediaFileEditorPanel
extends JPanel {
    private final BindingGroup bindingGroup = new BindingGroup();
    private final List<MediaFileContainer> mediaFiles;
    private final TmmTable tableMediaFiles;
    private final JLabel lblFilename;
    private final JTextField tfCodec;
    private final JTextField tfContainerFormat;
    private final JTextField tfWidth;
    private final JTextField tfHeight;
    private final MediaFileAudioStreamEditTable tableAudioStreams;
    private final MediaFileSubtitleEditTable tableSubtitles;
    private final JButton btnAddAudioStream;
    private final JButton btnRemoveAudioStream;
    private final JButton btnAddSubtitle;
    private final JButton btnRemoveSubtitle;
    private final JComboBox<MediaInfo3D> cb3dFormat;
    private final JComboBox cbAspectRatio;
    private final JComboBox cbAspectRatio2;
    private final JSpinner spFrameRate;
    private final JTextField tfBitDepth;
    private final JTextField tfHdrFormat;
    private final JTextField tfVideoBitrate;
    private final JTextField tfRuntime;
    private final JButton btnARD;
    private final EventList<MediaFileAudioStream> audioStreams;
    private final EventList<MediaFileSubtitle> subtitles;
    private final List<AspectRatioContainer> aspectRatios = new ArrayList<AspectRatioContainer>();
    private final List<AspectRatioContainer> aspectRatios2 = new ArrayList<AspectRatioContainer>();
    private TmmTask ardTask;

    public MediaFileEditorPanel(List<MediaFile> mediaFiles) {
        this.mediaFiles = ObservableCollections.observableList(new ArrayList());
        for (MediaFile mediaFile : mediaFiles) {
            MediaFileContainer container = new MediaFileContainer(mediaFile);
            this.mediaFiles.add(container);
        }
        this.audioStreams = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFileAudioStream.class));
        this.subtitles = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFileSubtitle.class));
        HashSet<MediaFileType> videoTypes = new HashSet<MediaFileType>(Arrays.asList(MediaFileType.VIDEO, MediaFileType.SAMPLE, MediaFileType.TRAILER));
        this.setLayout((LayoutManager)new MigLayout("", "[300lp:450lp,grow]", "[200lp:450lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName("mediafileEditor.splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        this.add((Component)splitPane, "cell 0 0,grow");
        JPanel panelMediaFiles = new JPanel();
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[200lp:250lp,grow]", "[200lp:300lp,grow]"));
        JScrollPane scrollPaneMediaFiles = new JScrollPane();
        panelMediaFiles.add((Component)scrollPaneMediaFiles, "cell 0 0,grow");
        splitPane.setLeftComponent(panelMediaFiles);
        this.tableMediaFiles = new TmmTable();
        this.tableMediaFiles.configureScrollPane(scrollPaneMediaFiles);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][75lp:n][20lp:n][][75lp:n][20lp:n][][75lp:n][50lp:n,grow]", "[][][][][][][100lp:150lp][100lp:150lp]"));
        this.lblFilename = new JLabel("");
        TmmFontHelper.changeFont(this.lblFilename, 1.167, 1);
        panelDetails.add((Component)this.lblFilename, "cell 0 0 9 1,growx");
        TmmLabel lblCodec = new TmmLabel(TmmResourceBundle.getString("metatag.codec"));
        panelDetails.add((Component)lblCodec, "cell 0 1,alignx right");
        this.tfCodec = new JTextField();
        panelDetails.add((Component)this.tfCodec, "cell 1 1,growx");
        this.tfCodec.setColumns(10);
        TmmLabel lblContainerFormat = new TmmLabel(TmmResourceBundle.getString("metatag.container"));
        panelDetails.add((Component)lblContainerFormat, "cell 3 1,alignx right");
        this.tfContainerFormat = new JTextField();
        panelDetails.add((Component)this.tfContainerFormat, "cell 4 1,growx");
        this.tfContainerFormat.setColumns(10);
        TmmLabel lblWidth = new TmmLabel(TmmResourceBundle.getString("metatag.width"));
        panelDetails.add((Component)lblWidth, "cell 0 2,alignx right");
        this.tfWidth = new JTextField();
        this.tfWidth.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfWidth, "cell 1 2,growx");
        this.tfWidth.setColumns(10);
        TmmLabel lblHeight = new TmmLabel(TmmResourceBundle.getString("metatag.height"));
        panelDetails.add((Component)lblHeight, "cell 3 2,alignx right");
        this.tfHeight = new JTextField();
        this.tfHeight.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfHeight, "cell 4 2,growx");
        this.tfHeight.setColumns(10);
        this.btnARD = new JButton(new ScanAspectRationAction());
        this.btnARD.setFocusable(false);
        MediaFile mf = this.mediaFiles.get((int)0).mediaFile;
        this.btnARD.setEnabled(videoTypes.contains((Object)mf.getType()));
        panelDetails.add((Component)this.btnARD, "cell 7 1");
        TmmLabel lblAspectT = new TmmLabel(TmmResourceBundle.getString("metatag.aspect"));
        panelDetails.add((Component)lblAspectT, "cell 6 2,alignx right");
        this.cbAspectRatio = new JComboBox<AspectRatioContainer>(this.getAspectRatios().toArray(new AspectRatioContainer[0]));
        panelDetails.add((Component)this.cbAspectRatio, "cell 7 2");
        lblAspectT = new TmmLabel(TmmResourceBundle.getString("metatag.aspect2"));
        panelDetails.add((Component)lblAspectT, "cell 6 3,alignx right");
        this.cbAspectRatio2 = new JComboBox<AspectRatioContainer>(this.getAspectRatios2().toArray(new AspectRatioContainer[0]));
        panelDetails.add((Component)this.cbAspectRatio2, "cell 7 3");
        TmmLabel lblFrameRate = new TmmLabel(TmmResourceBundle.getString("metatag.framerate"));
        panelDetails.add((Component)lblFrameRate, "cell 0 3,alignx trailing");
        this.spFrameRate = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 999.0, 0.01));
        panelDetails.add((Component)this.spFrameRate, "cell 1 3,growx");
        TmmLabel lblVideoBitrate = new TmmLabel(TmmResourceBundle.getString("metatag.bitrate"));
        panelDetails.add((Component)lblVideoBitrate, "cell 3 3,alignx trailing");
        this.tfVideoBitrate = new JTextField();
        panelDetails.add((Component)this.tfVideoBitrate, "cell 4 3");
        this.tfVideoBitrate.setColumns(10);
        this.tfVideoBitrate.setInputVerifier(new IntegerInputVerifier());
        TmmLabel lblBitDepthT = new TmmLabel(TmmResourceBundle.getString("metatag.videobitdepth"));
        panelDetails.add((Component)lblBitDepthT, "cell 0 4,alignx trailing");
        this.tfBitDepth = new JTextField();
        this.tfBitDepth.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfBitDepth, "cell 1 4,growx");
        this.tfBitDepth.setColumns(10);
        TmmLabel lblHdrFormatT = new TmmLabel(TmmResourceBundle.getString("metatag.hdrformat"));
        panelDetails.add((Component)lblHdrFormatT, "cell 3 4,alignx trailing");
        this.tfHdrFormat = new JTextField();
        panelDetails.add((Component)this.tfHdrFormat, "cell 4 4,growx");
        this.tfHdrFormat.setColumns(10);
        TmmLabel lblRuntimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        panelDetails.add((Component)lblRuntimeT, "cell 0 5,alignx trailing");
        this.tfRuntime = new JTextField();
        panelDetails.add((Component)this.tfRuntime, "cell 1 5");
        this.tfRuntime.setColumns(5);
        this.tfRuntime.setInputVerifier(new IntegerInputVerifier());
        TmmLabel lbl3d = new TmmLabel(TmmResourceBundle.getString("metatag.3dformat"));
        panelDetails.add((Component)lbl3d, "cell 3 5,alignx right");
        this.cb3dFormat = new JComboBox<MediaInfo3D>(MediaInfo3D.values());
        panelDetails.add(this.cb3dFormat, "cell 4 5");
        TmmLabel lblAudiostreams = new TmmLabel(TmmResourceBundle.getString("metatag.countAudioStreams"));
        panelDetails.add((Component)lblAudiostreams, "flowy,cell 0 6,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "cell 1 6 8 1,grow");
        this.tableAudioStreams = new MediaFileAudioStreamEditTable(this.audioStreams){

            @Override
            public void onAddAudioStream() {
                MediaFileEditorPanel.this.syncAudioStreams();
            }

            @Override
            public void onEditAudioStream() {
                MediaFileEditorPanel.this.syncAudioStreams();
            }
        };
        this.tableAudioStreams.configureScrollPane(scrollPane);
        TmmLabel lblSubtitles = new TmmLabel(TmmResourceBundle.getString("metatag.subtitles"));
        panelDetails.add((Component)lblSubtitles, "flowy,cell 0 7,alignx right,aligny top");
        scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "cell 1 7 8 1,grow");
        this.tableSubtitles = new MediaFileSubtitleEditTable(this.subtitles){

            @Override
            public void onEditSubtitle() {
                MediaFileEditorPanel.this.syncSubtitles();
            }

            @Override
            public void onAddSubtitle() {
                MediaFileEditorPanel.this.syncSubtitles();
            }
        };
        this.tableSubtitles.configureScrollPane(scrollPane);
        this.btnAddAudioStream = new SquareIconButton(new AddAudioStreamAction());
        panelDetails.add((Component)this.btnAddAudioStream, "cell 0 6,alignx right,aligny top");
        this.btnRemoveAudioStream = new SquareIconButton(new RemoveAudioStreamAction());
        panelDetails.add((Component)this.btnRemoveAudioStream, "cell 0 6,alignx right,aligny top");
        this.btnAddSubtitle = new SquareIconButton(new AddSubtitleAction());
        panelDetails.add((Component)this.btnAddSubtitle, "cell 0 7,alignx right,aligny top");
        this.btnRemoveSubtitle = new SquareIconButton(new RemoveSubtitleAction());
        panelDetails.add((Component)this.btnRemoveSubtitle, "cell 0 7,alignx right,aligny top");
        this.initDataBindings();
        this.tableMediaFiles.getSelectionModel().addListSelectionListener(listener -> {
            int selectedRow;
            if (!listener.getValueIsAdjusting() && (selectedRow = this.tableMediaFiles.convertRowIndexToModel(this.tableMediaFiles.getSelectedRow())) > -1) {
                MediaFileContainer container = this.mediaFiles.get(selectedRow);
                this.tfCodec.setEnabled(container.mediaFile.getType() != MediaFileType.NFO);
                this.btnAddAudioStream.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()) || container.mediaFile.getType() == MediaFileType.AUDIO);
                this.btnRemoveAudioStream.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()) || container.mediaFile.getType() == MediaFileType.AUDIO);
                this.btnAddSubtitle.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()) || container.mediaFile.getType() == MediaFileType.SUBTITLE);
                this.btnRemoveSubtitle.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()) || container.mediaFile.getType() == MediaFileType.SUBTITLE);
                this.cb3dFormat.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()));
                this.tfRuntime.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()));
                this.btnARD.setEnabled(videoTypes.contains((Object)container.mediaFile.getType()) && FFmpeg.isAvailable());
                this.audioStreams.clear();
                this.audioStreams.addAll(container.getAudioStreams());
                this.tableAudioStreams.adjustColumnPreferredWidths(6);
                this.subtitles.clear();
                this.subtitles.addAll(container.getSubtitles());
                this.tableSubtitles.adjustColumnPreferredWidths(6);
            }
        });
        if (!this.mediaFiles.isEmpty()) {
            this.tableMediaFiles.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private List<AspectRatioContainer> getAspectRatios() {
        if (this.aspectRatios.isEmpty()) {
            this.aspectRatios.add(new AspectRatioContainer(Float.valueOf(0.0f), TmmResourceBundle.getString("aspectratio.calculated")));
            for (Float ar : AspectRatio.getDefaultValues()) {
                this.aspectRatios.add(new AspectRatioContainer(ar));
            }
        }
        return this.aspectRatios;
    }

    private List<AspectRatioContainer> getAspectRatios2() {
        if (this.aspectRatios2.isEmpty()) {
            this.aspectRatios2.add(new AspectRatioContainer(null, TmmResourceBundle.getString("aspectratio.nomultiformat")));
            for (Float ar : AspectRatio.getDefaultValues()) {
                this.aspectRatios2.add(new AspectRatioContainer(ar));
            }
        }
        return this.aspectRatios2;
    }

    private void syncAudioStreams() {
        int selectedRow = this.tableMediaFiles.convertRowIndexToModel(this.tableMediaFiles.getSelectedRow());
        if (selectedRow > -1) {
            MediaFileContainer container = this.mediaFiles.get(selectedRow);
            container.setAudioStreams((List<MediaFileAudioStream>)this.audioStreams);
        }
    }

    private void syncSubtitles() {
        int selectedRow = this.tableMediaFiles.convertRowIndexToModel(this.tableMediaFiles.getSelectedRow());
        if (selectedRow > -1) {
            MediaFileContainer container = this.mediaFiles.get(selectedRow);
            container.setSubtitles((List<MediaFileSubtitle>)this.subtitles);
        }
    }

    public static void syncMediaFiles(List<MediaFile> mfsFromEditor, List<MediaFile> mfsFromMediaEntity) {
        block0: for (MediaFile mfEditor : mfsFromEditor) {
            for (MediaFile mfOriginal : mfsFromMediaEntity) {
                if (!mfEditor.equals(mfOriginal)) continue;
                if (!mfEditor.getVideoCodec().equals(mfOriginal.getVideoCodec())) {
                    mfOriginal.setVideoCodec(mfEditor.getVideoCodec());
                }
                if (!mfEditor.getContainerFormat().equals(mfOriginal.getContainerFormat())) {
                    mfOriginal.setContainerFormat(mfEditor.getContainerFormat());
                }
                if (mfEditor.getVideoWidth() != mfOriginal.getVideoWidth()) {
                    mfOriginal.setVideoWidth(mfEditor.getVideoWidth());
                }
                if (mfEditor.getVideoHeight() != mfOriginal.getVideoHeight()) {
                    mfOriginal.setVideoHeight(mfEditor.getVideoHeight());
                }
                if (MetadataUtil.unboxFloat(mfEditor.getAspectRatio()) != MetadataUtil.unboxFloat(mfOriginal.getAspectRatio())) {
                    mfOriginal.setAspectRatio(mfEditor.getAspectRatio());
                }
                if (MetadataUtil.unboxFloat(mfEditor.getAspectRatio2()) != MetadataUtil.unboxFloat(mfOriginal.getAspectRatio2())) {
                    mfOriginal.setAspectRatio2(mfEditor.getAspectRatio2());
                }
                if (mfEditor.getFrameRate() != mfOriginal.getFrameRate()) {
                    mfOriginal.setFrameRate(mfEditor.getFrameRate());
                }
                if (!mfEditor.getVideo3DFormat().equals(mfOriginal.getVideo3DFormat())) {
                    if (mfEditor.getVideo3DFormat().equals("mono")) {
                        mfOriginal.setVideo3DFormat("");
                    } else {
                        mfOriginal.setVideo3DFormat(mfEditor.getVideo3DFormat());
                    }
                }
                if (!mfEditor.getHdrFormat().equals(mfOriginal.getHdrFormat())) {
                    mfOriginal.setHdrFormat(mfEditor.getHdrFormat());
                }
                if (mfEditor.getBitDepth() != mfOriginal.getBitDepth()) {
                    mfOriginal.setBitDepth(mfEditor.getBitDepth());
                }
                if (mfEditor.getOverallBitRate() != mfOriginal.getOverallBitRate()) {
                    mfOriginal.setOverallBitRate(mfEditor.getOverallBitRate());
                }
                if (mfEditor.getDuration() != mfOriginal.getDuration()) {
                    mfOriginal.setDuration(mfEditor.getDuration());
                }
                ArrayList<MediaFileAudioStream> audioStreams = new ArrayList<MediaFileAudioStream>();
                for (MediaFileAudioStream audioStream : mfEditor.getAudioStreams()) {
                    if (StringUtils.isBlank((CharSequence)audioStream.getCodec()) || audioStream.getAudioChannels() == 0) continue;
                    audioStreams.add(audioStream);
                }
                mfOriginal.setAudioStreams(audioStreams);
                ArrayList<MediaFileSubtitle> subtitles = new ArrayList<MediaFileSubtitle>();
                for (MediaFileSubtitle subtitle : mfEditor.getSubtitles()) {
                    if (StringUtils.isBlank((CharSequence)subtitle.getLanguage())) continue;
                    subtitles.add(subtitle);
                }
                mfOriginal.setSubtitles(subtitles);
                continue block0;
            }
        }
    }

    public void unbindBindings() {
        try {
            this.bindingGroup.unbind();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.mediaFiles, (JTable)this.tableMediaFiles);
        BeanProperty mediaFileContainerBeanProperty = BeanProperty.create((String)"mediaFile.filename");
        jTableBinding.addColumnBinding((Property)mediaFileContainerBeanProperty).setColumnName("Filename").setEditable(false);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.filename");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty, (Object)this.lblFilename, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.videoCodec");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_1, (Object)this.tfCodec, (Property)jTextFieldBeanProperty);
        autoBinding_1.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.containerFormat");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_3, (Object)this.tfContainerFormat, (Property)jTextFieldBeanProperty_2);
        autoBinding_3.bind();
        BeanProperty jTableBeanProperty_5 = BeanProperty.create((String)"selectedElement.mediaFile.videoWidth");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_5, (Object)this.tfWidth, (Property)jTextFieldBeanProperty_4);
        autoBinding_5.bind();
        BeanProperty jTableBeanProperty_6 = BeanProperty.create((String)"selectedElement.mediaFile.videoHeight");
        BeanProperty jTextFieldBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_6, (Object)this.tfHeight, (Property)jTextFieldBeanProperty_5);
        autoBinding_6.bind();
        BeanProperty jTableBeanProperty_7 = BeanProperty.create((String)"selectedElement.mediaFile.video3DFormat");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_7, this.cb3dFormat, (Property)jComboBoxBeanProperty);
        autoBinding_2.setConverter((Converter)new MediaInfo3DConverter());
        autoBinding_2.bind();
        BeanProperty tmmTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.aspectRatio");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty, (Object)this.cbAspectRatio, (Property)jComboBoxBeanProperty);
        autoBinding_4.setConverter((Converter)new AspectRatioConverter(this.getAspectRatios()));
        autoBinding_4.bind();
        BeanProperty tmmTableBeanProperty_6 = BeanProperty.create((String)"selectedElement.mediaFile.aspectRatio2");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_6, (Object)this.cbAspectRatio2, (Property)jComboBoxBeanProperty);
        autoBinding_12.setConverter((Converter)new AspectRatioConverter(this.getAspectRatios2()));
        autoBinding_12.bind();
        BeanProperty tmmTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.frameRate");
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"value");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_1, (Object)this.spFrameRate, (Property)jSpinnerBeanProperty);
        autoBinding_7.bind();
        BeanProperty tmmTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.mediaFile.bitDepth");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_2, (Object)this.tfBitDepth, (Property)jTextFieldBeanProperty_1);
        autoBinding_8.bind();
        BeanProperty tmmTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.overallBitRate");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_3, (Object)this.tfVideoBitrate, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty tmmTableBeanProperty_4 = BeanProperty.create((String)"selectedElement.mediaFile.hdrFormat");
        BeanProperty jTextFieldBeanProperty_6 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_4, (Object)this.tfHdrFormat, (Property)jTextFieldBeanProperty_6);
        autoBinding_10.bind();
        BeanProperty tmmTableBeanProperty_5 = BeanProperty.create((String)"selectedElement.mediaFile.durationInMinutes");
        BeanProperty jTextFieldBeanProperty_7 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_5, (Object)this.tfRuntime, (Property)jTextFieldBeanProperty_7);
        autoBinding_11.bind();
        this.bindingGroup.addBinding((Binding)jTableBinding);
    }

    public void cancelTask() {
        if (this.ardTask != null) {
            this.ardTask.cancel();
            this.ardTask = null;
        }
    }

    public static class MediaFileContainer {
        private final MediaFile mediaFile;
        private final List<MediaFileAudioStream> audioStreams;
        private final List<MediaFileSubtitle> subtitles;

        private MediaFileContainer(MediaFile mediaFile) {
            this.mediaFile = mediaFile;
            this.audioStreams = ObservableCollections.observableList(new ArrayList<MediaFileAudioStream>(mediaFile.getAudioStreams()));
            this.subtitles = ObservableCollections.observableList(new ArrayList<MediaFileSubtitle>(mediaFile.getSubtitles()));
        }

        public MediaFile getMediaFile() {
            return this.mediaFile;
        }

        public List<MediaFileAudioStream> getAudioStreams() {
            return this.audioStreams;
        }

        public void setAudioStreams(List<MediaFileAudioStream> audioStreams) {
            this.audioStreams.clear();
            this.audioStreams.addAll(audioStreams);
            this.mediaFile.setAudioStreams(audioStreams);
        }

        public List<MediaFileSubtitle> getSubtitles() {
            return this.subtitles;
        }

        public void setSubtitles(List<MediaFileSubtitle> subtitles) {
            this.subtitles.clear();
            this.subtitles.addAll(subtitles);
            this.mediaFile.setSubtitles(subtitles);
        }
    }

    private class ScanAspectRationAction
    extends AbstractAction
    implements TmmTaskListener {
        public ScanAspectRationAction() {
            this.putValue("Name", TmmResourceBundle.getString("task.ard"));
            this.putValue("SmallIcon", IconManager.ASPECT_RATIO);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                MediaFileARDetectorTask task = new MediaFileARDetectorTask(mf.getMediaFile());
                task.addListener(this);
                TmmTaskManager.getInstance().addUnnamedTask(task);
                MediaFileEditorPanel.this.ardTask = task;
            }
        }

        @Override
        public void processTaskEvent(TmmTaskHandle task) {
            if (TmmTaskHandle.TaskState.QUEUED.equals((Object)task.getState())) {
                MediaFileEditorPanel.this.btnARD.setEnabled(false);
            } else if (TmmTaskHandle.TaskState.FINISHED.equals((Object)task.getState())) {
                MediaFileEditorPanel.this.btnARD.setEnabled(true);
            }
        }
    }

    public static class AspectRatioContainer {
        private final Float aspectRatio;
        private final String customText;

        private AspectRatioContainer(Float aspectRatio) {
            this(aspectRatio, null);
        }

        private AspectRatioContainer(Float aspectRatio, String customText) {
            this.aspectRatio = aspectRatio;
            this.customText = customText;
        }

        private Float getAspectRatio() {
            return this.aspectRatio;
        }

        public String toString() {
            if (StringUtils.isNotBlank((CharSequence)this.customText)) {
                if (this.aspectRatio != null && this.aspectRatio.floatValue() > 0.0f) {
                    return this.customText + String.format(" (%.2f:1)", this.aspectRatio);
                }
                return this.customText;
            }
            return AspectRatio.getDescription(this.aspectRatio);
        }
    }

    private class AddAudioStreamAction
    extends AbstractAction {
        public AddAudioStreamAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("audiostream.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaFileEditorPanel.this.tableAudioStreams.addAudioStream();
            MediaFileEditorPanel.this.syncAudioStreams();
        }
    }

    private class RemoveAudioStreamAction
    extends AbstractAction {
        public RemoveAudioStreamAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("audiostream.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] audioRows;
            for (int index : audioRows = TmmUIHelper.getSelectedRowsAsModelRows(MediaFileEditorPanel.this.tableAudioStreams)) {
                MediaFileEditorPanel.this.audioStreams.remove(index);
            }
            MediaFileEditorPanel.this.syncAudioStreams();
        }
    }

    private class AddSubtitleAction
    extends AbstractAction {
        public AddSubtitleAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("subtitle.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaFileEditorPanel.this.tableSubtitles.addSubtitle();
            MediaFileEditorPanel.this.syncSubtitles();
        }
    }

    private class RemoveSubtitleAction
    extends AbstractAction {
        public RemoveSubtitleAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("subtitle.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] subtitleRows;
            for (int index : subtitleRows = TmmUIHelper.getSelectedRowsAsModelRows(MediaFileEditorPanel.this.tableSubtitles)) {
                MediaFileEditorPanel.this.subtitles.remove(index);
            }
            MediaFileEditorPanel.this.syncSubtitles();
        }
    }

    public static class MediaInfo3DConverter
    extends Converter<String, MediaInfo3D> {
        public MediaInfo3D convertForward(String value) {
            if (value == null || value.isBlank()) {
                return MediaInfo3D.MONO;
            }
            return MediaInfo3D.get3DFrom(value);
        }

        public String convertReverse(MediaInfo3D value) {
            if (value == null) {
                return "";
            }
            return value.getId();
        }
    }

    public static class AspectRatioConverter
    extends Converter<Float, AspectRatioContainer> {
        private final List<AspectRatioContainer> values;

        public AspectRatioConverter(List<AspectRatioContainer> values) {
            this.values = values;
        }

        public AspectRatioContainer convertForward(Float value) {
            return this.values.stream().filter(entry -> Objects.equals(entry.aspectRatio, value)).findFirst().orElse(null);
        }

        public Float convertReverse(AspectRatioContainer value) {
            return value.aspectRatio;
        }
    }
}

