/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.panels.IModalPopupPanel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;

public class ModalPopupPanel
extends JPanel {
    private final IModalPopupPanelProvider popupPanelProvider;
    private final JLabel lblTitle;
    private final JPanel contentPanel;
    private final JPanel buttonPanel;
    private Runnable onCloseHandler;
    private Runnable onCancelHandler;

    public ModalPopupPanel(IModalPopupPanelProvider parent) {
        this(parent, null);
    }

    public ModalPopupPanel(IModalPopupPanelProvider parent, String title) {
        super(false);
        this.popupPanelProvider = parent;
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){});
        this.setLayout((LayoutManager)new MigLayout("", "[center, grow]", "[center, grow]"));
        JPanel layoutPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g1) {
                super.paintComponent(g1);
                Graphics2D g2d = (Graphics2D)g1.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                Dimension arcs = new Dimension(15, 15);
                int width = this.getWidth();
                int height = this.getHeight();
                g2d.setColor(this.getBackground());
                g2d.fillRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
                g2d.dispose();
            }
        };
        layoutPanel.setOpaque(false);
        layoutPanel.setLayout(new BorderLayout());
        layoutPanel.setBorder(new EmptyBorder(5, 20, 5, 20));
        this.add((Component)layoutPanel, "cell 0 0");
        this.lblTitle = new JLabel(title);
        this.lblTitle.setHorizontalAlignment(0);
        TmmFontHelper.changeFont(this.lblTitle, 1.16667, 1);
        layoutPanel.add((Component)this.lblTitle, "North");
        this.contentPanel = new JPanel();
        layoutPanel.add((Component)this.contentPanel, "Center");
        JPanel bottomPanel = new JPanel();
        layoutPanel.add((Component)bottomPanel, "South");
        bottomPanel.setLayout((LayoutManager)new MigLayout("insets n 0 0 0, gap rel 0", "[grow][]", "[shrink 0][]"));
        JSeparator separator = new JSeparator();
        bottomPanel.add((Component)separator, "cell 0 0 2 1,growx");
        this.buttonPanel = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        this.buttonPanel.setLayout(layout);
        this.buttonPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        bottomPanel.add((Component)this.buttonPanel, "cell 1 1");
    }

    @Override
    protected void paintComponent(Graphics g1) {
        super.paintComponent(g1);
        Graphics2D g = (Graphics2D)g1.create();
        g.setPaint(Color.black);
        Composite savedComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setComposite(savedComposite);
        g.dispose();
    }

    public void setTitle(String title) {
        this.lblTitle.setText(title);
    }

    public void setContent(final IModalPopupPanel panel) {
        JComponent content = panel.getContent();
        content.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ModalPopupPanel.this.popupPanelProvider.hideModalPopupPanel(ModalPopupPanel.this);
                if (panel.isCancelled()) {
                    ModalPopupPanel.this.onCancel();
                } else {
                    ModalPopupPanel.this.onClose();
                }
            }
        });
        this.contentPanel.add(content);
        if (panel.getCancelButton() != null) {
            this.buttonPanel.add(panel.getCancelButton());
        }
        if (panel.getCloseButton() != null) {
            this.buttonPanel.add(panel.getCloseButton());
            for (Component component : content.getComponents()) {
                component.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            panel.getCloseButton().doClick();
                        }
                    }
                });
            }
        }
    }

    public void setOnCloseHandler(Runnable onCloseHandler) {
        this.onCloseHandler = onCloseHandler;
    }

    public void setOnCancelHandler(Runnable onCancelHandler) {
        this.onCancelHandler = onCancelHandler;
    }

    protected void onClose() {
        if (this.onCloseHandler != null) {
            this.onCloseHandler.run();
        }
    }

    protected void onCancel() {
        if (this.onCancelHandler != null) {
            this.onCancelHandler.run();
        }
    }
}

