/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.thirdparty.imageviewer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeSupport;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.tinymediamanager.ui.thirdparty.imageviewer.ImageViewer;
import org.tinymediamanager.ui.thirdparty.imageviewer.ResizeStrategy;

class ImageComponent
extends JComponent {
    private final PaintManager paintManager = new PaintManager();
    private final Scroller scroller = new Scroller();
    private final PropertyChangeSupport propertyChangeSupport;
    private final ImageViewer viewer;
    private BufferedImage image;
    private ResizeStrategy resizeStrategy = ResizeStrategy.SHRINK_TO_FIT;
    private Object interpolationType = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    private boolean pixelatedZoom = false;
    private double zoomFactor = 1.0;

    public ImageComponent(ImageViewer viewer, PropertyChangeSupport propertyChangeSupport) {
        this.viewer = viewer;
        this.propertyChangeSupport = propertyChangeSupport;
        this.setOpaque(true);
    }

    private boolean hasSize() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setImage(BufferedImage newImage) {
        BufferedImage oldImage = this.image;
        this.image = newImage;
        this.resizePanel();
        this.paintManager.notifyChanged();
        if (oldImage != newImage && (oldImage == null || newImage == null || oldImage.getWidth() != newImage.getWidth() || oldImage.getHeight() != newImage.getHeight())) {
            this.revalidate();
        }
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("image", oldImage, newImage);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void resizeNow() {
        Container c;
        this.invalidate();
        Container root = null;
        for (c = this; c != null; c = c.getParent()) {
            if (!c.isDisplayable() || c instanceof CellRendererPane) {
                return;
            }
            if (!c.isValidateRoot()) continue;
            root = c;
            break;
        }
        if (root == null) {
            return;
        }
        while (c != null) {
            if (!c.isDisplayable() || !c.isVisible()) {
                return;
            }
            if (c instanceof Window) break;
            c = c.getParent();
        }
        if (c == null) {
            return;
        }
        root.validate();
        this.repaint();
    }

    public void setResizeStrategy(ResizeStrategy resizeStrategy) {
        if (resizeStrategy == this.resizeStrategy) {
            return;
        }
        this.scroller.prepare();
        ResizeStrategy oldResizeStrategy = this.resizeStrategy;
        this.resizeStrategy = resizeStrategy;
        this.resizeNow();
        this.scroller.rescroll();
        this.propertyChangeSupport.firePropertyChange("resizeStrategy", (Object)oldResizeStrategy, (Object)resizeStrategy);
    }

    public ResizeStrategy getResizeStrategy() {
        return this.resizeStrategy;
    }

    public void setInterpolationType(Object type) {
        if (this.interpolationType == type) {
            return;
        }
        if (type != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR && type != RenderingHints.VALUE_INTERPOLATION_BILINEAR && type != RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            throw new IllegalArgumentException("Invalid interpolation type; use one of the RenderingHints constants");
        }
        Object old = this.interpolationType;
        this.interpolationType = type;
        this.paintManager.notifyChanged();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("interpolationType", old, type);
    }

    public Object getInterpolationType() {
        return this.interpolationType;
    }

    public void setPixelatedZoom(boolean pixelatedZoom) {
        if (pixelatedZoom == this.pixelatedZoom) {
            return;
        }
        this.pixelatedZoom = pixelatedZoom;
        this.paintManager.notifyChanged();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("pixelatedZoom", !pixelatedZoom, pixelatedZoom);
    }

    public boolean isPixelatedZoom() {
        return this.pixelatedZoom;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    protected void resizePanel() {
        if (this.zoomFactor == 1.0) {
            this.viewer.getComponent().setPreferredSize(this.getPreferredSize());
            this.viewer.getScrollPane().setPreferredSize(this.getPreferredSize());
        } else {
            Dimension original = new Dimension(this.image.getWidth(), this.image.getHeight());
            this.viewer.getComponent().setPreferredSize(original);
            this.viewer.getScrollPane().setPreferredSize(original);
        }
        this.viewer.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.viewer.getScrollPane().setVerticalScrollBarPolicy(20);
    }

    public void setZoomFactor(double newZoomFactor) {
        if (this.zoomFactor == newZoomFactor) {
            return;
        }
        if (newZoomFactor <= 0.0 || Double.isInfinite(newZoomFactor) || Double.isNaN(newZoomFactor)) {
            throw new IllegalArgumentException("Invalid zoom factor: " + newZoomFactor);
        }
        if (this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
            this.scroller.prepare();
        }
        double oldZoomFactor = this.zoomFactor;
        this.zoomFactor = newZoomFactor;
        if (this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
            this.resizePanel();
            this.resizeNow();
            this.scroller.rescroll();
        }
        this.propertyChangeSupport.firePropertyChange("zoomFactor", oldZoomFactor, newZoomFactor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension();
        }
        if (this.resizeStrategy == ResizeStrategy.CUSTOM_ZOOM) {
            return new Dimension((int)Math.ceil((double)this.image.getWidth() * this.zoomFactor), (int)Math.ceil((double)this.image.getHeight() * this.zoomFactor));
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public Point pointToPixel(Point p) {
        return this.pointToPixel(p, true);
    }

    public Point pointToPixel(Point p, boolean clipToImage) {
        Point2D.Double fp = new Point2D.Double((double)p.x + 0.5, (double)p.y + 0.5);
        try {
            this.getImageTransform().inverseTransform(fp, fp);
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalStateException("Image transformation not invertible");
        }
        p.x = (int)Math.floor(fp.x);
        p.y = (int)Math.floor(fp.y);
        if (clipToImage && (p.x < 0 || p.y < 0 || p.x >= this.image.getWidth() || p.y >= this.image.getHeight())) {
            return null;
        }
        return p;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintManager.paintComponent(g);
    }

    public AffineTransform getImageTransform() {
        if (this.getImage() == null) {
            throw new IllegalStateException("No image");
        }
        if (!this.hasSize()) {
            throw new IllegalStateException("Viewer size is zero");
        }
        double currentZoom = switch (this.resizeStrategy) {
            case ResizeStrategy.NO_RESIZE -> 1.0;
            case ResizeStrategy.SHRINK_TO_FIT -> Math.min(this.getSizeRatio(), 1.0);
            case ResizeStrategy.RESIZE_TO_FIT -> this.getSizeRatio();
            case ResizeStrategy.CUSTOM_ZOOM -> this.zoomFactor;
            default -> throw new IllegalStateException("Unhandled resize strategy");
        };
        AffineTransform tr = new AffineTransform();
        tr.setToTranslation(((double)this.getWidth() - (double)this.image.getWidth() * currentZoom) / 2.0, ((double)this.getHeight() - (double)this.image.getHeight() * currentZoom) / 2.0);
        tr.scale(currentZoom, currentZoom);
        return tr;
    }

    private double getSizeRatio() {
        return Math.min((double)this.getWidth() / (double)this.image.getWidth(), (double)this.getHeight() / (double)this.image.getHeight());
    }

    private class PaintManager {
        BufferedImage cachedImage = null;
        boolean cachedImageChanged = false;
        AffineTransform cachedTransform;

        private PaintManager() {
        }

        private void doPaint(Graphics2D gg, AffineTransform imageTransform) {
            gg.setColor(ImageComponent.this.getBackground());
            gg.fillRect(0, 0, ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
            gg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (ImageComponent.this.pixelatedZoom && imageTransform.getScaleX() >= 1.0) {
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, ImageComponent.this.interpolationType);
            }
            gg.drawImage(ImageComponent.this.image, imageTransform, ImageComponent.this);
        }

        private void ensureCachedValid(AffineTransform imageTransform) {
            boolean cacheValid;
            if (this.cachedImage == null || this.cachedImage.getWidth() < ImageComponent.this.getWidth() || this.cachedImage.getHeight() < ImageComponent.this.getHeight()) {
                this.cachedImage = ImageComponent.this.getGraphicsConfiguration().createCompatibleImage(ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
                cacheValid = false;
            } else {
                boolean bl = cacheValid = this.cachedTransform.equals(imageTransform) && !this.cachedImageChanged;
            }
            if (!cacheValid) {
                Graphics2D gg = this.cachedImage.createGraphics();
                this.doPaint(gg, imageTransform);
                gg.dispose();
                this.cachedImageChanged = false;
                this.cachedTransform = new AffineTransform(imageTransform);
            }
        }

        public void notifyChanged() {
            this.cachedImageChanged = true;
        }

        public void paintComponent(Graphics g) {
            if (ImageComponent.this.image == null) {
                Graphics2D gg = (Graphics2D)g.create();
                gg.setColor(ImageComponent.this.getBackground());
                gg.fillRect(0, 0, ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
                gg.dispose();
                return;
            }
            AffineTransform imageTransform = ImageComponent.this.getImageTransform();
            if (imageTransform.getScaleX() < 1.0 && ImageComponent.this.interpolationType != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                this.ensureCachedValid(imageTransform);
                g.drawImage(this.cachedImage, 0, 0, ImageComponent.this);
            } else {
                Graphics2D gg = (Graphics2D)g.create();
                this.doPaint(gg, imageTransform);
                gg.dispose();
            }
        }
    }

    class Scroller {
        private Point2D preparedCenter = null;

        Scroller() {
        }

        void prepare() {
            if (ImageComponent.this.image != null && ImageComponent.this.hasSize()) {
                Rectangle viewRect = ImageComponent.this.viewer.getScrollPane().getViewport().getViewRect();
                this.preparedCenter = new Point2D.Double(viewRect.getCenterX(), viewRect.getCenterY());
                try {
                    ImageComponent.this.getImageTransform().inverseTransform(this.preparedCenter, this.preparedCenter);
                }
                catch (NoninvertibleTransformException e) {
                    throw new Error(e);
                }
            }
        }

        void rescroll() {
            if (this.preparedCenter != null) {
                Dimension viewSize = ImageComponent.this.viewer.getScrollPane().getViewport().getExtentSize();
                ImageComponent.this.getImageTransform().transform(this.preparedCenter, this.preparedCenter);
                Rectangle view = new Rectangle((int)Math.round(this.preparedCenter.getX() - (double)viewSize.width / 2.0), (int)Math.round(this.preparedCenter.getY() - (double)viewSize.height / 2.0), viewSize.width, viewSize.height);
                this.preparedCenter = null;
                ImageComponent.this.scrollRectToVisible(view);
            }
        }
    }
}

