/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowSeasonEditorDialog;

public class TvShowChangeSeasonArtworkAction
extends TmmAction {
    public TvShowChangeSeasonArtworkAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.changeseasonartwork"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.changeseasonartwork"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.getSeasons().isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        ArrayList<TvShowSeason> selectedTvShowSeasons = new ArrayList<TvShowSeason>(selectedObjects.getSeasons());
        int selectedCount = selectedTvShowSeasons.size();
        int index = 0;
        int selectedSeasonTab = 0;
        do {
            TvShowSeason season = (TvShowSeason)selectedTvShowSeasons.get(index);
            TvShowSeasonEditorDialog editor = new TvShowSeasonEditorDialog(season, index, selectedCount, selectedSeasonTab);
            editor.setVisible(true);
            selectedSeasonTab = editor.getSelectedTab();
            if (!editor.isContinueQueue()) break;
            if (editor.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

