/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowThemeDownloadTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDownloadThemeAction
extends TmmAction {
    public TvShowDownloadThemeAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.downloadtheme"));
        this.putValue("SmallIcon", IconManager.MUSIC);
        this.putValue("SwingLargeIconKey", IconManager.MUSIC);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 512));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        TvShowThemeDownloadTask task = new TvShowThemeDownloadTask(selectedTvShows, true);
        TmmTaskManager.getInstance().addDownloadTask(task);
    }
}

