/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tasks.ExportTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowExporter;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.panels.ExporterPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowExportAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowExportAction.class);

    public TvShowExportAction() {
        this.putValue("SwingLargeIconKey", IconManager.EXPORT);
        this.putValue("SmallIcon", IconManager.EXPORT);
        this.putValue("Name", TmmResourceBundle.getString("tvshow.export"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive(true);
        if (selectedTvShows.isEmpty()) {
            return;
        }
        ModalPopupPanel popupPanel = MainWindow.getInstance().createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("tvshow.export"));
        ExporterPanel exporterPanel = new ExporterPanel(MediaEntityExporter.TemplateType.TV_SHOW){

            @Override
            protected void onClose() {
                Path exportPath;
                if (StringUtils.isBlank((CharSequence)this.tfExportDir.getText())) {
                    return;
                }
                ExportTemplate template = (ExportTemplate)this.list.getSelectedValue();
                if (template == null) {
                    return;
                }
                try {
                    exportPath = this.getExportPath();
                }
                catch (Exception e) {
                    LOGGER.debug("Aborted export - '{}'", (Object)e.getMessage());
                    return;
                }
                try {
                    TmmProperties.getInstance().putProperty(this.panelId + ".template", template.getName());
                    TvShowExporter exporter = new TvShowExporter(Paths.get(template.getPath(), new String[0]));
                    TmmTaskManager.getInstance().addMainTask(new ExportTask(TmmResourceBundle.getString("tvshow.export"), exporter, selectedTvShows, exportPath));
                }
                catch (Exception e) {
                    LOGGER.error("Error exporting TV shows -'{}'", (Object)e.getMessage());
                }
                this.setVisible(false);
            }
        };
        popupPanel.setContent(exporterPanel);
        MainWindow.getInstance().showModalPopupPanel(popupPanel);
    }
}

